/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nv;

import java.io.IOException;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BFacets;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class VirtualSlotNameParser {
    private String virtualPathName;
    private String slotName;
    private boolean frozen;
    private boolean isComponent;
    private String typeSpec;
    private int flags;
    private BFacets facets;
    private boolean isAction;
    private String returnTypeSpec;

    public static final VirtualSlotNameParser make(String string) {
        VirtualSlotNameParser virtualSlotNameParser = new VirtualSlotNameParser();
        virtualSlotNameParser.virtualPathName = string;
        return virtualSlotNameParser;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final VirtualSlotNameParser parse() throws Exception {
        String[] stringArray = TextUtil.splitAndTrim((String)this.virtualPathName, (char)';');
        if (stringArray.length <= 1) {
            throw new Exception("Invalid virtual slot name: " + this.virtualPathName);
        }
        int n = 0;
        while (n < stringArray.length) {
            if (n == 0) {
                this.slotName = VirtualSlotNameParser.unescape(stringArray[n]);
            } else if (n == 1) {
                if (stringArray[n].equals(String.valueOf('f'))) {
                    this.frozen = true;
                } else {
                    if (!stringArray[n].equals(String.valueOf('d'))) throw new Exception("Could not decode whether Slot is virtually frozen");
                    this.frozen = false;
                }
            } else if (n == 2) {
                if (stringArray[n].equals("a")) {
                    this.isAction = true;
                    this.isComponent = false;
                } else if (stringArray[n].equals("c")) {
                    this.isAction = false;
                    this.isComponent = true;
                } else {
                    if (!stringArray[n].equals("p")) throw new Exception("Could not decode virtual type: " + stringArray[n]);
                    this.isAction = false;
                    this.isComponent = false;
                }
            } else if (n == 3) {
                this.typeSpec = VirtualSlotNameParser.unescape(stringArray[n]);
                if (this.isComponent) {
                    return this;
                }
            } else if (n == 4) {
                try {
                    this.flags = Integer.parseInt(stringArray[n]);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new Exception("Could not decode virtual config flags: " + stringArray[n]);
                }
            } else if (n == 5) {
                try {
                    this.facets = (BFacets)BFacets.DEFAULT.decodeFromString(VirtualSlotNameParser.unescape(stringArray[n]));
                }
                catch (IOException iOException) {
                    throw new Exception("Could not decode virtual facets: " + this.facets);
                }
            } else if (n == 5 && this.isAction) {
                this.returnTypeSpec = VirtualSlotNameParser.unescape(stringArray[n]);
            }
            ++n;
        }
        return this;
    }

    public final VirtualSlotNameParser parsePartial() throws Exception {
        char[] cArray = this.virtualPathName.toCharArray();
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < cArray.length) {
            if (bl) {
                if (cArray[n] == 'f') {
                    this.frozen = true;
                    break;
                }
                if (cArray[n] == 'd') {
                    this.frozen = false;
                    break;
                }
                throw new Exception("Could not decode whether Slot is virtually frozen");
            }
            if (cArray[n] == ';') {
                bl = true;
            } else {
                stringBuffer.append(cArray[n]);
            }
            ++n;
        }
        if (!bl) {
            throw new Exception("Could not parse Slot name");
        }
        this.slotName = VirtualSlotNameParser.unescape(stringBuffer.toString());
        return this;
    }

    public static final String escape(String string) {
        if (string.length() == 0) {
            return "";
        }
        string = SlotPath.escape((String)string);
        char[] cArray = string.toCharArray();
        int n = 0;
        while (n < cArray.length) {
            if (cArray[n] == '$') {
                cArray[n] = 37;
            }
            ++n;
        }
        return new String(cArray);
    }

    public static final String unescape(String string) {
        if (string.length() == 0) {
            return "";
        }
        char[] cArray = string.toCharArray();
        int n = 0;
        while (n < cArray.length) {
            if (cArray[n] == '%') {
                cArray[n] = 36;
            }
            ++n;
        }
        return SlotPath.unescape((String)new String(cArray));
    }

    public final String getSlotName() {
        return this.slotName;
    }

    public final boolean isFrozen() {
        return this.frozen;
    }

    public final boolean isComponent() {
        return this.isComponent;
    }

    public final String getTypeSpec() {
        return this.typeSpec;
    }

    public final int getFlags() {
        return this.flags;
    }

    public final BFacets getFacets() {
        return this.facets;
    }

    public final boolean isAction() {
        return this.isAction;
    }

    public final String getReturnTypeSpec() {
        return this.returnTypeSpec;
    }

    private final /* synthetic */ void this() {
        this.slotName = "";
        this.frozen = false;
        this.isComponent = false;
        this.typeSpec = "";
        this.flags = 0;
        this.facets = BFacets.NULL;
        this.isAction = false;
        this.returnTypeSpec = "";
    }

    private VirtualSlotNameParser() {
        this.this();
    }
}

