/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nv;

import com.tridium.nv.BINiagaraVirtualPropertySubstitute;
import com.tridium.nv.BNiagaraVirtualComponentInfo;
import com.tridium.nv.BNiagaraVirtualGateway;
import com.tridium.nv.BSlotInfo;
import com.tridium.nv.BSlotType;
import com.tridium.nv.INiagaraVirtualCommsAdapter;
import com.tridium.nv.INiagaraVirtualStationAdapter;
import com.tridium.nv.NiagaraVirtualPropertyHandler;
import com.tridium.nv.NiagaraVirtualUtil;
import com.tridium.nv.VirtualSlotNameParser;
import com.tridium.nv.cache.BNiagaraVirtualCache;
import com.tridium.nv.point.BVirtualAction;
import com.tridium.nv.point.IProxyActionParent;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.HashMap;
import java.util.ListIterator;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentList;
import javax.baja.agent.BIAgent;
import javax.baja.agent.BPxView;
import javax.baja.agent.NoSuchAgentException;
import javax.baja.data.BIDataValue;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.space.BComponentSpace;
import javax.baja.space.LoadCallbacks;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAction;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIMixIn;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.ModuleException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.sys.TypeException;
import javax.baja.util.BFormat;
import javax.baja.util.BIFormatPropertyHandler;
import javax.baja.util.BNameMap;
import javax.baja.util.BTypeSpec;
import javax.baja.util.ICoalesceable;
import javax.baja.util.Invocation;
import javax.baja.util.Lexicon;
import javax.baja.virtual.BVirtualComponent;
import javax.baja.virtual.VirtualPath;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BNiagaraVirtualComponent
extends BVirtualComponent
implements IProxyActionParent,
BIStatus,
BIFormatPropertyHandler,
BIAgent {
    private static final BIcon GHOST_ICON = BIcon.std((String)"badges/ghost.png");
    private static final BIcon DEFAULT_ICON = BNiagaraVirtualComponent.makeVirtualIcon(BIcon.std((String)"object.png"));
    public static final Property icon = BNiagaraVirtualComponent.newProperty((int)5, (BValue)DEFAULT_ICON, null);
    public static final Property niagaraVirtualCompInfo = BNiagaraVirtualComponent.newProperty((int)257, (BValue)new BNiagaraVirtualComponentInfo(), null);
    public static final Action niagaraVirtualCompCheckActions = BNiagaraVirtualComponent.newAction((int)260, null);
    public static final Action getProxyActionDefault = BNiagaraVirtualComponent.newAction((int)260, (BValue)BString.DEFAULT, null);
    public static final Action niagaraVirtualCompUpdateStatus = BNiagaraVirtualComponent.newAction((int)20, null);
    public static final Action niagaraVirtualCompDeviceStatusChanged = BNiagaraVirtualComponent.newAction((int)20, null);
    public static final Type TYPE;
    public static final String NIAGARA_VIRTUAL = "nVirtual";
    public static final String NIAGARA_VIRTUAL_WRITABLE = "nVirtualW";
    public static final String NIAGARA_VIRTUAL_SLOT_NAME = "nVirtualSN";
    public static final String NIAGARA_VIRTUAL_FROZEN = "nVirtualFroz";
    public static final String NIAGARA_VIRTUAL_COMP_TYPE_SPEC = "nVirtualTS";
    public static final int NIAGARA_VIRTUAL_SLOT_FLAG = 0x10000000;
    public static final char POST_ID_SEP = ';';
    public static final char PROP_FROZEN = 'f';
    public static final char PROP_DYNAMIC = 'd';
    private HandlerArray propertyHandlerArray;
    private boolean actionFetchRequired;
    private Object monitor;
    private boolean mappedToNiagaraVirtual;
    private BStatus mappedStatus;
    private BNiagaraVirtualGateway gw;
    static /* synthetic */ Class class$com$tridium$nv$BNiagaraVirtualComponent;
    static /* synthetic */ Class class$javax$baja$sys$Property;

    public BIcon getIcon() {
        return (BIcon)this.get(icon);
    }

    public void setIcon(BIcon bIcon) {
        this.set(icon, (BValue)bIcon, null);
    }

    public BNiagaraVirtualComponentInfo getNiagaraVirtualCompInfo() {
        return (BNiagaraVirtualComponentInfo)this.get(niagaraVirtualCompInfo);
    }

    public void setNiagaraVirtualCompInfo(BNiagaraVirtualComponentInfo bNiagaraVirtualComponentInfo) {
        this.set(niagaraVirtualCompInfo, (BValue)bNiagaraVirtualComponentInfo, null);
    }

    public void niagaraVirtualCompCheckActions() {
        this.invoke(niagaraVirtualCompCheckActions, null, null);
    }

    public BValue getProxyActionDefault(BString bString) {
        return this.invoke(getProxyActionDefault, (BValue)bString, null);
    }

    public void niagaraVirtualCompUpdateStatus() {
        this.invoke(niagaraVirtualCompUpdateStatus, null, null);
    }

    public void niagaraVirtualCompDeviceStatusChanged() {
        this.invoke(niagaraVirtualCompDeviceStatusChanged, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public static final BNiagaraVirtualComponent make(BTypeSpec bTypeSpec) {
        BNiagaraVirtualComponent bNiagaraVirtualComponent = null;
        try {
            Type type = bTypeSpec.getResolvedType();
            AgentList agentList = Sys.getRegistry().getAgents(type.getTypeInfo());
            bNiagaraVirtualComponent = (BNiagaraVirtualComponent)agentList.filter(AgentFilter.is((Type)TYPE)).getDefault().getInstance();
        }
        catch (ModuleException moduleException) {
        }
        catch (TypeException typeException) {
        }
        catch (NoSuchAgentException noSuchAgentException) {}
        if (bNiagaraVirtualComponent == null) {
            bNiagaraVirtualComponent = new BNiagaraVirtualComponent();
        }
        return bNiagaraVirtualComponent;
    }

    public final Object fw(int n, Object object, Object object2, Object object3, Object object4) {
        switch (n) {
            case 11: {
                this.fwStarted();
                break;
            }
            case 12: {
                this.fwStopped();
                break;
            }
            case 17: {
                this.fwSubscribed();
                break;
            }
            case 18: {
                this.fwUnsubscribed();
                break;
            }
            case 3: {
                this.fwAdded((Property)object, (Context)object2);
                break;
            }
            case 4: {
                this.fwRemoved((Property)object, (BValue)object2, (Context)object3);
                break;
            }
            case 2: {
                this.fwChanged((Property)object, (Context)object2);
                break;
            }
        }
        return super.fw(n, object, object2, object3, object4);
    }

    private final void fwStarted() {
        Property[] propertyArray = this.getPropertiesArray();
        int n = 0;
        while (n < propertyArray.length) {
            this.addToPropHandler(propertyArray[n]);
            ++n;
        }
    }

    private final void fwStopped() {
        NiagaraVirtualPropertyHandler[] niagaraVirtualPropertyHandlerArray = this.propertyHandlerArray.toArray();
        int n = 0;
        while (n < niagaraVirtualPropertyHandlerArray.length) {
            niagaraVirtualPropertyHandlerArray[n].stop();
            ++n;
        }
        this.propertyHandlerArray.clear();
    }

    private final void fwSubscribed() {
        if (!this.isRunning()) {
            return;
        }
        this.getNiagaraVirtualGateway().getNiagaraVirtualPolicies().postAsync((Runnable)new Invocation((BComponent)this, niagaraVirtualCompCheckActions, null, null));
        if (!this.propertyHandlerArray.hasPropertyHandlers()) {
            this.getNiagaraVirtualCompInfo().setStatus(BStatus.makeStale((BStatus)this.getNiagaraVirtualCompInfo().getStatus(), (boolean)false));
        } else {
            NiagaraVirtualPropertyHandler[] niagaraVirtualPropertyHandlerArray = this.propertyHandlerArray.toArray();
            int n = 0;
            while (n < niagaraVirtualPropertyHandlerArray.length) {
                niagaraVirtualPropertyHandlerArray[n].subscribed();
                ++n;
            }
        }
        this.niagaraVirtualCompUpdateStatus();
    }

    private final void fwUnsubscribed() {
        if (!this.isRunning()) {
            return;
        }
        if (!this.propertyHandlerArray.hasPropertyHandlers()) {
            this.getNiagaraVirtualCompInfo().setStatus(BStatus.makeStale((BStatus)this.getNiagaraVirtualCompInfo().getStatus(), (boolean)true));
        }
        this.unsubscribeHandlers();
    }

    private final void fwAdded(Property property, Context context) {
        if (this.isRunning()) {
            BVirtualAction bVirtualAction;
            BAction bAction;
            this.addToPropHandler(property);
            if (property.isAction() && (bAction = (BAction)this.get(property)) instanceof BVirtualAction && (bVirtualAction = (BVirtualAction)bAction).getProxyActionName().equals("set") && this.get("set") == null) {
                BTypeSpec bTypeSpec = bVirtualAction.getReturnTypeSpec();
                Type type = bTypeSpec.isNull() ? null : bTypeSpec.getResolvedType();
                BTypeSpec bTypeSpec2 = bVirtualAction.getParamTypeSpec();
                Type type2 = bTypeSpec2.isNull() ? null : bTypeSpec2.getResolvedType();
                BVirtualAction bVirtualAction2 = new BVirtualAction(bVirtualAction.getProxyActionName(), bVirtualAction.getProxyActionDisplayName(), type, type2, bVirtualAction.getProxyActionFlags(), bVirtualAction.getFacets());
                int n = this.getFlags((Slot)property) | 4;
                this.add("set", (BValue)bVirtualAction2, n &= 0xEFFFFFFF, this.getSlotFacets((Slot)property), context);
            }
        } else {
            if (property.isTopic()) {
                return;
            }
            if (property.isAction()) {
                return;
            }
            BValue bValue = this.get(property);
            if (!bValue.isComponent()) {
                BFacets bFacets = this.getSlotFacets((Slot)property);
                int n = this.getFlags((Slot)property);
                int n2 = NiagaraVirtualUtil.getVirtualFlags(bValue, n, bFacets);
                if (n2 != n) {
                    this.setFlags((Slot)property, n2);
                }
            }
        }
    }

    private final void fwRemoved(Property property, BValue bValue, Context context) {
        if (!this.isRunning()) {
            return;
        }
        NiagaraVirtualPropertyHandler niagaraVirtualPropertyHandler = this.propertyHandlerArray.findAndRemove(property);
        if (niagaraVirtualPropertyHandler != null) {
            niagaraVirtualPropertyHandler.stop();
        }
    }

    private final void fwChanged(Property property, Context context) {
        if (this.isRunning() && context != NiagaraVirtualPropertyHandler.readUpdateContext && !property.isAction() && !property.isTopic() && Flags.isUserDefined1((BComplex)this, (Slot)property) && !Flags.isReadonly((BComplex)this, (Slot)property)) {
            NiagaraVirtualPropertyHandler niagaraVirtualPropertyHandler;
            BValue bValue = this.get(property);
            if (bValue.isComponent()) {
                return;
            }
            if (property == niagaraVirtualCompInfo) {
                this.getLog().error("Invalid State -> Attempting to write Virtual Comp Info!");
            }
            if ((niagaraVirtualPropertyHandler = this.propertyHandlerArray.find(property)) == null) {
                this.getLog().error("Could not perform Niagara Virtual Component write. Could not find Property Handler");
                return;
            }
            if (bValue instanceof BINiagaraVirtualPropertySubstitute && (bValue = ((BINiagaraVirtualPropertySubstitute)bValue).nvWrite(this)) == null) {
                if (this.getLog().isTraceOn()) {
                    this.getLog().trace("Could not perform Niagara Virtual Component write. Could not get valid Property to write for INiagaraVirtualPropertySubstitute");
                }
                return;
            }
            this.getNiagaraVirtualGateway().getNiagaraVirtualPolicies().postAsync(new WriteRequest(this, niagaraVirtualPropertyHandler, bValue));
        }
    }

    /*
     * Unable to fully structure code
     */
    public final String getDisplayName(Slot var1_1, Context var2_2) {
        block17: {
            block16: {
                block15: {
                    if (!var1_1.isProperty() && !var1_1.isAction() || var1_1 == BNiagaraVirtualComponent.niagaraVirtualCompInfo || (this.getFlags(var1_1) & 0x10000000) != 0x10000000) break block17;
                    var3_3 = this.getProperty("displayNames");
                    if (var3_3 != null && var3_3.getType().is(BNameMap.TYPE) && (var5_5 = (var4_4 = (BNameMap)this.get(var3_3)).get(var1_1.getName())) != null) {
                        return var5_5.format(null, var2_2);
                    }
                    var4_4 = this.getSlotFacets(var1_1);
                    var5_6 = var4_4.getb("nVirtualFroz", false);
                    var6_7 = var4_4.gets("nVirtualSN", var1_1.getName());
                    try {
                        var6_7 = VirtualSlotNameParser.make(SlotPath.unescape((String)var6_7)).parsePartial().getSlotName();
                    }
                    catch (Exception v0) {}
                    if (var5_6) ** GOTO lbl29
                    var7_8 = this.get((Property)var1_1);
                    if (!(var7_8 instanceof BNiagaraVirtualComponent)) ** GOTO lbl27
                    var8_9 = var4_4.gets("nVirtualTS", "");
                    if (var8_9.length() <= 0) ** GOTO lbl29
                    try {
                        var9_10 = Sys.getType((String)var8_9);
                        var10_11 = var9_10.getInstance();
                        if (var10_11 instanceof BIMixIn) {
                            return ((BIMixIn)var10_11).getDisplayNameInParent(var2_2);
                        }
                        break block15;
                    }
                    catch (Exception v1) {}
                    break block15;
lbl27:
                    // 1 sources

                    if (var7_8 instanceof BIMixIn) {
                        return ((BIMixIn)var7_8).getDisplayNameInParent(var2_2);
                    }
                }
                var7_8 = Sys.getType((String)this.getNiagaraVirtualCompInfo().getTypeSpec());
                var8_9 = var7_8.getModule().getModuleName();
                var9_10 = Lexicon.make((String)var8_9, (Context)var2_2).get(var6_7);
                if (var9_10 == null) break block16;
                return var9_10;
            }
            try {
                ** GOTO lbl-1000
            }
            catch (Throwable v2) {
                try lbl-1000:
                // 2 sources

                {
                    if (var5_6) {
                        return TextUtil.toFriendly((String)var6_7);
                    }
                    return SlotPath.unescape((String)var6_7);
                }
                catch (Exception v3) {}
            }
        }
        return super.getDisplayName(var1_1, var2_2);
    }

    public final BFacets getSlotFacets(Slot slot) {
        BFacets bFacets = super.getSlotFacets(slot);
        if (Flags.isUserDefined1((BComplex)this, (Slot)slot)) {
            return BFacets.make((BFacets)bFacets, (String)NIAGARA_VIRTUAL, (BIDataValue)BBoolean.TRUE);
        }
        return bFacets;
    }

    public boolean isParentLegal(BComponent bComponent) {
        return true;
    }

    private final void addToPropHandler(Property property) {
        if (!(!this.isRunning() || property.isAction() || property.isTopic() || (this.getFlags((Slot)property) & 0x10000000) != 0x10000000 || this.get(property).isComponent() || Flags.isHidden((BComplex)this, (Slot)property))) {
            try {
                if (!this.propertyHandlerArray.hasPropertyHandlers()) {
                    this.getNiagaraVirtualCompInfo().setStatus(BStatus.makeStale((BStatus)this.getNiagaraVirtualCompInfo().getStatus(), (boolean)true));
                }
                this.propertyHandlerArray.add(NiagaraVirtualPropertyHandler.make(this.getStationAdapter(), this, property));
            }
            catch (Exception exception) {
                this.getLog().error("Could not parse virtual slot path information", (Throwable)exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final BNiagaraVirtualGateway getNiagaraVirtualGateway() {
        Object object = this.monitor;
        synchronized (object) {
            if (this.gw != null) {
                return this.gw;
            }
            this.gw = (BNiagaraVirtualGateway)this.getVirtualGateway();
            if (this.gw != null) {
                if (this.isRunning()) {
                    this.getNiagaraVirtualCompInfo().setGateway(this.gw.getOrdInSession());
                }
            } else if (!this.getNiagaraVirtualCompInfo().getGateway().isNull()) {
                try {
                    this.gw = (BNiagaraVirtualGateway)this.getNiagaraVirtualCompInfo().getGateway().get((BObject)this.getHost());
                }
                catch (Exception exception) {
                    System.out.println("Error attempting to resolve Niagara Virtual Gateway: " + this.getNiagaraVirtualCompInfo().getGateway() + "...");
                    exception.printStackTrace();
                }
            } else if (this.isRunning()) {
                System.out.println("Could not resolve Niagara Virtual Gateway (ORD reference is NULL)");
            }
            return this.gw;
        }
    }

    public final Log getLog() {
        return this.getStationAdapter().getLog();
    }

    final void close() {
        NiagaraVirtualPropertyHandler[] niagaraVirtualPropertyHandlerArray = this.propertyHandlerArray.toArray();
        int n = 0;
        while (n < niagaraVirtualPropertyHandlerArray.length) {
            niagaraVirtualPropertyHandlerArray[n].close();
            ++n;
        }
    }

    public final String getPointId() {
        return this.getNiagaraVirtualCompInfo().getSlotOrd().toString();
    }

    public final BValue invokeAction(BVirtualAction bVirtualAction, BValue bValue) throws Exception {
        return this.getComms().invokeAction(this, bVirtualAction, bValue, "ProxyActionInvoke");
    }

    public final BValue doGetProxyActionDefault(BString bString) throws Exception {
        if (this.getComms().isTraceOn()) {
            this.getComms().trace("getProxyActionDefault " + bString);
        }
        BVirtualAction bVirtualAction = (BVirtualAction)this.get(bString.toString());
        return this.getComms().getActionDefault(this, bVirtualAction, this.getDisplayName(null) + ": Niagara Virtual Proxy Action Default");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void doNiagaraVirtualCompCheckActions() throws Exception {
        if (!this.isRunning()) {
            return;
        }
        Object object = this.monitor;
        synchronized (object) {
            block9: {
                if (!this.actionFetchRequired) break block9;
                INiagaraVirtualStationAdapter iNiagaraVirtualStationAdapter = this.getStationAdapter();
                if (!this.getNiagaraVirtualGateway().isLicensed()) {
                    return;
                }
                if (iNiagaraVirtualStationAdapter.getStationStatus().isDisabled()) {
                    return;
                }
                if (!iNiagaraVirtualStationAdapter.isVirtualsEnabled()) {
                    return;
                }
                try {
                    this.updateActions(this.getComms().loadActions(this, this.getDisplayName(null) + ": Niagara Virtual Get Actions"));
                }
                catch (Exception exception) {
                    this.getComms().error("Could not get Actions back from component", exception);
                }
                this.actionFetchRequired = false;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final void reloadActionsIfLoaded() {
        Object object = this.monitor;
        synchronized (object) {
            block8: {
                if (this.actionFetchRequired) break block8;
                INiagaraVirtualStationAdapter iNiagaraVirtualStationAdapter = this.getStationAdapter();
                if (!this.getNiagaraVirtualGateway().isLicensed()) {
                    return;
                }
                if (iNiagaraVirtualStationAdapter.getStationStatus().isDisabled()) {
                    return;
                }
                if (!iNiagaraVirtualStationAdapter.isVirtualsEnabled()) {
                    return;
                }
                try {
                    this.updateActions(this.getComms().loadActions(this, this.getDisplayName(null) + ": Niagara Virtual Get Actions"));
                }
                catch (Exception exception) {
                    this.getComms().error("Could not get Actions back from component", exception);
                }
            }
            return;
        }
    }

    private final void updateActions(BVirtualAction[] bVirtualActionArray) {
        BFacets bFacets;
        Object object;
        Property property;
        if (this.getLog().isTraceOn()) {
            this.getLog().trace("updateActions - Virtuals - " + this.getSlotPathOrd());
        }
        HashMap hashMap = NiagaraVirtualUtil.getDisplayNamesHashMap((BComponent)this);
        boolean bl = false;
        Class clazz = class$javax$baja$sys$Property;
        if (clazz == null) {
            clazz = class$javax$baja$sys$Property = BNiagaraVirtualComponent.class("[Ljavax.baja.sys.Property;", false);
        }
        Array array = new Array(clazz);
        int n = 0;
        while (n < bVirtualActionArray.length) {
            try {
                property = this.getProperty(bVirtualActionArray[n].getProxyActionName());
                if (property == null) {
                    object = new BSlotInfo();
                    ((BSlotInfo)((Object)object)).setSlotName(bVirtualActionArray[n].getProxyActionName());
                    ((BSlotInfo)((Object)object)).setSlotDisplayName(BFormat.make((String)bVirtualActionArray[n].getProxyActionDisplayName()));
                    ((BSlotInfo)((Object)object)).setSlotFlags(bVirtualActionArray[n].getProxyActionFlags());
                    ((BSlotInfo)((Object)object)).setSlotType(BSlotType.action);
                    ((BSlotInfo)((Object)object)).setReturnTypeSpec(bVirtualActionArray[n].getReturnTypeSpec().toString());
                    bFacets = bVirtualActionArray[n].getFacets();
                    int n2 = bVirtualActionArray[n].getProxyActionFlags() | 0x10000000;
                    if (this.checkVirtualAdd((BSlotInfo)((Object)object), (BValue)bVirtualActionArray[n], bFacets, n2)) {
                        property = this.add(bVirtualActionArray[n].getProxyActionName(), (BValue)bVirtualActionArray[n], n2, bFacets, null);
                    }
                } else {
                    this.set(bVirtualActionArray[n].getProxyActionName(), (BValue)bVirtualActionArray[n]);
                    bl = true;
                }
                if (property != null) {
                    array.add((Object)property);
                    object = bVirtualActionArray[n].getProxyActionDisplayName();
                    if (((String)object).length() > 0) {
                        hashMap.put(bVirtualActionArray[n].getProxyActionName(), BFormat.make((String)object));
                    }
                }
            }
            catch (Exception exception) {
                this.getLog().error("Could not add Proxy Action to Virtual", (Throwable)exception);
            }
            ++n;
        }
        NiagaraVirtualUtil.setDisplayNames((BComponent)this, hashMap);
        if (bl) {
            Property[] propertyArray = this.getDynamicPropertiesArray();
            int n3 = 0;
            while (n3 < propertyArray.length) {
                if (!propertyArray[n3].isAction()) {
                    array.add((Object)propertyArray[n3]);
                }
                ++n3;
            }
            property = (Property)array.trim();
            Class clazz2 = class$javax$baja$sys$Property;
            if (clazz2 == null) {
                clazz2 = class$javax$baja$sys$Property = BNiagaraVirtualComponent.class("[Ljavax.baja.sys.Property;", false);
            }
            object = new Array(clazz2);
            object.addAll((Object[])this.getDynamicPropertiesArray());
            object = object.sort(new Comparator((Property[])property){
                final /* synthetic */ Property[] val$props;

                public final int compare(Object object, Object object2) {
                    Property property = (Property)object;
                    Property property2 = (Property)object2;
                    int n = -1;
                    int n2 = -1;
                    int n3 = 0;
                    while (n3 < this.val$props.length) {
                        if (this.val$props[n3] == property) {
                            n = n3;
                        } else if (this.val$props[n3] == property2) {
                            n2 = n3;
                        }
                        if (n > -1 && n2 > -1) break;
                        ++n3;
                    }
                    return n > n2 ? 1 : -1;
                }
                {
                    this.val$props = propertyArray;
                }
            });
            this.reorder((Property[])object.trim());
        }
        BNiagaraVirtualCache bNiagaraVirtualCache = this.getNiagaraVirtualGateway().getNiagaraVirtualPolicies().getCache();
        int n4 = 0;
        while (n4 < bVirtualActionArray.length) {
            object = new BSlotInfo();
            ((BSlotInfo)((Object)object)).setSlotName(bVirtualActionArray[n4].getProxyActionName());
            ((BSlotInfo)((Object)object)).setSlotDisplayName(BFormat.make((String)bVirtualActionArray[n4].getProxyActionDisplayName()));
            ((BSlotInfo)((Object)object)).setSlotOrd(this.getNiagaraVirtualCompInfo().formSlotOrd(bVirtualActionArray[n4].getProxyActionName()));
            ((BSlotInfo)((Object)object)).setIsFrozen(bVirtualActionArray[n4].getFacets().getb(NIAGARA_VIRTUAL_FROZEN, false));
            ((BSlotInfo)((Object)object)).setIsComponent(false);
            ((BSlotInfo)((Object)object)).setSlotType(BSlotType.action);
            ((BSlotInfo)((Object)object)).setIsNiagaraVirtual(false);
            bFacets = bVirtualActionArray[n4].getParameterType();
            if (bFacets != null) {
                ((BSlotInfo)((Object)object)).setTypeSpec(bFacets.toString());
            }
            ((BSlotInfo)((Object)object)).setFacets(BFacets.makeRemove((BFacets)bVirtualActionArray[n4].getFacets(), (String)NIAGARA_VIRTUAL_FROZEN));
            ((BSlotInfo)((Object)object)).setSlotFlags(((BSlotInfo)((Object)object)).getSlotFlags() | bVirtualActionArray[n4].getProxyActionFlags());
            Type type = bVirtualActionArray[n4].getReturnType();
            if (type != null) {
                ((BSlotInfo)((Object)object)).setReturnTypeSpec(type.toString());
            }
            BOrd bOrd = this.formVirtualOrd(SlotPath.unescape((String)bVirtualActionArray[n4].getProxyActionName()));
            bNiagaraVirtualCache.update(this.getStationAdapter().getStationName(), bOrd, (BSlotInfo)((Object)object));
            ++n4;
        }
    }

    final void makeIcon() {
        try {
            if (this.getIcon().equals((Object)DEFAULT_ICON)) {
                this.setIcon(BNiagaraVirtualComponent.makeVirtualIcon(Sys.getType((String)this.getNiagaraVirtualCompInfo().getTypeSpec()).getInstance().getIcon()));
            }
        }
        catch (Exception exception) {
            this.setIcon(DEFAULT_ICON);
        }
    }

    private static final BIcon makeVirtualIcon(BIcon bIcon) {
        BOrd[] bOrdArray = bIcon.getOrdList().toArray();
        boolean bl = false;
        int n = 0;
        while (n < bOrdArray.length) {
            if (bOrdArray[n].equals((Object)GHOST_ICON)) {
                bl = true;
                break;
            }
            ++n;
        }
        if (!bl) {
            return BIcon.make((BIcon)bIcon, (BIcon)GHOST_ICON);
        }
        return bIcon;
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        this.spyInfo(spyWriter);
        super.spy(spyWriter);
    }

    public final void spyInfo(SpyWriter spyWriter) throws Exception {
        spyWriter.startProps("Niagara Virtual Component Information");
        BNiagaraVirtualComponentInfo bNiagaraVirtualComponentInfo = this.getNiagaraVirtualCompInfo();
        spyWriter.prop((Object)"Virtual Status", (Object)bNiagaraVirtualComponentInfo.getStatus());
        spyWriter.prop((Object)"Type Specification", (Object)bNiagaraVirtualComponentInfo.getTypeSpec());
        spyWriter.prop((Object)"Slot ORD", (Object)bNiagaraVirtualComponentInfo.getSlotOrd());
        spyWriter.prop((Object)"Last Failure Cause", (Object)bNiagaraVirtualComponentInfo.getLastFailureCause());
        spyWriter.endProps();
        spyWriter.startTable(true);
        spyWriter.trTitle((Object)"Fox Point Channel Subscriptions", 9);
        spyWriter.w((Object)"<tr>");
        spyWriter.th((Object)"Name");
        spyWriter.th((Object)"Type");
        spyWriter.th((Object)"Message Id");
        spyWriter.th((Object)"Last Read");
        spyWriter.th((Object)"Last Write");
        spyWriter.th((Object)"Subscription State");
        spyWriter.th((Object)"Subscription Status");
        spyWriter.th((Object)"Read Status");
        spyWriter.th((Object)"Write Status");
        spyWriter.w((Object)"</tr>");
        NiagaraVirtualPropertyHandler[] niagaraVirtualPropertyHandlerArray = this.propertyHandlerArray.toArray();
        int n = 0;
        while (n < niagaraVirtualPropertyHandlerArray.length) {
            String string;
            Object object;
            Object object2;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<tr");
            try {
                object2 = (BSimple)Sys.getType((String)"gx:Color").getInstance();
                object = (BSimple)object2.decodeFromString("#90ee90");
                BSimple bSimple = niagaraVirtualPropertyHandlerArray[n].getOverallStatus().getBackgroundColor(object);
                Method method = bSimple.getClass().getMethod("toHtmlString", new Class[0]);
                string = method.invoke((Object)bSimple, new Object[0]).toString();
                if (string != null) {
                    stringBuffer.append(" bgcolor='").append(string).append("'");
                }
            }
            catch (Exception exception) {}
            stringBuffer.append(">");
            spyWriter.w((Object)stringBuffer.toString());
            object2 = new StringBuffer();
            ((StringBuffer)object2).append("<a href='");
            ((StringBuffer)object2).append(niagaraVirtualPropertyHandlerArray[n].getProperty().getName());
            ((StringBuffer)object2).append("'>");
            ((StringBuffer)object2).append(niagaraVirtualPropertyHandlerArray[n].getName());
            ((StringBuffer)object2).append("</a>");
            object = "-";
            long l = niagaraVirtualPropertyHandlerArray[n].getLastReadTicks();
            if (l != 0L) {
                object = BRelTime.toString((long)(Clock.ticks() - l));
            }
            string = "-";
            long l2 = niagaraVirtualPropertyHandlerArray[n].getLastWriteTicks();
            if (l2 != 0L) {
                string = BRelTime.toString((long)(Clock.ticks() - l2));
            }
            spyWriter.td((Object)((StringBuffer)object2).toString());
            spyWriter.td((Object)niagaraVirtualPropertyHandlerArray[n].getProperty().getType());
            spyWriter.td((Object)new Integer(niagaraVirtualPropertyHandlerArray[n].getMessageId()));
            spyWriter.td(object);
            spyWriter.td((Object)string);
            spyWriter.td((Object)niagaraVirtualPropertyHandlerArray[n].getSubscriptionState());
            spyWriter.td((Object)niagaraVirtualPropertyHandlerArray[n].getSubscriptionStatus());
            spyWriter.td((Object)niagaraVirtualPropertyHandlerArray[n].getReadStatus());
            spyWriter.td((Object)niagaraVirtualPropertyHandlerArray[n].getWriteStatus());
            spyWriter.w((Object)"</tr>");
            ++n;
        }
        spyWriter.endTable();
    }

    public BStatus getStatus() {
        return this.getNiagaraVirtualCompInfo().getStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void doNiagaraVirtualCompUpdateStatus() {
        Object object;
        INiagaraVirtualStationAdapter iNiagaraVirtualStationAdapter = this.getStationAdapter();
        BStatus bStatus = iNiagaraVirtualStationAdapter.getStationStatus();
        if (!iNiagaraVirtualStationAdapter.isVirtualsEnabled()) {
            bStatus = BStatus.makeDisabled((BStatus)bStatus, (boolean)true);
        }
        if (bStatus.isDown() || bStatus.isFault()) {
            object = new StringBuffer();
            object.append("Station Err: (");
            object.append(Sys.getStation().getStationName());
            object.append(" -> ");
            object.append(iNiagaraVirtualStationAdapter.getStationName());
            object.append(") ");
            object.append(bStatus.toString());
            this.getNiagaraVirtualCompInfo().setLastFailureCause(object.toString());
        }
        if (!this.propertyHandlerArray.hasPropertyHandlers()) {
            if (this.getNiagaraVirtualCompInfo().getStatus().isStale()) {
                bStatus = BStatus.makeStale((BStatus)bStatus, (boolean)true);
            }
            if (this.getNiagaraVirtualCompInfo().getStatus().isFault()) {
                bStatus = BStatus.makeFault((BStatus)bStatus, (boolean)true);
            }
        } else {
            object = this.propertyHandlerArray.toArray();
            int n = 0;
            int n2 = 0;
            while (n2 < ((NiagaraVirtualPropertyHandler[])object).length) {
                n = object[n2].getOverallStatus().getBits() | n;
                ++n2;
            }
            bStatus = BStatus.make((int)(bStatus.getBits() | n));
        }
        if (!(!this.mappedToNiagaraVirtual || bStatus.isDisabled() || bStatus.isStale() || bStatus.isDown() || bStatus.isFault())) {
            object = this.propertyHandlerArray;
            synchronized (object) {
                if (this.mappedStatus != null) {
                    bStatus = BStatus.make((int)(bStatus.getBits() | this.mappedStatus.getBits()));
                    bStatus = BStatus.makeOverridden((BStatus)bStatus, (boolean)true);
                }
            }
        }
        this.getNiagaraVirtualCompInfo().setStatus(bStatus);
    }

    public final void doNiagaraVirtualCompDeviceStatusChanged() {
        INiagaraVirtualStationAdapter iNiagaraVirtualStationAdapter = this.getStationAdapter();
        BStatus bStatus = iNiagaraVirtualStationAdapter.getStationStatus();
        if (bStatus.isDown() || bStatus.isFault() || bStatus.isDisabled() || !this.getNiagaraVirtualGateway().isRunning() || !iNiagaraVirtualStationAdapter.isVirtualsEnabled()) {
            this.unsubscribeHandlers();
        } else {
            this.niagaraVirtualCompUpdateStatus();
        }
    }

    final void unsubscribeHandlers() {
        NiagaraVirtualPropertyHandler[] niagaraVirtualPropertyHandlerArray = this.propertyHandlerArray.toArray();
        int n = 0;
        while (n < niagaraVirtualPropertyHandlerArray.length) {
            niagaraVirtualPropertyHandlerArray[n].unsubscribed();
            ++n;
        }
        this.niagaraVirtualCompUpdateStatus();
    }

    final void discoveryFail(String string, boolean bl) {
        if (bl) {
            this.getNiagaraVirtualCompInfo().setStatus(BStatus.makeFault((BStatus)this.getNiagaraVirtualCompInfo().getStatus(), (boolean)true));
        }
        this.getNiagaraVirtualCompInfo().setLastFailureCause(string);
        this.unsubscribeHandlers();
    }

    final void discoveryOk() {
        if (!this.propertyHandlerArray.hasPropertyHandlers()) {
            this.getNiagaraVirtualCompInfo().setStatus(BStatus.makeFault((BStatus)this.getNiagaraVirtualCompInfo().getStatus(), (boolean)false));
        }
    }

    public String toString(Context context) {
        return this.getNiagaraVirtualCompInfo().toString(context);
    }

    public final BOrd getCategorizableOrd() {
        BOrd bOrd = this.getNavOrd();
        if (bOrd == null) {
            return BOrd.NULL;
        }
        OrdQuery[] ordQueryArray = bOrd.parse();
        try {
            int n = 0;
            while (n < ordQueryArray.length) {
                if (ordQueryArray[n] instanceof VirtualPath) {
                    VirtualPath virtualPath = (VirtualPath)ordQueryArray[n];
                    StringBuffer stringBuffer = new StringBuffer();
                    BNiagaraVirtualComponent bNiagaraVirtualComponent = this.getNiagaraVirtualGateway().getRootComponent();
                    int n2 = 0;
                    while (n2 < virtualPath.depth()) {
                        String string = virtualPath.nameAt(n2);
                        if (string.length() > 0) {
                            stringBuffer.append("/");
                            BNiagaraVirtualComponent bNiagaraVirtualComponent2 = (BNiagaraVirtualComponent)bNiagaraVirtualComponent.get(SlotPath.escape((String)string));
                            BFacets bFacets = bNiagaraVirtualComponent.getSlotFacets((Slot)bNiagaraVirtualComponent2.getPropertyInParent());
                            String string2 = SlotPath.unescape((String)bFacets.gets(NIAGARA_VIRTUAL_SLOT_NAME, bNiagaraVirtualComponent2.getName()));
                            stringBuffer.append(string2);
                            bNiagaraVirtualComponent = bNiagaraVirtualComponent2;
                        }
                        ++n2;
                    }
                    ordQueryArray[n] = new VirtualPath(stringBuffer.toString());
                }
                ++n;
            }
        }
        catch (Exception exception) {
            this.getLog().error("Error parsing Niagara Virtual Component Categorizable ORD", (Throwable)exception);
        }
        return BOrd.make((OrdQuery[])ordQueryArray);
    }

    public final Property getFormatPropertyByName(String string) {
        Slot slot;
        if (string.length() <= 0) {
            return null;
        }
        Property property = this.findPropertyByName(string);
        BComponentSpace bComponentSpace = this.getComponentSpace();
        LoadCallbacks loadCallbacks = bComponentSpace.getLoadCallbacks();
        if (bComponentSpace != null && loadCallbacks != null && (slot = loadCallbacks.loadSlot((BComponent)this, string)) != null && slot instanceof Property) {
            property = (Property)slot;
        }
        if (property == null) {
            this.loadSlots();
            property = this.findPropertyByName(string);
        }
        return property;
    }

    private final Property findPropertyByName(String string) {
        Property[] propertyArray = this.getPropertiesArray();
        try {
            int n = 0;
            while (n < propertyArray.length) {
                BFacets bFacets;
                String string2;
                if (!propertyArray[n].isFrozen() && !propertyArray[n].isAction() && !propertyArray[n].isTopic() && (this.getFlags((Slot)propertyArray[n]) & 0x10000000) == 0x10000000 && (string2 = (bFacets = this.getSlotFacets((Slot)propertyArray[n])).gets(NIAGARA_VIRTUAL_SLOT_NAME, propertyArray[n].getName())).equals(string)) {
                    return propertyArray[n];
                }
                ++n;
            }
        }
        catch (Exception exception) {
            this.getLog().error("Could not decode format value", (Throwable)exception);
        }
        return null;
    }

    public final BValue getFormatValue(String string) {
        Property property = this.getFormatPropertyByName(string);
        if (property != null) {
            return this.get(property);
        }
        return null;
    }

    public final int getVirtualPropertySize() {
        return this.propertyHandlerArray.size();
    }

    public final BOrd getVirtualOrd() {
        return BOrd.make((OrdQuery)new VirtualPath(SlotPath.unescape((String)this.toPathString())));
    }

    public final BOrd formVirtualOrd(String string) {
        String string2 = this.getVirtualOrd().toString();
        string2 = !string2.endsWith("/") ? string2 + '/' + string : string2 + string;
        return BOrd.make((String)string2);
    }

    public final String getTypeSpec() {
        return this.getNiagaraVirtualCompInfo().getTypeSpec();
    }

    public final INiagaraVirtualStationAdapter getStationAdapter() {
        return this.getNiagaraVirtualGateway().getStationAdapter();
    }

    public final INiagaraVirtualCommsAdapter getComms() {
        return this.getNiagaraVirtualGateway().getComms();
    }

    public final boolean checkVirtualAdd(BSlotInfo bSlotInfo, BValue bValue, BFacets bFacets, int n) {
        if (bValue.getType().is(BPxView.TYPE)) {
            return false;
        }
        return this.doCheckVirtualAdd(bSlotInfo, bValue, bFacets, n);
    }

    public boolean doCheckVirtualAdd(BSlotInfo bSlotInfo, BValue bValue, BFacets bFacets, int n) {
        return true;
    }

    final void setMappedToNiagaraVirtual(boolean bl) {
        this.mappedToNiagaraVirtual = bl;
        if (bl) {
            this.setFlags((Slot)niagaraVirtualCompInfo, this.getFlags((Slot)niagaraVirtualCompInfo) | 0x10000000);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final void readOkMappedVirtualInfo(BNiagaraVirtualComponentInfo bNiagaraVirtualComponentInfo) {
        if (this.getComms().isTraceOn()) {
            this.getComms().trace("Called readOkMappedVirtualInfo: " + this.getVirtualOrd());
        }
        if (!this.mappedToNiagaraVirtual) return;
        if (bNiagaraVirtualComponentInfo.getLastFailureCause().length() > 0) {
            this.getNiagaraVirtualCompInfo().setLastFailureCause(bNiagaraVirtualComponentInfo.getLastFailureCause());
        }
        HandlerArray handlerArray = this.propertyHandlerArray;
        synchronized (handlerArray) {
            this.mappedStatus = bNiagaraVirtualComponentInfo.getStatus();
            return;
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.propertyHandlerArray = new HandlerArray();
        this.actionFetchRequired = true;
        this.monitor = new Object();
        this.mappedToNiagaraVirtual = false;
    }

    public BNiagaraVirtualComponent() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$nv$BNiagaraVirtualComponent;
        if (clazz == null) {
            clazz = class$com$tridium$nv$BNiagaraVirtualComponent = BNiagaraVirtualComponent.class("[Lcom.tridium.nv.BNiagaraVirtualComponent;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static final class HandlerArray {
        private Array array;
        static /* synthetic */ Class class$com$tridium$nv$NiagaraVirtualPropertyHandler;

        private final synchronized void add(NiagaraVirtualPropertyHandler niagaraVirtualPropertyHandler) {
            this.array.add((Object)niagaraVirtualPropertyHandler);
        }

        private final synchronized NiagaraVirtualPropertyHandler findAndRemove(Property property) {
            NiagaraVirtualPropertyHandler niagaraVirtualPropertyHandler = this.find(property);
            if (niagaraVirtualPropertyHandler != null) {
                this.array.remove((Object)niagaraVirtualPropertyHandler);
            }
            return niagaraVirtualPropertyHandler;
        }

        private final synchronized NiagaraVirtualPropertyHandler[] toArray() {
            return (NiagaraVirtualPropertyHandler[])this.array.copy().trim();
        }

        private final synchronized void clear() {
            this.array.clear();
        }

        private final synchronized boolean hasPropertyHandlers() {
            boolean bl = false;
            if (this.array.size() > 0) {
                bl = true;
            }
            return bl;
        }

        private final synchronized int size() {
            return this.array.size();
        }

        private final synchronized NiagaraVirtualPropertyHandler find(Property property) {
            ListIterator listIterator = this.array.iterator();
            while (listIterator.hasNext()) {
                NiagaraVirtualPropertyHandler niagaraVirtualPropertyHandler = (NiagaraVirtualPropertyHandler)listIterator.next();
                if (niagaraVirtualPropertyHandler.getProperty() != property) continue;
                return niagaraVirtualPropertyHandler;
            }
            return null;
        }

        static /* synthetic */ Class class(String string, boolean bl) {
            try {
                Class<?> clazz = Class.forName(string);
                if (!bl) {
                    clazz = clazz.getComponentType();
                }
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }

        private final /* synthetic */ void this() {
            Class clazz = class$com$tridium$nv$NiagaraVirtualPropertyHandler;
            if (clazz == null) {
                clazz = class$com$tridium$nv$NiagaraVirtualPropertyHandler = HandlerArray.class("[Lcom.tridium.nv.NiagaraVirtualPropertyHandler;", false);
            }
            this.array = new Array(clazz);
        }

        private HandlerArray() {
            this.this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private final class WriteRequest
    implements Runnable,
    ICoalesceable {
        private BNiagaraVirtualComponent vComp;
        private NiagaraVirtualPropertyHandler handler;
        private BValue val;
        private int hashCode;

        public final void run() {
            try {
                BNiagaraVirtualComponent.this.getComms().write(BNiagaraVirtualComponent.this.getNiagaraVirtualCompInfo().getSlotOrd(), this.handler.getName(), this.val, BNiagaraVirtualComponent.this.getDisplayName(null) + ": Niagara Virtual Write");
                this.handler.writeOk();
            }
            catch (Exception exception) {
                String string = "";
                if (this.handler != null) {
                    string = this.handler.getName();
                    this.handler.writeFail(exception.getMessage());
                }
                BNiagaraVirtualComponent.this.getComms().error("Writing to Niagara Virtual Property: " + string, exception);
            }
        }

        public final boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (!(object instanceof WriteRequest)) {
                return false;
            }
            WriteRequest writeRequest = (WriteRequest)object;
            boolean bl = false;
            if (writeRequest.handler.getName().equals(this.handler.getName()) && writeRequest.vComp.equals(this.vComp)) {
                bl = true;
            }
            return bl;
        }

        public final int hashCode() {
            return this.hashCode;
        }

        public final ICoalesceable coalesce(ICoalesceable iCoalesceable) {
            return iCoalesceable;
        }

        public final Object getCoalesceKey() {
            return this;
        }

        private WriteRequest(BNiagaraVirtualComponent bNiagaraVirtualComponent2, NiagaraVirtualPropertyHandler niagaraVirtualPropertyHandler, BValue bValue) {
            this.vComp = bNiagaraVirtualComponent2;
            this.handler = niagaraVirtualPropertyHandler;
            this.val = bValue.newCopy(true);
            this.hashCode = bNiagaraVirtualComponent2.hashCode() ^ niagaraVirtualPropertyHandler.getName().hashCode();
        }
    }
}

