/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion.priv.util;

import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.priv.util.BOrionQueueNode;
import com.tridium.orion.priv.util.IPersistentQueue;
import com.tridium.orion.priv.util.OrionQueueException;
import com.tridium.orion.sql.BSqlField;
import com.tridium.orion.sql.BSqlQuery;
import com.tridium.orion.sql.PropertyValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.baja.query.BExpression;
import javax.baja.query.BOrderByColumn;
import javax.baja.query.BOrdering;
import javax.baja.query.util.Columns;
import javax.baja.query.util.Predicates;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.util.IFilter;

public final class OrionQueue
implements IPersistentQueue {
    private static final HashMap typeToQ = new HashMap();
    protected BOrionDatabase db;
    protected OrionType nodeType;
    protected String queueName;
    protected boolean loaded;
    protected int size;

    public static final synchronized IPersistentQueue makeOrionQueue(BOrionDatabase bOrionDatabase, OrionType orionType, String string, boolean bl) {
        if (!orionType.is(BOrionQueueNode.TYPE)) {
            throw new IllegalArgumentException("nodeType: '" + orionType + "' is not a " + BOrionQueueNode.TYPE);
        }
        if (string.length() > 64) {
            throw new IllegalArgumentException("queueName parameter must be 64 characters or less in length. " + string + " is " + string.length() + " characters.");
        }
        HashMap<String, OrionQueue> hashMap = null;
        hashMap = (HashMap<String, OrionQueue>)typeToQ.get(orionType);
        if (hashMap == null) {
            hashMap = new HashMap<String, OrionQueue>();
            typeToQ.put(orionType, hashMap);
        }
        IPersistentQueue iPersistentQueue = null;
        iPersistentQueue = (IPersistentQueue)hashMap.get(string);
        if (iPersistentQueue == null) {
            iPersistentQueue = new OrionQueue(bOrionDatabase, orionType, string);
            hashMap.put(string, (OrionQueue)iPersistentQueue);
        }
        if (bl) {
            iPersistentQueue.load();
        }
        return iPersistentQueue;
    }

    public static final synchronized IPersistentQueue makeOrionQueue(BOrionDatabase bOrionDatabase, OrionType orionType, String string) {
        return OrionQueue.makeOrionQueue(bOrionDatabase, orionType, string, true);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final synchronized void load() {
        if (this.loaded) {
            return;
        }
        OrionSession orionSession = this.getOrionSession();
        OrionCursor orionCursor = null;
        try {
            orionCursor = this.selectAll(orionSession);
            while (true) {
                block7: {
                    if (orionCursor.next()) break block7;
                    this.loaded = true;
                    break;
                }
                ++this.size;
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (orionCursor != null) {
                orionCursor.close();
            }
            if (orionSession == null) throw throwable;
            orionSession.close();
            throw throwable;
        }
        {
            Object var4_5 = null;
            if (orionCursor != null) {
                orionCursor.close();
            }
            if (orionSession == null) return;
            orionSession.close();
            return;
        }
    }

    public final String getQueueName() {
        return this.queueName;
    }

    public final synchronized void clear() {
        throw new IllegalStateException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized BValue dequeue() {
        if (this.size == 0) {
            return null;
        }
        OrionSession orionSession = this.getOrionSession();
        BValue bValue = null;
        try {
            BOrionQueueNode bOrionQueueNode = this.peekNode(orionSession);
            bValue = bOrionQueueNode.getQueueItem().getItem();
            if (!orionSession.delete(bOrionQueueNode)) {
                throw new OrionQueueException("Could not permanently remove the dequeued item.");
            }
            --this.size;
            BValue bValue2 = bValue;
            Object var4_5 = null;
            if (orionSession != null) {
                orionSession.close();
            }
            return bValue2;
        }
        catch (Throwable throwable) {
            block5: {
                Object var4_6 = null;
                if (orionSession == null) break block5;
                orionSession.close();
            }
            throw throwable;
        }
    }

    public final synchronized BValue dequeue(long l) throws InterruptedException {
        if (this.size == 0) {
            this.wait(l);
        }
        if (this.size == 0) {
            return null;
        }
        return this.dequeue();
    }

    /*
     * Exception decompiling
     */
    public final synchronized void enqueue(BValue var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 86->90)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized List filter(IFilter iFilter, boolean bl) {
        ArrayList<BValue> arrayList = new ArrayList<BValue>();
        if (this.size == 0) {
            return arrayList;
        }
        OrionSession orionSession = this.getOrionSession();
        OrionCursor orionCursor = null;
        try {
            orionCursor = this.selectAll(orionSession);
            while (orionCursor.next()) {
                BOrionQueueNode bOrionQueueNode = (BOrionQueueNode)orionCursor.get();
                BValue bValue = bOrionQueueNode.getQueueItem().getItem();
                if (!iFilter.accept((Object)bValue)) continue;
                arrayList.add(bValue);
                if (!bl) continue;
                orionSession.delete(bOrionQueueNode);
                --this.size;
            }
            ArrayList<BValue> arrayList2 = arrayList;
            Object var7_9 = null;
            if (orionCursor != null) {
                orionCursor.close();
            }
            if (orionSession != null) {
                orionSession.close();
            }
            return arrayList2;
        }
        catch (Throwable throwable) {
            block7: {
                Object var7_10 = null;
                if (orionCursor != null) {
                    orionCursor.close();
                }
                if (orionSession == null) break block7;
                orionSession.close();
            }
            throw throwable;
        }
    }

    public final synchronized boolean isEmpty() {
        boolean bl = false;
        if (this.size == 0) {
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized BValue peek() {
        OrionSession orionSession = this.getOrionSession();
        try {
            BValue bValue = this.peekNode(orionSession).getQueueItem().getItem();
            Object var3_3 = null;
            if (orionSession != null) {
                orionSession.close();
            }
            return bValue;
        }
        catch (Throwable throwable) {
            block3: {
                Object var3_4 = null;
                if (orionSession == null) break block3;
                orionSession.close();
            }
            throw throwable;
        }
    }

    public final synchronized BValue peek(long l) throws InterruptedException {
        if (this.size == 0) {
            this.wait(l);
        }
        if (this.size == 0) {
            return null;
        }
        return this.peek();
    }

    public final synchronized int size() {
        return this.size;
    }

    private final OrionSession getOrionSession() {
        return this.db.createSession(null);
    }

    private final OrionCursor selectAll(OrionSession orionSession) {
        OrionCursor orionCursor = null;
        orionCursor = orionSession.select(this.nodeType, new PropertyValue(BOrionQueueNode.queueName, (BValue)BString.make((String)this.queueName)));
        return orionCursor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final BOrionQueueNode peekNode(OrionSession orionSession) {
        OrionCursor orionCursor = null;
        try {
            BSqlQuery bSqlQuery = BSqlQuery.make(this.nodeType);
            bSqlQuery.where(Predicates.eq((Property)BOrionQueueNode.queueName, (BSimple)BString.make((String)this.queueName)));
            bSqlQuery.orderBy(BOrdering.make((BOrderByColumn)Columns.orderBy((BExpression)new BSqlField(this.nodeType, BOrionQueueNode.id))));
            orionCursor = orionSession.select(bSqlQuery);
            if (!orionCursor.next()) {
                throw new OrionQueueException("Deque returned no items for " + this.queueName + " but size is " + this.size);
            }
            BOrionQueueNode bOrionQueueNode = (BOrionQueueNode)orionCursor.get();
            Object var4_5 = null;
            if (orionCursor != null) {
                orionCursor.close();
            }
            return bOrionQueueNode;
        }
        catch (Throwable throwable) {
            block4: {
                Object var4_6 = null;
                if (orionCursor == null) break block4;
                orionCursor.close();
            }
            throw throwable;
        }
    }

    protected OrionQueue(BOrionDatabase bOrionDatabase, OrionType orionType, String string) {
        this.db = bOrionDatabase;
        this.nodeType = orionType;
        this.queueName = string;
        this.loaded = false;
        this.size = 0;
    }
}

