/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion.priv.sys;

import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BOrionSpace;
import com.tridium.orion.OrionSession;
import java.util.HashMap;
import java.util.Iterator;
import javax.baja.space.BComponentSpace;
import javax.baja.sync.SetCategoryMaskOp;
import javax.baja.sync.SyncBuffer;
import javax.baja.sync.SyncOp;
import javax.baja.sys.BComponent;
import javax.baja.sys.Context;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class OrionSyncBuffer
extends SyncBuffer {
    private HashMap sessionMap;
    private HashMap objMap;
    private OrionSession orionSession;
    private BIOrionObject last;
    private boolean needUpdate;

    public static SyncBuffer getCategoryOps(SyncBuffer syncBuffer) {
        SyncBuffer syncBuffer2 = new SyncBuffer(syncBuffer.getSpace(), syncBuffer.isCoalesced());
        SyncOp[] syncOpArray = syncBuffer.list();
        int n = 0;
        while (n < syncOpArray.length) {
            if (syncOpArray[n] instanceof SetCategoryMaskOp) {
                syncBuffer2.add((SyncOp)new SetCategoryMaskOp(syncOpArray[n].getComponent(), ((SetCategoryMaskOp)syncOpArray[n]).getMask()));
            }
            ++n;
        }
        return syncBuffer2;
    }

    public SyncOp[] startCommit(SyncOp[] syncOpArray, Context context) {
        this.needUpdate = false;
        return syncOpArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected OrionSession getSession(BIOrionObject bIOrionObject, Context context) {
        BOrionDatabase bOrionDatabase = bIOrionObject.getOrionDatabase();
        OrionSession orionSession = null;
        HashMap hashMap = this.sessionMap;
        synchronized (hashMap) {
            orionSession = (OrionSession)this.sessionMap.get(bOrionDatabase.getId());
            if (orionSession == null) {
                orionSession = bOrionDatabase.createSession(context);
                orionSession.setAutoCommit(false);
                this.sessionMap.put(bOrionDatabase.getId(), orionSession);
            }
            return orionSession;
        }
    }

    protected void doUpdate(BIOrionObject bIOrionObject, Context context) {
        OrionSession orionSession = this.getSession(bIOrionObject, context);
        if (bIOrionObject.isModified()) {
            this.orionSession.update(bIOrionObject);
        }
        this.needUpdate = false;
    }

    public void commitOp(SyncOp syncOp, Context context) throws Exception {
        if (this.needUpdate) {
            if (this.last != syncOp.getComponent()) {
                this.doUpdate(this.last, context);
                this.last = null;
            } else if (syncOp.getId() != 115) {
                this.doUpdate(this.last, context);
                this.last = null;
            }
        } else if (syncOp.getId() == 115) {
            this.last = (BIOrionObject)syncOp.getComponent();
            this.needUpdate = true;
        }
        super.commitOp(syncOp, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void endCommit() throws Exception {
        if (this.last != null && this.last.isModified()) {
            this.getSession(this.last, null).update(this.last);
        }
        HashMap hashMap = this.sessionMap;
        synchronized (hashMap) {
            Object var6_4;
            OrionSession orionSession;
            Iterator iterator = this.sessionMap.values().iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    this.sessionMap.clear();
                    return;
                }
                orionSession = (OrionSession)iterator.next();
                try {
                    orionSession.commit();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    orionSession.rollback();
                }
                var6_4 = null;
                orionSession.close();
                continue;
                break;
            }
            catch (Throwable throwable) {
                var6_4 = null;
                orionSession.close();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void abortCommit(Exception exception) {
        HashMap hashMap = this.sessionMap;
        synchronized (hashMap) {
            Iterator iterator = this.sessionMap.values().iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    this.sessionMap.clear();
                    return;
                }
                OrionSession orionSession = (OrionSession)iterator.next();
                try {
                    orionSession.rollback();
                }
                catch (Exception exception2) {
                    exception2.printStackTrace();
                }
                try {
                    orionSession.close();
                    continue;
                }
                catch (Exception exception3) {
                    exception3.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }

    public BComponent findByHandle(Object object, boolean bl) {
        BComponent bComponent = (BComponent)this.objMap.get(object);
        if (bComponent == null && (bComponent = this.getSpace().findByHandle(object, bl)) != null) {
            this.objMap.put(object, bComponent);
        }
        return bComponent;
    }

    private final /* synthetic */ void this() {
        this.sessionMap = new HashMap();
        this.objMap = new HashMap();
        this.needUpdate = false;
    }

    public OrionSyncBuffer(BOrionSpace bOrionSpace, boolean bl) {
        super((BComponentSpace)bOrionSpace, bl);
        this.this();
    }
}

