/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion.priv.fox;

import com.tridium.fox.encoding.BogCodec;
import com.tridium.fox.encoding.DecoderFactory;
import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.message.FoxTuple;
import com.tridium.fox.session.Fox;
import com.tridium.fox.session.FoxCircuit;
import com.tridium.fox.session.InvalidCommandException;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BNameFactory;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BOrionObject;
import com.tridium.orion.BOrionService;
import com.tridium.orion.BOrionSpace;
import com.tridium.orion.BOrionType;
import com.tridium.orion.BOrionTypeId;
import com.tridium.orion.BTypeDependency;
import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionException;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.priv.fox.BFoxOrionDatabase;
import com.tridium.orion.priv.fox.BOrionChannel;
import com.tridium.orion.priv.fox.FoxOrionSession;
import com.tridium.orion.priv.fox.OrionInput;
import com.tridium.orion.priv.fox.OrionOutput;
import com.tridium.orion.priv.sys.OrionSyncBuffer;
import com.tridium.orion.priv.util.OrionObjectCursor;
import com.tridium.orion.sql.BatchStatement;
import com.tridium.orion.sql.PropertyValue;
import javax.baja.io.BogDecoder;
import javax.baja.io.BogEncoder;
import javax.baja.naming.BOrd;
import javax.baja.query.BQuery;
import javax.baja.security.BPermissions;
import javax.baja.security.PermissionException;
import javax.baja.sync.SyncBuffer;
import javax.baja.sync.SyncDecoder;
import javax.baja.sync.SyncEncoder;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

public class OrionCircuit {
    private BOrionChannel channel;

    public void circuitOpened(FoxCircuit foxCircuit) throws Exception {
        String string = foxCircuit.command;
        if (string == "depTypes") {
            this.getDependentTypes(foxCircuit);
            return;
        }
        if (string == "getType") {
            this.getType(foxCircuit);
            return;
        }
        if (string == "getNameFactory") {
            this.getNameFactory(foxCircuit);
            return;
        }
        if (string == "scan") {
            this.scan(foxCircuit);
            return;
        }
        if (string == "linkedScan") {
            this.linkedScan(foxCircuit);
            return;
        }
        if (string == "insert") {
            this.insert(foxCircuit);
            return;
        }
        if (string == "read") {
            this.read(foxCircuit);
            return;
        }
        if (string == "readRaw") {
            this.readRaw(foxCircuit);
            return;
        }
        if (string == "preadRaw") {
            this.preadRaw(foxCircuit);
            return;
        }
        if (string == "update") {
            this.update(foxCircuit);
            return;
        }
        if (string == "persist") {
            this.persist(foxCircuit);
            return;
        }
        if (string == "delete") {
            this.delete(foxCircuit);
            return;
        }
        if (string == "select") {
            this.select(foxCircuit);
            return;
        }
        if (string == "qselect") {
            this.qselect(foxCircuit);
            return;
        }
        if (string == "pselect") {
            this.pselect(foxCircuit);
            return;
        }
        if (string == "commitSyncBuffer") {
            this.commitSyncBuffer(foxCircuit);
            return;
        }
        if (string == "sendSyncBufferToClient") {
            this.receiveSyncBufferFromServer(foxCircuit);
            return;
        }
        if (string == "batchInsert") {
            this.batchInsert(foxCircuit);
            return;
        }
        if (string == "batchUpdate") {
            this.batchUpdate(foxCircuit);
            return;
        }
        if (string == "batchPersist") {
            this.batchPersist(foxCircuit);
            return;
        }
        if (string == "batchDelete") {
            this.batchDelete(foxCircuit);
            return;
        }
        throw new InvalidCommandException(string);
    }

    public BTypeDependency[] getDependentTypes(BFoxOrionDatabase bFoxOrionDatabase, OrionType orionType) throws Exception {
        FoxCircuit foxCircuit = this.channel.openCircuit("depTypes");
        FoxMessage foxMessage = new FoxMessage();
        foxMessage.add("dbId", bFoxOrionDatabase.getId());
        foxMessage.add("baseTypeId", orionType.getOrionTypeId().encodeToString());
        foxCircuit.writeMessage(foxMessage);
        FoxMessage foxMessage2 = foxCircuit.readMessage();
        if (foxMessage2.getString("exception", null) != null) {
            throw Fox.exceptionTranslator.messageToException(foxMessage2);
        }
        String[] stringArray = foxMessage2.listStrings("d");
        BTypeDependency[] bTypeDependencyArray = new BTypeDependency[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            bTypeDependencyArray[n] = (BTypeDependency)BTypeDependency.DEFAULT.decodeFromString(stringArray[n]);
            ++n;
        }
        return bTypeDependencyArray;
    }

    private final void getDependentTypes(FoxCircuit foxCircuit) throws Exception {
        try {
            FoxMessage foxMessage = foxCircuit.readMessage();
            BOrionService bOrionService = (BOrionService)Sys.getService((Type)BOrionService.TYPE);
            BOrionDatabase bOrionDatabase = bOrionService.getOrionDatabase(foxMessage.getString("dbId"));
            BOrionTypeId bOrionTypeId = (BOrionTypeId)BOrionTypeId.DEFAULT.decodeFromString(foxMessage.getString("baseTypeId"));
            OrionType orionType = bOrionDatabase.getType(bOrionTypeId);
            BTypeDependency[] bTypeDependencyArray = bOrionDatabase.getDependentTypes(orionType);
            FoxMessage foxMessage2 = new FoxMessage("resp");
            int n = 0;
            while (n < bTypeDependencyArray.length) {
                foxMessage2.add("d", bTypeDependencyArray[n].encodeToString());
                ++n;
            }
            foxCircuit.writeMessage(foxMessage2);
            foxCircuit.flush();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            foxCircuit.writeMessage(Fox.exceptionTranslator.exceptionToMessage((Throwable)exception));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OrionType getType(BFoxOrionDatabase bFoxOrionDatabase, BOrionTypeId bOrionTypeId) throws Exception {
        OrionType orionType;
        FoxCircuit foxCircuit = this.channel.openCircuit("getType");
        try {
            FoxMessage foxMessage = new FoxMessage("getType");
            foxMessage.add("dbId", bFoxOrionDatabase.getId());
            foxMessage.add("typeId", bOrionTypeId.encodeToString());
            foxCircuit.writeMessage(foxMessage);
            foxCircuit.flush();
            OrionInput orionInput = new OrionInput(foxCircuit.getInputStream());
            OrionType orionType2 = orionInput.readType();
            orionInput.close();
            orionType = orionType2;
            Object var5_8 = null;
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            foxCircuit.close();
            throw throwable;
        }
        foxCircuit.close();
        return orionType;
    }

    private final void getType(FoxCircuit foxCircuit) throws Exception {
        FoxMessage foxMessage = foxCircuit.readMessage();
        BOrionService bOrionService = (BOrionService)Sys.getService((Type)BOrionService.TYPE);
        BOrionDatabase bOrionDatabase = bOrionService.getOrionDatabase(foxMessage.getString("dbId"));
        BOrionTypeId bOrionTypeId = BOrionTypeId.decode(foxMessage.getString("typeId"));
        OrionType orionType = bOrionDatabase.getType(bOrionTypeId);
        OrionOutput orionOutput = new OrionOutput(foxCircuit.getOutputStream());
        orionOutput.writeType(orionType);
        orionOutput.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BNameFactory getNameFactory(BFoxOrionDatabase bFoxOrionDatabase, OrionType orionType) throws Exception {
        BNameFactory bNameFactory;
        FoxCircuit foxCircuit = this.channel.openCircuit("getNameFactory");
        try {
            FoxMessage foxMessage = new FoxMessage("getNameFactory");
            foxMessage.add("dbId", bFoxOrionDatabase.getId());
            foxMessage.add("typeId", orionType.getOrionTypeId().encodeToString());
            foxCircuit.writeMessage(foxMessage);
            foxCircuit.flush();
            FoxMessage foxMessage2 = foxCircuit.readMessage();
            if (foxMessage2.getString("exception", null) != null) {
                throw Fox.exceptionTranslator.messageToException(foxMessage2);
            }
            bNameFactory = (BNameFactory)((Object)DecoderFactory.decode((FoxMessage)foxMessage2, (String)"factory", null));
            Object var5_7 = null;
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            foxCircuit.close();
            throw throwable;
        }
        foxCircuit.close();
        return bNameFactory;
    }

    private final void getNameFactory(FoxCircuit foxCircuit) throws Exception {
        try {
            BOrionService bOrionService = (BOrionService)Sys.getService((Type)BOrionService.TYPE);
            FoxMessage foxMessage = foxCircuit.readMessage();
            BOrionDatabase bOrionDatabase = bOrionService.getOrionDatabase(foxMessage.getString("dbId"));
            BOrionTypeId bOrionTypeId = BOrionTypeId.decode(foxMessage.getString("typeId"));
            OrionType orionType = bOrionDatabase.getType(bOrionTypeId);
            FoxMessage foxMessage2 = new FoxMessage();
            BogCodec.add((FoxMessage)foxMessage2, (String)"factory", (BValue)bOrionDatabase.getNameFactory(orionType), null);
            foxCircuit.writeMessage(foxMessage2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            foxCircuit.writeMessage(Fox.exceptionTranslator.exceptionToMessage((Throwable)exception));
        }
    }

    public OrionCursor scan(FoxOrionSession foxOrionSession, OrionType orionType) throws Exception {
        FoxCircuit foxCircuit = this.channel.openCircuit("scan");
        try {
            this.channel.setSession(foxOrionSession, foxCircuit);
            FoxMessage foxMessage = new FoxMessage("type");
            foxMessage.add("typeId", orionType.getOrionTypeId().encodeToString());
            foxCircuit.writeMessage(foxMessage);
            foxCircuit.flush();
            FoxMessage foxMessage2 = foxCircuit.readMessage();
            if (foxMessage2.getString("exception", null) != null) {
                throw Fox.exceptionTranslator.messageToException(foxMessage2);
            }
            this.channel.assignSessionId(foxOrionSession, foxMessage2);
        }
        catch (Exception exception) {
            foxCircuit.close();
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new OrionException("Operation failed.", exception);
        }
        return new OrionObjectCursor(foxOrionSession, new OrionInput(foxOrionSession, foxCircuit.getInputStream()), null);
    }

    private final void scan(FoxCircuit foxCircuit) throws Exception {
        try {
            FoxMessage foxMessage = new FoxMessage();
            OrionSession orionSession = this.channel.getSession(foxCircuit, foxMessage, true);
            foxCircuit.writeMessage(foxMessage);
            FoxMessage foxMessage2 = foxCircuit.readMessage();
            BOrionTypeId bOrionTypeId = BOrionTypeId.decode(foxMessage2.getString("typeId"));
            OrionType orionType = orionSession.getOrionDatabase().getType(bOrionTypeId);
            OrionCursor orionCursor = orionSession.scan(orionType);
            OrionOutput orionOutput = new OrionOutput(foxCircuit.getOutputStream());
            orionOutput.writeType(orionCursor.getOrionType());
            while (orionCursor.next()) {
                orionOutput.writeObject((BIOrionObject)orionCursor.get());
            }
            orionOutput.flush();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            foxCircuit.writeMessage(Fox.exceptionTranslator.exceptionToMessage((Throwable)exception));
        }
    }

    public OrionCursor linkedScan(FoxOrionSession foxOrionSession, BIOrionObject bIOrionObject, OrionType orionType, OrionType orionType2) throws Exception {
        FoxCircuit foxCircuit = this.channel.openCircuit("linkedScan");
        try {
            this.channel.setSession(foxOrionSession, foxCircuit);
            FoxMessage foxMessage = new FoxMessage("linkedScan");
            foxMessage.add("linkTypeId", orionType.getOrionTypeId().encodeToString());
            foxMessage.add("scanTypeId", orionType2.getOrionTypeId().encodeToString());
            foxCircuit.writeMessage(foxMessage);
            OrionOutput orionOutput = new OrionOutput(foxCircuit.getOutputStream());
            orionOutput.writeObject(bIOrionObject);
            orionOutput.flush();
            foxCircuit.flush();
            FoxMessage foxMessage2 = foxCircuit.readMessage();
            if (foxMessage2.getString("exception", null) != null) {
                throw Fox.exceptionTranslator.messageToException(foxMessage2);
            }
            this.channel.assignSessionId(foxOrionSession, foxMessage2);
        }
        catch (Exception exception) {
            foxCircuit.close();
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new OrionException("Operation failed.", exception);
        }
        return new OrionObjectCursor(foxOrionSession, new OrionInput(foxOrionSession, foxCircuit.getInputStream()), null);
    }

    private final void linkedScan(FoxCircuit foxCircuit) throws Exception {
        try {
            FoxMessage foxMessage = new FoxMessage();
            OrionSession orionSession = this.channel.getSession(foxCircuit, foxMessage, true);
            foxCircuit.writeMessage(foxMessage);
            FoxMessage foxMessage2 = foxCircuit.readMessage();
            BOrionTypeId bOrionTypeId = BOrionTypeId.decode(foxMessage2.getString("linkTypeId"));
            OrionType orionType = orionSession.getOrionDatabase().getType(bOrionTypeId);
            BOrionTypeId bOrionTypeId2 = BOrionTypeId.decode(foxMessage2.getString("scanTypeId"));
            OrionType orionType2 = orionSession.getOrionDatabase().getType(bOrionTypeId2);
            OrionInput orionInput = new OrionInput(orionSession, foxCircuit.getInputStream());
            BIOrionObject bIOrionObject = orionInput.readObject();
            OrionCursor orionCursor = orionSession.linkedScan(bIOrionObject, orionType, orionType2);
            OrionOutput orionOutput = new OrionOutput(foxCircuit.getOutputStream());
            orionOutput.writeType(orionCursor.getOrionType());
            while (orionCursor.next()) {
                orionOutput.writeObject((BIOrionObject)orionCursor.get());
            }
            orionOutput.flush();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            foxCircuit.writeMessage(Fox.exceptionTranslator.exceptionToMessage((Throwable)exception));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BIOrionObject insert(FoxOrionSession foxOrionSession, BIOrionObject bIOrionObject) throws Exception {
        BIOrionObject bIOrionObject2;
        FoxCircuit foxCircuit = this.channel.openCircuit("insert");
        try {
            this.channel.setSession(foxOrionSession, foxCircuit);
            OrionOutput orionOutput = new OrionOutput(foxCircuit.getOutputStream());
            orionOutput.writeObject(bIOrionObject);
            orionOutput.flush();
            FoxMessage foxMessage = foxCircuit.readMessage();
            if (foxMessage.getString("exception", null) != null) {
                throw Fox.exceptionTranslator.messageToException(foxMessage);
            }
            this.channel.assignSessionId(foxOrionSession, foxMessage);
            OrionInput orionInput = new OrionInput(foxOrionSession, foxCircuit.getInputStream());
            this.readClientInsert(orionInput, foxOrionSession.getOrionDatabase(), bIOrionObject);
            bIOrionObject2 = bIOrionObject;
            Object var5_8 = null;
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            foxCircuit.close();
            throw throwable;
        }
        foxCircuit.close();
        return bIOrionObject2;
    }

    private final void readClientInsert(OrionInput orionInput, BOrionDatabase bOrionDatabase, BIOrionObject bIOrionObject) throws Exception {
        BIOrionObject bIOrionObject2 = orionInput.readObject();
        Property[] propertyArray = bIOrionObject2.getOrionType().getProperties();
        int n = 0;
        while (n < propertyArray.length) {
            if (BOrionObject.isIdentity(propertyArray[n])) {
                bIOrionObject.init(propertyArray[n], bIOrionObject2.get(propertyArray[n]));
            }
            ++n;
        }
        bIOrionObject.setOrionDatabase(bOrionDatabase);
    }

    private final void insert(FoxCircuit foxCircuit) throws Exception {
        try {
            FoxMessage foxMessage = new FoxMessage();
            OrionSession orionSession = this.channel.getSession(foxCircuit, foxMessage, true);
            OrionInput orionInput = new OrionInput(foxCircuit.getInputStream());
            BIOrionObject bIOrionObject = orionInput.readObject();
            BOrionDatabase bOrionDatabase = orionSession.getOrionDatabase();
            BOrionType bOrionType = bOrionDatabase.getType(bIOrionObject.getOrionType());
            BPermissions bPermissions = this.channel.getPermissionsFor(bOrionType);
            if (!bPermissions.hasAdminWrite()) {
                throw new PermissionException("Insufficient Permission");
            }
            orionSession.insert(bIOrionObject);
            foxCircuit.writeMessage(foxMessage);
            OrionOutput orionOutput = new OrionOutput(foxCircuit.getOutputStream());
            orionOutput.writeObject(bIOrionObject);
            orionOutput.flush();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            foxCircuit.writeMessage(Fox.exceptionTranslator.exceptionToMessage((Throwable)exception));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BIOrionObject read(FoxOrionSession foxOrionSession, BIOrionObject bIOrionObject) throws Exception {
        BIOrionObject bIOrionObject2;
        OrionType orionType = bIOrionObject.getOrionType();
        FoxCircuit foxCircuit = this.channel.openCircuit("read");
        this.channel.setSession(foxOrionSession, foxCircuit);
        try {
            Object object;
            FoxMessage foxMessage = new FoxMessage("params");
            foxMessage.add("typeId", orionType.getOrionTypeId().encodeToString());
            PropertyValue[] propertyValueArray = PropertyValue.makeKeys(bIOrionObject);
            int n = 0;
            while (n < propertyValueArray.length) {
                object = new FoxMessage("key");
                object.add("name", propertyValueArray[n].getProperty().getName());
                object.add("type", propertyValueArray[n].getProperty().getType().getTypeSpec().encodeToString());
                object.add("value", PropertyValue.encodeValueToString(propertyValueArray[n].getValue()));
                foxMessage.add("key", (FoxMessage)object);
                ++n;
            }
            foxCircuit.writeMessage(foxMessage);
            foxCircuit.flush();
            FoxMessage foxMessage2 = foxCircuit.readMessage();
            if (foxMessage2.getString("exception", null) != null) {
                throw Fox.exceptionTranslator.messageToException(foxMessage2);
            }
            this.channel.assignSessionId(foxOrionSession, foxMessage2);
            object = new OrionInput(foxOrionSession, foxCircuit.getInputStream());
            BIOrionObject bIOrionObject3 = ((OrionInput)object).readObject();
            if (bIOrionObject3 != null) {
                bIOrionObject3.setOrionDatabase(foxOrionSession.getOrionDatabase());
            }
            bIOrionObject2 = bIOrionObject3;
            Object var6_12 = null;
        }
        catch (Throwable throwable) {
            Object var6_13 = null;
            foxCircuit.close();
            throw throwable;
        }
        foxCircuit.close();
        return bIOrionObject2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BIOrionObject read(FoxOrionSession foxOrionSession, OrionType orionType, BSimple bSimple) throws Exception {
        BIOrionObject bIOrionObject;
        FoxCircuit foxCircuit = this.channel.openCircuit("read");
        this.channel.setSession(foxOrionSession, foxCircuit);
        try {
            FoxMessage foxMessage = new FoxMessage("params");
            foxMessage.add("typeId", orionType.getOrionTypeId().encodeToString());
            Property[] propertyArray = orionType.getKey();
            if (propertyArray.length != 1) {
                throw new OrionException("Single key required.");
            }
            FoxMessage foxMessage2 = new FoxMessage("key");
            foxMessage2.add("name", propertyArray[0].getName());
            foxMessage2.add("type", bSimple.getType().getTypeSpec().encodeToString());
            foxMessage2.add("value", bSimple.encodeToString());
            foxMessage.add("key", foxMessage2);
            foxCircuit.writeMessage(foxMessage);
            foxCircuit.flush();
            FoxMessage foxMessage3 = foxCircuit.readMessage();
            if (foxMessage3.getString("exception", null) != null) {
                throw Fox.exceptionTranslator.messageToException(foxMessage3);
            }
            this.channel.assignSessionId(foxOrionSession, foxMessage3);
            OrionInput orionInput = new OrionInput(foxOrionSession, foxCircuit.getInputStream());
            BIOrionObject bIOrionObject2 = orionInput.readObject();
            if (bIOrionObject2 != null) {
                bIOrionObject2.setOrionDatabase(foxOrionSession.getOrionDatabase());
            }
            bIOrionObject = bIOrionObject2;
            Object var6_12 = null;
        }
        catch (Throwable throwable) {
            Object var6_13 = null;
            foxCircuit.close();
            throw throwable;
        }
        foxCircuit.close();
        return bIOrionObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BIOrionObject read(FoxOrionSession foxOrionSession, OrionType orionType, PropertyValue propertyValue) throws Exception {
        BIOrionObject bIOrionObject;
        FoxCircuit foxCircuit = this.channel.openCircuit("read");
        this.channel.setSession(foxOrionSession, foxCircuit);
        try {
            FoxMessage foxMessage = new FoxMessage("params");
            foxMessage.add("typeId", orionType.getOrionTypeId().encodeToString());
            FoxMessage foxMessage2 = new FoxMessage("key");
            foxMessage2.add("name", propertyValue.getProperty().getName());
            foxMessage2.add("type", propertyValue.getProperty().getType().getTypeSpec().encodeToString());
            foxMessage2.add("value", PropertyValue.encodeValueToString(propertyValue.getValue()));
            foxMessage.add("key", foxMessage2);
            foxCircuit.writeMessage(foxMessage);
            foxCircuit.flush();
            FoxMessage foxMessage3 = foxCircuit.readMessage();
            if (foxMessage3.getString("exception", null) != null) {
                throw Fox.exceptionTranslator.messageToException(foxMessage3);
            }
            this.channel.assignSessionId(foxOrionSession, foxMessage3);
            OrionInput orionInput = new OrionInput(foxOrionSession, foxCircuit.getInputStream());
            BIOrionObject bIOrionObject2 = orionInput.readObject();
            if (bIOrionObject2 != null) {
                bIOrionObject2.setOrionDatabase(foxOrionSession.getOrionDatabase());
            }
            bIOrionObject = bIOrionObject2;
            Object var6_11 = null;
        }
        catch (Throwable throwable) {
            Object var6_12 = null;
            foxCircuit.close();
            throw throwable;
        }
        foxCircuit.close();
        return bIOrionObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BIOrionObject read(FoxOrionSession foxOrionSession, OrionType orionType, PropertyValue[] propertyValueArray) throws Exception {
        BIOrionObject bIOrionObject;
        FoxCircuit foxCircuit = this.channel.openCircuit("read");
        this.channel.setSession(foxOrionSession, foxCircuit);
        try {
            Object object;
            FoxMessage foxMessage = new FoxMessage("params");
            foxMessage.add("typeId", orionType.getOrionTypeId().encodeToString());
            int n = 0;
            while (n < propertyValueArray.length) {
                object = new FoxMessage("key");
                object.add("name", propertyValueArray[n].getProperty().getName());
                object.add("type", propertyValueArray[n].getProperty().getType().getTypeSpec().encodeToString());
                object.add("value", PropertyValue.encodeValueToString(propertyValueArray[n].getValue()));
                foxMessage.add("key", (FoxMessage)object);
                ++n;
            }
            foxCircuit.writeMessage(foxMessage);
            foxCircuit.flush();
            FoxMessage foxMessage2 = foxCircuit.readMessage();
            if (foxMessage2.getString("exception", null) != null) {
                throw Fox.exceptionTranslator.messageToException(foxMessage2);
            }
            this.channel.assignSessionId(foxOrionSession, foxMessage2);
            object = new OrionInput(foxOrionSession, foxCircuit.getInputStream());
            BIOrionObject bIOrionObject2 = ((OrionInput)object).readObject();
            if (bIOrionObject2 != null) {
                bIOrionObject2.setOrionDatabase(foxOrionSession.getOrionDatabase());
            }
            bIOrionObject = bIOrionObject2;
            Object var6_11 = null;
        }
        catch (Throwable throwable) {
            Object var6_12 = null;
            foxCircuit.close();
            throw throwable;
        }
        foxCircuit.close();
        return bIOrionObject;
    }

    private final void read(FoxCircuit foxCircuit) throws Exception {
        try {
            Object object;
            FoxMessage foxMessage = new FoxMessage();
            OrionSession orionSession = this.channel.getSession(foxCircuit, foxMessage, true);
            FoxMessage foxMessage2 = foxCircuit.readMessage();
            OrionType orionType = orionSession.getOrionDatabase().getType(BOrionTypeId.make(foxMessage2.getString("typeId")));
            FoxTuple[] foxTupleArray = foxMessage2.list("key");
            PropertyValue[] propertyValueArray = new PropertyValue[foxTupleArray.length];
            int n = 0;
            while (n < foxTupleArray.length) {
                object = (FoxMessage)foxTupleArray[n];
                String string = object.getString("name");
                Type type = ((BTypeSpec)BTypeSpec.DEFAULT.decodeFromString(object.getString("type"))).getResolvedType();
                BValue bValue = PropertyValue.decodeValueFromString(type, object.getString("value"));
                propertyValueArray[n] = new PropertyValue(orionType.getProperty(string), bValue);
                ++n;
            }
            BIOrionObject bIOrionObject = orionSession.read(orionType, propertyValueArray);
            foxCircuit.writeMessage(foxMessage);
            if (bIOrionObject != null && !this.channel.getPermissionsFor(bIOrionObject).hasOperatorRead()) {
                bIOrionObject = null;
            }
            object = new OrionOutput(foxCircuit.getOutputStream());
            ((OrionOutput)object).writeObject(bIOrionObject);
            ((OrionOutput)object).flush();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            foxCircuit.writeMessage(Fox.exceptionTranslator.exceptionToMessage((Throwable)exception));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BIOrionObject readRaw(FoxOrionSession foxOrionSession, OrionType orionType, String string) throws Exception {
        BIOrionObject bIOrionObject;
        FoxCircuit foxCircuit = this.channel.openCircuit("readRaw");
        this.channel.setSession(foxOrionSession, foxCircuit);
        try {
            FoxMessage foxMessage = new FoxMessage("params");
            foxMessage.add("typeId", orionType.getOrionTypeId().encodeToString());
            foxMessage.add("sql", string);
            foxCircuit.writeMessage(foxMessage);
            foxCircuit.flush();
            FoxMessage foxMessage2 = foxCircuit.readMessage();
            if (foxMessage2.getString("exception", null) != null) {
                throw Fox.exceptionTranslator.messageToException(foxMessage2);
            }
            this.channel.assignSessionId(foxOrionSession, foxMessage2);
            OrionInput orionInput = new OrionInput(foxOrionSession, foxCircuit.getInputStream());
            BIOrionObject bIOrionObject2 = orionInput.readObject();
            if (bIOrionObject2 != null) {
                bIOrionObject2.setOrionDatabase(foxOrionSession.getOrionDatabase());
            }
            bIOrionObject = bIOrionObject2;
            Object var6_10 = null;
        }
        catch (Throwable throwable) {
            Object var6_11 = null;
            foxCircuit.close();
            throw throwable;
        }
        foxCircuit.close();
        return bIOrionObject;
    }

    private final void readRaw(FoxCircuit foxCircuit) throws Exception {
        try {
            FoxMessage foxMessage = new FoxMessage();
            OrionSession orionSession = this.channel.getSession(foxCircuit, foxMessage, true);
            FoxMessage foxMessage2 = foxCircuit.readMessage();
            OrionType orionType = orionSession.getOrionDatabase().getType(BOrionTypeId.make(foxMessage2.getString("typeId")));
            String string = foxMessage2.getString("sql");
            BIOrionObject bIOrionObject = orionSession.read(orionType, string);
            foxCircuit.writeMessage(foxMessage);
            if (bIOrionObject != null && !this.channel.getPermissionsFor(bIOrionObject).hasOperatorRead()) {
                bIOrionObject = null;
            }
            OrionOutput orionOutput = new OrionOutput(foxCircuit.getOutputStream());
            orionOutput.writeObject(bIOrionObject);
            orionOutput.flush();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            foxCircuit.writeMessage(Fox.exceptionTranslator.exceptionToMessage((Throwable)exception));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BIOrionObject preadRaw(FoxOrionSession foxOrionSession, OrionType orionType, String string, BSimple[] bSimpleArray) throws Exception {
        BIOrionObject bIOrionObject;
        FoxCircuit foxCircuit = this.channel.openCircuit("preadRaw");
        this.channel.setSession(foxOrionSession, foxCircuit);
        try {
            FoxMessage foxMessage = new FoxMessage("params");
            foxMessage.add("typeId", orionType.getOrionTypeId().encodeToString());
            foxMessage.add("sql", string);
            if (bSimpleArray != null) {
                this.channel.encodeParameters(foxMessage, bSimpleArray);
            }
            foxCircuit.writeMessage(foxMessage);
            foxCircuit.flush();
            FoxMessage foxMessage2 = foxCircuit.readMessage();
            if (foxMessage2.getString("exception", null) != null) {
                throw Fox.exceptionTranslator.messageToException(foxMessage2);
            }
            this.channel.assignSessionId(foxOrionSession, foxMessage2);
            OrionInput orionInput = new OrionInput(foxOrionSession, foxCircuit.getInputStream());
            BIOrionObject bIOrionObject2 = orionInput.readObject();
            if (bIOrionObject2 != null) {
                bIOrionObject2.setOrionDatabase(foxOrionSession.getOrionDatabase());
            }
            bIOrionObject = bIOrionObject2;
            Object var7_11 = null;
        }
        catch (Throwable throwable) {
            Object var7_12 = null;
            foxCircuit.close();
            throw throwable;
        }
        foxCircuit.close();
        return bIOrionObject;
    }

    private final void preadRaw(FoxCircuit foxCircuit) throws Exception {
        try {
            FoxMessage foxMessage = new FoxMessage();
            OrionSession orionSession = this.channel.getSession(foxCircuit, foxMessage, true);
            FoxMessage foxMessage2 = foxCircuit.readMessage();
            OrionType orionType = orionSession.getOrionDatabase().getType(BOrionTypeId.make(foxMessage2.getString("typeId")));
            String string = foxMessage2.getString("sql");
            BSimple[] bSimpleArray = this.channel.decodeParameters(foxMessage2);
            BIOrionObject bIOrionObject = orionSession.read(orionType, string);
            foxCircuit.writeMessage(foxMessage);
            if (bIOrionObject != null && !this.channel.getPermissionsFor(bIOrionObject).hasOperatorRead()) {
                bIOrionObject = null;
            }
            OrionOutput orionOutput = new OrionOutput(foxCircuit.getOutputStream());
            orionOutput.writeObject(bIOrionObject);
            orionOutput.flush();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            foxCircuit.writeMessage(Fox.exceptionTranslator.exceptionToMessage((Throwable)exception));
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void update(FoxOrionSession foxOrionSession, BIOrionObject bIOrionObject, boolean bl) throws Exception {
        FoxCircuit foxCircuit = this.channel.openCircuit("update");
        this.channel.setSession(foxOrionSession, foxCircuit);
        try {
            OrionOutput orionOutput = new OrionOutput(foxCircuit.getOutputStream());
            orionOutput.writeUpdate(bIOrionObject);
            orionOutput.flush();
            FoxMessage foxMessage = foxCircuit.readMessage();
            if (foxMessage.getString("exception", null) != null) {
                throw Fox.exceptionTranslator.messageToException(foxMessage);
            }
            this.channel.assignSessionId(foxOrionSession, foxMessage);
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            foxCircuit.close();
            throw throwable;
        }
        {
            Object var6_9 = null;
        }
        foxCircuit.close();
    }

    private final void update(FoxCircuit foxCircuit) throws Exception {
        try {
            FoxMessage foxMessage = new FoxMessage();
            OrionSession orionSession = this.channel.getSession(foxCircuit, foxMessage, true);
            OrionInput orionInput = new OrionInput(foxCircuit.getInputStream());
            BIOrionObject bIOrionObject = orionInput.readUpdate();
            OrionType orionType = bIOrionObject.getOrionType();
            Property[] propertyArray = orionType.getKey();
            int n = 0;
            while (n < propertyArray.length) {
                bIOrionObject.setModified(propertyArray[n], false);
                ++n;
            }
            BPermissions bPermissions = null;
            BIOrionObject bIOrionObject2 = orionSession.read(orionType, PropertyValue.makeKeys(bIOrionObject));
            bPermissions = bIOrionObject2 == null ? this.channel.getPermissionsFor(orionSession.getOrionDatabase()) : this.channel.getPermissionsFor(bIOrionObject2);
            if (!bPermissions.hasAdminWrite()) {
                throw new PermissionException("Insufficient Permission");
            }
            orionSession.update(bIOrionObject);
            foxCircuit.writeMessage(foxMessage);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            foxCircuit.writeMessage(Fox.exceptionTranslator.exceptionToMessage((Throwable)exception));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BIOrionObject persist(FoxOrionSession foxOrionSession, BIOrionObject bIOrionObject) throws Exception {
        BIOrionObject bIOrionObject2;
        FoxCircuit foxCircuit = this.channel.openCircuit("persist");
        try {
            this.channel.setSession(foxOrionSession, foxCircuit);
            OrionOutput orionOutput = new OrionOutput(foxCircuit.getOutputStream());
            orionOutput.writeObject(bIOrionObject);
            orionOutput.flush();
            FoxMessage foxMessage = foxCircuit.readMessage();
            if (foxMessage.getString("exception", null) != null) {
                throw Fox.exceptionTranslator.messageToException(foxMessage);
            }
            OrionInput orionInput = new OrionInput(foxOrionSession, foxCircuit.getInputStream());
            BIOrionObject bIOrionObject3 = orionInput.readObject();
            Property[] propertyArray = bIOrionObject3.getOrionType().getProperties();
            int n = 0;
            while (n < propertyArray.length) {
                if (BOrionObject.isIdentity(propertyArray[n])) {
                    bIOrionObject.init(propertyArray[n], bIOrionObject3.get(propertyArray[n]));
                }
                ++n;
            }
            bIOrionObject2 = bIOrionObject;
            Object var5_11 = null;
        }
        catch (Throwable throwable) {
            Object var5_12 = null;
            foxCircuit.close();
            throw throwable;
        }
        foxCircuit.close();
        return bIOrionObject2;
    }

    private final void persist(FoxCircuit foxCircuit) throws Exception {
        try {
            FoxMessage foxMessage = new FoxMessage();
            OrionSession orionSession = this.channel.getSession(foxCircuit, foxMessage, true);
            OrionInput orionInput = new OrionInput(foxCircuit.getInputStream());
            BIOrionObject bIOrionObject = orionInput.readObject();
            BPermissions bPermissions = null;
            BIOrionObject bIOrionObject2 = orionSession.read(bIOrionObject.getOrionType(), PropertyValue.makeKeys(bIOrionObject));
            bPermissions = bIOrionObject2 == null ? this.channel.getPermissionsFor(orionSession.getOrionDatabase()) : this.channel.getPermissionsFor(bIOrionObject2);
            if (!bPermissions.hasAdminWrite()) {
                throw new PermissionException("Insufficient Permission");
            }
            orionSession.persist(bIOrionObject);
            foxCircuit.writeMessage(foxMessage);
            OrionOutput orionOutput = new OrionOutput(foxCircuit.getOutputStream());
            orionOutput.writeObject(bIOrionObject);
            orionOutput.flush();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            foxCircuit.writeMessage(Fox.exceptionTranslator.exceptionToMessage((Throwable)exception));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(FoxOrionSession foxOrionSession, BIOrionObject bIOrionObject) throws Exception {
        boolean bl;
        FoxCircuit foxCircuit = this.channel.openCircuit("delete");
        this.channel.setSession(foxOrionSession, foxCircuit);
        try {
            OrionOutput orionOutput = new OrionOutput(foxCircuit.getOutputStream());
            orionOutput.writeUpdate(bIOrionObject);
            orionOutput.flush();
            FoxMessage foxMessage = foxCircuit.readMessage();
            if (foxMessage.getString("exception", null) != null) {
                throw Fox.exceptionTranslator.messageToException(foxMessage);
            }
            this.channel.assignSessionId(foxOrionSession, foxMessage);
            bl = foxMessage.getBoolean("found");
            Object var5_7 = null;
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            foxCircuit.close();
            throw throwable;
        }
        foxCircuit.close();
        return bl;
    }

    private final void delete(FoxCircuit foxCircuit) throws Exception {
        try {
            FoxMessage foxMessage = new FoxMessage("deleteResp");
            OrionSession orionSession = this.channel.getSession(foxCircuit, foxMessage, true);
            BOrionService bOrionService = (BOrionService)Sys.getService((Type)BOrionService.TYPE);
            OrionInput orionInput = new OrionInput(foxCircuit.getInputStream());
            BIOrionObject bIOrionObject = orionInput.readObject();
            BPermissions bPermissions = null;
            BIOrionObject bIOrionObject2 = orionSession.read(bIOrionObject.getOrionType(), PropertyValue.makeKeys(bIOrionObject));
            bPermissions = bIOrionObject2 == null ? this.channel.getPermissionsFor(orionSession.getOrionDatabase()) : this.channel.getPermissionsFor(bIOrionObject2);
            boolean bl = false;
            if (!bPermissions.hasAdminWrite()) {
                throw new PermissionException("Insufficient Permission");
            }
            bl = orionSession.delete(bIOrionObject);
            foxMessage.add("found", bl);
            foxCircuit.writeMessage(foxMessage);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            foxCircuit.writeMessage(Fox.exceptionTranslator.exceptionToMessage((Throwable)exception));
        }
    }

    public OrionCursor qselect(FoxOrionSession foxOrionSession, BQuery bQuery) throws Exception {
        FoxCircuit foxCircuit = this.channel.openCircuit("qselect");
        this.channel.setSession(foxOrionSession, foxCircuit);
        FoxMessage foxMessage = new FoxMessage("query");
        if (bQuery != null) {
            foxMessage.add("bquery", BogEncoder.marshal((BValue)bQuery));
        }
        foxCircuit.writeMessage(foxMessage);
        foxCircuit.flush();
        FoxMessage foxMessage2 = foxCircuit.readMessage();
        if (foxMessage2.getString("exception", null) != null) {
            throw Fox.exceptionTranslator.messageToException(foxMessage2);
        }
        this.channel.assignSessionId(foxOrionSession, foxMessage2);
        foxCircuit.readMessage();
        return new OrionObjectCursor(foxOrionSession, new OrionInput(foxOrionSession, foxCircuit.getInputStream()), null);
    }

    private final void qselect(FoxCircuit foxCircuit) throws Exception {
        try {
            FoxMessage foxMessage = new FoxMessage();
            OrionSession orionSession = this.channel.getSession(foxCircuit, foxMessage, true);
            foxCircuit.writeMessage(foxMessage);
            BQuery bQuery = null;
            FoxMessage foxMessage2 = foxCircuit.readMessage();
            String string = foxMessage2.getString("bquery", null);
            if (string == null) {
                throw new OrionException("BQuery is null.");
            }
            bQuery = (BQuery)BogDecoder.unmarshal((String)string);
            OrionCursor orionCursor = orionSession.select(bQuery);
            foxMessage = new FoxMessage("resp");
            foxMessage.add("status", "ok");
            foxCircuit.writeMessage(foxMessage);
            foxCircuit.flush();
            OrionOutput orionOutput = new OrionOutput(foxCircuit.getOutputStream());
            orionOutput.writeType(orionCursor.getOrionType());
            while (orionCursor.next()) {
                orionOutput.writeObject((BIOrionObject)orionCursor.get());
            }
            orionOutput.flush();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            foxCircuit.writeMessage(Fox.exceptionTranslator.exceptionToMessage((Throwable)exception));
        }
    }

    public OrionCursor select(FoxOrionSession foxOrionSession, OrionType orionType, String string) throws Exception {
        Object object;
        FoxCircuit foxCircuit = this.channel.openCircuit("select");
        this.channel.setSession(foxOrionSession, foxCircuit);
        FoxMessage foxMessage = new FoxMessage("select");
        if (orionType != null) {
            foxMessage.add("typeId", orionType.getOrionTypeId().encodeToString());
        }
        if (string != null) {
            foxMessage.add("sql", string);
        }
        foxCircuit.writeMessage(foxMessage);
        if (orionType != null && orionType.getOrionTypeId().isTemporary()) {
            object = new OrionOutput(foxCircuit.getOutputStream());
            ((OrionOutput)object).writeType(orionType);
            ((OrionOutput)object).flush();
        }
        foxCircuit.flush();
        object = foxCircuit.readMessage();
        if (object.getString("exception", null) != null) {
            throw Fox.exceptionTranslator.messageToException((FoxMessage)object);
        }
        this.channel.assignSessionId(foxOrionSession, (FoxMessage)object);
        foxCircuit.readMessage();
        return new OrionObjectCursor(foxOrionSession, new OrionInput(foxOrionSession, foxCircuit.getInputStream()), null);
    }

    public OrionCursor select(FoxOrionSession foxOrionSession, OrionType orionType, PropertyValue[] propertyValueArray) throws Exception {
        if (orionType.getOrionTypeId().isTemporary()) {
            throw new OrionException("Unsupported for temporary type.");
        }
        FoxCircuit foxCircuit = this.channel.openCircuit("select");
        this.channel.setSession(foxOrionSession, foxCircuit);
        FoxMessage foxMessage = new FoxMessage("select");
        foxMessage.add("typeId", orionType.getOrionTypeId().encodeToString());
        this.channel.encodePropertyValues(foxMessage, "value", propertyValueArray);
        foxCircuit.writeMessage(foxMessage);
        foxCircuit.flush();
        FoxMessage foxMessage2 = foxCircuit.readMessage();
        if (foxMessage2.getString("exception", null) != null) {
            throw Fox.exceptionTranslator.messageToException(foxMessage2);
        }
        this.channel.assignSessionId(foxOrionSession, foxMessage2);
        foxCircuit.readMessage();
        return new OrionObjectCursor(foxOrionSession, new OrionInput(foxOrionSession, foxCircuit.getInputStream()), null);
    }

    private final void select(FoxCircuit foxCircuit) throws Exception {
        try {
            Object object;
            Object object2;
            OrionCursor orionCursor = null;
            OrionType orionType = null;
            FoxMessage foxMessage = new FoxMessage();
            OrionSession orionSession = this.channel.getSession(foxCircuit, foxMessage, true);
            foxCircuit.writeMessage(foxMessage);
            String string = null;
            PropertyValue[] propertyValueArray = null;
            FoxMessage foxMessage2 = foxCircuit.readMessage();
            String string2 = foxMessage2.getString("typeId", null);
            if (string2 != null) {
                object2 = BOrionTypeId.decode(string2);
                if (object2.isTemporary()) {
                    object = new OrionInput(foxCircuit.getInputStream());
                    orionType = ((OrionInput)object).readType();
                } else {
                    orionType = orionSession.getOrionDatabase().getType((BOrionTypeId)((Object)object2));
                }
            }
            if (!(object = this.channel.getPermissionsFor(object2 = orionSession.getOrionDatabase().getType(orionType))).hasOperatorRead()) {
                throw new OrionException("Access denied");
            }
            string = foxMessage2.getString("sql", null);
            if (string == null) {
                propertyValueArray = this.channel.decodePropertyValues(orionType, foxMessage2, "value");
            }
            if (string != null) {
                orionCursor = orionSession.select(orionType, string);
            } else if (propertyValueArray != null) {
                orionCursor = orionSession.select(orionType, propertyValueArray);
            } else {
                throw new OrionException("Invalid select request.");
            }
            foxMessage = new FoxMessage("resp");
            foxMessage.add("status", "ok");
            foxCircuit.writeMessage(foxMessage);
            foxCircuit.flush();
            OrionOutput orionOutput = new OrionOutput(foxCircuit.getOutputStream());
            orionOutput.writeType(orionCursor.getOrionType());
            while (orionCursor.next()) {
                orionOutput.writeObject((BIOrionObject)orionCursor.get());
            }
            orionOutput.flush();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            foxCircuit.writeMessage(Fox.exceptionTranslator.exceptionToMessage((Throwable)exception));
        }
    }

    public OrionCursor pselect(FoxOrionSession foxOrionSession, OrionType orionType, String string, BSimple[] bSimpleArray) throws Exception {
        Object object;
        FoxCircuit foxCircuit = this.channel.openCircuit("pselect");
        this.channel.setSession(foxOrionSession, foxCircuit);
        FoxMessage foxMessage = new FoxMessage("pselect");
        if (orionType != null) {
            foxMessage.add("typeId", orionType.getOrionTypeId().encodeToString());
        }
        if (bSimpleArray != null) {
            this.channel.encodeParameters(foxMessage, bSimpleArray);
        }
        if (string != null) {
            foxMessage.add("sql", string);
        }
        foxCircuit.writeMessage(foxMessage);
        if (orionType != null && orionType.getOrionTypeId().isTemporary()) {
            object = new OrionOutput(foxCircuit.getOutputStream());
            ((OrionOutput)object).writeType(orionType);
            ((OrionOutput)object).flush();
        }
        foxCircuit.flush();
        object = foxCircuit.readMessage();
        if (object.getString("exception", null) != null) {
            throw Fox.exceptionTranslator.messageToException((FoxMessage)object);
        }
        this.channel.assignSessionId(foxOrionSession, (FoxMessage)object);
        return new OrionObjectCursor(foxOrionSession, new OrionInput(foxOrionSession, foxCircuit.getInputStream()), null);
    }

    private final void pselect(FoxCircuit foxCircuit) throws Exception {
        try {
            Object object;
            Object object2;
            FoxMessage foxMessage = new FoxMessage();
            OrionSession orionSession = this.channel.getSession(foxCircuit, foxMessage, true);
            foxCircuit.writeMessage(foxMessage);
            OrionType orionType = null;
            String string = null;
            BSimple[] bSimpleArray = null;
            FoxMessage foxMessage2 = foxCircuit.readMessage();
            String string2 = foxMessage2.getString("typeId", null);
            if (string2 != null) {
                object2 = BOrionTypeId.decode(string2);
                if (object2.isTemporary()) {
                    object = new OrionInput(foxCircuit.getInputStream());
                    orionType = ((OrionInput)object).readType();
                } else {
                    orionType = orionSession.getOrionDatabase().getType((BOrionTypeId)((Object)object2));
                }
            }
            if (!(object = this.channel.getPermissionsFor(object2 = orionSession.getOrionDatabase().getType(orionType))).hasOperatorRead()) {
                throw new OrionException("Access denied");
            }
            string = foxMessage2.getString("sql", null);
            bSimpleArray = this.channel.decodeParameters(foxMessage2);
            OrionCursor orionCursor = orionSession.select(orionType, string, bSimpleArray);
            OrionOutput orionOutput = new OrionOutput(foxCircuit.getOutputStream());
            orionOutput.writeType(orionCursor.getOrionType());
            while (orionCursor.next()) {
                orionOutput.writeObject((BIOrionObject)orionCursor.get());
            }
            orionOutput.flush();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            foxCircuit.writeMessage(Fox.exceptionTranslator.exceptionToMessage((Throwable)exception));
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void commitSyncBuffer(SyncBuffer syncBuffer) throws Exception {
        FoxCircuit foxCircuit = this.channel.openCircuit("commitSyncBuffer");
        try {
            SyncEncoder syncEncoder = new SyncEncoder(foxCircuit.getOutputStream(), null);
            syncBuffer.encode(syncEncoder);
            syncEncoder.flush();
            FoxMessage foxMessage = foxCircuit.readMessage();
            FoxMessage foxMessage2 = (FoxMessage)foxMessage.getOptional("error");
            if (foxMessage2 != null) {
                throw Fox.exceptionTranslator.messageToException(foxMessage2);
            }
            SyncBuffer syncBuffer2 = OrionSyncBuffer.getCategoryOps(syncBuffer);
            syncBuffer2.commit();
        }
        catch (Throwable throwable) {
            Object var4_8 = null;
            foxCircuit.close();
            throw throwable;
        }
        {
            Object var4_9 = null;
        }
        foxCircuit.close();
    }

    private final void commitSyncBuffer(FoxCircuit foxCircuit) throws Exception {
        try {
            BOrionService bOrionService = (BOrionService)Sys.getService((Type)BOrionService.TYPE);
            BOrionSpace bOrionSpace = bOrionService.getOrionSpace();
            SyncDecoder syncDecoder = new SyncDecoder(foxCircuit.getInputStream());
            SyncBuffer syncBuffer = bOrionSpace.makeSyncBuffer(false);
            syncBuffer.decode(syncDecoder);
            Context context = this.channel.getSessionContext();
            syncBuffer.commit(context);
            FoxMessage foxMessage = new FoxMessage();
            foxCircuit.writeMessage(foxMessage);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            foxCircuit.writeMessage(Fox.exceptionTranslator.exceptionToMessage((Throwable)exception));
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sendSyncBufferToClient(SyncBuffer syncBuffer) throws Exception {
        FoxCircuit foxCircuit = this.channel.openCircuit("sendSyncBufferToClient");
        try {
            SyncEncoder syncEncoder = new SyncEncoder(foxCircuit.getOutputStream(), null);
            syncBuffer.encode(syncEncoder);
            syncEncoder.flush();
            FoxMessage foxMessage = foxCircuit.readMessage();
            FoxMessage foxMessage2 = (FoxMessage)foxMessage.getOptional("error");
            if (foxMessage2 != null) {
                throw Fox.exceptionTranslator.messageToException(foxMessage2);
            }
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            foxCircuit.close();
            throw throwable;
        }
        {
            Object var4_8 = null;
        }
        foxCircuit.close();
    }

    private final void receiveSyncBufferFromServer(FoxCircuit foxCircuit) throws Exception {
        BFoxSession bFoxSession = this.channel.getFoxSession();
        BOrionSpace bOrionSpace = (BOrionSpace)BOrd.make((String)"orion:").get((BObject)bFoxSession);
        SyncDecoder syncDecoder = new SyncDecoder(foxCircuit.getInputStream());
        SyncBuffer syncBuffer = bOrionSpace.makeSyncBuffer(false);
        syncBuffer.decode(syncDecoder);
        syncBuffer.commit(Context.commit);
        FoxMessage foxMessage = new FoxMessage();
        foxCircuit.writeMessage(foxMessage);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void batchInsert(FoxOrionSession foxOrionSession, BatchStatement batchStatement) throws Exception {
        FoxCircuit foxCircuit = this.channel.openCircuit("batchInsert");
        try {
            FoxMessage foxMessage;
            this.channel.setSession(foxOrionSession, foxCircuit);
            OrionOutput orionOutput = new OrionOutput(foxCircuit.getOutputStream());
            orionOutput.writeType(batchStatement.getOrionType());
            orionOutput.writeIntElem("chunkSize", "size", batchStatement.getChunkSize());
            orionOutput.writeIntElem("batchSize", "size", batchStatement.size());
            int n = 0;
            while (true) {
                if (n >= batchStatement.size()) {
                    orionOutput.flush();
                    foxMessage = foxCircuit.readMessage();
                    if (foxMessage.getString("exception", null) == null) break;
                    throw Fox.exceptionTranslator.messageToException(foxMessage);
                }
                orionOutput.writeObject(batchStatement.get(n));
                ++n;
            }
            this.channel.assignSessionId(foxOrionSession, foxMessage);
            OrionInput orionInput = new OrionInput(foxOrionSession, foxCircuit.getInputStream());
            int n2 = 0;
            while (n2 < batchStatement.size()) {
                BIOrionObject bIOrionObject = batchStatement.get(n2);
                this.readClientInsert(orionInput, foxOrionSession.getOrionDatabase(), bIOrionObject);
                ++n2;
            }
        }
        catch (Throwable throwable) {
            Object var5_11 = null;
            foxCircuit.close();
            throw throwable;
        }
        {
            Object var5_12 = null;
        }
        foxCircuit.close();
    }

    private final void batchInsert(FoxCircuit foxCircuit) throws Exception {
        try {
            Object object;
            FoxMessage foxMessage = new FoxMessage();
            OrionSession orionSession = this.channel.getSession(foxCircuit, foxMessage, true);
            OrionInput orionInput = new OrionInput(foxCircuit.getInputStream());
            OrionType orionType = orionInput.readType();
            int n = orionInput.readIntElem("chunkSize", "size");
            int n2 = orionInput.readIntElem("batchSize", "size");
            BatchStatement batchStatement = orionSession.batchInsert(orionType);
            batchStatement.setChunkSize(n);
            BIOrionObject[] bIOrionObjectArray = new BIOrionObject[n2];
            int n3 = 0;
            while (n3 < n2) {
                object = orionInput.readObject();
                bIOrionObjectArray[n3] = object;
                batchStatement.add((BIOrionObject)object);
                ++n3;
            }
            BPermissions bPermissions = this.channel.getPermissionsFor(orionType);
            if (!bPermissions.hasAdminWrite()) {
                throw new PermissionException("Insufficient Permission");
            }
            batchStatement.execute();
            foxCircuit.writeMessage(foxMessage);
            object = new OrionOutput(foxCircuit.getOutputStream());
            int n4 = 0;
            while (n4 < n2) {
                ((OrionOutput)object).writeObject(bIOrionObjectArray[n4]);
                ++n4;
            }
            ((OrionOutput)object).flush();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            foxCircuit.writeMessage(Fox.exceptionTranslator.exceptionToMessage((Throwable)exception));
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void batchUpdate(FoxOrionSession foxOrionSession, BatchStatement batchStatement) throws Exception {
        FoxCircuit foxCircuit = this.channel.openCircuit("batchUpdate");
        try {
            FoxMessage foxMessage;
            this.channel.setSession(foxOrionSession, foxCircuit);
            OrionOutput orionOutput = new OrionOutput(foxCircuit.getOutputStream());
            orionOutput.writeType(batchStatement.getOrionType());
            orionOutput.writeIntElem("chunkSize", "size", batchStatement.getChunkSize());
            orionOutput.writeIntElem("batchSize", "size", batchStatement.size());
            int n = 0;
            while (true) {
                if (n >= batchStatement.size()) {
                    orionOutput.flush();
                    foxMessage = foxCircuit.readMessage();
                    if (foxMessage.getString("exception", null) == null) break;
                    throw Fox.exceptionTranslator.messageToException(foxMessage);
                }
                orionOutput.writeUpdate(batchStatement.get(n));
                ++n;
            }
            this.channel.assignSessionId(foxOrionSession, foxMessage);
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            foxCircuit.close();
            throw throwable;
        }
        {
            Object var5_9 = null;
        }
        foxCircuit.close();
    }

    private final void batchUpdate(FoxCircuit foxCircuit) throws Exception {
        try {
            FoxMessage foxMessage = new FoxMessage();
            OrionSession orionSession = this.channel.getSession(foxCircuit, foxMessage, true);
            OrionInput orionInput = new OrionInput(foxCircuit.getInputStream());
            OrionType orionType = orionInput.readType();
            int n = orionInput.readIntElem("chunkSize", "size");
            int n2 = orionInput.readIntElem("batchSize", "size");
            BatchStatement batchStatement = orionSession.batchUpdate(orionType);
            batchStatement.setChunkSize(n);
            int n3 = 0;
            while (n3 < n2) {
                BIOrionObject bIOrionObject = orionInput.readUpdate();
                batchStatement.add(bIOrionObject);
                OrionType orionType2 = bIOrionObject.getOrionType();
                Property[] propertyArray = orionType2.getKey();
                int n4 = 0;
                while (n4 < propertyArray.length) {
                    bIOrionObject.setModified(propertyArray[n4], false);
                    ++n4;
                }
                ++n3;
            }
            BPermissions bPermissions = this.channel.getPermissionsFor(orionType);
            if (!bPermissions.hasAdminWrite()) {
                throw new PermissionException("Insufficient Permission");
            }
            batchStatement.execute();
            foxCircuit.writeMessage(foxMessage);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            foxCircuit.writeMessage(Fox.exceptionTranslator.exceptionToMessage((Throwable)exception));
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void batchPersist(FoxOrionSession foxOrionSession, BatchStatement batchStatement) throws Exception {
        FoxCircuit foxCircuit = this.channel.openCircuit("batchPersist");
        try {
            FoxMessage foxMessage;
            this.channel.setSession(foxOrionSession, foxCircuit);
            OrionOutput orionOutput = new OrionOutput(foxCircuit.getOutputStream());
            orionOutput.writeType(batchStatement.getOrionType());
            orionOutput.writeIntElem("chunkSize", "size", batchStatement.getChunkSize());
            orionOutput.writeIntElem("batchSize", "size", batchStatement.size());
            int n = 0;
            while (true) {
                if (n >= batchStatement.size()) {
                    orionOutput.flush();
                    foxMessage = foxCircuit.readMessage();
                    if (foxMessage.getString("exception", null) == null) break;
                    throw Fox.exceptionTranslator.messageToException(foxMessage);
                }
                orionOutput.writeObject(batchStatement.get(n));
                ++n;
            }
            this.channel.assignSessionId(foxOrionSession, foxMessage);
            OrionInput orionInput = new OrionInput(foxOrionSession, foxCircuit.getInputStream());
            int n2 = 0;
            while (n2 < batchStatement.size()) {
                BIOrionObject bIOrionObject = batchStatement.get(n2);
                this.readClientInsert(orionInput, foxOrionSession.getOrionDatabase(), bIOrionObject);
                ++n2;
            }
        }
        catch (Throwable throwable) {
            Object var5_11 = null;
            foxCircuit.close();
            throw throwable;
        }
        {
            Object var5_12 = null;
        }
        foxCircuit.close();
    }

    private final void batchPersist(FoxCircuit foxCircuit) throws Exception {
        try {
            Object object;
            FoxMessage foxMessage = new FoxMessage();
            OrionSession orionSession = this.channel.getSession(foxCircuit, foxMessage, true);
            OrionInput orionInput = new OrionInput(foxCircuit.getInputStream());
            OrionType orionType = orionInput.readType();
            int n = orionInput.readIntElem("chunkSize", "size");
            int n2 = orionInput.readIntElem("batchSize", "size");
            BatchStatement batchStatement = orionSession.batchPersist(orionType);
            batchStatement.setChunkSize(n);
            BIOrionObject[] bIOrionObjectArray = new BIOrionObject[n2];
            int n3 = 0;
            while (n3 < n2) {
                object = orionInput.readObject();
                bIOrionObjectArray[n3] = object;
                batchStatement.add((BIOrionObject)object);
                ++n3;
            }
            BPermissions bPermissions = this.channel.getPermissionsFor(orionType);
            if (!bPermissions.hasAdminWrite()) {
                throw new PermissionException("Insufficient Permission");
            }
            batchStatement.execute();
            foxCircuit.writeMessage(foxMessage);
            object = new OrionOutput(foxCircuit.getOutputStream());
            int n4 = 0;
            while (n4 < n2) {
                ((OrionOutput)object).writeObject(bIOrionObjectArray[n4]);
                ++n4;
            }
            ((OrionOutput)object).flush();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            foxCircuit.writeMessage(Fox.exceptionTranslator.exceptionToMessage((Throwable)exception));
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void batchDelete(FoxOrionSession foxOrionSession, BatchStatement batchStatement) throws Exception {
        FoxCircuit foxCircuit = this.channel.openCircuit("batchDelete");
        try {
            FoxMessage foxMessage;
            this.channel.setSession(foxOrionSession, foxCircuit);
            OrionOutput orionOutput = new OrionOutput(foxCircuit.getOutputStream());
            orionOutput.writeType(batchStatement.getOrionType());
            orionOutput.writeIntElem("chunkSize", "size", batchStatement.getChunkSize());
            orionOutput.writeIntElem("batchSize", "size", batchStatement.size());
            int n = 0;
            while (true) {
                if (n >= batchStatement.size()) {
                    orionOutput.flush();
                    foxMessage = foxCircuit.readMessage();
                    if (foxMessage.getString("exception", null) == null) break;
                    throw Fox.exceptionTranslator.messageToException(foxMessage);
                }
                orionOutput.writeObject(batchStatement.get(n));
                ++n;
            }
            this.channel.assignSessionId(foxOrionSession, foxMessage);
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            foxCircuit.close();
            throw throwable;
        }
        {
            Object var5_9 = null;
        }
        foxCircuit.close();
    }

    private final void batchDelete(FoxCircuit foxCircuit) throws Exception {
        try {
            FoxMessage foxMessage = new FoxMessage();
            OrionSession orionSession = this.channel.getSession(foxCircuit, foxMessage, true);
            OrionInput orionInput = new OrionInput(foxCircuit.getInputStream());
            OrionType orionType = orionInput.readType();
            int n = orionInput.readIntElem("chunkSize", "size");
            int n2 = orionInput.readIntElem("batchSize", "size");
            BatchStatement batchStatement = orionSession.batchDelete(orionType);
            batchStatement.setChunkSize(n);
            int n3 = 0;
            while (n3 < n2) {
                batchStatement.add(orionInput.readObject());
                ++n3;
            }
            BPermissions bPermissions = this.channel.getPermissionsFor(orionType);
            if (!bPermissions.hasAdminWrite()) {
                throw new PermissionException("Insufficient Permission");
            }
            batchStatement.execute();
            foxCircuit.writeMessage(foxMessage);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            foxCircuit.writeMessage(Fox.exceptionTranslator.exceptionToMessage((Throwable)exception));
        }
    }

    OrionCircuit(BOrionChannel bOrionChannel) {
        this.channel = bOrionChannel;
    }
}

