/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion.priv.fox;

import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionException;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.priv.fox.BFoxOrionDatabase;
import com.tridium.orion.priv.fox.BOrionChannel;
import com.tridium.orion.priv.fox.FoxBatchDelete;
import com.tridium.orion.priv.fox.FoxBatchInsert;
import com.tridium.orion.priv.fox.FoxBatchPersist;
import com.tridium.orion.priv.fox.FoxBatchUpdate;
import com.tridium.orion.priv.util.MapHelper;
import com.tridium.orion.sql.BSqlUpdate;
import com.tridium.orion.sql.BatchStatement;
import com.tridium.orion.sql.PropertyValue;
import javax.baja.query.BExpression;
import javax.baja.query.BQuery;
import javax.baja.rdb.BRdbms;
import javax.baja.rdb.RdbmsContext;
import javax.baja.rdb.ddl.DdlCommand;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.user.BUser;
import javax.baja.util.BTypeSpec;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class FoxOrionSession
implements OrionSession {
    private static final int SESSION_INIT = -1;
    private static final int SESSION_CLOSED = -2;
    private Context context;
    private BFoxOrionDatabase db;
    private RdbmsContext rdbmsContext;
    private boolean autoCommit;
    private int sessionId;
    private MapHelper mapHelper;

    public BOrionDatabase getOrionDatabase() {
        return this.db;
    }

    public RdbmsContext getRdbmsContext() {
        this.checkClosed();
        if (this.rdbmsContext == null) {
            try {
                BTypeSpec bTypeSpec = this.db.getChannel().requestHandler.getRdbmsTypeSpec(this);
                this.rdbmsContext = ((BRdbms)bTypeSpec.getInstance()).getRdbmsContext();
            }
            catch (OrionException orionException) {
                throw orionException;
            }
            catch (Exception exception) {
                throw new OrionException("Operation failed.", exception);
            }
        }
        return this.rdbmsContext;
    }

    void open(int n) {
        this.checkClosed();
        this.sessionId = n;
    }

    public int getSessionId() {
        return this.sessionId;
    }

    public void setAutoCommit(boolean bl) {
        this.checkClosed();
        this.autoCommit = bl;
    }

    public boolean getAutoCommit() {
        return this.autoCommit;
    }

    public void commit() {
        if (!this.isOpen()) {
            return;
        }
        try {
            BOrionChannel bOrionChannel = this.db.getChannel();
            bOrionChannel.requestHandler.commit(this);
        }
        catch (OrionException orionException) {
            throw orionException;
        }
        catch (Exception exception) {
            throw new OrionException("Operation failed.", exception);
        }
    }

    public void rollback() {
        if (!this.isOpen()) {
            return;
        }
        try {
            BOrionChannel bOrionChannel = this.db.getChannel();
            bOrionChannel.requestHandler.rollback(this);
        }
        catch (OrionException orionException) {
            throw orionException;
        }
        catch (Exception exception) {
            throw new OrionException("Operation failed.", exception);
        }
    }

    public boolean isOpen() {
        boolean bl = false;
        if (this.sessionId != -2) {
            bl = true;
        }
        return bl;
    }

    private final void checkClosed() {
        if (this.sessionId == -2) {
            throw new OrionException("Session has been closed.");
        }
    }

    public void close() {
        if (this.sessionId == -1) {
            this.sessionId = -2;
        }
        if (!this.isOpen()) {
            return;
        }
        try {
            BOrionChannel bOrionChannel = this.db.getChannel();
            bOrionChannel.requestHandler.closeSession(this);
        }
        catch (OrionException orionException) {
            throw orionException;
        }
        catch (Exception exception) {
            throw new OrionException("Operation failed.", exception);
        }
    }

    public void closed() {
        this.sessionId = -2;
    }

    public void invokeDdl(DdlCommand ddlCommand) {
        this.checkClosed();
        try {
            BOrionChannel bOrionChannel = this.db.getChannel();
            bOrionChannel.requestHandler.invokeDdl(this, ddlCommand.getDdl(this.getRdbmsContext()));
        }
        catch (OrionException orionException) {
            throw orionException;
        }
        catch (Exception exception) {
            throw new OrionException("Operation failed.", exception);
        }
    }

    public void insert(BIOrionObject bIOrionObject) {
        this.checkClosed();
        try {
            BOrionChannel bOrionChannel = this.db.getChannel();
            bOrionChannel.circuitHandler.insert(this, bIOrionObject);
        }
        catch (OrionException orionException) {
            throw orionException;
        }
        catch (Exception exception) {
            throw new OrionException("Operation failed.", exception);
        }
    }

    public int insert(String string) {
        return this.insert(string, null);
    }

    public int insert(String string, BSimple[] bSimpleArray) {
        this.checkClosed();
        try {
            return this.db.getChannel().requestHandler.insertRaw(this, string, bSimpleArray);
        }
        catch (OrionException orionException) {
            throw orionException;
        }
        catch (Exception exception) {
            throw new OrionException("Operation failed.", exception);
        }
    }

    public void mappedInsert(BObject bObject) {
        this.insert(this.mapHelper.mapForInsert(bObject));
    }

    public boolean exists(BIOrionObject bIOrionObject) {
        this.checkClosed();
        try {
            BOrionChannel bOrionChannel = this.db.getChannel();
            return bOrionChannel.requestHandler.exists(this, bIOrionObject.getOrionType(), PropertyValue.makeKeys(bIOrionObject));
        }
        catch (OrionException orionException) {
            throw orionException;
        }
        catch (Exception exception) {
            throw new OrionException("Operation failed.", exception);
        }
    }

    public boolean exists(OrionType orionType, PropertyValue[] propertyValueArray) {
        this.checkClosed();
        try {
            BOrionChannel bOrionChannel = this.db.getChannel();
            return bOrionChannel.requestHandler.exists(this, orionType, propertyValueArray);
        }
        catch (OrionException orionException) {
            throw orionException;
        }
        catch (Exception exception) {
            throw new OrionException("Operation failed.", exception);
        }
    }

    public BIOrionObject mappedRead(BObject bObject) {
        this.checkClosed();
        BIOrionObject bIOrionObject = this.mapHelper.mapForRead(bObject);
        if (this.read(bIOrionObject) == null) {
            return null;
        }
        return bIOrionObject;
    }

    public BIOrionObject read(BQuery bQuery) {
        this.checkClosed();
        try {
            BOrionChannel bOrionChannel = this.db.getChannel();
            BIOrionObject[] bIOrionObjectArray = bOrionChannel.circuitHandler.qselect(this, bQuery).toArray();
            switch (bIOrionObjectArray.length) {
                case 0: {
                    return null;
                }
                case 1: {
                    return bIOrionObjectArray[0];
                }
            }
            throw new OrionException("More than one object found");
        }
        catch (OrionException orionException) {
            throw orionException;
        }
        catch (Exception exception) {
            throw new OrionException("Operation failed.", exception);
        }
    }

    public BIOrionObject read(BIOrionObject bIOrionObject) {
        this.checkClosed();
        try {
            BOrionChannel bOrionChannel = this.db.getChannel();
            BIOrionObject bIOrionObject2 = bOrionChannel.circuitHandler.read(this, bIOrionObject);
            if (bIOrionObject2 == null) {
                return null;
            }
            this.copyAfterRead(bIOrionObject, bIOrionObject2);
            return bIOrionObject;
        }
        catch (OrionException orionException) {
            throw orionException;
        }
        catch (Exception exception) {
            throw new OrionException("Operation failed.", exception);
        }
    }

    private final void copyAfterRead(BIOrionObject bIOrionObject, BIOrionObject bIOrionObject2) {
        OrionType orionType;
        OrionType orionType2 = bIOrionObject.getOrionType();
        if (orionType2 != (orionType = bIOrionObject2.getOrionType())) {
            throw new OrionException("Type mismatch: " + orionType2 + " != " + orionType);
        }
        bIOrionObject.copyFrom(bIOrionObject2);
        bIOrionObject.setOrionDatabase(this.getOrionDatabase());
    }

    public BIOrionObject read(OrionType orionType, BSimple bSimple) {
        this.checkClosed();
        try {
            BOrionChannel bOrionChannel = this.db.getChannel();
            return bOrionChannel.circuitHandler.read(this, orionType, bSimple);
        }
        catch (OrionException orionException) {
            throw orionException;
        }
        catch (Exception exception) {
            throw new OrionException("Operation failed.", exception);
        }
    }

    public BIOrionObject read(OrionType orionType, PropertyValue propertyValue) {
        return this.read(orionType, new PropertyValue[]{propertyValue});
    }

    public BIOrionObject read(OrionType orionType, PropertyValue[] propertyValueArray) {
        this.checkClosed();
        try {
            BOrionChannel bOrionChannel = this.db.getChannel();
            return bOrionChannel.circuitHandler.read(this, orionType, propertyValueArray);
        }
        catch (OrionException orionException) {
            throw orionException;
        }
        catch (Exception exception) {
            throw new OrionException("Operation failed.", exception);
        }
    }

    public BIOrionObject read(OrionType orionType, String string) {
        this.checkClosed();
        try {
            BOrionChannel bOrionChannel = this.db.getChannel();
            return bOrionChannel.circuitHandler.readRaw(this, orionType, string);
        }
        catch (OrionException orionException) {
            throw orionException;
        }
        catch (Exception exception) {
            throw new OrionException("Operation failed.", exception);
        }
    }

    public BIOrionObject read(OrionType orionType, String string, BSimple[] bSimpleArray) {
        this.checkClosed();
        try {
            BOrionChannel bOrionChannel = this.db.getChannel();
            return bOrionChannel.circuitHandler.preadRaw(this, orionType, string, bSimpleArray);
        }
        catch (OrionException orionException) {
            throw orionException;
        }
        catch (Exception exception) {
            throw new OrionException("Operation failed.", exception);
        }
    }

    public int update(BSqlUpdate bSqlUpdate) {
        this.checkClosed();
        try {
            return this.db.getChannel().requestHandler.qupdate(this, bSqlUpdate);
        }
        catch (OrionException orionException) {
            throw orionException;
        }
        catch (Exception exception) {
            throw new OrionException("Operation failed.", exception);
        }
    }

    public int update(String string) {
        return this.update(string, null);
    }

    public int update(String string, BSimple[] bSimpleArray) {
        this.checkClosed();
        try {
            return this.db.getChannel().requestHandler.updateRaw(this, string, bSimpleArray);
        }
        catch (OrionException orionException) {
            throw orionException;
        }
        catch (Exception exception) {
            throw new OrionException("Operation failed.", exception);
        }
    }

    public void update(BIOrionObject bIOrionObject) {
        this.update(bIOrionObject, false);
    }

    public void update(BIOrionObject bIOrionObject, boolean bl) {
        this.checkClosed();
        try {
            BOrionChannel bOrionChannel = this.db.getChannel();
            bOrionChannel.circuitHandler.update(this, bIOrionObject, bl);
        }
        catch (OrionException orionException) {
            throw orionException;
        }
        catch (Exception exception) {
            throw new OrionException("Operation failed.", exception);
        }
    }

    public void mappedUpdate(BObject bObject) {
        this.update(this.mapHelper.mapForUpdate(bObject));
    }

    public void persist(BIOrionObject bIOrionObject) {
        this.checkClosed();
        try {
            BOrionChannel bOrionChannel = this.db.getChannel();
            bOrionChannel.circuitHandler.persist(this, bIOrionObject);
        }
        catch (OrionException orionException) {
            throw orionException;
        }
        catch (Exception exception) {
            throw new OrionException("Operation failed.", exception);
        }
    }

    public int delete(OrionType orionType, BExpression bExpression) {
        this.checkClosed();
        try {
            return this.db.getChannel().requestHandler.qdelete(this, orionType, bExpression);
        }
        catch (OrionException orionException) {
            throw orionException;
        }
        catch (Exception exception) {
            throw new OrionException("Operation failed.", exception);
        }
    }

    public int delete(String string) {
        return this.delete(string, null);
    }

    public int delete(String string, BSimple[] bSimpleArray) {
        this.checkClosed();
        try {
            return this.db.getChannel().requestHandler.deleteRaw(this, string, bSimpleArray);
        }
        catch (OrionException orionException) {
            throw orionException;
        }
        catch (Exception exception) {
            throw new OrionException("Operation failed.", exception);
        }
    }

    public boolean mappedDelete(BObject bObject) {
        return this.delete(this.mapHelper.mapForDelete(bObject));
    }

    public boolean delete(BIOrionObject bIOrionObject) {
        this.checkClosed();
        try {
            BOrionChannel bOrionChannel = this.db.getChannel();
            return bOrionChannel.circuitHandler.delete(this, bIOrionObject);
        }
        catch (OrionException orionException) {
            throw orionException;
        }
        catch (Exception exception) {
            throw new OrionException("Operation failed.", exception);
        }
    }

    public OrionCursor select(BQuery bQuery) {
        this.checkClosed();
        try {
            BOrionChannel bOrionChannel = this.db.getChannel();
            return bOrionChannel.circuitHandler.qselect(this, bQuery);
        }
        catch (OrionException orionException) {
            throw orionException;
        }
        catch (Exception exception) {
            throw new OrionException("Operation failed.", exception);
        }
    }

    public OrionCursor select(OrionType orionType, String string) {
        this.checkClosed();
        try {
            BOrionChannel bOrionChannel = this.db.getChannel();
            return bOrionChannel.circuitHandler.select(this, orionType, string);
        }
        catch (OrionException orionException) {
            throw orionException;
        }
        catch (Exception exception) {
            throw new OrionException("Operation failed.", exception);
        }
    }

    public OrionCursor select(OrionType orionType, String string, BSimple[] bSimpleArray) {
        this.checkClosed();
        try {
            BOrionChannel bOrionChannel = this.db.getChannel();
            return bOrionChannel.circuitHandler.pselect(this, orionType, string, bSimpleArray);
        }
        catch (OrionException orionException) {
            throw orionException;
        }
        catch (Exception exception) {
            throw new OrionException("Operation failed.", exception);
        }
    }

    public OrionCursor select(OrionType orionType, PropertyValue propertyValue) {
        return this.select(orionType, new PropertyValue[]{propertyValue});
    }

    public OrionCursor select(OrionType orionType, PropertyValue[] propertyValueArray) {
        this.checkClosed();
        try {
            BOrionChannel bOrionChannel = this.db.getChannel();
            return bOrionChannel.circuitHandler.select(this, orionType, propertyValueArray);
        }
        catch (OrionException orionException) {
            throw orionException;
        }
        catch (Exception exception) {
            throw new OrionException("Operation failed.", exception);
        }
    }

    public OrionCursor scan(OrionType orionType) {
        this.checkClosed();
        try {
            BOrionChannel bOrionChannel = this.db.getChannel();
            return bOrionChannel.circuitHandler.scan(this, orionType);
        }
        catch (OrionException orionException) {
            throw orionException;
        }
        catch (Exception exception) {
            throw new OrionException("Operation failed.", exception);
        }
    }

    public OrionCursor linkedScan(BIOrionObject bIOrionObject, OrionType orionType, OrionType orionType2) {
        this.checkClosed();
        try {
            BOrionChannel bOrionChannel = this.db.getChannel();
            return bOrionChannel.circuitHandler.linkedScan(this, bIOrionObject, orionType, orionType2);
        }
        catch (OrionException orionException) {
            throw orionException;
        }
        catch (Exception exception) {
            throw new OrionException("Operation failed.", exception);
        }
    }

    public BatchStatement batchInsert(OrionType orionType) {
        return new FoxBatchInsert(this, this.db.getChannel(), orionType);
    }

    public BatchStatement batchUpdate(OrionType orionType) {
        return new FoxBatchUpdate(this, this.db.getChannel(), orionType);
    }

    public BatchStatement batchPersist(OrionType orionType) {
        return new FoxBatchPersist(this, this.db.getChannel(), orionType);
    }

    public BatchStatement batchDelete(OrionType orionType) {
        return new FoxBatchDelete(this, this.db.getChannel(), orionType);
    }

    public Context getBase() {
        return this.context;
    }

    public String getLanguage() {
        if (this.context != null) {
            return this.context.getLanguage();
        }
        return Sys.getLanguage();
    }

    public BFacets getFacets() {
        if (this.context != null) {
            return this.context.getFacets();
        }
        return BFacets.DEFAULT;
    }

    public BObject getFacet(String string) {
        if (this.context != null) {
            return this.context.getFacet(string);
        }
        return null;
    }

    public BUser getUser() {
        if (this.context != null) {
            return this.context.getUser();
        }
        return null;
    }

    private final /* synthetic */ void this() {
        this.autoCommit = true;
        this.sessionId = -1;
    }

    public FoxOrionSession(BFoxOrionDatabase bFoxOrionDatabase, Context context) {
        this.this();
        this.db = bFoxOrionDatabase;
        this.context = context;
        this.mapHelper = new MapHelper();
    }
}

