/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion.priv.db.sql;

import com.tridium.orion.BLocalOrionDatabase;
import com.tridium.orion.BOrionSpace;
import com.tridium.orion.OrionException;
import com.tridium.orion.OrionType;
import com.tridium.orion.priv.db.TableDefinition;
import com.tridium.orion.priv.db.sql.NameGenerator;
import com.tridium.orion.priv.db.sql.SqlHelper;
import com.tridium.orion.priv.db.sql.SqlVisitor;
import com.tridium.orion.priv.model.DynamicOrionProperty;
import com.tridium.orion.sql.BExtentProjection;
import com.tridium.orion.sql.BPage;
import com.tridium.orion.sql.BSqlCase;
import com.tridium.orion.sql.BSqlJoin;
import com.tridium.orion.sql.BSqlQuery;
import com.tridium.orion.sql.BSubSqlQuery;
import javax.baja.query.BExpression;
import javax.baja.query.BProjectionColumn;
import javax.baja.query.BQuery;
import javax.baja.query.BQueryNode;
import javax.baja.query.BTypedExtent;
import javax.baja.query.expression.BFieldExpression;
import javax.baja.query.expression.BFunctionExpression;
import javax.baja.query.expression.BSimpleExpression;
import javax.baja.rdb.BRdbms;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Property;
import javax.baja.util.Array;
import javax.baja.util.BTypeSpec;
import javax.baja.util.TextUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SelectVisitor
extends SqlVisitor {
    protected static final BTypeSpec DB2 = BTypeSpec.make((String)"rdbDb2:Db2Database");
    protected static final BTypeSpec ORACLE = BTypeSpec.make((String)"rdbOracle:OracleDatabase");
    protected static final BTypeSpec HSQL = BTypeSpec.make((String)"rdbHsqlDb:HsqlDatabase");
    protected static final BTypeSpec SQL_SERVER = BTypeSpec.make((String)"rdbSqlServer:SqlServerDatabase");
    protected static final BTypeSpec MY_SQL = BTypeSpec.make((String)"rdbMySQL:MySQLDatabase");
    protected BQuery query;
    protected Array returnTypeProps;
    protected boolean isSelectAll;
    static /* synthetic */ Class class$javax$baja$sys$Property;

    public OrionType getResultType() {
        return this.query.getProjection() instanceof BExtentProjection ? this.getExtentType() : BOrionSpace.createDynamicType((Property[])this.returnTypeProps.trim());
    }

    protected void initialize() {
        super.initialize();
        this.query = null;
        Class clazz = class$javax$baja$sys$Property;
        if (clazz == null) {
            clazz = class$javax$baja$sys$Property = SelectVisitor.class("[Ljavax.baja.sys.Property;", false);
        }
        this.returnTypeProps = new Array(clazz);
        this.isSelectAll = false;
    }

    private final void setBufferFromQT(StringBuffer stringBuffer) {
        stringBuffer.append(this.queryText);
        this.queryText = new StringBuffer();
    }

    private final String getAlias(BExpression bExpression) {
        BProjectionColumn bProjectionColumn = (BProjectionColumn)bExpression.getParent();
        if (bProjectionColumn.hasAlias()) {
            return bProjectionColumn.getAlias();
        }
        return null;
    }

    protected boolean inProjectionColumn(BQueryNode bQueryNode) {
        boolean bl = false;
        if (bQueryNode.getParent() != null && bQueryNode.getParent().getType().is(BProjectionColumn.TYPE)) {
            bl = true;
        }
        return bl;
    }

    protected OrionType getExtentType() {
        try {
            return (OrionType)this.query.getExtent().asTypedExtent().listTypes()[0];
        }
        catch (Exception exception) {
            throw new OrionException("Failed to build query because the extent is not set, or is not a BTypedExtent.", exception);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void visit(BQuery bQuery) {
        StringBuffer stringBuffer;
        StringBuffer stringBuffer2;
        this.initialize();
        this.query = bQuery;
        this.helper = new SqlHelper(this.db, this.query);
        StringBuffer stringBuffer3 = new StringBuffer();
        stringBuffer3.append("SELECT ");
        if (bQuery.hasProjection()) {
            try {
                this.setUseParameterSubstitution(true);
                this.visit(bQuery.getProjection());
                this.setBufferFromQT(stringBuffer3);
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this.setUseParameterSubstitution(false);
                throw throwable;
            }
            {
                stringBuffer2 = null;
            }
            this.setUseParameterSubstitution(false);
        }
        StringBuffer stringBuffer4 = new StringBuffer();
        if (this.query instanceof BSqlQuery) {
            try {
                this.setUseParameterSubstitution(true);
                this.visit(((BSqlQuery)this.query).getJoins());
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                this.setUseParameterSubstitution(false);
                throw throwable;
            }
            {
                stringBuffer = null;
            }
            this.setUseParameterSubstitution(false);
        }
        this.setBufferFromQT(stringBuffer4);
        stringBuffer2 = new StringBuffer();
        if (bQuery.hasPredicate()) {
            stringBuffer2.append("WHERE ");
            this.visit(bQuery.getPredicate());
            this.setBufferFromQT(stringBuffer2);
        }
        stringBuffer = new StringBuffer();
        if (bQuery.hasGrouping()) {
            stringBuffer.append("GROUP BY ");
            this.visit(bQuery.getGrouping());
            this.setBufferFromQT(stringBuffer);
        }
        StringBuffer stringBuffer5 = new StringBuffer();
        if (bQuery.hasHaving()) {
            try {
                this.setUseParameterSubstitution(true);
                stringBuffer5.append("HAVING ");
                this.visit(bQuery.getHaving());
                this.setBufferFromQT(stringBuffer5);
            }
            catch (Throwable throwable) {
                Object var8_13 = null;
                this.setUseParameterSubstitution(false);
                throw throwable;
            }
            {
                Object var8_14 = null;
            }
            this.setUseParameterSubstitution(false);
        }
        StringBuffer stringBuffer6 = new StringBuffer();
        if (bQuery.hasOrdering()) {
            stringBuffer6.append("ORDER BY ");
            this.visit(bQuery.getOrdering());
            this.setBufferFromQT(stringBuffer6);
        }
        this.queryText.append(stringBuffer3);
        if (bQuery.hasExtent()) {
            this.queryText.append("FROM ");
            this.visit(bQuery.getExtent());
        }
        this.queryText.append(stringBuffer4);
        this.queryText.append(stringBuffer2);
        this.queryText.append(stringBuffer);
        this.queryText.append(stringBuffer5);
        if (this.query instanceof BSqlQuery && ((BSqlQuery)this.query).hasPage() && this.dbSupportsPagination()) {
            this.queryText = this.paginate((BSqlQuery)this.query, stringBuffer6);
            return;
        }
        this.queryText.append(stringBuffer6);
    }

    public void visit(BExpression bExpression) {
        if (bExpression instanceof BSqlCase) {
            this.visit((BSqlCase)bExpression);
        } else if (bExpression instanceof BSubSqlQuery) {
            this.visitQuery((BSubSqlQuery)bExpression);
        } else {
            super.visit(bExpression);
        }
    }

    public void visit(BProjectionColumn bProjectionColumn) {
        if (bProjectionColumn.getColumnExpression() instanceof BFieldExpression) {
            this.visit((BFieldExpression)bProjectionColumn.getColumnExpression());
        } else {
            super.visit(bProjectionColumn);
        }
    }

    public void visit(BSqlJoin[] bSqlJoinArray) {
        if (bSqlJoinArray.length == 0) {
            return;
        }
        int n = 0;
        while (n < bSqlJoinArray.length) {
            this.visit(bSqlJoinArray[n]);
            ++n;
        }
    }

    public void visit(BSqlJoin bSqlJoin) {
        this.queryText.append(' ').append(TextUtil.toFriendly((String)bSqlJoin.getJoinKind().getTag()).toUpperCase()).append(' ');
        this.visit(bSqlJoin.getJoinTable());
        this.queryText.append(" ON ");
        this.visit(bSqlJoin.getOnExpr());
        this.queryText.append(' ');
    }

    public void visit(BFieldExpression bFieldExpression) {
        String string = this.helper.resolveField(bFieldExpression);
        this.queryText.append(string);
        if (this.inProjectionColumn((BQueryNode)bFieldExpression)) {
            if (this.isSelectAll) {
                throw new OrionException("Orion Queries cannot contain multiple columns in the projection if '*' is specified.");
            }
            if (string.equals("*")) {
                this.isSelectAll = true;
            }
            String string2 = this.getAlias((BExpression)bFieldExpression);
            Property property = this.helper.getFieldProperty(bFieldExpression);
            if (string2 == null) {
                string2 = property.getName();
            } else {
                this.queryText.append(' ').append(this.idioms().toAliasString(string2));
            }
            this.returnTypeProps.add((Object)new DynamicOrionProperty(string2, property.getType(), property.getDefaultValue(), property.getFacets(), property.getDefaultFlags()));
        }
    }

    public void visit(BFunctionExpression bFunctionExpression) {
        super.visit(bFunctionExpression);
        if (this.inProjectionColumn((BQueryNode)bFunctionExpression)) {
            String string = null;
            string = this.getAlias((BExpression)bFunctionExpression);
            if (string == null) {
                SelectVisitor selectVisitor = new SelectVisitor(this.db, this.helper);
                selectVisitor.visit((BFunctionExpression)bFunctionExpression.newCopy());
                string = selectVisitor.getQueryString();
            }
            this.returnTypeProps.add((Object)BOrionSpace.createProperty(string, bFunctionExpression.getFunctionType()));
        }
    }

    public void visit(BSimpleExpression bSimpleExpression) {
        super.visit(bSimpleExpression);
        if (this.inProjectionColumn((BQueryNode)bSimpleExpression)) {
            String string = null;
            string = this.getAlias((BExpression)bSimpleExpression);
            if (string == null) {
                string = "";
            }
            this.returnTypeProps.add((Object)BOrionSpace.createProperty(string, bSimpleExpression.getSimpleValue().getType()));
        }
    }

    public void visit(BSqlCase bSqlCase) {
        this.queryText.append(" CASE ");
        if (bSqlCase.hasCase()) {
            this.visit(bSqlCase.getCase());
        }
        BSqlCase.WhenTuple[] whenTupleArray = bSqlCase.getWhenTuples();
        int n = 0;
        while (n < whenTupleArray.length) {
            this.queryText.append(" WHEN ");
            this.visit(whenTupleArray[n].whenExpr);
            this.queryText.append(" THEN ");
            this.visit(whenTupleArray[n].thenExpr);
            ++n;
        }
        if (bSqlCase.hasElse()) {
            this.queryText.append(" ELSE ");
            this.visit(bSqlCase.getElse());
        }
        this.queryText.append(" END ");
    }

    public void visitQuery(BSubSqlQuery bSubSqlQuery) {
        SelectVisitor selectVisitor = new SelectVisitor(this.db);
        selectVisitor.visit(bSubSqlQuery.getQuery());
        Array array = selectVisitor.parameters;
        this.parameters.addAll(array);
        selectVisitor.parameters.clear();
        this.queryText.append("(");
        this.queryText.append(selectVisitor.getQueryString());
        this.queryText.append(")");
    }

    public static boolean dbSupportsFlexibleOnClause(BRdbms bRdbms) {
        BTypeSpec bTypeSpec = bRdbms.getType().getTypeSpec();
        return !bTypeSpec.equals((Object)MY_SQL);
    }

    public static boolean dbSupportsFlexibleOrderByForDistict(BRdbms bRdbms) {
        BTypeSpec bTypeSpec = bRdbms.getType().getTypeSpec();
        return bTypeSpec.equals((Object)MY_SQL);
    }

    public boolean dbSupportsPagination() {
        return SelectVisitor.dbSupportsPagination(this.db.getRdbms());
    }

    public static boolean dbSupportsPagination(BRdbms bRdbms) {
        BTypeSpec bTypeSpec = bRdbms.getType().getTypeSpec();
        if (bTypeSpec.equals((Object)SQL_SERVER)) {
            BFrozenEnum bFrozenEnum = (BFrozenEnum)bRdbms.get("version");
            return !bFrozenEnum.getTag().equals("sqlServer2000");
        }
        boolean bl = false;
        if (bTypeSpec.equals((Object)ORACLE) || bTypeSpec.equals((Object)DB2) || bTypeSpec.equals((Object)HSQL) || bTypeSpec.equals((Object)MY_SQL)) {
            bl = true;
        }
        return bl;
    }

    private final StringBuffer paginate(BSqlQuery bSqlQuery, StringBuffer stringBuffer) {
        OrionType orionType = (OrionType)((BTypedExtent)bSqlQuery.getExtent()).listTypes()[0];
        TableDefinition tableDefinition = TableDefinition.get(this.db, orionType);
        NameGenerator nameGenerator = new NameGenerator(new TableDefinition[]{tableDefinition});
        return new StringBuffer(this.applyPagination(nameGenerator, bSqlQuery.getPage(), stringBuffer.toString(), this.queryText.toString()));
    }

    private final String applyPagination(NameGenerator nameGenerator, BPage bPage, String string, String string2) {
        BTypeSpec bTypeSpec = this.db.getRdbms().getType().getTypeSpec();
        if (bTypeSpec.equals((Object)ORACLE)) {
            int n = bPage.getOffset() + 1;
            int n2 = n + bPage.getLimit() - 1;
            String string3 = nameGenerator.generateUniqueName("A");
            String string4 = nameGenerator.generateUniqueName("R");
            return "SELECT * FROM (SELECT " + string3 + ".*, ROWNUM " + string4 + " FROM (" + string2 + ' ' + string + ") " + string3 + " WHERE ROWNUM <= " + n2 + ") WHERE " + string4 + " >= " + n;
        }
        if (bTypeSpec.equals((Object)DB2)) {
            int n = bPage.getOffset() + 1;
            int n3 = n + bPage.getLimit() - 1;
            String string5 = nameGenerator.generateUniqueName("A");
            String string6 = nameGenerator.generateUniqueName("B");
            String string7 = nameGenerator.generateUniqueName("R");
            return "SELECT * FROM (SELECT " + string5 + ".*, ROWNUMBER() OVER (" + string + ") AS " + string7 + " FROM (" + string2 + ") AS " + string5 + ") AS " + string6 + " WHERE " + string7 + " <= " + n3 + " AND " + string7 + " >= " + n;
        }
        if (bTypeSpec.equals((Object)SQL_SERVER)) {
            int n = bPage.getOffset();
            int n4 = n + bPage.getLimit();
            int n5 = n4 - n;
            if (n == 0) {
                int n6 = string2.indexOf("SELECT ");
                if (n6 != 0) {
                    return string2;
                }
                String string8 = "SELECT";
                int n7 = string2.indexOf("SELECT DISTINCT");
                if (n7 == 0) {
                    string8 = "SELECT DISTINCT";
                }
                string2 = string8 + " TOP " + n5 + ' ' + string2.substring(n6 + string8.length());
                if (string == null || string.length() == 0) {
                    return string2;
                }
                return string2 + ' ' + string;
            }
            String string9 = nameGenerator.generateUniqueName("A");
            String string10 = nameGenerator.generateUniqueName("B");
            String string11 = nameGenerator.generateUniqueName("R");
            if (string == null || string.length() == 0) {
                string = "ORDER BY (SELECT 1)";
            } else {
                String[] stringArray = TextUtil.split((String)string, (char)' ');
                int n8 = 0;
                while (n8 < stringArray.length) {
                    if (stringArray[n8].indexOf(".") > -1) {
                        stringArray[n8] = string9 + stringArray[n8].substring(stringArray[n8].indexOf("."));
                    }
                    ++n8;
                }
                string = TextUtil.join((String[])stringArray, (char)' ');
            }
            return "SELECT TOP " + n5 + " * FROM (SELECT *, ROW_NUMBER() OVER (" + string + ") AS " + string11 + " FROM (" + string2 + ") " + string9 + ") " + string10 + " WHERE " + string11 + " > " + n;
        }
        if (bTypeSpec.equals((Object)HSQL)) {
            int n = string2.indexOf(32);
            if (bPage.getOffset() == 0) {
                return string2.substring(0, n) + " TOP " + bPage.getLimit() + ' ' + string2.substring(n) + ' ' + string;
            }
            return string2.substring(0, n) + " LIMIT " + bPage.getOffset() + ' ' + bPage.getLimit() + string2.substring(n) + ' ' + string;
        }
        if (bTypeSpec.equals((Object)MY_SQL)) {
            string = string == null || string.length() == 0 ? "" : " " + string;
            return string2 + string + " LIMIT " + bPage.getOffset() + ", " + bPage.getLimit();
        }
        throw new IllegalStateException();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.isSelectAll = false;
    }

    public SelectVisitor(BLocalOrionDatabase bLocalOrionDatabase) {
        this(bLocalOrionDatabase, null);
    }

    public SelectVisitor(BLocalOrionDatabase bLocalOrionDatabase, SqlHelper sqlHelper) {
        super(bLocalOrionDatabase);
        this.this();
        this.helper = sqlHelper;
    }
}

