/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion.priv.db.sql;

import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionObject;
import com.tridium.orion.OrionException;
import com.tridium.orion.priv.audit.BOrionAuditWorker;
import com.tridium.orion.priv.db.ColumnDefinition;
import com.tridium.orion.priv.db.DbOrionSession;
import com.tridium.orion.priv.db.TableDefinition;
import com.tridium.orion.priv.db.sql.SessionHelper;
import com.tridium.rdb.jdbc.RdbmsDialect;
import com.tridium.rdb.jdbc.RdbmsPreparedStatement;
import com.tridium.rdb.jdbc.RdbmsResultSet;
import java.sql.Connection;
import java.sql.SQLException;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.util.Array;
import javax.baja.util.BUuid;
import javax.baja.util.TextUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Insert
extends SessionHelper {
    static /* synthetic */ Class class$java$lang$String;

    public void insert(BIOrionObject bIOrionObject) {
        try {
            if (this.conn.isReadOnly()) {
                throw new OrionException("This is a readonly database context.");
            }
            bIOrionObject.setOrionDatabase(this.db);
            if (bIOrionObject.beforeInsert(this.session)) {
                this.doInsert(bIOrionObject);
                bIOrionObject.clearAllModified();
                ((BObject)bIOrionObject).fw(702, null, null, null, null);
                if (bIOrionObject.isAuditable() && this.session.getUser() != null) {
                    BOrionAuditWorker.auditCreated(bIOrionObject, this.session);
                }
                bIOrionObject.afterInsert(this.session);
            } else if (this.log.isTraceOn()) {
                this.log.trace("VETOED INSERT: " + bIOrionObject);
            }
        }
        catch (SQLException sQLException) {
            throw new OrionException(sQLException);
        }
    }

    private final void doInsert(BIOrionObject bIOrionObject) throws SQLException {
        switch (this.dialect.getInsertionMode()) {
            case 1: {
                this.createViaIdentity(bIOrionObject);
                break;
            }
            case 2: {
                this.createViaIdentityLookup(bIOrionObject);
                break;
            }
            case 0: {
                this.createViaSequence(bIOrionObject);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private final void createViaIdentity(BIOrionObject bIOrionObject) throws SQLException {
        TableDefinition tableDefinition = TableDefinition.get(this.db, bIOrionObject.getOrionType());
        ColumnDefinition columnDefinition = tableDefinition.getIdentityColumn();
        String string = Insert.buildInsertSql(tableDefinition, false);
        int n = 0;
        if (columnDefinition == null) {
            n = 1;
        }
        RdbmsPreparedStatement rdbmsPreparedStatement = this.session.makeAutoKeyStatement(this.db, this.conn, string, n + 1);
        Insert.loadInsertStatement(rdbmsPreparedStatement, tableDefinition, false, bIOrionObject);
        rdbmsPreparedStatement.executeUpdate();
        Insert.retrieveIdentityKeys(rdbmsPreparedStatement, columnDefinition, new BIOrionObject[]{bIOrionObject});
    }

    private final void createViaIdentityLookup(BIOrionObject bIOrionObject) throws SQLException {
        TableDefinition tableDefinition = TableDefinition.get(this.db, bIOrionObject.getOrionType());
        ColumnDefinition columnDefinition = tableDefinition.getIdentityColumn();
        RdbmsPreparedStatement rdbmsPreparedStatement = this.session.makeStatement(this.db, this.conn, Insert.buildInsertSql(tableDefinition, false));
        Insert.loadInsertStatement(rdbmsPreparedStatement, tableDefinition, false, bIOrionObject);
        rdbmsPreparedStatement.executeUpdate();
        Insert.retrieveIdentityLookupKeys(this.dialect, this.conn, columnDefinition, new BIOrionObject[]{bIOrionObject});
    }

    private final void createViaSequence(BIOrionObject bIOrionObject) throws SQLException {
        TableDefinition tableDefinition = TableDefinition.get(this.db, bIOrionObject.getOrionType());
        ColumnDefinition columnDefinition = tableDefinition.getIdentityColumn();
        RdbmsPreparedStatement rdbmsPreparedStatement = this.session.makeStatement(this.db, this.conn, Insert.buildInsertSql(tableDefinition, true));
        Insert.lookupSequenceKey(this.dialect, this.conn, tableDefinition, columnDefinition, bIOrionObject);
        Insert.loadInsertStatement(rdbmsPreparedStatement, tableDefinition, true, bIOrionObject);
        rdbmsPreparedStatement.executeUpdate();
    }

    public static void retrieveIdentityKeys(RdbmsPreparedStatement rdbmsPreparedStatement, ColumnDefinition columnDefinition, BIOrionObject[] bIOrionObjectArray) throws SQLException {
        if (columnDefinition != null) {
            RdbmsResultSet rdbmsResultSet = new RdbmsResultSet(rdbmsPreparedStatement.getGeneratedKeys());
            Property property = columnDefinition.getProperty();
            rdbmsResultSet.next();
            int n = 0;
            while (n < bIOrionObjectArray.length) {
                bIOrionObjectArray[n].set(property, columnDefinition.getTranslator().getResultSetValue(rdbmsResultSet, 1, (Context)property.getFacets()));
                rdbmsResultSet.next();
                ++n;
            }
        }
    }

    public static void retrieveIdentityLookupKeys(RdbmsDialect rdbmsDialect, Connection connection, ColumnDefinition columnDefinition, BIOrionObject[] bIOrionObjectArray) throws SQLException {
        if (columnDefinition != null) {
            RdbmsResultSet rdbmsResultSet = new RdbmsResultSet(connection.createStatement().executeQuery(rdbmsDialect.getIdentityLookup()));
            Property property = columnDefinition.getProperty();
            rdbmsResultSet.next();
            int n = 0;
            while (n < bIOrionObjectArray.length) {
                bIOrionObjectArray[n].set(property, columnDefinition.getTranslator().getResultSetValue(rdbmsResultSet, 1, (Context)property.getFacets()));
                rdbmsResultSet.next();
                ++n;
            }
        }
    }

    public static void lookupSequenceKey(RdbmsDialect rdbmsDialect, Connection connection, TableDefinition tableDefinition, ColumnDefinition columnDefinition, BIOrionObject bIOrionObject) throws SQLException {
        if (columnDefinition != null) {
            RdbmsResultSet rdbmsResultSet = new RdbmsResultSet(connection.createStatement().executeQuery(rdbmsDialect.getSequenceLookup(tableDefinition.getTableName())));
            Property property = columnDefinition.getProperty();
            rdbmsResultSet.next();
            bIOrionObject.set(property, columnDefinition.getTranslator().getResultSetValue(rdbmsResultSet, 1, (Context)property.getFacets()));
        }
    }

    public static String buildInsertSql(TableDefinition tableDefinition, boolean bl) {
        ColumnDefinition[] columnDefinitionArray = tableDefinition.getColumns();
        Class clazz = class$java$lang$String;
        if (clazz == null) {
            clazz = class$java$lang$String = Insert.class("[Ljava.lang.String;", false);
        }
        Array array = new Array(clazz);
        Class clazz2 = class$java$lang$String;
        if (clazz2 == null) {
            clazz2 = class$java$lang$String = Insert.class("[Ljava.lang.String;", false);
        }
        Array array2 = new Array(clazz2);
        int n = 0;
        while (n < columnDefinitionArray.length) {
            ColumnDefinition columnDefinition = columnDefinitionArray[n];
            Property property = columnDefinitionArray[n].getProperty();
            if (!BOrionObject.isIdentity(property) || bl) {
                array.add((Object)columnDefinition.getColumnName());
                array2.add((Object)"?");
            }
            ++n;
        }
        return "INSERT INTO " + tableDefinition.getTableName() + " (" + TextUtil.join((String[])((String[])array.trim()), (char)',') + ") VALUES (" + TextUtil.join((String[])((String[])array2.trim()), (char)',') + ')';
    }

    public static void loadInsertStatement(RdbmsPreparedStatement rdbmsPreparedStatement, TableDefinition tableDefinition, boolean bl, BIOrionObject bIOrionObject) {
        int n = 1;
        ColumnDefinition[] columnDefinitionArray = tableDefinition.getColumns();
        int n2 = 0;
        while (n2 < columnDefinitionArray.length) {
            ColumnDefinition columnDefinition = columnDefinitionArray[n2];
            Property property = columnDefinitionArray[n2].getProperty();
            BValue bValue = bIOrionObject.get(columnDefinitionArray[n2].getProperty());
            if (BOrionObject.isKey(property) && bValue.equals((Object)BUuid.NULL)) {
                bValue = BUuid.make();
                bIOrionObject.set(columnDefinitionArray[n2].getProperty(), bValue);
            }
            if (!BOrionObject.isIdentity(property) || bl) {
                columnDefinitionArray[n2].getTranslator().setPreparedStatementValue(rdbmsPreparedStatement, n++, bValue, (Context)property.getFacets());
            }
            ++n2;
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public Insert(DbOrionSession dbOrionSession) {
        super(dbOrionSession);
    }
}

