/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion.priv.db.sql;

import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BRef;
import com.tridium.orion.OrionException;
import com.tridium.orion.OrionType;
import com.tridium.orion.priv.db.ColumnDefinition;
import com.tridium.orion.priv.db.DbOrionSession;
import com.tridium.orion.priv.db.TableDefinition;
import com.tridium.orion.priv.db.sql.SessionHelper;
import com.tridium.orion.priv.db.trans.TranslatorFactory;
import com.tridium.orion.sql.PropertyValue;
import com.tridium.rdb.jdbc.RdbmsPreparedStatement;
import com.tridium.rdb.jdbc.RdbmsResultSet;
import com.tridium.rdb.jdbc.trans.BColumnTranslator;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;

public class Fetch
extends SessionHelper {
    public void setPropertyValues(TableDefinition tableDefinition, BIOrionObject bIOrionObject, RdbmsResultSet rdbmsResultSet, boolean bl) {
        ColumnDefinition[] columnDefinitionArray = tableDefinition.getColumns();
        if (!bl && this.anyAutoResolve(columnDefinitionArray)) {
            this.setAutoResolvePropertyValues(tableDefinition, bIOrionObject, rdbmsResultSet, 1);
        } else {
            int n = 0;
            while (n < columnDefinitionArray.length) {
                this.setPropertyValue(columnDefinitionArray[n], bIOrionObject, rdbmsResultSet, n + 1);
                ++n;
            }
        }
        bIOrionObject.clearAllModified();
    }

    private final int setAutoResolvePropertyValues(TableDefinition tableDefinition, BIOrionObject bIOrionObject, RdbmsResultSet rdbmsResultSet, int n) {
        ColumnDefinition[] columnDefinitionArray = tableDefinition.getColumns();
        int n2 = 0;
        while (n2 < columnDefinitionArray.length) {
            this.setPropertyValue(columnDefinitionArray[n2], bIOrionObject, rdbmsResultSet, n++);
            if (columnDefinitionArray[n2].isAutoResolve()) {
                BRef bRef = (BRef)bIOrionObject.get(columnDefinitionArray[n2].getProperty());
                TableDefinition tableDefinition2 = this.getRefTableDef(bRef);
                BIOrionObject bIOrionObject2 = (BIOrionObject)bRef.getTargetTypeSpec().getInstance();
                if (rdbmsResultSet.isNull(n - 1)) {
                    n = this.skipAutoResolvePropertyValues(tableDefinition2, bIOrionObject2, n);
                    bIOrionObject.set(columnDefinitionArray[n2].getProperty(), (BValue)BRef.NULL);
                } else {
                    n = this.setAutoResolvePropertyValues(tableDefinition2, bIOrionObject2, rdbmsResultSet, n);
                    bIOrionObject2.clearAllModified();
                    bIOrionObject2.setOrionDatabase(this.db);
                    ((BObject)bIOrionObject2).fw(702, null, null, null, null);
                    bRef.resolve(bIOrionObject2);
                }
            }
            ++n2;
        }
        return n;
    }

    private final int skipAutoResolvePropertyValues(TableDefinition tableDefinition, BIOrionObject bIOrionObject, int n) {
        ColumnDefinition[] columnDefinitionArray = tableDefinition.getColumns();
        int n2 = 0;
        while (n2 < columnDefinitionArray.length) {
            ++n;
            if (columnDefinitionArray[n2].isAutoResolve()) {
                BRef bRef = (BRef)bIOrionObject.get(columnDefinitionArray[n2].getProperty());
                TableDefinition tableDefinition2 = this.getRefTableDef(bRef);
                BIOrionObject bIOrionObject2 = (BIOrionObject)bRef.getTargetTypeSpec().getInstance();
                n = this.skipAutoResolvePropertyValues(tableDefinition2, bIOrionObject2, n);
            }
            ++n2;
        }
        return n;
    }

    private final void setPropertyValue(ColumnDefinition columnDefinition, BIOrionObject bIOrionObject, RdbmsResultSet rdbmsResultSet, int n) {
        Property property = columnDefinition.getProperty();
        BColumnTranslator bColumnTranslator = columnDefinition.getTranslator();
        if (rdbmsResultSet.isNull(n)) {
            ((BObject)bIOrionObject).fw(704, (Object)property, (Object)Boolean.TRUE, null, null);
            bIOrionObject.set(property, property.getDefaultValue());
        } else {
            bIOrionObject.set(property, bColumnTranslator.getResultSetValue(rdbmsResultSet, n, (Context)property.getFacets()));
        }
    }

    protected BIOrionObject prepareAndFetchRecord(BOrionDatabase bOrionDatabase, Connection connection, BIOrionObject bIOrionObject, TableDefinition tableDefinition, PropertyValue[] propertyValueArray) throws SQLException {
        RdbmsPreparedStatement rdbmsPreparedStatement = this.session.makeStatement(bOrionDatabase, connection, this.buildPreparedSelect(tableDefinition, propertyValueArray));
        this.loadPreparedSelect(tableDefinition, propertyValueArray, rdbmsPreparedStatement);
        return this.fetchRecord(bIOrionObject, tableDefinition, rdbmsPreparedStatement.executeQuery());
    }

    protected BIOrionObject fetchRecord(BIOrionObject bIOrionObject, TableDefinition tableDefinition, ResultSet resultSet) throws SQLException {
        if (!resultSet.next()) {
            return null;
        }
        if (bIOrionObject == null) {
            bIOrionObject = tableDefinition.getInstance();
        }
        this.setPropertyValues(tableDefinition, bIOrionObject, new RdbmsResultSet(resultSet), false);
        if (resultSet.next()) {
            throw new OrionException("More than one object found");
        }
        resultSet.close();
        bIOrionObject.setOrionDatabase(this.db);
        ((BObject)bIOrionObject).fw(702, null, null, null, null);
        return bIOrionObject;
    }

    public String buildPreparedSelect(TableDefinition tableDefinition, PropertyValue[] propertyValueArray) {
        StringBuffer stringBuffer = this.makeSqlForType(tableDefinition);
        stringBuffer.append(" WHERE ");
        int n = 0;
        while (n < propertyValueArray.length) {
            if (n > 0) {
                stringBuffer.append(" AND ");
            }
            stringBuffer.append("(");
            stringBuffer.append(tableDefinition.getTableName()).append(".");
            stringBuffer.append(propertyValueArray[n].getProperty().getName());
            stringBuffer.append(" = ?)");
            ++n;
        }
        return stringBuffer.toString();
    }

    public void loadPreparedSelect(TableDefinition tableDefinition, PropertyValue[] propertyValueArray, RdbmsPreparedStatement rdbmsPreparedStatement) {
        int n = 0;
        while (n < propertyValueArray.length) {
            Property property = propertyValueArray[n].getProperty();
            ColumnDefinition columnDefinition = tableDefinition.getColumn(property.getName());
            columnDefinition.getTranslator().setPreparedStatementValue(rdbmsPreparedStatement, n + 1, propertyValueArray[n].getValue(), (Context)property.getFacets());
            ++n;
        }
    }

    protected ResultSet makeQueryResultSet(String string, BSimple[] bSimpleArray) throws SQLException {
        if (bSimpleArray == null || bSimpleArray.length == 0) {
            if (this.log.isTraceOn()) {
                this.log.trace(string);
            }
            return this.conn.createStatement().executeQuery(string);
        }
        RdbmsPreparedStatement rdbmsPreparedStatement = this.session.makeStatement(this.db, this.conn, string);
        int n = 0;
        while (n < bSimpleArray.length) {
            BColumnTranslator bColumnTranslator = TranslatorFactory.make(this.dialect, (BValue)bSimpleArray[n]);
            bColumnTranslator.setPreparedStatementValue(rdbmsPreparedStatement, n + 1, (BValue)bSimpleArray[n], null);
            ++n;
        }
        return rdbmsPreparedStatement.executeQuery();
    }

    protected StringBuffer makeSqlForType(TableDefinition tableDefinition) {
        StringBuffer stringBuffer = new StringBuffer();
        ColumnDefinition[] columnDefinitionArray = tableDefinition.getColumns();
        if (this.anyAutoResolve(columnDefinitionArray)) {
            stringBuffer.append("SELECT ");
            this.appendColumns(stringBuffer, tableDefinition, columnDefinitionArray, true);
            stringBuffer.append(" FROM ").append(tableDefinition.getTableName());
            this.appendJoins(stringBuffer, tableDefinition, columnDefinitionArray);
        } else {
            stringBuffer.append("SELECT * FROM ").append(tableDefinition.getTableName());
        }
        return stringBuffer;
    }

    public void appendColumns(StringBuffer stringBuffer, TableDefinition tableDefinition, ColumnDefinition[] columnDefinitionArray, boolean bl) {
        int n = 0;
        while (n < columnDefinitionArray.length) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(", ");
            }
            stringBuffer.append(tableDefinition.getTableName()).append('.').append(columnDefinitionArray[n].getColumnName());
            if (columnDefinitionArray[n].isAutoResolve()) {
                TableDefinition tableDefinition2 = this.getRefTableDef(columnDefinitionArray[n]);
                this.appendColumns(stringBuffer, tableDefinition2, tableDefinition2.getColumns(), bl);
            }
            ++n;
        }
    }

    private final void appendJoins(StringBuffer stringBuffer, TableDefinition tableDefinition, ColumnDefinition[] columnDefinitionArray) {
        int n = 0;
        while (n < columnDefinitionArray.length) {
            if (columnDefinitionArray[n].isAutoResolve()) {
                TableDefinition tableDefinition2 = this.getRefTableDef(columnDefinitionArray[n]);
                ColumnDefinition columnDefinition = tableDefinition2.getKeyColumn();
                stringBuffer.append(" LEFT JOIN ").append(tableDefinition2.getTableName()).append(" ON ");
                stringBuffer.append(tableDefinition.getTableName()).append(".").append(columnDefinitionArray[n].getColumnName()).append(" = ");
                stringBuffer.append(tableDefinition2.getTableName()).append(".").append(columnDefinition.getColumnName());
                this.appendJoins(stringBuffer, tableDefinition2, tableDefinition2.getColumns());
            }
            ++n;
        }
    }

    public TableDefinition getRefTableDef(ColumnDefinition columnDefinition) {
        return this.getRefTableDef((BRef)columnDefinition.getProperty().getDefaultValue());
    }

    public TableDefinition getRefTableDef(BRef bRef) {
        OrionType orionType = TableDefinition.getRefType(this.db, bRef);
        return TableDefinition.get(this.db, orionType);
    }

    private final boolean anyAutoResolve(ColumnDefinition[] columnDefinitionArray) {
        int n = 0;
        while (n < columnDefinitionArray.length) {
            if (columnDefinitionArray[n].isAutoResolve()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public Fetch(DbOrionSession dbOrionSession) {
        super(dbOrionSession);
    }
}

