/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion.priv.db.sql;

import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BLocalOrionDatabase;
import com.tridium.orion.OrionException;
import com.tridium.orion.OrionType;
import com.tridium.orion.priv.audit.BOrionAuditWorker;
import com.tridium.orion.priv.db.ColumnDefinition;
import com.tridium.orion.priv.db.DbOrionSession;
import com.tridium.orion.priv.db.TableDefinition;
import com.tridium.orion.priv.db.sql.SessionHelper;
import com.tridium.orion.priv.db.sql.SqlHelper;
import com.tridium.orion.priv.db.sql.SqlVisitor;
import com.tridium.orion.sql.BSqlExtent;
import com.tridium.orion.sql.BSqlQuery;
import com.tridium.orion.sql.PropertyValue;
import com.tridium.rdb.jdbc.RdbmsPreparedStatement;
import java.sql.SQLException;
import javax.baja.query.BExpression;
import javax.baja.query.BExtent;
import javax.baja.query.BQuery;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Type;

public class Delete
extends SessionHelper {
    public boolean delete(BIOrionObject bIOrionObject) {
        if (bIOrionObject.beforeDelete(this.session)) {
            int n = this.doDelete((OrionType)bIOrionObject.getType(), PropertyValue.makeKeys(bIOrionObject));
            if (n < 0 || n > 1) {
                throw new OrionException("Unexpected row count during deletion: " + n);
            }
            if (bIOrionObject.isAuditable() && this.session.getUser() != null) {
                BOrionAuditWorker.auditDeleted(bIOrionObject, this.session);
            }
            bIOrionObject.afterDelete(this.session);
            boolean bl = false;
            if (n == 1) {
                bl = true;
            }
            return bl;
        }
        if (this.log.isTraceOn()) {
            this.log.trace("VETOED DELETE: " + bIOrionObject);
        }
        return false;
    }

    public int delete(OrionType orionType, BExpression bExpression) {
        BSqlQuery bSqlQuery = new BSqlQuery();
        bSqlQuery.from((BExtent)BSqlExtent.make((Type)orionType));
        if (bExpression != null) {
            bSqlQuery.where(bExpression);
        }
        DeleteVisitor deleteVisitor = new DeleteVisitor(this.db);
        deleteVisitor.visit(bSqlQuery);
        this.logBQuery(deleteVisitor);
        return this.updateOrDelete("DELETE", deleteVisitor.getQueryString(), deleteVisitor.getParameters());
    }

    private final int doDelete(OrionType orionType, PropertyValue[] propertyValueArray) {
        TableDefinition tableDefinition = TableDefinition.get(this.db, orionType);
        String string = Delete.buildDeleteSql(tableDefinition, orionType, propertyValueArray);
        try {
            RdbmsPreparedStatement rdbmsPreparedStatement = this.session.makeStatement(this.db, this.conn, string.toString());
            Delete.loadDeleteStatement(rdbmsPreparedStatement, tableDefinition, orionType, propertyValueArray);
            return rdbmsPreparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new OrionException(sQLException);
        }
    }

    public static String buildDeleteSql(TableDefinition tableDefinition, OrionType orionType, PropertyValue[] propertyValueArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DELETE FROM ").append(tableDefinition.getTableName()).append(" WHERE ");
        int n = 0;
        while (n < propertyValueArray.length) {
            if (n > 0) {
                stringBuffer.append(" AND ");
            }
            stringBuffer.append("(");
            stringBuffer.append(propertyValueArray[n].getProperty().getName());
            stringBuffer.append(" = ?)");
            ++n;
        }
        return stringBuffer.toString();
    }

    public static void loadDeleteStatement(RdbmsPreparedStatement rdbmsPreparedStatement, TableDefinition tableDefinition, OrionType orionType, PropertyValue[] propertyValueArray) {
        int n = 0;
        while (n < propertyValueArray.length) {
            Property property = propertyValueArray[n].getProperty();
            ColumnDefinition columnDefinition = tableDefinition.getColumn(property.getName());
            columnDefinition.getTranslator().setPreparedStatementValue(rdbmsPreparedStatement, n + 1, propertyValueArray[n].getValue(), (Context)property.getFacets());
            ++n;
        }
    }

    public Delete(DbOrionSession dbOrionSession) {
        super(dbOrionSession);
    }

    public static class DeleteVisitor
    extends SqlVisitor {
        public void visit(BQuery bQuery) {
            this.initialize();
            this.helper = new SqlHelper(this.db, bQuery);
            this.queryText.append("DELETE FROM ");
            this.visit(bQuery.getExtent());
            if (bQuery.hasPredicate()) {
                this.queryText.append("WHERE ");
                this.visit(bQuery.getPredicate());
            }
        }

        public DeleteVisitor(BLocalOrionDatabase bLocalOrionDatabase) {
            super(bLocalOrionDatabase);
        }
    }
}

