/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion.priv.db;

import com.tridium.orion.BIOrionObject;
import com.tridium.orion.OrionException;
import com.tridium.orion.OrionType;
import com.tridium.orion.priv.db.ColumnDefinition;
import com.tridium.orion.priv.db.DbBatch;
import com.tridium.orion.priv.db.DbOrionSession;
import com.tridium.orion.priv.db.sql.Insert;
import com.tridium.rdb.jdbc.RdbmsPreparedStatement;
import java.sql.SQLException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DbBatchInsert
extends DbBatch {
    RdbmsPreparedStatement prep;

    public void execute() {
        BIOrionObject bIOrionObject;
        if (this.arr.size() == 0) {
            return;
        }
        int n = 0;
        while (n < this.arr.size()) {
            bIOrionObject = (BIOrionObject)this.arr.get(n);
            if (!bIOrionObject.beforeInsert(this.session)) {
                if (this.log.isTraceOn()) {
                    this.log.trace("VETOED BATCH INSERT: index " + n + ", object " + bIOrionObject);
                }
                return;
            }
            ++n;
        }
        try {
            switch (this.dialect.getInsertionMode()) {
                case 1: {
                    this.executeIdentity();
                    break;
                }
                case 2: {
                    this.executeIdentityLookup();
                    break;
                }
                case 0: {
                    this.executeSequence();
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        catch (SQLException sQLException) {
            throw new OrionException(sQLException);
        }
        n = 0;
        while (n < this.arr.size()) {
            bIOrionObject = (BIOrionObject)this.arr.get(n);
            bIOrionObject.afterInsert(this.session);
            ++n;
        }
        this.clear();
    }

    private final void executeIdentity() throws SQLException {
        ColumnDefinition columnDefinition = this.tableDef.getIdentityColumn();
        if (this.prep == null) {
            String string = Insert.buildInsertSql(this.tableDef, false);
            int n = 0;
            if (columnDefinition == null) {
                n = 1;
            }
            this.prep = this.session.makeAutoKeyStatement(this.db, this.conn, string, n + 1);
        }
        if (this.dialect.supportsBatchInsert()) {
            int n = this.getChunkSize();
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            while (n5 < this.arr.size()) {
                BIOrionObject bIOrionObject = (BIOrionObject)this.arr.get(n5);
                Insert.loadInsertStatement(this.prep, this.tableDef, false, bIOrionObject);
                this.prep.addBatch();
                ++n4;
                if (n > 0 && ++n2 >= n) {
                    this.prep.executeBatch();
                    Insert.retrieveIdentityKeys(this.prep, columnDefinition, (BIOrionObject[])this.arr.slice(n3, n4).trim());
                    n2 = 0;
                    n3 = n4;
                }
                ++n5;
            }
            if (n == 0 || n2 > 0) {
                this.prep.executeBatch();
                Insert.retrieveIdentityKeys(this.prep, columnDefinition, (BIOrionObject[])this.arr.slice(n3, n4).trim());
            }
        } else {
            int n = 0;
            while (n < this.arr.size()) {
                BIOrionObject bIOrionObject = (BIOrionObject)this.arr.get(n);
                Insert.loadInsertStatement(this.prep, this.tableDef, false, bIOrionObject);
                this.prep.executeUpdate();
                Insert.retrieveIdentityKeys(this.prep, columnDefinition, new BIOrionObject[]{bIOrionObject});
                ++n;
            }
        }
    }

    private final void executeIdentityLookup() throws SQLException {
        ColumnDefinition columnDefinition = this.tableDef.getIdentityColumn();
        if (this.prep == null) {
            this.prep = this.session.makeStatement(this.db, this.conn, Insert.buildInsertSql(this.tableDef, false));
        }
        if (this.dialect.supportsBatchInsert()) {
            int n = this.getChunkSize();
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            while (n5 < this.arr.size()) {
                BIOrionObject bIOrionObject = (BIOrionObject)this.arr.get(n5);
                Insert.loadInsertStatement(this.prep, this.tableDef, false, bIOrionObject);
                this.prep.addBatch();
                ++n4;
                if (n > 0 && ++n2 >= n) {
                    this.prep.executeBatch();
                    Insert.retrieveIdentityLookupKeys(this.dialect, this.conn, columnDefinition, (BIOrionObject[])this.arr.slice(n3, n4).trim());
                    n2 = 0;
                    n3 = n4;
                }
                ++n5;
            }
            if (n == 0 || n2 > 0) {
                this.prep.executeBatch();
                Insert.retrieveIdentityLookupKeys(this.dialect, this.conn, columnDefinition, (BIOrionObject[])this.arr.slice(n3, n4).trim());
            }
        } else {
            int n = 0;
            while (n < this.arr.size()) {
                BIOrionObject bIOrionObject = (BIOrionObject)this.arr.get(n);
                Insert.loadInsertStatement(this.prep, this.tableDef, false, bIOrionObject);
                this.prep.executeUpdate();
                Insert.retrieveIdentityLookupKeys(this.dialect, this.conn, columnDefinition, new BIOrionObject[]{bIOrionObject});
                ++n;
            }
        }
    }

    private final void executeSequence() throws SQLException {
        ColumnDefinition columnDefinition = this.tableDef.getIdentityColumn();
        if (this.prep == null) {
            this.prep = this.session.makeStatement(this.db, this.conn, Insert.buildInsertSql(this.tableDef, true));
        }
        if (this.dialect.supportsBatchInsert()) {
            int n = this.getChunkSize();
            int n2 = 0;
            int n3 = 0;
            while (n3 < this.arr.size()) {
                BIOrionObject bIOrionObject = (BIOrionObject)this.arr.get(n3);
                Insert.lookupSequenceKey(this.dialect, this.conn, this.tableDef, columnDefinition, bIOrionObject);
                Insert.loadInsertStatement(this.prep, this.tableDef, true, bIOrionObject);
                this.prep.addBatch();
                if (n > 0 && ++n2 >= n) {
                    this.prep.executeBatch();
                    n2 = 0;
                }
                ++n3;
            }
            if (n == 0 || n2 > 0) {
                this.prep.executeBatch();
            }
        } else {
            int n = 0;
            while (n < this.arr.size()) {
                BIOrionObject bIOrionObject = (BIOrionObject)this.arr.get(n);
                Insert.lookupSequenceKey(this.dialect, this.conn, this.tableDef, columnDefinition, bIOrionObject);
                Insert.loadInsertStatement(this.prep, this.tableDef, true, bIOrionObject);
                this.prep.executeUpdate();
                ++n;
            }
        }
    }

    private final /* synthetic */ void this() {
        this.prep = null;
    }

    public DbBatchInsert(DbOrionSession dbOrionSession, OrionType orionType) {
        super(dbOrionSession, orionType);
        this.this();
    }
}

