/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion;

import com.tridium.fox.sys.BFoxChannelRegistry;
import com.tridium.orion.BAuditMode;
import com.tridium.orion.BLocalOrionDatabase;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BOrionRoot;
import com.tridium.orion.BOrionSpace;
import com.tridium.orion.OrionException;
import com.tridium.orion.priv.audit.BOrionAuditWorker;
import com.tridium.orion.priv.db.DbOrionSession;
import com.tridium.orion.priv.fox.BOrionChannel;
import com.tridium.rdb.jdbc.RdbmsDialect;
import com.tridium.sys.station.Station;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Iterator;
import javax.baja.category.BCategoryMask;
import javax.baja.category.BOrdToCategoryMap;
import javax.baja.log.Log;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.rdb.BRdbms;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbstractService;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BOrionService
extends BAbstractService {
    public static final Property status = BOrionService.newProperty((int)3, (BValue)BStatus.ok, null);
    public static final Property faultCause = BOrionService.newProperty((int)3, (String)"", null);
    public static final Property ordMap = BOrionService.newProperty((int)5, (BValue)BOrdToCategoryMap.DEFAULT, null);
    public static final Property auditMode = BOrionService.newProperty((int)0, (BValue)BAuditMode.none, null);
    public static final Property auditWorker = BOrionService.newProperty((int)4, (BValue)new BOrionAuditWorker(), null);
    public static final Type TYPE;
    private static final BIcon icon;
    public static final Log log;
    private BOrionSpace space;
    private HashMap dbs;
    private boolean ready;
    private Station.SaveListener saveListener;
    static /* synthetic */ Class class$com$tridium$orion$BOrionService;

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus bStatus) {
        this.set(status, (BValue)bStatus, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String string) {
        this.setString(faultCause, string, null);
    }

    public BOrdToCategoryMap getOrdMap() {
        return (BOrdToCategoryMap)this.get(ordMap);
    }

    public void setOrdMap(BOrdToCategoryMap bOrdToCategoryMap) {
        this.set(ordMap, (BValue)bOrdToCategoryMap, null);
    }

    public BAuditMode getAuditMode() {
        return (BAuditMode)this.get(auditMode);
    }

    public void setAuditMode(BAuditMode bAuditMode) {
        this.set(auditMode, (BValue)bAuditMode, null);
    }

    public BOrionAuditWorker getAuditWorker() {
        return (BOrionAuditWorker)this.get(auditWorker);
    }

    public void setAuditWorker(BOrionAuditWorker bOrionAuditWorker) {
        this.set(auditWorker, (BValue)bOrionAuditWorker, null);
    }

    public Type getType() {
        return TYPE;
    }

    public static BOrionService getService() {
        return (BOrionService)Sys.getService((Type)TYPE);
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    public void serviceStarted() {
        Station.addSaveListener((Station.SaveListener)this.saveListener);
    }

    public void started() {
        if (this.getStatus().isValid()) {
            this.boot();
        }
    }

    public void stopped() {
        this.shutdown();
    }

    public void serviceStopped() {
        Station.removeSaveListener((Station.SaveListener)this.saveListener);
    }

    public void boot() {
        Object object;
        Iterator iterator = this.dbs.values().iterator();
        while (iterator.hasNext()) {
            object = (BLocalOrionDatabase)iterator.next();
            ((BLocalOrionDatabase)object).boot();
        }
        object = BFoxChannelRegistry.getPrototype().get("orion");
        if (object == null) {
            BFoxChannelRegistry.getPrototype().add("orion", (BValue)new BOrionChannel());
        } else if (!object.getType().is(BOrionChannel.TYPE)) {
            throw new OrionException("Orion channel already registered as " + object.getType());
        }
        this.ready = true;
        iterator = this.dbs.values().iterator();
        while (iterator.hasNext()) {
            BLocalOrionDatabase bLocalOrionDatabase = (BLocalOrionDatabase)iterator.next();
            bLocalOrionDatabase.orionReady();
        }
    }

    public void shutdown() {
        this.ready = false;
        try {
            BFoxChannelRegistry.getPrototype().remove("orion");
        }
        catch (Exception exception) {}
        if (this.space != null) {
            try {
                BLocalHost.INSTANCE.removeNavChild((BINavNode)this.space);
                this.space.getRootComponent().removeAll();
                this.space.setRootComponent(null);
                this.space = null;
            }
            catch (Exception exception) {}
        }
        Iterator iterator = this.dbs.values().iterator();
        while (iterator.hasNext()) {
            BLocalOrionDatabase bLocalOrionDatabase = (BLocalOrionDatabase)iterator.next();
            try {
                bLocalOrionDatabase.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.dbs.clear();
    }

    public boolean isOrionReady() {
        return this.ready;
    }

    public BOrionSpace getOrionSpace() {
        if (this.space == null) {
            this.space = new BOrionSpace();
            BOrionRoot bOrionRoot = new BOrionRoot();
            BCategoryMask bCategoryMask = this.getCategoryMask(bOrionRoot.getOrdInSession());
            if (bCategoryMask == null) {
                bOrionRoot.setCategoryMask(BCategoryMask.make((String)"1"), Context.decoding);
            } else {
                bOrionRoot.setCategoryMask(bCategoryMask, Context.decoding);
            }
            this.space.setRootComponent(bOrionRoot);
            BLocalHost.INSTANCE.addNavChild((BINavNode)this.space);
        }
        return this.space;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BOrionDatabase getOrionDatabase(BRdbms bRdbms) {
        String string = bRdbms.getName();
        HashMap hashMap = this.dbs;
        synchronized (hashMap) {
            BLocalOrionDatabase bLocalOrionDatabase = (BLocalOrionDatabase)this.dbs.get(string);
            if (bLocalOrionDatabase == null) {
                bLocalOrionDatabase = this.initDatabase(bRdbms);
                this.getOrionSpace().getRootComponent().add(bLocalOrionDatabase.getId(), (BValue)bLocalOrionDatabase);
                BCategoryMask bCategoryMask = this.getOrdMap().getCategoryMask(bLocalOrionDatabase.getOrdInSession());
                if (bCategoryMask != null) {
                    bLocalOrionDatabase.setCategoryMask(bCategoryMask, Context.decoding);
                }
                this.dbs.put(bLocalOrionDatabase.getId(), bLocalOrionDatabase);
            }
            return bLocalOrionDatabase;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BOrionDatabase getOrionDatabase(String string) {
        HashMap hashMap = this.dbs;
        synchronized (hashMap) {
            return (BOrionDatabase)this.dbs.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BOrionDatabase[] getOrionDatabases() {
        HashMap hashMap = this.dbs;
        synchronized (hashMap) {
            BOrionDatabase[] bOrionDatabaseArray = new BOrionDatabase[this.dbs.size()];
            int n = 0;
            Iterator iterator = this.dbs.values().iterator();
            while (iterator.hasNext()) {
                bOrionDatabaseArray[n] = (BOrionDatabase)iterator.next();
            }
            return bOrionDatabaseArray;
        }
    }

    private final BLocalOrionDatabase initDatabase(BRdbms bRdbms) {
        BLocalOrionDatabase bLocalOrionDatabase = new BLocalOrionDatabase();
        bLocalOrionDatabase.init(this, bRdbms);
        return bLocalOrionDatabase;
    }

    public void setCategoryMask(BOrd bOrd, BCategoryMask bCategoryMask) {
        this.setOrdMap(this.getOrdMap().setCategoryMask(bOrd, bCategoryMask));
    }

    public BCategoryMask getCategoryMask(BOrd bOrd) {
        return this.getOrdMap().getCategoryMask(bOrd);
    }

    public BCategoryMask getAppliedCategoryMask(BOrd bOrd) {
        return this.getOrdMap().getAppliedCategoryMask(bOrd);
    }

    private final void checkpoint() {
        Iterator iterator = this.dbs.values().iterator();
        while (iterator.hasNext()) {
            BLocalOrionDatabase bLocalOrionDatabase = (BLocalOrionDatabase)iterator.next();
            BRdbms bRdbms = bLocalOrionDatabase.getRdbms();
            RdbmsDialect rdbmsDialect = (RdbmsDialect)bRdbms.getRdbmsContext();
            try {
                log.message("begin checkpoint on " + bRdbms.getName() + " (" + bRdbms.getType() + ')');
                DbOrionSession dbOrionSession = (DbOrionSession)bLocalOrionDatabase.createSession(null);
                Connection connection = dbOrionSession.getUnderylingConnection();
                rdbmsDialect.issueCheckpoint(connection);
                dbOrionSession.close();
                log.message("end checkpoint on " + bRdbms.getName() + " (" + bRdbms.getType() + ')');
            }
            catch (Exception exception) {
                exception.printStackTrace();
                log.error("Cannot issue checkpoint on " + bRdbms.getName() + " (" + bRdbms.getType() + ')');
            }
        }
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.dbs = new HashMap();
        this.ready = false;
        this.saveListener = new Station.SaveListener(){

            public final void stationSave() {
                BOrionService.this.checkpoint();
            }

            public final void stationSaveOk() {
            }

            public final void stationSaveFail(String string) {
            }

            public final String toString() {
                return "OrionService " + BOrionService.this.getNavOrd();
            }
        };
    }

    public BOrionService() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$orion$BOrionService;
        if (clazz == null) {
            clazz = class$com$tridium$orion$BOrionService = BOrionService.class("[Lcom.tridium.orion.BOrionService;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.make((String)"module://orion/rc/orion.png");
        log = Log.getLog((String)"orion");
    }
}

