/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.ui;

import com.tridium.crypto.core.cert.CertValidationResult;
import com.tridium.crypto.core.cert.NHostExemption;
import com.tridium.crypto.core.cert.NX509Certificate;
import com.tridium.crypto.core.cert.TridiumX509TrustManager;
import com.tridium.crypto.core.io.CoreCryptoManager;
import com.tridium.crypto.core.util.ILogger;
import com.tridium.nre.security.ISecurityInfoProvider;
import com.tridium.platcrypto.ui.BExemptionChangedDialog;
import com.tridium.platcrypto.ui.BExemptionPromptDialog;
import com.tridium.platcrypto.util.Logger;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.baja.log.Log;

public class TridiumUIX509TrustManager
extends TridiumX509TrustManager {
    /*
     * Enabled aggressive block sorting
     */
    protected void handleRejectedCertificate(X509Certificate[] x509CertificateArray, CoreCryptoManager coreCryptoManager, CertValidationResult certValidationResult) throws Exception {
        this.log.error("No trusted certificate found");
        if (!certValidationResult.certChanged()) {
            boolean bl = BExemptionPromptDialog.show(null, certValidationResult);
            this.addExemption(x509CertificateArray[0], coreCryptoManager, bl);
            if (bl) return;
            this.certificateException(certValidationResult.isValidCertChain(), certValidationResult.isHostnameVerified(), certValidationResult.isCertExpired());
            return;
        }
        if (BExemptionChangedDialog.show(null, certValidationResult)) {
            this.addExemption(x509CertificateArray[0], coreCryptoManager, true);
            return;
        }
        NHostExemption nHostExemption = coreCryptoManager.getExemptionStore().getExemption(this.host);
        nHostExemption.setChanged(NX509Certificate.make((X509Certificate)x509CertificateArray[0]));
        coreCryptoManager.getExemptionStore().setExemption(nHostExemption);
        throw new CertificateException("certificate private key has changed");
    }

    public TridiumUIX509TrustManager(ISecurityInfoProvider iSecurityInfoProvider) throws Exception {
        super(iSecurityInfoProvider, (ILogger)new Logger(Log.getLog((String)"crypto")));
    }
}

