/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.ui;

import com.tridium.crypto.core.cert.NX509Certificate;
import com.tridium.ui.theme.Theme;
import com.tridium.ui.theme.custom.nss.StyleUtils;
import java.util.Enumeration;
import java.util.Properties;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.style.IStylable;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BX509CertificateChangedPane
extends BEdgePane {
    public static final Type TYPE;
    static Lexicon lex;
    private NX509Certificate oldCert;
    private NX509Certificate cert;
    private Properties before;
    private Properties after;
    static /* synthetic */ Class class$com$tridium$platcrypto$ui$BX509CertificateChangedPane;

    public Type getType() {
        return TYPE;
    }

    public void set(NX509Certificate nX509Certificate, NX509Certificate nX509Certificate2) {
        this.set(nX509Certificate, nX509Certificate2, null, null);
    }

    public void set(NX509Certificate nX509Certificate, NX509Certificate nX509Certificate2, Properties properties, Properties properties2) {
        this.oldCert = nX509Certificate;
        this.cert = nX509Certificate2;
        this.before = properties;
        this.after = properties2;
        this.buildCertPane();
    }

    private final void buildCertPane() {
        BGridPane bGridPane = new BGridPane(2);
        bGridPane.setStretchColumn(1);
        bGridPane.setColorRows(true);
        StyleUtils.addStyleClass((IStylable)bGridPane, (String)"scrolled");
        bGridPane.setColumnAlign(BHalign.fill);
        this.appendProperties(bGridPane, this.before);
        this.appendCertProperties(bGridPane);
        this.appendProperties(bGridPane, this.after);
        this.setCenter((BWidget)bGridPane);
    }

    protected void appendProperties(BGridPane bGridPane, Properties properties) {
        if (properties == null) {
            return;
        }
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string, null);
            if (string2 == null) continue;
            bGridPane.add(null, (BValue)this.createPaddedLabel(lex.getText(string), false));
            bGridPane.add(null, (BValue)this.createPaddedLabel(string2, true));
        }
    }

    protected void appendCertProperty(BGridPane bGridPane, String string, String string2, String string3) {
        if (string2.equals(string3)) {
            bGridPane.add(null, (BValue)this.createPaddedLabel(string, false));
            bGridPane.add(null, (BValue)this.createPaddedLabel(string3, true));
        } else {
            bGridPane.add(null, (BValue)this.createPaddedLabel(string, false));
            BEdgePane bEdgePane = new BEdgePane();
            bEdgePane.setTop(this.createPaddedLabel("(-) " + string2, true));
            bEdgePane.setBottom(this.createChangedLabel("(+) " + string3));
            bGridPane.add(null, (BValue)bEdgePane);
        }
    }

    protected void appendCertProperties(BGridPane bGridPane) {
        if (this.cert == null || this.oldCert == null) {
            return;
        }
        this.appendCertProperty(bGridPane, lex.getText("cert.field.version"), "v" + this.oldCert.getVersion(), "v" + this.cert.getVersion());
        this.appendCertProperty(bGridPane, lex.getText("cert.field.serialNum"), ByteArrayUtil.toHexString((byte[])this.oldCert.getSerialNumber().toByteArray(), (String)" "), ByteArrayUtil.toHexString((byte[])this.cert.getSerialNumber().toByteArray(), (String)" "));
        this.appendCertProperty(bGridPane, lex.getText("cert.field.issuedBy"), this.oldCert.getIssuer(), this.cert.getIssuer());
        this.appendCertProperty(bGridPane, lex.getText("cert.field.issuerDn"), this.oldCert.getIssuerDN().toString(), this.cert.getIssuerDN().toString());
        this.appendCertProperty(bGridPane, lex.getText("cert.field.subject"), this.oldCert.getSubject(), this.cert.getSubject());
        this.appendCertProperty(bGridPane, lex.getText("cert.field.subjectDn"), this.oldCert.getSubjectDN().toString(), this.cert.getSubjectDN().toString());
        this.appendCertProperty(bGridPane, lex.getText("cert.field.notBefore"), this.oldCert.getNotBefore().toString(), this.cert.getNotBefore().toString());
        this.appendCertProperty(bGridPane, lex.getText("cert.field.notAfter"), this.oldCert.getNotAfter().toString(), this.cert.getNotAfter().toString());
        this.appendCertProperty(bGridPane, lex.getText("cert.field.keyAlgorithm"), this.oldCert.getKeyAlgorithm(), this.cert.getKeyAlgorithm());
        this.appendCertProperty(bGridPane, lex.getText("cert.field.keySize"), "" + this.oldCert.getKeySize(), "" + this.cert.getKeySize());
        this.appendCertProperty(bGridPane, lex.getText("cert.field.signatureAlgorithm"), this.oldCert.getSignatureAlgorithm(), this.cert.getSignatureAlgorithm());
        this.appendCertProperty(bGridPane, lex.getText("cert.field.signatureSize"), "" + this.oldCert.getSignatureSize(), "" + this.cert.getSignatureSize());
        this.appendCertProperty(bGridPane, lex.getText("cert.field.basicConstraints"), this.oldCert.getBasicConstraints(), this.cert.getBasicConstraints());
        this.appendCertProperty(bGridPane, lex.getText("cert.field.keyUsage"), this.oldCert.getKeyUsage(), this.cert.getKeyUsage());
        this.appendCertProperty(bGridPane, lex.getText("cert.field.extendedKeyUsage"), this.oldCert.getExtendedKeyUsage(), this.cert.getExtendedKeyUsage());
        this.appendCertProperty(bGridPane, lex.getText("cert.field.md5Fingerprint"), this.oldCert.getMD5Fingerprint(), this.cert.getMD5Fingerprint());
        this.appendCertProperty(bGridPane, lex.getText("cert.field.sha1Fingerprint"), this.oldCert.getSHA1Fingerprint(), this.cert.getSHA1Fingerprint());
        this.appendCertProperty(bGridPane, lex.getText("cert.field.valid"), this.oldCert.checkValidity() ? lex.getText("cert.field.valid.true") : lex.getText("cert.field.valid.false"), this.cert.checkValidity() ? lex.getText("cert.field.valid.true") : lex.getText("cert.field.valid.false"));
    }

    private final BWidget createPaddedLabel(String string, boolean bl) {
        BLabel bLabel = new BLabel(string, BHalign.left);
        if (bl) {
            bLabel.setFont(Theme.label().getFixedWidthFont((IStylable)bLabel));
        }
        BBorderPane bBorderPane = new BBorderPane((BWidget)bLabel, 0.0, (double)5, 0.0, 15.0);
        return bBorderPane;
    }

    private final BWidget createChangedLabel(String string) {
        BLabel bLabel = new BLabel(string, BHalign.left);
        bLabel.setFont(Theme.label().getFixedWidthFont((IStylable)bLabel));
        StyleUtils.addStyleClass((IStylable)bLabel, (String)"warning emphasized");
        BBorderPane bBorderPane = new BBorderPane((BWidget)bLabel, 0.0, (double)5, 0.0, 15.0);
        return bBorderPane;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BX509CertificateChangedPane() {
        this.cert = null;
        this.before = null;
        this.after = null;
    }

    public BX509CertificateChangedPane(NX509Certificate nX509Certificate, NX509Certificate nX509Certificate2) {
        this.oldCert = nX509Certificate;
        this.cert = nX509Certificate2;
        this.before = null;
        this.after = null;
        this.buildCertPane();
    }

    public BX509CertificateChangedPane(NX509Certificate nX509Certificate, NX509Certificate nX509Certificate2, Properties properties, Properties properties2) {
        this.oldCert = nX509Certificate;
        this.cert = nX509Certificate2;
        this.before = properties;
        this.after = properties2;
        this.buildCertPane();
    }

    static {
        Class clazz = class$com$tridium$platcrypto$ui$BX509CertificateChangedPane;
        if (clazz == null) {
            clazz = class$com$tridium$platcrypto$ui$BX509CertificateChangedPane = BX509CertificateChangedPane.class("[Lcom.tridium.platcrypto.ui.BX509CertificateChangedPane;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        lex = Lexicon.make((String)"platCrypto");
    }
}

