/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.ui;

import com.tridium.crypto.core.io.ICoreKeyStore;
import com.tridium.platcrypto.ui.BCertsTable;
import com.tridium.platcrypto.ui.BPrivateKeyPasswordDialog;
import com.tridium.workbench.fieldeditors.BAbsTimeFE;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Locale;
import javax.baja.gx.BImage;
import javax.baja.security.BPassword;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BRadioButton;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.ToggleCommandGroup;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.event.BWindowEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.ui.wizard.BWizardHeader;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BSelfSignedDialog
extends BDialog {
    public static final Action okButtonPressed = BSelfSignedDialog.newAction((int)0, (BValue)new BWidgetEvent(), null);
    public static final Action cancelButtonPressed = BSelfSignedDialog.newAction((int)0, (BValue)new BWidgetEvent(), null);
    public static final Action setModified = BSelfSignedDialog.newAction((int)0, (BValue)new BWidgetEvent(), null);
    public static final Type TYPE;
    private static Lexicon lex;
    private static final BImage logo;
    private BTextField alias;
    private BTextField cn;
    private BTextField ou;
    private BTextField o;
    private BTextField l;
    private BTextField st;
    private BTextField c;
    private BAbsTimeFE starts;
    private BAbsTimeFE ends;
    private BRadioButton keySize1024;
    private BRadioButton keySize2048;
    private BRadioButton keySize3072;
    private BRadioButton keySize4096;
    private BRadioButton serverCert;
    private BRadioButton caCert;
    private BTextField emailAltName;
    private BPassword pkPassword;
    private BButton okButton;
    private BButton cancelButton;
    private ICoreKeyStore mgr;
    private int keySize;
    private int keyUsage;
    private boolean canceled;
    static /* synthetic */ Class class$com$tridium$platcrypto$ui$BSelfSignedDialog;

    public void okButtonPressed(BWidgetEvent bWidgetEvent) {
        this.invoke(okButtonPressed, (BValue)bWidgetEvent, null);
    }

    public void cancelButtonPressed(BWidgetEvent bWidgetEvent) {
        this.invoke(cancelButtonPressed, (BValue)bWidgetEvent, null);
    }

    public void setModified(BWidgetEvent bWidgetEvent) {
        this.invoke(setModified, (BValue)bWidgetEvent, null);
    }

    public Type getType() {
        return TYPE;
    }

    public static BCertsTable.CertGenRequest show(BWidget bWidget, ICoreKeyStore iCoreKeyStore) {
        BSelfSignedDialog bSelfSignedDialog = new BSelfSignedDialog(bWidget, iCoreKeyStore);
        bSelfSignedDialog.setBoundsCenteredOnOwner();
        bSelfSignedDialog.setResizable(false);
        bSelfSignedDialog.open();
        return bSelfSignedDialog.getResult();
    }

    private final BWidget buildDialog() {
        BEdgePane bEdgePane = new BEdgePane();
        bEdgePane.setTop(this.buildHeader());
        bEdgePane.setCenter(this.buildContent());
        return bEdgePane;
    }

    private final BWidget buildHeader() {
        return new BWizardHeader(logo, this.getTitle(), lex.getText("cert.generate.dialog.info"));
    }

    private final BWidget buildContent() {
        BGridPane bGridPane = new BGridPane(1);
        bGridPane.setHalign(BHalign.center);
        bGridPane.setColumnAlign(BHalign.center);
        bGridPane.add(null, (BValue)this.buildBody());
        bGridPane.add(null, (BValue)this.buildButtons());
        return new BBorderPane((BWidget)bGridPane, 7.0, 7.0, 7.0, 7.0);
    }

    private final BWidget buildDnTextField(BTextField bTextField, boolean bl) {
        BGridPane bGridPane = new BGridPane(2);
        bGridPane.setStretchColumn(0);
        bGridPane.setColumnAlign(BHalign.fill);
        bGridPane.add(null, (BValue)bTextField);
        if (bl) {
            bGridPane.add(null, (BValue)new BLabel(lex.getText("cert.field.required")));
        } else {
            bGridPane.add(null, (BValue)new BLabel());
        }
        return bGridPane;
    }

    private final BWidget buildBody() {
        BGridPane bGridPane = new BGridPane(2);
        bGridPane.setRowGap((double)5);
        bGridPane.setColumnGap((double)5);
        bGridPane.setColumnAlign(BHalign.left);
        bGridPane.setStretchColumn(1);
        bGridPane.add(null, (BValue)new BLabel(lex.getText("cert.field.alias")));
        this.alias = new BTextField("", 40);
        bGridPane.add(null, (BValue)this.buildDnTextField(this.alias, true));
        bGridPane.add(null, (BValue)new BLabel(lex.getText("cert.field.commonName")));
        this.cn = new BTextField("", 40);
        bGridPane.add(null, (BValue)this.buildDnTextField(this.cn, true));
        bGridPane.add(null, (BValue)new BLabel(""));
        bGridPane.add(null, (BValue)new BLabel(lex.getText("cert.field.commonName.desc")));
        bGridPane.add(null, (BValue)new BLabel(lex.getText("cert.field.organizationalUnit")));
        this.ou = new BTextField("", 40);
        bGridPane.add(null, (BValue)this.buildDnTextField(this.ou, false));
        bGridPane.add(null, (BValue)new BLabel(lex.getText("cert.field.organization")));
        this.o = new BTextField("", 40);
        bGridPane.add(null, (BValue)this.buildDnTextField(this.o, true));
        bGridPane.add(null, (BValue)new BLabel(lex.getText("cert.field.locality")));
        this.l = new BTextField("", 40);
        bGridPane.add(null, (BValue)this.buildDnTextField(this.l, false));
        bGridPane.add(null, (BValue)new BLabel(lex.getText("cert.field.stateProvince")));
        this.st = new BTextField("", 40);
        bGridPane.add(null, (BValue)this.buildDnTextField(this.st, false));
        bGridPane.add(null, (BValue)new BLabel(lex.getText("cert.field.countryCode")));
        this.c = new BTextField("", 3);
        bGridPane.add(null, (BValue)this.buildDnTextField(this.c, true));
        bGridPane.add(null, (BValue)new BLabel(lex.getText("cert.field.notBefore")));
        this.starts = new BAbsTimeFE();
        bGridPane.add(null, (BValue)this.starts);
        this.starts.loadValue((BObject)BAbsTime.now());
        bGridPane.add(null, (BValue)new BLabel(lex.getText("cert.field.notAfter")));
        this.ends = new BAbsTimeFE();
        bGridPane.add(null, (BValue)this.ends);
        this.ends.loadValue((BObject)BAbsTime.make((long)(Clock.millis() + BRelTime.makeHours((int)8760).getMillis())));
        BGridPane bGridPane2 = new BGridPane(4);
        bGridPane2.setColumnGap(7.0);
        ToggleCommandGroup toggleCommandGroup = new ToggleCommandGroup();
        this.keySize1024 = new BRadioButton(toggleCommandGroup, lex.getText("cert.field.1024bits"), false);
        bGridPane2.add(null, (BValue)this.keySize1024);
        this.keySize2048 = new BRadioButton(toggleCommandGroup, lex.getText("cert.field.2048bits"), true);
        bGridPane2.add(null, (BValue)this.keySize2048);
        this.keySize3072 = new BRadioButton(toggleCommandGroup, lex.getText("cert.field.3072bits"), true);
        bGridPane2.add(null, (BValue)this.keySize3072);
        this.keySize4096 = new BRadioButton(toggleCommandGroup, lex.getText("cert.field.4096bits"), false);
        bGridPane2.add(null, (BValue)this.keySize4096);
        bGridPane.add(null, (BValue)new BLabel(lex.getText("cert.field.keySize")));
        bGridPane.add(null, (BValue)bGridPane2);
        this.keySize2048.setSelected(true);
        BGridPane bGridPane3 = new BGridPane(2);
        toggleCommandGroup = new ToggleCommandGroup();
        this.serverCert = new BRadioButton(toggleCommandGroup, lex.getText("cert.field.serverCert"), true);
        bGridPane3.add(null, (BValue)this.serverCert);
        this.caCert = new BRadioButton(toggleCommandGroup, lex.getText("cert.field.caCert"), false);
        bGridPane3.add(null, (BValue)this.caCert);
        bGridPane.add(null, (BValue)new BLabel(lex.getText("cert.field.certUsage")));
        bGridPane.add(null, (BValue)bGridPane3);
        bGridPane.add(null, (BValue)new BLabel(lex.getText("cert.field.emailAddress")));
        this.emailAltName = new BTextField("", 40);
        bGridPane.add(null, (BValue)this.emailAltName);
        BGridPane bGridPane4 = new BGridPane(1);
        bGridPane4.add(null, (BValue)bGridPane);
        this.linkTo(null, (BComponent)this.alias, (Slot)BTextField.textModified, (Slot)setModified);
        this.linkTo(null, (BComponent)this.cn, (Slot)BTextField.textModified, (Slot)setModified);
        this.linkTo(null, (BComponent)this.o, (Slot)BTextField.textModified, (Slot)setModified);
        this.linkTo(null, (BComponent)this.c, (Slot)BTextField.textModified, (Slot)setModified);
        this.linkTo(null, (BComponent)this.starts, (Slot)BAbsTimeFE.pluginModified, (Slot)setModified);
        this.linkTo(null, (BComponent)this.ends, (Slot)BAbsTimeFE.pluginModified, (Slot)setModified);
        return bGridPane4;
    }

    private final BWidget buildButtons() {
        BGridPane bGridPane = new BGridPane(2);
        bGridPane.setColumnAlign(BHalign.fill);
        bGridPane.setUniformColumnWidth(true);
        this.okButton = new BButton(UiLexicon.bajaui().getText("dialog.ok"));
        bGridPane.add(null, (BValue)this.okButton);
        this.linkTo("linkA", (BComponent)this.okButton, (Slot)BButton.actionPerformed, (Slot)okButtonPressed);
        this.okButton.setEnabled(false);
        this.cancelButton = new BButton(UiLexicon.bajaui().getText("dialog.cancel"));
        bGridPane.add(null, (BValue)this.cancelButton);
        this.linkTo("linkB", (BComponent)this.cancelButton, (Slot)BButton.actionPerformed, (Slot)cancelButtonPressed);
        return new BBorderPane((BWidget)bGridPane, 7.0, 0.0, 0.0, 0.0);
    }

    public void windowClosing(BWindowEvent bWindowEvent) {
        this.close();
    }

    public void doOkButtonPressed(BWidgetEvent bWidgetEvent) throws Exception {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.alias.getText().length() <= 0) {
            stringBuffer.append("- " + lex.getText("cert.generate.error.requiredAlias") + '\n');
        }
        if (this.cn.getText().length() <= 0) {
            stringBuffer.append("- " + lex.getText("cert.generate.error.requiredCommonName") + '\n');
        }
        if (this.o.getText().length() <= 0) {
            stringBuffer.append("- " + lex.getText("cert.generate.error.requiredOrganization") + '\n');
        }
        if (!BSelfSignedDialog.isValidCountryCode(string = this.c.getText())) {
            stringBuffer.append("- " + lex.getText("cert.generate.error.requiredCountryCode") + '\n');
        }
        if (stringBuffer.length() > 0) {
            BDialog.error((BWidget)this, (String)lex.getText("cert.generate.error.failure"), (Object)lex.getText("cert.generate.error.failure.description"), (String)stringBuffer.toString());
            return;
        }
        if (this.keySize1024.getSelected()) {
            if (BDialog.open((BWidget)this, (String)lex.getText("cert.generate.warning.weakKeySize"), (Object)lex.getText("cert.generate.warning.weakKeySize.description"), (int)12, (BImage)BDialog.WARNING_ICON, null) == 8) {
                return;
            }
            this.keySize = 1024;
        } else if (this.keySize2048.getSelected()) {
            this.keySize = 2048;
        } else if (this.keySize3072.getSelected()) {
            this.keySize = 3072;
        } else if (this.keySize4096.getSelected()) {
            this.keySize = 4096;
        }
        this.keyUsage = 0;
        if (this.serverCert.getSelected()) {
            this.keyUsage = 160;
        } else if (this.caCert.getSelected()) {
            this.keyUsage = 6;
        }
        try {
            X509Certificate x509Certificate = this.mgr.getCertificate(this.alias.getText());
            if (x509Certificate != null) {
                if (BDialog.open((BWidget)this, (String)lex.getText("cert.generate.warning.matchingAlias"), (Object)lex.getText("cert.generate.warning.matchingAlias.description", new Object[]{this.alias.getText()}), (int)12, (BImage)BDialog.WARNING_ICON) == 8) {
                    return;
                }
                this.mgr.deleteEntry(this.alias.getText());
            }
        }
        catch (Exception exception) {}
        if ((this.keyUsage & 4) != 0) {
            this.pkPassword = BPrivateKeyPasswordDialog.open((BWidget)this);
            if (this.pkPassword == null) {
                this.close();
                return;
            }
        }
        this.canceled = false;
        this.close();
    }

    public void doCancelButtonPressed(BWidgetEvent bWidgetEvent) {
        this.close();
    }

    public void doSetModified(BWidgetEvent bWidgetEvent) {
        boolean bl = true;
        try {
            if (this.alias.getText().trim().length() == 0) {
                bl = false;
            }
            if (this.cn.getText().trim().length() == 0) {
                bl = false;
            }
            if (this.o.getText().trim().length() == 0) {
                bl = false;
            }
            if (!BSelfSignedDialog.isValidCountryCode(this.c.getText())) {
                bl = false;
            }
            if (((BAbsTime)this.ends.saveValue()).getMillis() <= ((BAbsTime)this.starts.saveValue()).getMillis()) {
                bl = false;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        this.okButton.setEnabled(bl);
    }

    private static final boolean isValidCountryCode(String string) {
        boolean bl = true;
        if (string.trim().length() <= 0) {
            bl = false;
        } else if (string.trim().length() != 2) {
            bl = false;
        } else {
            String[] stringArray = Locale.getISOCountries();
            int n = 0;
            n = 0;
            while (n < stringArray.length) {
                if (string.equalsIgnoreCase(stringArray[n])) break;
                ++n;
            }
            if (n == stringArray.length) {
                bl = false;
            }
        }
        return bl;
    }

    public BCertsTable.CertGenRequest getResult() {
        if (this.canceled) {
            return null;
        }
        try {
            int n = this.mgr.generateSelfSignedCert(this.alias.getText(), this.cn.getText().trim().length() > 0 ? this.cn.getText() : null, this.ou.getText().trim().length() > 0 ? this.ou.getText() : null, this.o.getText().trim().length() > 0 ? this.o.getText() : null, this.l.getText().trim().length() > 0 ? this.l.getText() : null, this.st.getText().trim().length() > 0 ? this.st.getText() : null, this.c.getText().length() > 0 ? this.c.getText() : null, new Date(((BAbsTime)this.starts.saveValue()).getMillis()), new Date(((BAbsTime)this.ends.saveValue()).getMillis()), this.keySize, this.keyUsage, this.emailAltName.getText().length() > 0 ? this.emailAltName.getText() : null, this.pkPassword != null ? this.pkPassword.getValue() : null);
            if (n == -1) {
                return null;
            }
            return new BCertsTable.CertGenRequest(n, this.alias.getText());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.alias = null;
        this.cn = null;
        this.ou = null;
        this.o = null;
        this.l = null;
        this.st = null;
        this.c = null;
        this.starts = null;
        this.ends = null;
        this.keySize1024 = null;
        this.keySize2048 = null;
        this.keySize3072 = null;
        this.keySize4096 = null;
        this.serverCert = null;
        this.caCert = null;
        this.emailAltName = null;
        this.pkPassword = null;
        this.okButton = null;
        this.cancelButton = null;
        this.mgr = null;
        this.keySize = 2048;
        this.keyUsage = 0;
        this.canceled = true;
    }

    protected BSelfSignedDialog(BWidget bWidget, ICoreKeyStore iCoreKeyStore) {
        super(bWidget, lex.getText("cert.generate.dialog.title"), true);
        this.this();
        this.mgr = iCoreKeyStore;
        this.setContent(this.buildDialog());
        this.setDefaultButton(this.okButton);
    }

    static {
        Class clazz = class$com$tridium$platcrypto$ui$BSelfSignedDialog;
        if (clazz == null) {
            clazz = class$com$tridium$platcrypto$ui$BSelfSignedDialog = BSelfSignedDialog.class("[Lcom.tridium.platcrypto.ui.BSelfSignedDialog;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        lex = Lexicon.make((String)"platCrypto");
        logo = BImage.make((String)lex.get("cert.x32.icon", "module://icons/x32/lock.png"));
    }
}

