/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.ui;

import com.tridium.crypto.core.cert.NKey;
import com.tridium.crypto.core.cert.NPKCS10CertificationRequest;
import com.tridium.crypto.core.cert.NX509Certificate;
import com.tridium.crypto.core.util.FriendlyPemReader;
import com.tridium.platcrypto.ui.PrivateKeyPasswordFinder;
import com.tridium.platcrypto.util.BPemFile;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.Key;
import java.security.KeyPair;
import java.security.Provider;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.baja.gx.BImage;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BTextEditorPane;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.wizard.BWizardHeader;
import javax.baja.util.Lexicon;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.view.BWbView;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequest;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BPemFileView
extends BWbView {
    public static final Type TYPE;
    protected static Lexicon lex;
    protected static BImage logo;
    public BTextEditorPane pane;
    public BTextEditor editor;
    static /* synthetic */ Class class$com$tridium$platcrypto$ui$BPemFileView;

    public Type getType() {
        return TYPE;
    }

    protected BWidget buildHeader() {
        return new BWizardHeader(logo, lex.getText("pem.file.viewer.title"));
    }

    protected void doLoadValue(BObject bObject, Context context) throws Exception {
        super.doLoadValue(bObject, context);
        StringBuffer stringBuffer = new StringBuffer();
        BPemFile bPemFile = (BPemFile)bObject;
        InputStream inputStream = bPemFile.getInputStream();
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        FriendlyPemReader friendlyPemReader = new FriendlyPemReader((Reader)inputStreamReader);
        PEMParser pEMParser = new PEMParser((Reader)friendlyPemReader);
        int n = 0;
        while (n < 50) {
            try {
                NPKCS10CertificationRequest nPKCS10CertificationRequest;
                Object object;
                Object object2 = pEMParser.readObject();
                if (object2 == null) break;
                if (object2 instanceof X509Certificate) {
                    object = NX509Certificate.make((X509Certificate)((X509Certificate)object2));
                    stringBuffer.append(object.toString());
                } else if (object2 instanceof X509CertificateHolder) {
                    object = new JcaX509CertificateConverter().getCertificate((X509CertificateHolder)object2);
                    stringBuffer.append(((Certificate)object).toString());
                } else if (object2 instanceof PKCS10CertificationRequest) {
                    object = new JcaPKCS10CertificationRequest(((PKCS10CertificationRequest)object2).getEncoded());
                    nPKCS10CertificationRequest = NPKCS10CertificationRequest.make((JcaPKCS10CertificationRequest)object);
                    stringBuffer.append(nPKCS10CertificationRequest.toString());
                } else if (object2 instanceof Key) {
                    stringBuffer.append(NKey.toString((Key)((Key)object2)));
                } else if (object2 instanceof KeyPair) {
                    object = (KeyPair)object2;
                    stringBuffer.append(NKey.toString((Key)((KeyPair)object).getPrivate()));
                    stringBuffer.append(NKey.toString((Key)((KeyPair)object).getPublic()));
                } else if (object2 instanceof PEMKeyPair) {
                    object = (PEMKeyPair)object2;
                    nPKCS10CertificationRequest = new JcaPEMKeyConverter().setProvider((Provider)new BouncyCastleProvider());
                    stringBuffer.append(NKey.toString((Key)nPKCS10CertificationRequest.getPrivateKey(object.getPrivateKeyInfo())));
                    stringBuffer.append(NKey.toString((Key)nPKCS10CertificationRequest.getPublicKey(object.getPublicKeyInfo())));
                } else if (object2 instanceof PEMEncryptedKeyPair) {
                    object = new JcePEMDecryptorProviderBuilder().setProvider((Provider)new BouncyCastleProvider());
                    nPKCS10CertificationRequest = object.build(new PrivateKeyPasswordFinder((BWidget)this).getPassword());
                    JcaPEMKeyConverter jcaPEMKeyConverter = new JcaPEMKeyConverter().setProvider((Provider)new BouncyCastleProvider());
                    PEMKeyPair pEMKeyPair = ((PEMEncryptedKeyPair)object2).decryptKeyPair((PEMDecryptorProvider)nPKCS10CertificationRequest);
                    stringBuffer.append(NKey.toString((Key)jcaPEMKeyConverter.getPrivateKey(pEMKeyPair.getPrivateKeyInfo())));
                    stringBuffer.append(NKey.toString((Key)jcaPEMKeyConverter.getPublicKey(pEMKeyPair.getPublicKeyInfo())));
                } else {
                    stringBuffer.append("unrecognized object: " + object2.getClass().getName() + '\n');
                    stringBuffer.append(object2.toString());
                }
                stringBuffer.append("\n");
            }
            catch (Exception exception) {
                ++n;
                stringBuffer.append("error parsing object: " + exception.getLocalizedMessage()).append("\n");
            }
        }
        try {
            if (pEMParser != null) {
                pEMParser.close();
            }
        }
        catch (Exception exception) {}
        this.editor.setEditable(false);
        this.editor.setText(stringBuffer.toString());
    }

    protected BObject doSaveValue(BObject bObject, Context context) throws CannotSaveException, Exception {
        return super.doSaveValue(bObject, context);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.pane = new BTextEditorPane("", 80, 40, true);
        this.editor = this.pane.getEditor();
    }

    public BPemFileView() {
        this.this();
        this.setContent((BWidget)this.pane);
    }

    static {
        Class clazz = class$com$tridium$platcrypto$ui$BPemFileView;
        if (clazz == null) {
            clazz = class$com$tridium$platcrypto$ui$BPemFileView = BPemFileView.class("[Lcom.tridium.platcrypto.ui.BPemFileView;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        lex = Lexicon.make((String)"platCrypto");
        logo = BImage.make((String)lex.get("cert.x32.icon", "module://crypto/icons/x32/cert.png"));
    }
}

