/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.ui;

import com.tridium.crypto.core.cert.NHostExemption;
import com.tridium.crypto.core.io.ICoreExemptionStore;
import com.tridium.platcrypto.ui.BExemptionChangedDialog;
import com.tridium.platcrypto.ui.BExemptionViewDialog;
import com.tridium.platform.ui.util.BCommandBoundTable;
import com.tridium.platform.ui.util.BCommandEnablePolicy;
import com.tridium.platform.ui.util.CommandBindings;
import com.tridium.platform.ui.util.CommandUtil;
import java.util.Enumeration;
import javax.baja.gx.BImage;
import javax.baja.log.Log;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.SortUtil;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.table.DynamicTableModel;
import javax.baja.ui.table.TableModel;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BExemptionTable
extends BCommandBoundTable
implements CommandBindings.Support {
    public static final Type TYPE;
    public static final int COL_HOST = 0;
    public static final int COL_SUBJECT = 1;
    public static final int COL_STATUS = 2;
    public static final int COL_CREATED = 3;
    public static final int COL_ISSUER = 4;
    public static final int COL_NOT_BEFORE = 5;
    public static final int COL_NOT_AFTER = 6;
    public static final int COL_KEY_ALG = 7;
    public static final int COL_KEY_SIZE = 8;
    public static final int COL_SIG_ALG = 9;
    public static final int COL_SIG_SIZE = 10;
    public static final int COL_VALID = 11;
    protected static Log log;
    public static final Lexicon lex;
    static final BImage securityHigh;
    static final BImage securityMedium;
    static final BImage securityLow;
    protected ICoreExemptionStore mgr;
    protected boolean readonly;
    static /* synthetic */ Class class$com$tridium$platcrypto$ui$BExemptionTable;

    public Type getType() {
        return TYPE;
    }

    public void load() throws Exception {
        this.exemptModel().load();
    }

    protected void initCommands() {
        this.getCommandBindings().setSupport((CommandBindings.Support)this);
        ViewCommand viewCommand = new ViewCommand();
        this.addCommand(viewCommand, BCommandEnablePolicy.singleSelection);
        this.setDoubleClickCommand(viewCommand);
        this.addCommand(new ApproveCommand(), BCommandEnablePolicy.anySelection);
        this.addCommand(new UnapproveCommand(), BCommandEnablePolicy.anySelection);
        this.addCommand(new DeleteCommand(), BCommandEnablePolicy.anySelection);
    }

    protected ExemptionModel exemptModel() {
        DynamicTableModel dynamicTableModel = (DynamicTableModel)this.getModel();
        return (ExemptionModel)dynamicTableModel.getRootModel();
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public void setReadonly(boolean bl) {
        this.readonly = bl;
        this.setCommandEnabledStates();
    }

    public void setBoundCommandEnabled(Command command, boolean bl) {
        if (this.readonly && (command instanceof ApproveCommand || command instanceof UnapproveCommand || command instanceof DeleteCommand)) {
            command.setEnabled(false);
        } else {
            CommandBindings.TableSelection tableSelection = (CommandBindings.TableSelection)this.getSelection();
            int[] nArray = tableSelection.getRows();
            if (nArray.length > 0 && command instanceof ApprovalCommand) {
                ApprovalCommand approvalCommand = (ApprovalCommand)command;
                DynamicTableModel dynamicTableModel = (DynamicTableModel)this.getModel();
                ExemptionModel exemptionModel = (ExemptionModel)dynamicTableModel.getRootModel();
                boolean bl2 = true;
                int n = 0;
                while (n < nArray.length) {
                    NHostExemption nHostExemption = (NHostExemption)exemptionModel.exemptions.get(nArray[n]);
                    bl2 &= nHostExemption.getApproved();
                    ++n;
                }
                command.setEnabled(approvalCommand.isApproved() ? bl2 ^ true : bl2);
            } else {
                command.setEnabled(bl);
            }
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.mgr = null;
        this.readonly = false;
    }

    public BExemptionTable() throws UnsupportedOperationException {
        this.this();
        throw new UnsupportedOperationException();
    }

    public BExemptionTable(ICoreExemptionStore iCoreExemptionStore) throws Exception {
        int[] nArray = new int[7];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        nArray[6] = 6;
        super((TableModel)new DynamicTableModel((TableModel)new ExemptionModel(iCoreExemptionStore), nArray));
        this.this();
        this.mgr = iCoreExemptionStore;
        this.initCommands();
    }

    static {
        Class clazz = class$com$tridium$platcrypto$ui$BExemptionTable;
        if (clazz == null) {
            clazz = class$com$tridium$platcrypto$ui$BExemptionTable = BExemptionTable.class("[Lcom.tridium.platcrypto.ui.BExemptionTable;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        log = Log.getLog((String)"crypto");
        lex = Lexicon.make((String)"platCrypto");
        securityHigh = BImage.make((String)lex.get("security.high.x16.icon", "module://icons/x16/security-high.png"));
        securityMedium = BImage.make((String)lex.get("security.medium.x16.icon", "module://icons/x16/security-medium.png"));
        securityLow = BImage.make((String)lex.get("security.low.x16.icon", "module://icons/x16/security-low.png"));
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    static class ExemptionModel
    extends TableModel {
        private Array exemptions;
        private ICoreExemptionStore mgr;
        static /* synthetic */ Class class$com$tridium$crypto$core$cert$NHostExemption;

        public BImage getRowIcon(int n) {
            if (!this.exemption(n).getApproved()) {
                return securityLow;
            }
            if (this.exemption(n).getChanged() != null) {
                return securityMedium;
            }
            return securityHigh;
        }

        public void load() throws Exception {
            Enumeration enumeration = this.mgr.exemptions();
            Class clazz = class$com$tridium$crypto$core$cert$NHostExemption;
            if (clazz == null) {
                clazz = class$com$tridium$crypto$core$cert$NHostExemption = ExemptionModel.class("[Lcom.tridium.crypto.core.cert.NHostExemption;", false);
            }
            this.exemptions = new Array(clazz);
            while (enumeration.hasMoreElements()) {
                this.exemptions.add(enumeration.nextElement());
            }
            this.updateTable(true);
            this.getSelection().deselectAll();
        }

        public int getColumnCount() {
            return 12;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return lex.getText("exempt.field.host");
                }
                case 2: {
                    return lex.getText("exempt.field.approved");
                }
                case 3: {
                    return lex.getText("exempt.field.created");
                }
                case 4: {
                    return lex.getText("cert.field.issuedBy");
                }
                case 1: {
                    return lex.getText("cert.field.subject");
                }
                case 5: {
                    return lex.getText("cert.field.notBefore");
                }
                case 6: {
                    return lex.getText("cert.field.notAfter");
                }
                case 7: {
                    return lex.getText("cert.field.keyAlgorithm");
                }
                case 8: {
                    return lex.getText("cert.field.keySize");
                }
                case 9: {
                    return lex.getText("cert.field.signatureAlgorithm");
                }
                case 10: {
                    return lex.getText("cert.field.signatureSize");
                }
                case 11: {
                    return lex.getText("cert.field.valid");
                }
            }
            throw new IndexOutOfBoundsException();
        }

        public boolean isColumnSortable(int n) {
            return true;
        }

        public void sortByColumn(int n, boolean bl) {
            Object[] objectArray = this.getColumnValues(n);
            Object[] objectArray2 = this.exemptions.trim();
            SortUtil.sort((Object[])objectArray, (Object[])objectArray2, (boolean)bl);
            this.exemptions.clear();
            this.exemptions.addAll(objectArray2);
            this.updateTable(false);
        }

        public int getRowCount() {
            int n = 0;
            if (this.exemptions != null) {
                n = this.exemptions.size();
            }
            return n;
        }

        public NHostExemption exemption(int n) {
            return (NHostExemption)this.exemptions.get(n);
        }

        public Object getValueAt(int n, int n2) {
            switch (n2) {
                case 0: {
                    return this.exemption(n).getHost();
                }
                case 2: {
                    return this.exemption(n).getApproved() ? lex.getText("exempt.field.approved.true") : lex.getText("exempt.field.approved.false");
                }
                case 3: {
                    return this.exemption(n).getCreated();
                }
                case 4: {
                    return this.exemption(n).getCertificate().getIssuer();
                }
                case 1: {
                    return this.exemption(n).getCertificate().getSubject();
                }
                case 5: {
                    return this.exemption(n).getCertificate().getNotBefore();
                }
                case 6: {
                    return this.exemption(n).getCertificate().getNotAfter();
                }
                case 7: {
                    return this.exemption(n).getCertificate().getKeyAlgorithm();
                }
                case 8: {
                    return "" + this.exemption(n).getCertificate().getKeySize();
                }
                case 9: {
                    return this.exemption(n).getCertificate().getSignatureAlgorithm();
                }
                case 10: {
                    return "" + this.exemption(n).getCertificate().getSignatureSize();
                }
                case 11: {
                    return this.exemption(n).getCertificate().checkValidity() ? lex.getText("cert.field.valid.true") : lex.getText("cert.field.valid.false");
                }
            }
            throw new IndexOutOfBoundsException();
        }

        static /* synthetic */ Class class(String string, boolean bl) {
            try {
                Class<?> clazz = Class.forName(string);
                if (!bl) {
                    clazz = clazz.getComponentType();
                }
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }

        private final /* synthetic */ void this() {
            this.exemptions = null;
            this.mgr = null;
        }

        public ExemptionModel(ICoreExemptionStore iCoreExemptionStore) {
            this.this();
            this.mgr = iCoreExemptionStore;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class ViewCommand
    extends Command {
        public CommandArtifact doInvoke() {
            try {
                int n = BExemptionTable.this.exemptModel().getSelection().getRow();
                NHostExemption nHostExemption = BExemptionTable.this.exemptModel().exemption(n);
                if (nHostExemption.getChanged() != null) {
                    if (BExemptionChangedDialog.show((BWidget)BExemptionTable.this, nHostExemption)) {
                        nHostExemption.approveChanged();
                        BExemptionTable.this.mgr.setExemption(nHostExemption);
                        BExemptionTable.this.mgr.save();
                    }
                } else {
                    BExemptionViewDialog.show((BWidget)BExemptionTable.this, nHostExemption);
                }
            }
            catch (Exception exception) {
                CommandUtil.error((Command)this, (Throwable)exception);
            }
            return null;
        }

        public ViewCommand() {
            super((BWidget)BExemptionTable.this, lex, "exemption.button.view");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class ApproveCommand
    extends ApprovalCommand {
        public String getTitle() {
            return "exempt.approve.dialog.title";
        }

        public String getInfo() {
            return "exempt.approve.dialog.info";
        }

        public boolean isApproved() {
            return true;
        }

        public ApproveCommand() {
            super((BWidget)BExemptionTable.this, lex, "exemption.button.approve");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class UnapproveCommand
    extends ApprovalCommand {
        public String getTitle() {
            return "exempt.unapprove.dialog.title";
        }

        public String getInfo() {
            return "exempt.unapprove.dialog.info";
        }

        public boolean isApproved() {
            return false;
        }

        public UnapproveCommand() {
            super((BWidget)BExemptionTable.this, lex, "exemption.button.unapprove");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class DeleteCommand
    extends Command {
        public CommandArtifact doInvoke() {
            try {
                if (4 == BDialog.confirm((BWidget)BExemptionTable.this, (String)lex.getText("exempt.delete.dialog.title"), (Object)lex.getText("exempt.delete.dialog.info"), (int)12)) {
                    int[] nArray = BExemptionTable.this.getSelection().getRows();
                    int n = 0;
                    while (n < nArray.length) {
                        String string = BExemptionTable.this.exemptModel().exemption(nArray[n]).getHost();
                        BExemptionTable.this.mgr.deleteExemption(string);
                        ++n;
                    }
                    BExemptionTable.this.mgr.save();
                    BExemptionTable.this.exemptModel().load();
                }
            }
            catch (Exception exception) {
                CommandUtil.error((Command)this, (Throwable)exception);
            }
            return null;
        }

        public DeleteCommand() {
            super((BWidget)BExemptionTable.this, lex, "exemption.button.delete");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected abstract class ApprovalCommand
    extends Command {
        public abstract String getTitle();

        public abstract String getInfo();

        public abstract boolean isApproved();

        public CommandArtifact doInvoke() {
            try {
                if (4 == BDialog.confirm((BWidget)BExemptionTable.this, (String)lex.getText(this.getTitle()), (Object)lex.getText(this.getInfo()), (int)12)) {
                    int[] nArray = BExemptionTable.this.getSelection().getRows();
                    boolean bl = false;
                    int n = 0;
                    while (n < nArray.length) {
                        NHostExemption nHostExemption = BExemptionTable.this.exemptModel().exemption(nArray[n]);
                        boolean bl2 = this.isApproved();
                        if (bl2 != nHostExemption.getApproved()) {
                            nHostExemption.setApproved(bl2);
                            BExemptionTable.this.mgr.setExemption(nHostExemption);
                            bl = true;
                        }
                        ++n;
                    }
                    if (bl) {
                        BExemptionTable.this.mgr.save();
                    }
                    BExemptionTable.this.exemptModel().load();
                }
            }
            catch (Exception exception) {
                CommandUtil.error((Command)this, (Throwable)exception);
            }
            return null;
        }

        public ApprovalCommand(BWidget bWidget, Lexicon lexicon, String string) {
            super(bWidget, lexicon, string);
        }
    }
}

