/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.ui;

import com.tridium.crypto.core.cert.NX509Certificate;
import com.tridium.crypto.core.cert.NX509Extension;
import com.tridium.platcrypto.ui.BCryptoDialog;
import com.tridium.platcrypto.ui.BX509CertificatePane;
import com.tridium.platcrypto.ui.BX509ExtensionPane;
import javax.baja.gx.BImage;
import javax.baja.gx.Size;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.event.BWindowEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.ui.wizard.BWizardHeader;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BCertViewDialog
extends BCryptoDialog {
    public static final Type TYPE;
    protected static Lexicon lex;
    protected static BImage logo;
    protected NX509Certificate cert;
    protected BButton okButton;
    static /* synthetic */ Class class$com$tridium$platcrypto$ui$BCertViewDialog;

    public Type getType() {
        return TYPE;
    }

    public static void show(BWidget bWidget, NX509Certificate nX509Certificate) throws Exception {
        BCertViewDialog bCertViewDialog = new BCertViewDialog(bWidget, nX509Certificate);
        bCertViewDialog.setBoundsCenteredOnOwner();
        bCertViewDialog.setResizable(false);
        bCertViewDialog.open();
    }

    protected BWidget buildHeader() {
        return new BWizardHeader(logo, this.cert.getSubject(), lex.getText("cert.view.dialog.info", new Object[]{this.cert.getSubject()}));
    }

    protected BWidget buildBody() throws Exception {
        BGridPane bGridPane = new BGridPane(1);
        bGridPane.setStyleClasses("scrolled");
        bGridPane.setStretchColumn(0);
        bGridPane.setColumnAlign(BHalign.fill);
        bGridPane.add(null, (BValue)new BBorderPane(this.createHeaderLabel(lex.getText("cert.dialog.properties") + ':')));
        bGridPane.add(null, (BValue)new BBorderPane(this.buildProperties(), 0.0, 0.0, 0.0, 0.0));
        NX509Extension[] nX509ExtensionArray = this.cert.getExtensions();
        if (nX509ExtensionArray.length > 0) {
            bGridPane.add(null, (BValue)new BBorderPane(this.createHeaderLabel(lex.getText("cert.dialog.extensions") + ':')));
            bGridPane.add(null, (BValue)new BBorderPane(this.buildExtensions(), 0.0, 0.0, 0.0, 0.0));
        }
        BScrollPane bScrollPane = new BScrollPane((BWidget)bGridPane);
        Size size = this.getCertViewSize();
        BConstrainedPane bConstrainedPane = new BConstrainedPane((BWidget)bScrollPane, size.width, size.height);
        bConstrainedPane.setMinWidth(500.0);
        return bConstrainedPane;
    }

    protected Size getCertViewSize() {
        return new Size(600.0, 400.0);
    }

    protected BWidget buildProperties() {
        BX509CertificatePane bX509CertificatePane = new BX509CertificatePane(this.cert);
        return bX509CertificatePane;
    }

    protected BWidget buildExtensions() throws Exception {
        BX509ExtensionPane bX509ExtensionPane = new BX509ExtensionPane();
        bX509ExtensionPane.setExtensions(this.cert.getExtensions(), false);
        return bX509ExtensionPane;
    }

    protected BWidget buildButtons() {
        BGridPane bGridPane = new BGridPane(1);
        bGridPane.setColumnAlign(BHalign.fill);
        bGridPane.setUniformColumnWidth(true);
        this.okButton = new BButton(UiLexicon.bajaui().getText("dialog.ok"));
        bGridPane.add(null, (BValue)this.okButton);
        this.linkTo("linkA", (BComponent)this.okButton, (Slot)BButton.actionPerformed, (Slot)okButtonPressed);
        this.okButton.setEnabled(true);
        return new BBorderPane((BWidget)bGridPane, 7.0, 0.0, 0.0, 0.0);
    }

    public void windowClosing(BWindowEvent bWindowEvent) {
        this.close();
    }

    public void doOkButtonPressed(BWidgetEvent bWidgetEvent) {
        this.close();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected BCertViewDialog(BWidget bWidget, String string) throws Exception {
        super(bWidget, string);
    }

    protected BCertViewDialog(BWidget bWidget, NX509Certificate nX509Certificate) throws Exception {
        this(bWidget, lex.getText("cert.view.dialog.title"));
        this.cert = nX509Certificate;
        this.setContent(this.buildDialog());
        this.setDefaultButton(this.okButton);
    }

    static {
        Class clazz = class$com$tridium$platcrypto$ui$BCertViewDialog;
        if (clazz == null) {
            clazz = class$com$tridium$platcrypto$ui$BCertViewDialog = BCertViewDialog.class("[Lcom.tridium.platcrypto.ui.BCertViewDialog;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        lex = Lexicon.make((String)"platCrypto");
        logo = BImage.make((String)lex.get("cert.x32.icon", "module://icons/x32/lock.png"));
    }
}

