/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.daemon;

import com.tridium.net.HttpUtil;
import com.tridium.platcrypto.daemon.BDaemonSecureScheme;
import com.tridium.platcrypto.util.BSslSessionInfo;
import com.tridium.platform.BPlatformSSLSettings;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.util.BSessionInfo;
import java.net.ConnectException;
import java.net.Socket;
import java.net.SocketException;
import javax.baja.io.net.IClientSocketFactory;
import javax.baja.naming.BHost;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.nav.BINavNode;
import javax.baja.net.HttpConnection;
import javax.baja.net.HttpsConnection;
import javax.baja.security.BIUserCredentials;
import javax.baja.sys.BIcon;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.LexiconText;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BDaemonSecureSession
extends BDaemonSession {
    public static final String PLATFORM_SSL_ORD = "platformssl";
    public static final Type TYPE;
    private static final BIcon secureBadgeConnected;
    private static final BIcon secureBadgeDisconnected;
    private IClientSocketFactory socketFactory;
    private Socket lastSocket;
    private Object SOCKET_FACTORY_LOCK;
    private BOrd ordInHost;
    private BOrd absOrd;
    static /* synthetic */ Class class$com$tridium$platcrypto$daemon$BDaemonSecureSession;

    public Type getType() {
        return TYPE;
    }

    protected BDaemonSession makeNewSession(BHost bHost, int n, String[] stringArray) {
        return BDaemonSecureSession.make(bHost, n, stringArray);
    }

    public static BDaemonSession makeIgnoringCache(BHost bHost, int n, String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer("noCache:");
        stringBuffer.append(PLATFORM_SSL_ORD);
        if (n != 5011) {
            stringBuffer.append(":").append(n);
        }
        if (stringArray != null) {
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (stringArray[n2] != null) {
                    stringBuffer.append("/").append(stringArray[n2]);
                }
                ++n2;
            }
        }
        return new BDaemonSecureSession(stringBuffer.toString(), bHost, n, stringArray, BOrd.make((String)""));
    }

    public static BDaemonSession make(BHost bHost, int n, String[] stringArray) {
        BDaemonSession bDaemonSession;
        StringBuffer stringBuffer = new StringBuffer(PLATFORM_SSL_ORD);
        if (n != 5011) {
            stringBuffer.append(":").append(n);
        }
        if (stringArray != null) {
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (stringArray[n2] != null) {
                    stringBuffer.append("/").append(stringArray[n2]);
                }
                ++n2;
            }
        }
        if ((bDaemonSession = (BDaemonSession)bHost.getNavChild(stringBuffer.toString())) == null || !(bDaemonSession instanceof BDaemonSecureSession)) {
            BOrd bOrd;
            if (stringArray != null) {
                int n3 = 0;
                while (n3 < stringArray.length) {
                    HttpUtil.parseHost((String)stringArray[n3]);
                    HttpUtil.parsePort((String)stringArray[n3], (int)3011);
                    ++n3;
                }
                bOrd = BOrd.make((OrdQuery)new BDaemonSecureScheme.DaemonQuery(n, stringArray));
            } else {
                bOrd = BOrd.make((OrdQuery)new BDaemonSecureScheme.DaemonQuery(n));
            }
            bDaemonSession = new BDaemonSecureSession(stringBuffer.toString(), bHost, n, stringArray, bOrd);
            bHost.addNavChild((BINavNode)bDaemonSession);
        }
        return bDaemonSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected HttpConnection createNewConnection(String string, long l, int n, int n2, String string2) throws SocketException {
        try {
            Object object = this.SOCKET_FACTORY_LOCK;
            synchronized (object) {
                if (this.socketFactory == null) {
                    this.socketFactory = HttpsConnection.getDefaultSocketFactory();
                }
                HttpsConnection httpsConnection = new HttpsConnection(this.getHost(), this.getPort(), string2, this.socketFactory);
                return this.initConnection((HttpConnection)httpsConnection, string, l, n, n2);
            }
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void setDefaultAgent() {
        this.getAgentList().remove("platform:DaemonTunnelSessionAgent");
        this.getAgentList().remove("platform:DaemonSessionAgent");
        if (this.tunnelAuthorities != null) {
            this.getAgentList().toTop("platformssl:DaemonSecureTunnelSessionAgent");
        } else {
            this.getAgentList().toTop("platformssl:DaemonSecureSessionAgent");
        }
    }

    protected int connect(HttpConnection httpConnection) throws ConnectException {
        int n = super.connect(httpConnection);
        this.lastSocket = httpConnection.getSocket();
        return n;
    }

    public BSessionInfo getSessionInfo() {
        BHost bHost = this.getHost();
        if (bHost != null) {
            String string = null;
            if (this.getCredentials() instanceof BIUserCredentials) {
                string = ((BIUserCredentials)this.getCredentials()).getUsername();
            }
            return BSslSessionInfo.make(bHost.getHostname(), this.getLastConnectedAbsTime(), this.lastSocket, string);
        }
        return null;
    }

    public boolean shouldDowngrade(BPlatformSSLSettings bPlatformSSLSettings) {
        return bPlatformSSLSettings.getSslEnabled() ^ true;
    }

    public boolean isSecure() {
        return true;
    }

    protected String getLexiconPrefix() {
        return "DaemonSecureSession.";
    }

    protected int getDefaultPort() {
        return 5011;
    }

    public BIcon getIcon() {
        return BIcon.make((BIcon)super.getIcon(), (BIcon)(this.isConnected() ? secureBadgeConnected : secureBadgeDisconnected));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void disconnect(boolean bl) {
        super.disconnect(bl);
        Object object = this.SOCKET_FACTORY_LOCK;
        synchronized (object) {
            this.socketFactory = null;
            return;
        }
    }

    public BOrd getNavOrd() {
        return this.getAbsoluteOrd();
    }

    public BOrd getOrdInHost() {
        return this.ordInHost;
    }

    public BOrd getAbsoluteOrd() {
        return this.absOrd;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.lastSocket = null;
        this.SOCKET_FACTORY_LOCK = new Object();
    }

    protected BDaemonSecureSession(String string, BHost bHost, int n, String[] stringArray, BOrd bOrd) {
        super(string, bHost, n, stringArray, bOrd, stringArray == null ? LexiconText.make((String)"platCrypto", (String)"daemon.secure.session") : LexiconText.make((String)"platCrypto", (String)"daemon.secure.tunnel.session"));
        this.this();
        this.ordInHost = bOrd;
        this.absOrd = BOrd.make((BOrd)bHost.getAbsoluteOrd(), (BOrd)this.ordInHost);
    }

    static {
        Class clazz = class$com$tridium$platcrypto$daemon$BDaemonSecureSession;
        if (clazz == null) {
            clazz = class$com$tridium$platcrypto$daemon$BDaemonSecureSession = BDaemonSecureSession.class("[Lcom.tridium.platcrypto.daemon.BDaemonSecureSession;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        secureBadgeConnected = BIcon.std((String)"badges/lock.png");
        secureBadgeDisconnected = BIcon.std((String)"badges/lockDisconnected.png");
    }
}

