/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nvideo.dvr;

import com.tridium.ndriver.datatypes.BAddress;
import com.tridium.ndriver.util.SfUtil;
import com.tridium.nvideo.BVideoDevice;
import com.tridium.nvideo.BVideoNetwork;
import com.tridium.nvideo.camera.BCameraDeviceExt;
import com.tridium.nvideo.camera.BVideoCamera;
import com.tridium.nvideo.camera.BVideoSourcePreferences;
import com.tridium.nvideo.datatypes.BDvrId;
import com.tridium.nvideo.datatypes.BVideoDeviceId;
import com.tridium.nvideo.display.BDisplayDeviceExt;
import com.tridium.nvideo.display.BNullVideoDisplay;
import com.tridium.nvideo.dvr.BVideoDvrPingMonitor;
import com.tridium.videoDriver.BIVideoNetwork;
import com.tridium.videoDriver.camera.BIVideoCameraDeviceExt;
import com.tridium.videoDriver.display.BIVideoDisplayDeviceExt;
import com.tridium.videoDriver.dvr.BIVideoDvr;
import com.tridium.videoDriver.enums.BFoxVideoStreamEnum;
import com.tridium.videoDriver.enums.BVideoAspectRatioEnum;
import com.tridium.videoDriver.enums.BVideoCompressionEnum;
import com.tridium.videoDriver.enums.BVideoFrameRateEnum;
import com.tridium.videoDriver.enums.BVideoResolutionEnum;
import com.tridium.videoDriver.ui.playback.VideoPlaybackSession;
import com.tridium.videoDriver.videoStream.BIVideoMultistreamServer;
import com.tridium.videoDriver.videoStream.BPlaybackParams;
import com.tridium.videoDriver.videoStream.IVideoDestination;
import com.tridium.videoDriver.videoStream.IVideoPlayback;
import javax.baja.driver.ping.BPingMonitor;
import javax.baja.gx.BColor;
import javax.baja.license.LicenseException;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BVideoDvr
extends BVideoDevice
implements BIVideoDvr,
BIVideoMultistreamServer {
    public static final Property videoDeviceId = BVideoDvr.newProperty((int)0, (BValue)new BDvrId(), (BFacets)SfUtil.incl((String)"ed"));
    public static final Property monitor = BVideoDvr.newProperty((int)0, (BValue)new BVideoDvrPingMonitor(), null);
    public static final Property address = BVideoDvr.newProperty((int)0, (BValue)new BAddress(), null);
    public static final Property foxVideoStreamPreferred = BVideoDvr.newProperty((int)0, (BValue)BFoxVideoStreamEnum.inherit, (BFacets)SfUtil.incl((String)"ed.un"));
    public static final Property multistreamPreferences = BVideoDvr.newProperty((int)0, (BValue)new BVideoSourcePreferences(), null);
    public static final Property displays = BVideoDvr.newProperty((int)0, (BValue)new BDisplayDeviceExt(), null);
    public static final Property cameras = BVideoDvr.newProperty((int)0, (BValue)new BCameraDeviceExt(), null);
    public static final Type TYPE;
    static /* synthetic */ Class class$com$tridium$nvideo$dvr$BVideoDvr;

    public BPingMonitor getMonitor() {
        return (BPingMonitor)this.get(monitor);
    }

    public void setMonitor(BPingMonitor bPingMonitor) {
        this.set(monitor, (BValue)bPingMonitor, null);
    }

    public BAddress getAddress() {
        return (BAddress)this.get(address);
    }

    public void setAddress(BAddress bAddress) {
        this.set(address, (BValue)bAddress, null);
    }

    public BFoxVideoStreamEnum getFoxVideoStreamPreferred() {
        return (BFoxVideoStreamEnum)this.get(foxVideoStreamPreferred);
    }

    public void setFoxVideoStreamPreferred(BFoxVideoStreamEnum bFoxVideoStreamEnum) {
        this.set(foxVideoStreamPreferred, (BValue)bFoxVideoStreamEnum, null);
    }

    public BVideoSourcePreferences getMultistreamPreferences() {
        return (BVideoSourcePreferences)this.get(multistreamPreferences);
    }

    public void setMultistreamPreferences(BVideoSourcePreferences bVideoSourcePreferences) {
        this.set(multistreamPreferences, (BValue)bVideoSourcePreferences, null);
    }

    public BDisplayDeviceExt getDisplays() {
        return (BDisplayDeviceExt)this.get(displays);
    }

    public void setDisplays(BDisplayDeviceExt bDisplayDeviceExt) {
        this.set(displays, (BValue)bDisplayDeviceExt, null);
    }

    public BCameraDeviceExt getCameras() {
        return (BCameraDeviceExt)this.get(cameras);
    }

    public void setCameras(BCameraDeviceExt bCameraDeviceExt) {
        this.set(cameras, (BValue)bCameraDeviceExt, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void changed(Property property, Context context) {
        if (property.equals((Object)faultCause)) {
            this.getDisplays().updateStatus();
            this.getCameras().updateStatus();
        }
        super.changed(property, context);
    }

    public final void started() throws Exception {
        try {
            Sys.getLicenseManager().checkFeature("tridium", "videoDriver");
            this.videoDvrStarted();
        }
        catch (LicenseException licenseException) {
            this.configFatal(licenseException.toString());
        }
        super.started();
    }

    public void videoDvrStarted() throws Exception {
    }

    public Type getVideoDisplayType() {
        return BNullVideoDisplay.TYPE;
    }

    public BIVideoCameraDeviceExt getCameraExt() {
        return this.getCameras();
    }

    public BIVideoDisplayDeviceExt getDisplayExt() {
        return this.getDisplays();
    }

    public String getDvrDescription() {
        BVideoDeviceId bVideoDeviceId = this.getVideoDeviceId();
        if (bVideoDeviceId instanceof BDvrId) {
            return ((BDvrId)bVideoDeviceId).getDescription();
        }
        return this.getDisplayName(null);
    }

    public boolean supportsPlaybackControl() {
        return false;
    }

    public boolean isTimestampPreferred() {
        return this.getMultistreamPreferences().getTimestampPreferred();
    }

    public BRelTime getInterframeTimeout() {
        if (this.isDown()) {
            return BVideoCamera.ONE_SECOND;
        }
        return this.getMultistreamPreferences().getInterframeTimeout();
    }

    public BIVideoNetwork getVideoNetwork() {
        return this.vnetwork();
    }

    protected boolean recurseFoxVideoStreamPreferredToNet() {
        BIVideoNetwork bIVideoNetwork = this.getVideoNetwork();
        if (bIVideoNetwork != null && bIVideoNetwork instanceof BVideoNetwork) {
            if (bIVideoNetwork instanceof BComponent) {
                ((BComponent)bIVideoNetwork).lease();
                try {
                    ((BComponent)bIVideoNetwork).getComponentSpace().sync();
                }
                catch (Exception exception) {
                    return false;
                }
            }
            return ((BVideoNetwork)bIVideoNetwork).getFoxVideoStreamPreferred();
        }
        return false;
    }

    public boolean isFoxVideoStreamPreferred() {
        BFoxVideoStreamEnum bFoxVideoStreamEnum = this.getMultistreamPreferences().getPreferredVideoStreamFox();
        if (bFoxVideoStreamEnum == BFoxVideoStreamEnum.inherit) {
            return this.recurseFoxVideoStreamPreferredToNet();
        }
        if (bFoxVideoStreamEnum == BFoxVideoStreamEnum.no) {
            return false;
        }
        if (bFoxVideoStreamEnum == BFoxVideoStreamEnum.yes) {
            return true;
        }
        throw new IllegalStateException("Unrecognized foxStreamEnum: " + bFoxVideoStreamEnum);
    }

    public BFoxVideoStreamEnum getFoxVideoStreamSetting() {
        return this.getMultistreamPreferences().getPreferredVideoStreamFox();
    }

    public BVideoResolutionEnum getPreferredResolution() {
        return this.getMultistreamPreferences().getPreferredResolution();
    }

    public BVideoFrameRateEnum getPreferredFrameRate() {
        return this.getMultistreamPreferences().getPreferredFrameRate();
    }

    public BVideoCompressionEnum getPreferredCompression() {
        return this.getMultistreamPreferences().getPreferredCompression();
    }

    public VideoPlaybackSession newPlaybackSession(IVideoPlayback iVideoPlayback) {
        return new VideoPlaybackSession(iVideoPlayback);
    }

    public abstract void streamToDestination(BPlaybackParams var1, IVideoDestination var2);

    public BColor getPreferredBackgroundColor() {
        return this.getMultistreamPreferences().getPreferredBackgroundColor();
    }

    public BVideoAspectRatioEnum getPreferredAspectRatio() {
        return this.getMultistreamPreferences().getPreferredAspectRatio();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$nvideo$dvr$BVideoDvr;
        if (clazz == null) {
            clazz = class$com$tridium$nvideo$dvr$BVideoDvr = BVideoDvr.class("[Lcom.tridium.nvideo.dvr.BVideoDvr;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

