/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nvideo.camera;

import com.tridium.ndriver.util.SfUtil;
import com.tridium.nvideo.BVideoNetwork;
import com.tridium.nvideo.camera.BSimpleVideoCamera;
import com.tridium.nvideo.camera.BVideoSourcePreferences;
import com.tridium.nvideo.camera.controlHelper.BCameraControlHelper;
import com.tridium.nvideo.camera.controlHelper.BCameraControlTimings;
import com.tridium.nvideo.camera.controlHelper.BFocusControlHelper;
import com.tridium.nvideo.camera.controlHelper.BIrisControlHelper;
import com.tridium.nvideo.camera.controlHelper.BMovementControlHelper;
import com.tridium.nvideo.camera.controlHelper.BZoomControlHelper;
import com.tridium.nvideo.datatypes.BVideoCameraInfo;
import com.tridium.nvideo.datatypes.BVideoDeviceId;
import com.tridium.nvideo.display.BVideoDisplay;
import com.tridium.nvideo.display.BVideoDisplayChooser;
import com.tridium.nvideo.dvr.BVideoDvr;
import com.tridium.videoDriver.BIVideoDeviceSystem;
import com.tridium.videoDriver.BIVideoNetwork;
import com.tridium.videoDriver.camera.BIVideoPtzCamera;
import com.tridium.videoDriver.camera.control.BIVideoFocusControl;
import com.tridium.videoDriver.camera.control.BIVideoIrisControl;
import com.tridium.videoDriver.camera.control.BIVideoStorePresetControl;
import com.tridium.videoDriver.display.BIVideoDisplay;
import com.tridium.videoDriver.dvr.BIVideoDvr;
import com.tridium.videoDriver.enums.BFoxVideoStreamEnum;
import com.tridium.videoDriver.enums.BVideoAspectRatioEnum;
import com.tridium.videoDriver.enums.BVideoCompressionEnum;
import com.tridium.videoDriver.enums.BVideoFocusEnum;
import com.tridium.videoDriver.enums.BVideoFrameRateEnum;
import com.tridium.videoDriver.enums.BVideoIrisEnum;
import com.tridium.videoDriver.enums.BVideoPanTiltEnum;
import com.tridium.videoDriver.enums.BVideoResolutionEnum;
import com.tridium.videoDriver.enums.BVideoZoomEnum;
import com.tridium.videoDriver.ui.playback.VideoPlaybackSession;
import com.tridium.videoDriver.videoStream.BIVideoSource;
import com.tridium.videoDriver.videoStream.BPlaybackParams;
import com.tridium.videoDriver.videoStream.IVideoDestination;
import com.tridium.videoDriver.videoStream.IVideoPlayback;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.gx.BColor;
import javax.baja.naming.BOrd;
import javax.baja.naming.NullOrdException;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BVideoCamera
extends BSimpleVideoCamera
implements BIVideoPtzCamera,
BIVideoFocusControl,
BIVideoIrisControl,
BIVideoStorePresetControl,
BIVideoSource {
    public static final Property ptzSupport = BVideoCamera.newProperty((int)0, (BValue)new BVideoCameraInfo(), (BFacets)SfUtil.incl((String)"ed.un"));
    public static final Property controlTiming = BVideoCamera.newProperty((int)0, (BValue)new BCameraControlTimings(), null);
    public static final Property videoPreferences = BVideoCamera.newProperty((int)0, (BValue)new BVideoSourcePreferences(), (BFacets)SfUtil.incl());
    public static final Action move = BVideoCamera.newAction((int)20, (BValue)BVideoPanTiltEnum.none, null);
    public static final Action zoom = BVideoCamera.newAction((int)20, (BValue)BVideoZoomEnum.none, null);
    public static final Action moveToPreset = BVideoCamera.newAction((int)20, (BValue)BString.make((String)"-"), null);
    public static final Action storePreset = BVideoCamera.newAction((int)20, (BValue)BString.make((String)"-"), null);
    public static final Action makeActive = BVideoCamera.newAction((int)20, (BValue)new BVideoDisplayChooser(), null);
    public static final Action irisControl = BVideoCamera.newAction((int)20, (BValue)BVideoIrisEnum.none, null);
    public static final Action focusControl = BVideoCamera.newAction((int)20, (BValue)BVideoFocusEnum.none, null);
    public static final Action reevaluate = BVideoCamera.newAction((int)20, (BValue)new BMovementControlHelper(null), null);
    public static final Action sendToDisplay = BVideoCamera.newAction((int)0, null);
    public static final Type TYPE;
    protected static final BIcon icon;
    public static final BRelTime ONE_SECOND;
    protected int videoStreamThreadNumber;
    protected BFocusControlHelper focusControlHelper;
    protected BIrisControlHelper irisControlHelper;
    protected BZoomControlHelper zoomControlHelper;
    protected BMovementControlHelper movementControlHelper;
    static /* synthetic */ Class class$com$tridium$nvideo$camera$BVideoCamera;

    public BVideoCameraInfo getPtzSupport() {
        return (BVideoCameraInfo)this.get(ptzSupport);
    }

    public void setPtzSupport(BVideoCameraInfo bVideoCameraInfo) {
        this.set(ptzSupport, (BValue)bVideoCameraInfo, null);
    }

    public BCameraControlTimings getControlTiming() {
        return (BCameraControlTimings)this.get(controlTiming);
    }

    public void setControlTiming(BCameraControlTimings bCameraControlTimings) {
        this.set(controlTiming, (BValue)bCameraControlTimings, null);
    }

    public BVideoSourcePreferences getVideoPreferences() {
        return (BVideoSourcePreferences)this.get(videoPreferences);
    }

    public void setVideoPreferences(BVideoSourcePreferences bVideoSourcePreferences) {
        this.set(videoPreferences, (BValue)bVideoSourcePreferences, null);
    }

    public void move(BVideoPanTiltEnum bVideoPanTiltEnum) {
        this.invoke(move, (BValue)bVideoPanTiltEnum, null);
    }

    public void zoom(BVideoZoomEnum bVideoZoomEnum) {
        this.invoke(zoom, (BValue)bVideoZoomEnum, null);
    }

    public void moveToPreset(BValue bValue) {
        this.invoke(moveToPreset, bValue, null);
    }

    public void storePreset(BValue bValue) {
        this.invoke(storePreset, bValue, null);
    }

    public void makeActive(BVideoDisplayChooser bVideoDisplayChooser) {
        this.invoke(makeActive, (BValue)bVideoDisplayChooser, null);
    }

    public void irisControl(BVideoIrisEnum bVideoIrisEnum) {
        this.invoke(irisControl, (BValue)bVideoIrisEnum, null);
    }

    public void focusControl(BVideoFocusEnum bVideoFocusEnum) {
        this.invoke(focusControl, (BValue)bVideoFocusEnum, null);
    }

    public void reevaluate(BCameraControlHelper bCameraControlHelper) {
        this.invoke(reevaluate, (BValue)bCameraControlHelper, null);
    }

    public void sendToDisplay() {
        this.invoke(sendToDisplay, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public AgentList getAgents(Context context) {
        AgentInfo agentInfo;
        String string;
        AgentList agentList = super.getAgents(context);
        if (this.addLiveVideoView()) {
            string = this.getCameraViewTypeSpec();
            agentInfo = Sys.getRegistry().getType(string).getAgentInfo();
            agentList.add(agentInfo);
            if (this.areCameraViewsTopMost()) {
                agentList.toTop(agentInfo);
            }
        }
        if (this.addPlaybackView()) {
            string = this.getPlaybackViewTypeSpec();
            agentInfo = Sys.getRegistry().getType(string).getAgentInfo();
            agentList.add(agentInfo);
            if (this.areCameraViewsTopMost()) {
                agentList.toTop(agentInfo);
            }
        }
        try {
            string = Sys.getRegistry().getType("accessControl:HxWbAccessView").getAgentInfo();
            agentList.add((AgentInfo)string);
        }
        catch (Exception exception) {}
        return agentList;
    }

    protected boolean addLiveVideoView() {
        return true;
    }

    protected boolean addPlaybackView() {
        return true;
    }

    protected String getCameraViewTypeSpec() {
        return "videoDriver:LiveVideo";
    }

    protected String getPlaybackViewTypeSpec() {
        return "videoDriver:VideoPlayback";
    }

    protected boolean areCameraViewsTopMost() {
        return true;
    }

    protected BValue getMoveToPresetActionDefault() {
        return BString.make((String)"-");
    }

    protected BValue getStorePresetActionDefault() {
        return BString.make((String)"-");
    }

    public BVideoCameraInfo getCameraInfo() {
        return this.getPtzSupport();
    }

    public BIVideoDeviceSystem getVideoSystem() {
        BComplex bComplex = this.getParent();
        while (bComplex != null) {
            if (bComplex instanceof BIVideoDeviceSystem) {
                return (BIVideoDeviceSystem)bComplex;
            }
            bComplex = bComplex.getParent();
        }
        return null;
    }

    public void doReevaluate(BCameraControlHelper bCameraControlHelper) {
        bCameraControlHelper.doReevaluate();
    }

    public void doMove(BVideoPanTiltEnum bVideoPanTiltEnum) {
        if (this.getCameraInfo().getSupportsPanTilt()) {
            this.movementControlHelper.controlCamera(bVideoPanTiltEnum);
        }
    }

    public void doZoom(BVideoZoomEnum bVideoZoomEnum) {
        if (this.getCameraInfo().getSupportsZoom()) {
            this.zoomControlHelper.controlCamera(bVideoZoomEnum);
        }
    }

    public void doMoveToPreset(BValue bValue) {
    }

    public void doStorePreset(BValue bValue) {
    }

    public void doMakeActive(BVideoDisplayChooser bVideoDisplayChooser) {
        BOrd bOrd = bVideoDisplayChooser.getVideoDisplayOrd();
        try {
            BOrd bOrd2 = BOrd.make((BOrd)this.getOrdInHost(), (BOrd)bOrd);
            BVideoDisplay bVideoDisplay = (BVideoDisplay)bOrd2.get();
            bVideoDisplay.makeActiveCamera(this.getAbsoluteOrd());
        }
        catch (NullOrdException nullOrdException) {
            throw new LocalizableRuntimeException("nvideo", "makeCameraActive.noDisplays");
        }
    }

    public void doIrisControl(BVideoIrisEnum bVideoIrisEnum) {
        if (this.getCameraInfo().getSupportsIris()) {
            this.irisControlHelper.controlCamera(bVideoIrisEnum);
        }
    }

    public void doFocusControl(BVideoFocusEnum bVideoFocusEnum) {
        if (this.getCameraInfo().getSupportsFocus()) {
            this.focusControlHelper.controlCamera(bVideoFocusEnum);
        }
    }

    public void doSendToDisplay() {
        BIVideoDisplay[] bIVideoDisplayArray = this.getDvr().getDisplayExt().getAllDisplays();
        if (bIVideoDisplayArray.length == 0) {
            return;
        }
        BIVideoDisplay bIVideoDisplay = bIVideoDisplayArray[0];
        bIVideoDisplay.mapCamerasToCurrentLayout(new BOrd[]{this.getHandleOrd()});
    }

    public String getCameraDescription() {
        BVideoDeviceId bVideoDeviceId = this.getVideoDeviceId();
        return bVideoDeviceId.getDescription();
    }

    public abstract Action getMoveToPresetAction();

    public abstract Action getStorePresetAction();

    public BValue getActionParameterDefault(Action action) {
        if (action.equals((Object)makeActive)) {
            BComponent bComponent = (BComponent)this.getVideoSystem();
            BOrd bOrd = bComponent.getAbsoluteOrd();
            BVideoDisplayChooser bVideoDisplayChooser = new BVideoDisplayChooser();
            bVideoDisplayChooser.setVideoSystemOrd(bOrd);
            return bVideoDisplayChooser;
        }
        if (action.equals((Object)moveToPreset)) {
            return this.getMoveToPresetActionDefault();
        }
        return super.getActionParameterDefault(action);
    }

    public void onFocusControl(BVideoFocusEnum bVideoFocusEnum) {
    }

    public void onIrisControl(BVideoIrisEnum bVideoIrisEnum) {
    }

    public void onZoom(BVideoZoomEnum bVideoZoomEnum) {
    }

    public void onMove(BVideoPanTiltEnum bVideoPanTiltEnum) {
    }

    public VideoPlaybackSession newPlaybackSession(IVideoPlayback iVideoPlayback) {
        return new VideoPlaybackSession(iVideoPlayback);
    }

    public void streamToDestination(BPlaybackParams bPlaybackParams, IVideoDestination iVideoDestination) {
        throw new BajaRuntimeException("streamToDestination not implemented");
    }

    public boolean isMoveToPresetEnabled() {
        BVideoCameraInfo bVideoCameraInfo = this.getCameraInfo();
        boolean bl = false;
        if (bVideoCameraInfo != null && bVideoCameraInfo.getSupportsMoveToPreset()) {
            bl = true;
        }
        return bl;
    }

    public boolean isPanTiltEnabled() {
        BVideoCameraInfo bVideoCameraInfo = this.getCameraInfo();
        boolean bl = false;
        if (bVideoCameraInfo != null && bVideoCameraInfo.getSupportsPanTilt()) {
            bl = true;
        }
        return bl;
    }

    public boolean isStorePresetEnabled() {
        BVideoCameraInfo bVideoCameraInfo = this.getCameraInfo();
        boolean bl = false;
        if (bVideoCameraInfo != null && bVideoCameraInfo.getSupportsStorePreset()) {
            bl = true;
        }
        return bl;
    }

    public boolean isZoomEnabled() {
        BVideoCameraInfo bVideoCameraInfo = this.getCameraInfo();
        boolean bl = false;
        if (bVideoCameraInfo != null && bVideoCameraInfo.getSupportsZoom()) {
            bl = true;
        }
        return bl;
    }

    public boolean isFocusEnabled() {
        BVideoCameraInfo bVideoCameraInfo = this.getCameraInfo();
        boolean bl = false;
        if (bVideoCameraInfo != null && bVideoCameraInfo.getSupportsFocus()) {
            bl = true;
        }
        return bl;
    }

    public boolean isIrisEnabled() {
        BVideoCameraInfo bVideoCameraInfo = this.getCameraInfo();
        boolean bl = false;
        if (bVideoCameraInfo != null && bVideoCameraInfo.getSupportsIris()) {
            bl = true;
        }
        return bl;
    }

    public boolean supportsPlaybackControl() {
        return true;
    }

    public boolean isTimestampPreferred() {
        return this.getVideoPreferences().getTimestampPreferred();
    }

    public BRelTime getInterframeTimeout() {
        if (this.isDown()) {
            return ONE_SECOND;
        }
        return this.getVideoPreferences().getInterframeTimeout();
    }

    protected boolean recurseFoxVideoStreamPreferredToNet() {
        BIVideoNetwork bIVideoNetwork = this.getVideoNetwork();
        if (bIVideoNetwork != null && bIVideoNetwork instanceof BVideoNetwork) {
            if (bIVideoNetwork instanceof BComponent) {
                ((BComponent)bIVideoNetwork).lease();
                try {
                    ((BComponent)bIVideoNetwork).getComponentSpace().sync();
                }
                catch (Exception exception) {
                    return false;
                }
            }
            return ((BVideoNetwork)bIVideoNetwork).getFoxVideoStreamPreferred();
        }
        return false;
    }

    protected boolean recurseFoxVideoStreamPreferredToDvr() {
        BIVideoDvr bIVideoDvr = this.getDvr();
        if (bIVideoDvr != null && bIVideoDvr instanceof BVideoDvr) {
            BVideoDvr bVideoDvr = (BVideoDvr)bIVideoDvr;
            BFoxVideoStreamEnum bFoxVideoStreamEnum = bVideoDvr.getFoxVideoStreamPreferred();
            if (bIVideoDvr instanceof BComponent) {
                ((BComponent)bIVideoDvr).lease();
                try {
                    ((BComponent)bIVideoDvr).getComponentSpace().sync();
                }
                catch (Exception exception) {
                    return false;
                }
            }
            if (bFoxVideoStreamEnum == BFoxVideoStreamEnum.inherit) {
                return this.recurseFoxVideoStreamPreferredToNet();
            }
            if (bFoxVideoStreamEnum == BFoxVideoStreamEnum.no) {
                return false;
            }
            if (bFoxVideoStreamEnum == BFoxVideoStreamEnum.yes) {
                return true;
            }
            throw new IllegalStateException("Unrecognized foxStreamEnum: " + bFoxVideoStreamEnum);
        }
        return this.recurseFoxVideoStreamPreferredToNet();
    }

    public boolean isFoxVideoStreamPreferred() {
        BFoxVideoStreamEnum bFoxVideoStreamEnum = this.getFoxVideoStreamSetting();
        if (bFoxVideoStreamEnum == BFoxVideoStreamEnum.inherit) {
            return this.recurseFoxVideoStreamPreferredToDvr();
        }
        if (bFoxVideoStreamEnum == BFoxVideoStreamEnum.no) {
            return false;
        }
        if (bFoxVideoStreamEnum == BFoxVideoStreamEnum.yes) {
            return true;
        }
        throw new IllegalStateException("Unrecognized foxStreamEnum: " + bFoxVideoStreamEnum);
    }

    public BFoxVideoStreamEnum getFoxVideoStreamSetting() {
        return this.getVideoPreferences().getPreferredVideoStreamFox();
    }

    public BColor getPreferredBackgroundColor() {
        return this.getVideoPreferences().getPreferredBackgroundColor();
    }

    public BVideoAspectRatioEnum getPreferredAspectRatio() {
        return this.getVideoPreferences().getPreferredAspectRatio();
    }

    public BVideoFrameRateEnum getPreferredFrameRate() {
        return this.getVideoPreferences().getPreferredFrameRate();
    }

    public BVideoResolutionEnum getPreferredResolution() {
        return this.getVideoPreferences().getPreferredResolution();
    }

    public BVideoCompressionEnum getPreferredCompression() {
        return this.getVideoPreferences().getPreferredCompression();
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.videoStreamThreadNumber = 1;
        this.focusControlHelper = new BFocusControlHelper(this);
        this.irisControlHelper = new BIrisControlHelper(this);
        this.zoomControlHelper = new BZoomControlHelper(this);
        this.movementControlHelper = new BMovementControlHelper(this);
    }

    public BVideoCamera() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$nvideo$camera$BVideoCamera;
        if (clazz == null) {
            clazz = class$com$tridium$nvideo$camera$BVideoCamera = BVideoCamera.class("[Lcom.tridium.nvideo.camera.BVideoCamera;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.make((String)"module://videoDriver/icons/camera.png");
        ONE_SECOND = BRelTime.makeSeconds((int)1);
    }
}

