/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ndedicatedMicros.camera;

import com.tridium.ndedicatedMicros.BDedicatedMicrosNetwork;
import com.tridium.ndedicatedMicros.IDedicatedVideoServer;
import com.tridium.ndedicatedMicros.camera.BDedicatedCameraDeviceId;
import com.tridium.ndedicatedMicros.camera.DedicatedMicrosVideoDecoder;
import com.tridium.ndedicatedMicros.dvr.BDedicatedDvr;
import com.tridium.ndedicatedMicros.event.BDedicatedEventCameraExt;
import com.tridium.ndedicatedMicros.event.BDedicatedEventProxyExt;
import com.tridium.ndedicatedMicros.event.BDedicatedVideoEventRecall;
import com.tridium.ndedicatedMicros.messages.DedicatedFocusControlReq;
import com.tridium.ndedicatedMicros.messages.DedicatedIrisControlReq;
import com.tridium.ndedicatedMicros.messages.DedicatedMoveToPresetReq;
import com.tridium.ndedicatedMicros.messages.DedicatedPanTiltReq;
import com.tridium.ndedicatedMicros.messages.DedicatedStorePresetReq;
import com.tridium.ndedicatedMicros.messages.DedicatedZoomReq;
import com.tridium.ndedicatedMicros.util.DmHttpUtil;
import com.tridium.ndedicatedMicros.util.DmVideoStreamUtil;
import com.tridium.ndriver.comm.NComm;
import com.tridium.ndriver.comm.NMessage;
import com.tridium.ndriver.comm.http.HttpComm;
import com.tridium.ndriver.datatypes.BAddress;
import com.tridium.ndriver.datatypes.BIpAddress;
import com.tridium.ndriver.util.SfUtil;
import com.tridium.nvideo.camera.BVideoCamera;
import com.tridium.videoDriver.alarm.BIVideoAlarmRecorder;
import com.tridium.videoDriver.enums.BPlaybackTypeEnum;
import com.tridium.videoDriver.enums.BVideoFocusEnum;
import com.tridium.videoDriver.enums.BVideoIrisEnum;
import com.tridium.videoDriver.enums.BVideoPanTiltEnum;
import com.tridium.videoDriver.enums.BVideoZoomEnum;
import com.tridium.videoDriver.event.BIVideoEventProvider;
import com.tridium.videoDriver.event.BVideoEventRecall;
import com.tridium.videoDriver.videoStream.BPlaybackParams;
import com.tridium.videoDriver.videoStream.IVideoDestination;
import com.tridium.videoDriver.videoStream.IVideoSession;
import com.tridium.videoDriver.videoStream.decoder.IVideoDecoder;
import com.tridium.videoDriver.videoStream.fox.BFoxVideoSource;
import java.net.URLEncoder;
import java.util.StringTokenizer;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.control.BControlPoint;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.driver.point.BPointDeviceExt;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BDimension;
import javax.baja.units.BUnit;
import javax.baja.util.BTypeSpec;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BDedicatedCamera
extends BVideoCamera
implements BIVideoAlarmRecorder,
IDedicatedVideoServer,
BIVideoEventProvider {
    public static final Property videoDeviceId = BDedicatedCamera.newProperty((int)0, (BValue)new BDedicatedCameraDeviceId(), (BFacets)SfUtil.incl((String)"ed"));
    private static BFacets sf = BFacets.make((String)"min", (BIDataValue)BInteger.make((int)0), (String)"max", (BIDataValue)BInteger.make((int)15));
    private static BFacets rf = BFacets.make((String)"units", (BIDataValue)BUnit.make((String)"fps", (BDimension)BDimension.NULL), (String)"min", (BIDataValue)BInteger.make((int)1), (String)"max", (BIDataValue)BInteger.make((int)30));
    public static final Property fastSpeed = BDedicatedCamera.newProperty((int)0, (int)10, (BFacets)SfUtil.incl((String)"ed.un", (BFacets)sf));
    public static final Property mediumSpeed = BDedicatedCamera.newProperty((int)0, (int)5, (BFacets)SfUtil.incl((String)"ed.un", (BFacets)sf));
    public static final Property slowSpeed = BDedicatedCamera.newProperty((int)0, (int)2, (BFacets)SfUtil.incl((String)"ed.un", (BFacets)sf));
    public static final Property loFrameRate = BDedicatedCamera.newProperty((int)0, (int)4, (BFacets)SfUtil.incl((String)"ed.un", (BFacets)rf));
    public static final Property medFrameRate = BDedicatedCamera.newProperty((int)0, (int)15, (BFacets)SfUtil.incl((String)"ed.un", (BFacets)rf));
    public static final Property hiFrameRate = BDedicatedCamera.newProperty((int)0, (int)30, (BFacets)SfUtil.incl((String)"ed.un", (BFacets)rf));
    public static final Property presetText = BDedicatedCamera.newProperty((int)0, (BValue)BEnumRange.make((int[])new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9}, (String[])new String[]{"$31", "$32", "$33", "$34", "$35", "$36", "$37", "$38", "$39"}), null);
    public static final Property events = BDedicatedCamera.newProperty((int)0, (BValue)new BDedicatedEventCameraExt(), null);
    public static final Property eventRecaller = BDedicatedCamera.newProperty((int)6, (BValue)new BDedicatedVideoEventRecall(), null);
    public static final Action moveToPreset = BDedicatedCamera.newAction((int)20, (BValue)BDynamicEnum.make((int)0, (BEnumRange)((BEnumRange)presetText.getDefaultValue())), null);
    public static final Action storePreset = BDedicatedCamera.newAction((int)20, (BValue)BDynamicEnum.make((int)0, (BEnumRange)((BEnumRange)presetText.getDefaultValue())), null);
    public static final Type TYPE;
    public static final int MAX_PRESET = 30;
    public static final int MIN_PRESET = 1;
    boolean enableDetect;
    protected BPlaybackTypeEnum mostRecentPlaybackType;
    static /* synthetic */ Class class$com$tridium$ndedicatedMicros$camera$BDedicatedCamera;

    public int getFastSpeed() {
        return this.getInt(fastSpeed);
    }

    public void setFastSpeed(int n) {
        this.setInt(fastSpeed, n, null);
    }

    public int getMediumSpeed() {
        return this.getInt(mediumSpeed);
    }

    public void setMediumSpeed(int n) {
        this.setInt(mediumSpeed, n, null);
    }

    public int getSlowSpeed() {
        return this.getInt(slowSpeed);
    }

    public void setSlowSpeed(int n) {
        this.setInt(slowSpeed, n, null);
    }

    public int getLoFrameRate() {
        return this.getInt(loFrameRate);
    }

    public void setLoFrameRate(int n) {
        this.setInt(loFrameRate, n, null);
    }

    public int getMedFrameRate() {
        return this.getInt(medFrameRate);
    }

    public void setMedFrameRate(int n) {
        this.setInt(medFrameRate, n, null);
    }

    public int getHiFrameRate() {
        return this.getInt(hiFrameRate);
    }

    public void setHiFrameRate(int n) {
        this.setInt(hiFrameRate, n, null);
    }

    public BEnumRange getPresetText() {
        return (BEnumRange)this.get(presetText);
    }

    public void setPresetText(BEnumRange bEnumRange) {
        this.set(presetText, (BValue)bEnumRange, null);
    }

    public BPointDeviceExt getEvents() {
        return (BPointDeviceExt)this.get(events);
    }

    public void setEvents(BPointDeviceExt bPointDeviceExt) {
        this.set(events, (BValue)bPointDeviceExt, null);
    }

    public BVideoEventRecall getEventRecaller() {
        return (BVideoEventRecall)this.get(eventRecaller);
    }

    public void setEventRecaller(BVideoEventRecall bVideoEventRecall) {
        this.set(eventRecaller, (BValue)bVideoEventRecall, null);
    }

    public void moveToPreset(BValue bValue) {
        this.invoke(moveToPreset, bValue, null);
    }

    public void storePreset(BValue bValue) {
        this.invoke(storePreset, bValue, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void doPing() throws Exception {
        try {
            DmHttpUtil.getCamfail(this.hcomm(), this.httpAddress(), (BUsernameAndPassword)this.getDedicatedDvr().getCredentials());
            this.pingOk();
        }
        catch (Exception exception) {
            this.pingFail(exception.getLocalizedMessage());
        }
    }

    public final void videoCameraStarted() throws Exception {
        BDeviceNetwork bDeviceNetwork = this.getNetwork();
        String string = (String)bDeviceNetwork.fw(501, (Object)"camera.limit", null, null, null);
        if (string != null) {
            this.configFatal(string);
        }
        this.dmCameraStarted();
        super.videoCameraStarted();
    }

    protected void dmCameraStarted() {
    }

    public BValue getActionParameterDefault(Action action) {
        if (action.equals((Object)moveToPreset) || action.equals((Object)storePreset)) {
            BEnumRange bEnumRange = this.getPresetText();
            int[] nArray = bEnumRange.getOrdinals();
            int n = nArray == null || nArray.length == 0 ? 0 : nArray[0];
            return BDynamicEnum.make((int)n, (BEnumRange)bEnumRange);
        }
        return super.getActionParameterDefault(action);
    }

    public Type getNetworkType() {
        return BDedicatedMicrosNetwork.TYPE;
    }

    public Action getMoveToPresetAction() {
        return moveToPreset;
    }

    public Action getStorePresetAction() {
        return storePreset;
    }

    public BAbsTime getCameraTime() {
        try {
            return DmHttpUtil.getCurrentAbsTime(this.hcomm(), this.httpAddress(), (BUsernameAndPassword)this.getDedicatedDvr().getCredentials());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void onMove(BVideoPanTiltEnum bVideoPanTiltEnum) {
        this.udpSend(new DedicatedPanTiltReq(this, bVideoPanTiltEnum));
    }

    public void onFocusControl(BVideoFocusEnum bVideoFocusEnum) {
        if (bVideoFocusEnum != BVideoFocusEnum.none) {
            this.udpSend(new DedicatedFocusControlReq(this, bVideoFocusEnum));
        }
        this.udpSend(new DedicatedFocusControlReq(this, BVideoFocusEnum.none));
    }

    public void onIrisControl(BVideoIrisEnum bVideoIrisEnum) {
        if (bVideoIrisEnum != BVideoIrisEnum.none) {
            this.udpSend(new DedicatedIrisControlReq(this, bVideoIrisEnum));
        }
        this.udpSend(new DedicatedIrisControlReq(this, BVideoIrisEnum.none));
    }

    public void onZoom(BVideoZoomEnum bVideoZoomEnum) {
        this.udpSend(new DedicatedZoomReq(this, bVideoZoomEnum));
    }

    public void doMoveToPreset(BValue bValue) {
        this.udpSend(new DedicatedMoveToPresetReq(this, (BDynamicEnum)bValue));
    }

    public void doStorePreset(BValue bValue) {
        BDynamicEnum bDynamicEnum = (BDynamicEnum)bValue;
        this.setPresetText(bDynamicEnum.getRange());
        this.udpSend(new DedicatedStorePresetReq(this, bDynamicEnum));
    }

    public void verifyEnableDetection() {
        if (this.isDown()) {
            return;
        }
        Runnable runnable = new Runnable(){

            public final void run() {
                try {
                    boolean bl;
                    while ((bl = BDedicatedCamera.this.isDetectionEnabledDesired()) != BDedicatedCamera.this.enableDetect) {
                        DmHttpUtil.enableDetection(BDedicatedCamera.this.hcomm(), BDedicatedCamera.this.httpAddress(), BDedicatedCamera.this.getCameraId(), bl, (BUsernameAndPassword)BDedicatedCamera.this.getDedicatedDvr().getCredentials());
                        BDedicatedCamera.this.enableDetect = bl;
                    }
                }
                catch (Exception exception) {}
            }
        };
        this.postAsync(runnable);
    }

    private final boolean isDetectionEnabledDesired() {
        BControlPoint[] bControlPointArray = this.getEvents().getPoints();
        int n = 0;
        while (n < bControlPointArray.length) {
            BDedicatedEventProxyExt bDedicatedEventProxyExt = (BDedicatedEventProxyExt)bControlPointArray[n].getProxyExt();
            if (bDedicatedEventProxyExt.isDectionEnabled()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (property.equals((Object)status)) {
            if (this.isDown()) {
                this.enableDetect = false;
            } else {
                this.verifyEnableDetection();
            }
        }
    }

    public void startRecordingAlarm(BAlarmRecord bAlarmRecord) {
        BString bString = (BString)bAlarmRecord.getAlarmData().get("msgText", (BObject)BString.make((String)"none"));
        String string = bString.toString();
        if (string.length() == 0) {
            string = "none";
        }
        if (string.length() > 31) {
            string = string.substring(0, 31);
        }
        try {
            string = this.replaceBlank(string);
            string = URLEncoder.encode(string, "UTF-8");
            DmHttpUtil.startRecording(this.hcomm(), this.httpAddress(), this.getCameraId(), string, (BUsernameAndPassword)this.getDedicatedDvr().getCredentials());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private final String replaceBlank(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(stringTokenizer.nextToken());
        while (stringTokenizer.hasMoreElements()) {
            stringBuffer.append("$20").append(stringTokenizer.nextToken());
        }
        return stringBuffer.toString();
    }

    public IVideoDecoder makeVideoDecoder(BPlaybackParams bPlaybackParams) {
        return new DedicatedMicrosVideoDecoder();
    }

    public void streamToDestination(BPlaybackParams bPlaybackParams, IVideoDestination iVideoDestination) {
        BPlaybackTypeEnum bPlaybackTypeEnum = bPlaybackParams.getPlaybackType();
        if (this.mostRecentPlaybackType == BPlaybackTypeEnum.live && (bPlaybackTypeEnum == BPlaybackTypeEnum.fastFwd || bPlaybackTypeEnum == BPlaybackTypeEnum.fastRew || bPlaybackTypeEnum == BPlaybackTypeEnum.slowFwd || bPlaybackTypeEnum == BPlaybackTypeEnum.slowRew)) {
            BPlaybackParams bPlaybackParams2 = (BPlaybackParams)bPlaybackParams.newCopy();
            bPlaybackParams2.setPlaybackType(BPlaybackTypeEnum.pause);
            try {
                DmHttpUtil.pause(this.hcomm(), this.httpAddress(), this.getCameraId(), bPlaybackParams2, (BUsernameAndPassword)this.getDedicatedDvr().getCredentials());
            }
            catch (Exception exception) {}
        }
        this.mostRecentPlaybackType = bPlaybackTypeEnum;
        DmVideoStreamUtil.streamToDestination(this, bPlaybackParams, iVideoDestination);
    }

    public void initPlaybackParams(BPlaybackParams bPlaybackParams, IVideoSession iVideoSession) {
        BFacets bFacets = bPlaybackParams.getVideoFacets();
        BISession bISession = BOrd.toSession((BObject)this);
        if (!bISession.getType().is(BTypeSpec.make((String)"fox:FoxSession").getResolvedType())) {
            return;
        }
        BFacets bFacets2 = BFacets.make((BFacets)bFacets, (BFacets)BFacets.make((String)"dmId", (BIDataValue)BInteger.make((int)(BFoxVideoSource.getFoxWorkbenchRemoteSessionId((BObject)this) << 16 | iVideoSession.getVideoSessionId()))));
        bPlaybackParams.setVideoFacets(bFacets2);
    }

    public int getCameraId() {
        return ((BDedicatedCameraDeviceId)this.getVideoDeviceId()).getCameraId();
    }

    public BIpAddress httpAddress() {
        BDedicatedDvr bDedicatedDvr = (BDedicatedDvr)this.getDvr();
        return bDedicatedDvr.httpAddress();
    }

    public BIpAddress udpAddress() {
        BDedicatedDvr bDedicatedDvr = (BDedicatedDvr)this.getDvr();
        return bDedicatedDvr.udpAddress();
    }

    public HttpComm hcomm() throws Exception {
        return ((BDedicatedMicrosNetwork)this.vnetwork()).hcomm();
    }

    public NComm ucomm() throws Exception {
        return ((BDedicatedMicrosNetwork)this.vnetwork()).ucomm();
    }

    public void udpSend(NMessage nMessage) {
        try {
            nMessage.setAddress((BAddress)this.udpAddress());
            nMessage.setResponseTimeOut(15000);
            this.ucomm().sendMessage(nMessage);
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
    }

    public BDedicatedDvr getDedicatedDvr() {
        BComplex bComplex = this.getParent();
        while (bComplex != null && !(bComplex instanceof BDedicatedDvr)) {
            bComplex = bComplex.getParent();
        }
        return (BDedicatedDvr)bComplex;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.enableDetect = false;
    }

    public BDedicatedCamera() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$ndedicatedMicros$camera$BDedicatedCamera;
        if (clazz == null) {
            clazz = class$com$tridium$ndedicatedMicros$camera$BDedicatedCamera = BDedicatedCamera.class("[Lcom.tridium.ndedicatedMicros.camera.BDedicatedCamera;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

