/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.portal.api;

import com.tridium.portal.api.PortalApiException;
import com.tridium.sys.NreLib;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import javax.baja.license.Feature;
import javax.baja.sys.BModule;
import javax.baja.sys.Sys;
import javax.baja.util.Version;
import javax.baja.xml.XContent;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;
import javax.baja.xml.XWriter;

public class PortalApi {
    private static Properties brandProps;
    public static final String DEFAULT_HOST = "https://axlicensing.tridium.com";
    public static final String DEFAULT_SCHEME = "http";
    public static final int DEFAULT_PORT = -1;
    public static final BModule module;
    public static final Version version;
    public static final String myHostId;

    private static final XElem request(String string, String string2) {
        XElem xElem = new XElem(string);
        xElem.addAttr("path", string2);
        return xElem;
    }

    public static String getPortalAddress() {
        String string = brandProps.getProperty("license.server", null);
        if (string == null) {
            string = System.getProperty("portal.host", DEFAULT_HOST);
        }
        return string;
    }

    public static XElem[] getLicenses(String string) throws Exception {
        return PortalApi.getLicenses(string, PortalApi.getLocalBrandId());
    }

    public static XElem[] getLicenses(String string, String string2) throws Exception {
        XElem xElem = PortalApi.request("req", "/ws/license/api31/getByHostId");
        XElem xElem2 = new XElem("params");
        xElem2.addAttr("hostId", string);
        if (string2 != null) {
            xElem2.addAttr("brand", string2);
        }
        xElem.addContent((XContent)xElem2);
        XElem xElem3 = PortalApi.post(xElem);
        XElem[] xElemArray = xElem3.elems("license");
        if (xElemArray == null || xElemArray.length == 0) {
            XElem xElem4 = xElem3.elem("error");
            if (xElem4 != null) {
                throw new PortalApiException(xElem3.elem("error").get("msg"));
            }
            return null;
        }
        return xElemArray;
    }

    public static XElem[] getLicenseUpdates(XElem[] xElemArray) throws Exception {
        XElem xElem = PortalApi.request("req", "/ws/license/api31/getUpdates");
        int n = 0;
        while (n < xElemArray.length) {
            xElem.addContent((XContent)xElemArray[n].copy());
            ++n;
        }
        return PortalApi.post(xElem).elems("license");
    }

    public static XElem[] getCertificateUpdates(XElem[] xElemArray) throws Exception {
        XElem xElem = PortalApi.request("req", "/ws/license/api31/getUpdates");
        int n = 0;
        while (n < xElemArray.length) {
            xElem.addContent((XContent)xElemArray[n].copy());
            ++n;
        }
        return PortalApi.post(xElem).elems("certificate");
    }

    public static XElem[] getCertificates(String string) throws Exception {
        return PortalApi.getCertificates(string, PortalApi.getLocalBrandId());
    }

    public static XElem[] getCertificates(String string, String string2) throws Exception {
        XElem xElem = PortalApi.request("req", "/ws/license/api31/getCertsByHostId");
        XElem xElem2 = new XElem("params");
        xElem2.addAttr("hostId", string);
        if (string2 != null) {
            xElem2.addAttr("brand", string2);
        }
        xElem.addContent((XContent)xElem2);
        XElem xElem3 = PortalApi.post(xElem);
        XElem[] xElemArray = xElem3.elems("certificate");
        if (xElemArray == null || xElemArray.length == 0) {
            XElem xElem4 = xElem3.elem("error");
            if (xElem4 != null) {
                throw new PortalApiException(xElem3.elem("error").get("msg"));
            }
            return null;
        }
        return xElemArray;
    }

    public static XElem getCertificate(String string) throws Exception {
        XElem xElem = PortalApi.request("req", "/ws/license/api31/getCertByVendor");
        XElem xElem2 = new XElem("params");
        xElem2.addAttr("vendor", string);
        xElem.addContent((XContent)xElem2);
        XElem xElem3 = PortalApi.post(xElem);
        XElem[] xElemArray = xElem3.elems("certificate");
        if (xElemArray == null || xElemArray.length == 0) {
            XElem xElem4 = xElem3.elem("error");
            if (xElem4 != null) {
                throw new PortalApiException(xElem3.elem("error").get("msg"));
            }
            return null;
        }
        return xElemArray[0];
    }

    public static XElem[] getCertificates(String[] stringArray) throws Exception {
        XElem[] xElemArray;
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        XElem xElem = PortalApi.request("req", "/ws/license/api31/getCertsForVendors");
        XElem xElem2 = new XElem("params");
        int n = 0;
        while (n < stringArray.length) {
            xElemArray = new XElem("vendor");
            xElemArray.setAttr("name", stringArray[n]);
            xElem2.addContent((XContent)xElemArray);
            ++n;
        }
        xElem.addContent((XContent)xElem2);
        XElem xElem3 = PortalApi.post(xElem);
        xElemArray = xElem3.elems("certificate");
        if (xElemArray == null || xElemArray.length == 0) {
            XElem xElem4 = xElem3.elem("error");
            if (xElem4 != null) {
                throw new PortalApiException(xElem3.elem("error").get("msg"));
            }
            return null;
        }
        return xElemArray;
    }

    public static boolean checkConnectivity() {
        try {
            XElem xElem = PortalApi.get("/ws/license/api31/ping");
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static XElem get(String string) throws Exception {
        String string2 = PortalApi.getPortalAddress();
        String string3 = DEFAULT_SCHEME;
        int n = string2.indexOf("://");
        if (n != -1) {
            string3 = string2.substring(0, n);
            string2 = string2.substring(n + 3);
        }
        int n2 = -1;
        int n3 = string2.indexOf(58);
        if (n3 != -1) {
            n2 = Integer.parseInt(string2.substring(n3 + 1));
            string2 = string2.substring(0, n3);
        }
        URL uRL = new URL(string3, string2, n2, string);
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        XElem xElem = XParser.make((InputStream)httpURLConnection.getInputStream()).parse(true);
        httpURLConnection.disconnect();
        return xElem;
    }

    public static XElem post(XElem xElem) throws Exception {
        String string = PortalApi.getPortalAddress();
        String string2 = DEFAULT_SCHEME;
        int n = string.indexOf("://");
        if (n != -1) {
            string2 = string.substring(0, n);
            string = string.substring(n + 3);
        }
        int n2 = -1;
        int n3 = string.indexOf(58);
        if (n3 != -1) {
            n2 = Integer.parseInt(string.substring(n3 + 1));
            string = string.substring(0, n3);
        }
        URL uRL = new URL(string2, string, n2, xElem.get("path"));
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setDoInput(true);
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setUseCaches(false);
        httpURLConnection.setRequestProperty("Content-Type", "text/xml");
        XWriter xWriter = new XWriter(httpURLConnection.getOutputStream());
        xElem.write(xWriter);
        xWriter.flush();
        XElem xElem2 = XParser.make((InputStream)httpURLConnection.getInputStream()).parse(true);
        httpURLConnection.disconnect();
        return xElem2;
    }

    public static String brandGet(String string, String string2) {
        return brandProps.getProperty(string, string2);
    }

    public static boolean brandGet(String string, boolean bl) {
        return brandProps.getProperty(string, bl ? "true" : "false").equals("true");
    }

    public static int brandGet(String string, int n) {
        return Integer.parseInt(brandProps.getProperty(string, Integer.toString(n)));
    }

    public static String[] getBrandKeys() {
        Enumeration<?> enumeration = brandProps.propertyNames();
        ArrayList<String> arrayList = new ArrayList<String>(16);
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            arrayList.add(string);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private static final void loadBrand() {
        File file = new File(Sys.getBajaHome(), "lib" + File.separator + "brand.properties");
        try {
            brandProps = new Properties();
            FileInputStream fileInputStream = new FileInputStream(file);
            brandProps.load(fileInputStream);
            fileInputStream.close();
        }
        catch (Exception exception) {}
    }

    private static final String getLocalBrandId() {
        Feature[] featureArray = Sys.getLicenseManager().getFeatures();
        int n = 0;
        while (n < featureArray.length) {
            if (featureArray[n].getVendorName().equals("tridium") && featureArray[n].getFeatureName().equals("brand")) {
                return featureArray[n].get("brandId");
            }
            ++n;
        }
        return brandProps.getProperty("brand.id", null);
    }

    public static void main(String[] stringArray) throws Exception {
        System.out.println("online: " + PortalApi.checkConnectivity());
        XElem[] xElemArray = PortalApi.getLicenses(stringArray[0]);
        int n = 0;
        while (n < xElemArray.length) {
            System.out.println("------ " + n + " ------");
            xElemArray[n].dump();
            ++n;
        }
    }

    static {
        PortalApi.loadBrand();
        module = Sys.loadModule((String)"portalApi");
        version = module.getVendorVersion();
        myHostId = NreLib.getHostId();
    }
}

