/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platwifi.ui.security;

import com.tridium.platform.BSystemPlatformService;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.pki.ClientPrivateKeyInfo;
import com.tridium.platform.pki.PemCertInfo;
import com.tridium.platform.ui.util.BBox;
import com.tridium.platform.ui.util.BLimitedFrozenEnumFE;
import com.tridium.platform.ui.util.LabelUtil;
import com.tridium.platwifi.BWifiPlatformService;
import com.tridium.platwifi.security.BWifiAuthenticationMethod;
import com.tridium.platwifi.security.BWifiEAPMethod;
import com.tridium.platwifi.security.BWifiEncryptionMethod;
import com.tridium.platwifi.security.BWifiWPASettings;
import com.tridium.workbench.fieldeditors.BBooleanFE;
import com.tridium.workbench.fieldeditors.BPasswordFE;
import javax.baja.file.BFileSpace;
import javax.baja.file.FilePath;
import javax.baja.naming.BOrd;
import javax.baja.naming.SyntaxException;
import javax.baja.nre.util.Array;
import javax.baja.security.BPassword;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.list.ListModel;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.util.LexiconText;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.view.BWbView;

public class BWifiWPAEditor
extends BWbView {
    public static final Action editorModified = BWifiWPAEditor.newAction((int)0, (BValue)new BWidgetEvent(), null);
    public static final Action setEnabledStates = BWifiWPAEditor.newAction((int)0, null);
    public static final Action handleEAPPasswordChanged = BWifiWPAEditor.newAction((int)4, null);
    public static final Action handleEAPIdentityChanged = BWifiWPAEditor.newAction((int)4, null);
    public static final Action handleEAPAnonymousIdentityChanged = BWifiWPAEditor.newAction((int)4, null);
    public static final Action handlePrivateKeyPasswordChanged = BWifiWPAEditor.newAction((int)4, null);
    public static final Action handlePrivateKeyPassword2Changed = BWifiWPAEditor.newAction((int)4, null);
    public static final Action handleEAPMethodChanged = BWifiWPAEditor.newAction((int)4, null);
    public static final Action handlePhase2Changed = BWifiWPAEditor.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$platwifi$ui$security$BWifiWPAEditor == null ? (class$com$tridium$platwifi$ui$security$BWifiWPAEditor = BWifiWPAEditor.class$("com.tridium.platwifi.ui.security.BWifiWPAEditor")) : class$com$tridium$platwifi$ui$security$BWifiWPAEditor));
    private BGridPane mainPane = null;
    private BBorderPane tunnelParametersPane = null;
    private BEdgePane wpaEdgePane = null;
    private BBooleanFE wpaSupportedFE = null;
    private BCheckBox wpaEnabledCheckBox = null;
    private BLimitedFrozenEnumFE wpaEncryptionFE = null;
    private BLimitedFrozenEnumFE authenticationFE = null;
    private BLimitedFrozenEnumFE wpaEAPTypeFE = null;
    private boolean eapPasswordDirty = false;
    private boolean eapIdentityDirty = false;
    private boolean eapAnonymousIdentityDirty = false;
    private boolean privateKeyPasswordDirty = false;
    private boolean privateKeyPassword2Dirty = false;
    private boolean eapIdentityMustBeSet = false;
    private boolean eapPasswordMustBeSet = false;
    private BFileSpace srcFileSpace = null;
    private BTextField wpaEAPIdentityFE = null;
    private BTextField wpaEAPAnonymousIdentityFE = null;
    private BPasswordFE wpaEAPPasswordFE = null;
    private FilePath srcClientCertsDirPath = null;
    private FilePath srcClientKeysDirPath = null;
    private FilePath srcCaCertsDirPath = null;
    private FilePath destClientCertsDirPath = null;
    private FilePath destClientKeysDirPath = null;
    private FilePath destCaCertsDirPath = null;
    private BTextField wpaCACertFE = null;
    private BTextField wpaCACertDirFE = null;
    private BTextField wpaClientCertFE = null;
    private BTextField wpaPrivateKeyFileFE = null;
    private BPasswordFE wpaPrivateKeyPasswordFE = null;
    private BListDropDown clientKeyDropDown = null;
    private BListDropDown caCertDropDown = null;
    private BListDropDown wpaTunnelPhase1FE = null;
    private BListDropDown wpaTunnelPhase2FE = null;
    private final TunnelModel peapPhase1Model = new TunnelModel(new String[]{"", "peaplabel=0", "peaplabel=1", "peapver=0", "peapver=1", "peapver=0 peaplabel=0", "peapver=1 peaplabel=0", "peapver=0 peaplabel=1", "peapver=1 peaplabel=1"});
    private final TunnelModel peapPhase2Model = new TunnelModel(new String[]{"", "auth=MSCHAPV2", "auth=TLS", "auth=MD5", "auth=GTC"});
    private final TunnelModel ttlsPhase1Model = new TunnelModel(new String[]{""});
    private final TunnelModel ttlsPhase2Model = new TunnelModel(new String[]{"", "autheap=MSCHAPV2", "autheap=TLS", "autheap=MD5", "autheap=GTC", "auth=MSCHAPV2", "auth=MSCHAP", "auth=CHAP", "auth=PAP"});
    private final TunnelModel fastPhase1Model = new TunnelModel(new String[]{"", "fast_provisioning=1", "fast_provisioning=3"});
    private final TunnelModel fastPhase2Model = new TunnelModel(new String[]{""});
    private BTextField wpaCACert2FE = null;
    private BTextField wpaCACertDir2FE = null;
    private BTextField wpaClientCert2FE = null;
    private BTextField wpaPrivateKeyFile2FE = null;
    private BPasswordFE wpaPrivateKeyPassword2FE = null;
    private BListDropDown clientKey2DropDown = null;
    private BListDropDown caCert2DropDown = null;
    static /* synthetic */ Class class$com$tridium$platwifi$ui$security$BWifiWPAEditor;
    static /* synthetic */ Class class$com$tridium$platform$pki$PemCertInfo;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$tridium$platform$pki$ClientPrivateKeyInfo;

    public void editorModified(BWidgetEvent bWidgetEvent) {
        this.invoke(editorModified, (BValue)bWidgetEvent, null);
    }

    public void setEnabledStates() {
        this.invoke(setEnabledStates, null, null);
    }

    public void handleEAPPasswordChanged() {
        this.invoke(handleEAPPasswordChanged, null, null);
    }

    public void handleEAPIdentityChanged() {
        this.invoke(handleEAPIdentityChanged, null, null);
    }

    public void handleEAPAnonymousIdentityChanged() {
        this.invoke(handleEAPAnonymousIdentityChanged, null, null);
    }

    public void handlePrivateKeyPasswordChanged() {
        this.invoke(handlePrivateKeyPasswordChanged, null, null);
    }

    public void handlePrivateKeyPassword2Changed() {
        this.invoke(handlePrivateKeyPassword2Changed, null, null);
    }

    public void handleEAPMethodChanged() {
        this.invoke(handleEAPMethodChanged, null, null);
    }

    public void handlePhase2Changed() {
        this.invoke(handlePhase2Changed, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BWifiWPAEditor(BDaemonSession bDaemonSession) {
        this();
        this.init((BFileSpace)bDaemonSession.getFileSpace(), ClientPrivateKeyInfo.CLIENT_KEYS_PATH, ClientPrivateKeyInfo.CLIENT_CERTS_PATH, PemCertInfo.CA_CERTS_PATH, bDaemonSession.getFileSpace().getAltPath(new FilePath("!")));
    }

    public BWifiWPAEditor(BWifiPlatformService bWifiPlatformService) {
        this();
        BSystemPlatformService bSystemPlatformService = (BSystemPlatformService)BOrd.make((String)"service:platform:SystemPlatformService").get((BObject)bWifiPlatformService);
        bSystemPlatformService.lease();
        String string = bSystemPlatformService.getBajaHome().replace('\\', '/');
        FilePath filePath = string.charAt(0) == '/' ? new FilePath(string) : new FilePath('/' + string);
        this.init((BFileSpace)BOrd.make((String)"file:").get((BObject)bWifiPlatformService), ClientPrivateKeyInfo.CLIENT_KEYS_PATH, ClientPrivateKeyInfo.CLIENT_CERTS_PATH, PemCertInfo.CA_CERTS_PATH, filePath);
    }

    public static FilePath makeLocalAbsolutePath(FilePath filePath, FilePath filePath2) {
        if (filePath2.isLocalAbsolute()) {
            return filePath2;
        }
        if (filePath2.isSysHomeAbsolute()) {
            FilePath filePath3 = filePath;
            for (int i = 0; i < filePath2.depth(); ++i) {
                filePath3 = filePath3.merge(filePath2.nameAt(i));
            }
            return filePath3;
        }
        throw new IllegalArgumentException();
    }

    public BWifiWPAEditor(BFileSpace bFileSpace, FilePath filePath, FilePath filePath2, FilePath filePath3, FilePath filePath4) {
        this();
        this.init(bFileSpace, filePath, filePath2, filePath3, filePath4);
    }

    protected void init(BFileSpace bFileSpace, FilePath filePath, FilePath filePath2, FilePath filePath3, FilePath filePath4) {
        this.srcFileSpace = bFileSpace;
        this.srcClientCertsDirPath = filePath2;
        this.srcClientKeysDirPath = filePath;
        this.srcCaCertsDirPath = filePath3;
        this.destClientKeysDirPath = BWifiWPAEditor.makeLocalAbsolutePath(filePath4, ClientPrivateKeyInfo.CLIENT_KEYS_PATH);
        this.destClientCertsDirPath = BWifiWPAEditor.makeLocalAbsolutePath(filePath4, ClientPrivateKeyInfo.CLIENT_CERTS_PATH);
        this.destCaCertsDirPath = BWifiWPAEditor.makeLocalAbsolutePath(filePath4, PemCertInfo.CA_CERTS_PATH);
    }

    public BWifiWPAEditor() {
    }

    public final void doLoadValue(BObject bObject, Context context) {
        boolean bl;
        BFacets bFacets;
        int n;
        if (context == null) {
            context = new BasicContext((Context)BFacets.make((String)"configureMode", (int)0));
        }
        if ((n = (bFacets = context.getFacets()).geti("configureMode", 0)) > 2 || n < 0) {
            n = 0;
        }
        boolean bl2 = bFacets.getb("showUse", true);
        boolean bl3 = bFacets.getb("useSetAndReadonly", false);
        boolean bl4 = bFacets.getb("showCACert", true);
        boolean bl5 = bFacets.getb("showCACertDir", true);
        BBoolean bBoolean = (BBoolean)context.getFacets().getFacet("showSupported");
        BBoolean bBoolean2 = (BBoolean)context.getFacets().getFacet("supportedReadonly");
        boolean bl6 = bBoolean != null ? bBoolean.getBoolean() : (bl = n == 1);
        boolean bl7 = bBoolean2 != null ? bBoolean2.getBoolean() : n != 1;
        this.eapIdentityMustBeSet = n != 0;
        this.eapPasswordMustBeSet = n != 0;
        this.mainPane = new BGridPane(2);
        this.mainPane.setColumnAlign(BHalign.fill);
        this.mainPane.setValign(BValign.top);
        this.mainPane.setHalign(BHalign.left);
        this.mainPane.setColumnGap(10.0);
        this.mainPane.setRowGap(6.0);
        this.mainPane.setColorRows(true);
        this.wpaSupportedFE = new BBooleanFE();
        this.wpaEnabledCheckBox = new BCheckBox(this.getLexicon().getText("WifiNetworkManager.WPACheckBox.value"));
        if (bl) {
            LabelUtil.addLabelWidgetPair((BGridPane)this.mainPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"WifiNetworkManager.WPASupported.label"), (BWidget)this.left((BWidget)this.wpaSupportedFE));
            this.linkTo(null, (BComponent)this.wpaSupportedFE, (Slot)BBooleanFE.pluginModified, (Slot)setEnabledStates);
            this.linkTo(null, (BComponent)this.wpaSupportedFE, (Slot)BBooleanFE.pluginModified, (Slot)setModified);
        }
        if (bl2) {
            LabelUtil.addLabelWidgetPair((BGridPane)this.mainPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"WifiNetworkManager.WPACheckBox.label"), (BWidget)this.wpaEnabledCheckBox);
            this.linkTo(null, (BComponent)this.wpaEnabledCheckBox, (Slot)BCheckBox.actionPerformed, (Slot)setEnabledStates);
            this.linkTo(null, (BComponent)this.wpaEnabledCheckBox, (Slot)BCheckBox.actionPerformed, (Slot)setModified);
        }
        this.authenticationFE = new BLimitedFrozenEnumFE();
        LabelUtil.addLabelWidgetPair((BGridPane)this.mainPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"WifiNetworkManager.Authentication.label"), (BWidget)this.left((BWidget)this.authenticationFE));
        this.linkTo(null, (BComponent)this.authenticationFE, (Slot)BLimitedFrozenEnumFE.pluginModified, (Slot)setModified);
        this.wpaEncryptionFE = new BLimitedFrozenEnumFE();
        LabelUtil.addLabelWidgetPair((BGridPane)this.mainPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"WifiNetworkManager.WPAEncryption.label"), (BWidget)this.left((BWidget)this.wpaEncryptionFE));
        this.linkTo(null, (BComponent)this.wpaEncryptionFE, (Slot)BLimitedFrozenEnumFE.pluginModified, (Slot)setModified);
        this.wpaEAPTypeFE = new BLimitedFrozenEnumFE();
        LabelUtil.addLabelWidgetPair((BGridPane)this.mainPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"WifiNetworkManager.WPAEAP.label"), (BWidget)this.left((BWidget)this.wpaEAPTypeFE));
        this.linkTo(null, (BComponent)this.wpaEAPTypeFE, (Slot)BLimitedFrozenEnumFE.pluginModified, (Slot)handleEAPMethodChanged);
        this.wpaEAPIdentityFE = new BTextField("", 32);
        LabelUtil.addLabelWidgetPair((BGridPane)this.mainPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"WifiNetworkManager.WPAEAPIdentity.label"), (BWidget)this.wpaEAPIdentityFE);
        this.linkTo(null, (BComponent)this.wpaEAPIdentityFE, (Slot)BTextField.textModified, (Slot)setModified);
        this.linkTo(null, (BComponent)this.wpaEAPIdentityFE, (Slot)BTextField.textModified, (Slot)handleEAPIdentityChanged);
        this.wpaEAPAnonymousIdentityFE = new BTextField("", 32);
        LabelUtil.addLabelWidgetPair((BGridPane)this.mainPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"WifiNetworkManager.WPAEAPAnonymousIdentity.label"), (BWidget)this.wpaEAPAnonymousIdentityFE);
        this.linkTo(null, (BComponent)this.wpaEAPAnonymousIdentityFE, (Slot)BTextField.textModified, (Slot)setModified);
        this.linkTo(null, (BComponent)this.wpaEAPAnonymousIdentityFE, (Slot)BTextField.textModified, (Slot)handleEAPAnonymousIdentityChanged);
        this.wpaEAPPasswordFE = new BPasswordFE();
        LabelUtil.addLabelWidgetPair((BGridPane)this.mainPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"WifiNetworkManager.WPAEAPPassword.label"), (BWidget)this.wpaEAPPasswordFE);
        this.linkTo(null, (BComponent)this.wpaEAPPasswordFE, (Slot)BPasswordFE.pluginModified, (Slot)setModified);
        this.linkTo(null, (BComponent)this.wpaEAPPasswordFE, (Slot)BPasswordFE.pluginModified, (Slot)handleEAPPasswordChanged);
        PemCertInfo[] pemCertInfoArray = null;
        ClientPrivateKeyInfo[] clientPrivateKeyInfoArray = null;
        if (this.srcFileSpace != null && this.srcCaCertsDirPath != null) {
            try {
                pemCertInfoArray = PemCertInfo.list((BFileSpace)this.srcFileSpace, (FilePath)this.srcCaCertsDirPath);
            }
            catch (Exception exception) {
                pemCertInfoArray = null;
            }
        }
        if (this.srcFileSpace != null && this.srcClientCertsDirPath != null && this.srcClientKeysDirPath != null) {
            try {
                clientPrivateKeyInfoArray = ClientPrivateKeyInfo.list((BFileSpace)this.srcFileSpace, (FilePath)this.srcClientKeysDirPath, (FilePath)this.srcClientCertsDirPath);
            }
            catch (Exception exception) {
                clientPrivateKeyInfoArray = null;
            }
        }
        if (pemCertInfoArray != null) {
            this.caCertDropDown = new BListDropDown();
            LabelUtil.addLabelWidgetPair((BGridPane)this.mainPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"WifiNetworkManager.WPACACertDropDown.label"), (BWidget)this.caCertDropDown);
            this.caCertDropDown.getList().setModel((ListModel)new CACertModel(pemCertInfoArray));
            this.linkTo(null, (BComponent)this.caCertDropDown, (Slot)BListDropDown.listActionPerformed, (Slot)setModified);
        }
        if (this.caCertDropDown == null) {
            if (bl4) {
                this.wpaCACertFE = new BTextField("", 32);
                LabelUtil.addLabelWidgetPair((BGridPane)this.mainPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"WifiNetworkManager.WPACAcert.label"), (BWidget)this.wpaCACertFE);
                this.linkTo(null, (BComponent)this.wpaCACertFE, (Slot)BTextField.textModified, (Slot)setModified);
            }
            if (bl5) {
                this.wpaCACertDirFE = new BTextField("", 32);
                LabelUtil.addLabelWidgetPair((BGridPane)this.mainPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"WifiNetworkManager.WPACAcertDir.label"), (BWidget)this.wpaCACertDirFE);
                this.linkTo(null, (BComponent)this.wpaCACertDirFE, (Slot)BTextField.textModified, (Slot)setModified);
            }
        }
        if (clientPrivateKeyInfoArray != null) {
            this.clientKeyDropDown = new BListDropDown();
            LabelUtil.addLabelWidgetPair((BGridPane)this.mainPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"WifiNetworkManager.WPAClientKeyDropDown.label"), (BWidget)this.clientKeyDropDown);
            this.clientKeyDropDown.getList().setModel((ListModel)new ClientKeyModel(clientPrivateKeyInfoArray));
            this.linkTo(null, (BComponent)this.clientKeyDropDown, (Slot)BListDropDown.listActionPerformed, (Slot)setModified);
        }
        if (this.clientKeyDropDown == null) {
            this.wpaClientCertFE = new BTextField("", 32);
            LabelUtil.addLabelWidgetPair((BGridPane)this.mainPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"WifiNetworkManager.WPAClientCert.label"), (BWidget)this.wpaClientCertFE);
            this.linkTo(null, (BComponent)this.wpaClientCertFE, (Slot)BTextField.textModified, (Slot)setModified);
            this.wpaPrivateKeyFileFE = new BTextField("", 32);
            LabelUtil.addLabelWidgetPair((BGridPane)this.mainPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"WifiNetworkManager.WPAPrivateKeyFile.label"), (BWidget)this.wpaPrivateKeyFileFE);
            this.linkTo(null, (BComponent)this.wpaPrivateKeyFileFE, (Slot)BTextField.textModified, (Slot)setModified);
        }
        this.wpaPrivateKeyPasswordFE = new BPasswordFE();
        LabelUtil.addLabelWidgetPair((BGridPane)this.mainPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"WifiNetworkManager.WPAPrivateKeyPassword.label"), (BWidget)this.wpaPrivateKeyPasswordFE);
        this.linkTo(null, (BComponent)this.wpaPrivateKeyPasswordFE, (Slot)BPasswordFE.pluginModified, (Slot)setModified);
        this.linkTo(null, (BComponent)this.wpaPrivateKeyPasswordFE, (Slot)BPasswordFE.pluginModified, (Slot)handlePrivateKeyPasswordChanged);
        this.wpaSupportedFE.setEnabled(false);
        this.wpaSupportedFE.setReadonly(true);
        this.wpaEnabledCheckBox.setEnabled(false);
        this.wpaEncryptionFE.setEnabled(false);
        this.wpaEncryptionFE.setReadonly(true);
        this.authenticationFE.setEnabled(false);
        this.authenticationFE.setReadonly(true);
        this.wpaEAPTypeFE.setEnabled(false);
        this.wpaEAPTypeFE.setReadonly(true);
        this.wpaEAPIdentityFE.setEnabled(false);
        this.wpaEAPIdentityFE.setEditable(false);
        this.wpaEAPAnonymousIdentityFE.setEnabled(false);
        this.wpaEAPAnonymousIdentityFE.setEditable(false);
        this.wpaEAPPasswordFE.setEnabled(false);
        this.wpaEAPPasswordFE.setReadonly(true);
        if (this.wpaCACertFE != null) {
            this.wpaCACertFE.setEnabled(false);
            this.wpaCACertFE.setEditable(false);
        }
        if (this.wpaCACertDirFE != null) {
            this.wpaCACertDirFE.setEnabled(false);
            this.wpaCACertDirFE.setEditable(false);
        }
        if (this.wpaClientCertFE != null) {
            this.wpaClientCertFE.setEnabled(false);
            this.wpaClientCertFE.setEditable(false);
        }
        if (this.wpaPrivateKeyFileFE != null) {
            this.wpaPrivateKeyFileFE.setEnabled(false);
            this.wpaPrivateKeyFileFE.setEditable(false);
        }
        if (this.clientKeyDropDown != null) {
            this.clientKeyDropDown.setEnabled(false);
        }
        if (this.caCertDropDown != null) {
            this.caCertDropDown.setEnabled(false);
        }
        this.wpaPrivateKeyPasswordFE.setEnabled(false);
        this.wpaPrivateKeyPasswordFE.setReadonly(true);
        BWifiWPASettings bWifiWPASettings = (BWifiWPASettings)bObject;
        this.wpaSupportedFE.setEnabled(!bl7);
        this.wpaSupportedFE.setReadonly(bl7);
        this.wpaSupportedFE.loadValue((BObject)BBoolean.make((boolean)bWifiWPASettings.getSupported()), context);
        if (bl3) {
            this.wpaEnabledCheckBox.setSelected(true);
            this.wpaEnabledCheckBox.setEnabled(false);
        } else {
            this.wpaEnabledCheckBox.setSelected(bWifiWPASettings.getUse());
        }
        this.authenticationFE.loadValue((BObject)bWifiWPASettings.getAuthentication(), (Context)new BasicContext(context, BWifiWPASettings.authentication.getFacets()));
        this.wpaEncryptionFE.loadValue((BObject)bWifiWPASettings.getEncryption(), (Context)new BasicContext(context, BWifiWPASettings.encryption.getFacets()));
        this.wpaEAPTypeFE.loadValue((BObject)bWifiWPASettings.getEap(), (Context)new BasicContext(context, BWifiWPASettings.eap.getFacets()));
        this.wpaEAPIdentityFE.setText(bWifiWPASettings.getEapIdentity());
        this.wpaEAPAnonymousIdentityFE.setText(bWifiWPASettings.getEapAnonymousIdentity());
        this.wpaEAPPasswordFE.loadValue((BObject)bWifiWPASettings.getEapPassword(), context);
        if (this.wpaCACertFE != null) {
            this.wpaCACertFE.setText(bWifiWPASettings.getCertAuthCertificate());
        }
        if (this.wpaCACertDirFE != null) {
            this.wpaCACertDirFE.setText(bWifiWPASettings.getCertAuthDirectoryPath());
        }
        if (this.wpaClientCertFE != null) {
            this.wpaClientCertFE.setText(bWifiWPASettings.getClientCertificate());
        }
        if (this.wpaPrivateKeyFileFE != null) {
            this.wpaPrivateKeyFileFE.setText(bWifiWPASettings.getPrivateKeyFile());
        }
        if (this.clientKeyDropDown != null) {
            ((ClientKeyModel)this.clientKeyDropDown.getList().getModel()).select(bWifiWPASettings.getPrivateKeyFile());
        }
        if (this.caCertDropDown != null) {
            ((CACertModel)this.caCertDropDown.getList().getModel()).select(bWifiWPASettings.getCertAuthCertificate());
        }
        this.wpaPrivateKeyPasswordFE.loadValue((BObject)bWifiWPASettings.getPrivateKeyPassword(), context);
        BGridPane bGridPane = new BGridPane(2);
        bGridPane.setColumnAlign(BHalign.fill);
        bGridPane.setValign(BValign.top);
        bGridPane.setHalign(BHalign.left);
        bGridPane.setColumnGap(10.0);
        bGridPane.setRowGap(6.0);
        bGridPane.setColorRows(true);
        this.wpaTunnelPhase1FE = new BListDropDown();
        LabelUtil.addLabelWidgetPair((BGridPane)bGridPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"WifiNetworkManager.WPATunnel.phase1.label"), (BWidget)this.left((BWidget)this.wpaTunnelPhase1FE));
        this.wpaTunnelPhase1FE.getList().getSelection().deselectAll();
        this.wpaTunnelPhase1FE.getList().removeAllItems();
        this.linkTo(null, (BComponent)this.wpaTunnelPhase1FE, (Slot)BListDropDown.actionPerformed, (Slot)setModified);
        this.linkTo(null, (BComponent)this.wpaTunnelPhase1FE, (Slot)BListDropDown.listActionPerformed, (Slot)setModified);
        this.wpaTunnelPhase2FE = new BListDropDown();
        LabelUtil.addLabelWidgetPair((BGridPane)bGridPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"WifiNetworkManager.WPATunnel.phase2.label"), (BWidget)this.left((BWidget)this.wpaTunnelPhase2FE));
        this.wpaTunnelPhase2FE.getList().getSelection().deselectAll();
        this.wpaTunnelPhase2FE.getList().removeAllItems();
        this.linkTo(null, (BComponent)this.wpaTunnelPhase2FE, (Slot)BListDropDown.actionPerformed, (Slot)setModified);
        this.linkTo(null, (BComponent)this.wpaTunnelPhase2FE, (Slot)BListDropDown.listActionPerformed, (Slot)setModified);
        this.linkTo(null, (BComponent)this.wpaTunnelPhase2FE, (Slot)BListDropDown.listActionPerformed, (Slot)handlePhase2Changed);
        if (pemCertInfoArray != null) {
            this.caCert2DropDown = new BListDropDown();
            LabelUtil.addLabelWidgetPair((BGridPane)bGridPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"WifiNetworkManager.WPACACertDropDown2.label"), (BWidget)this.caCert2DropDown);
            this.caCert2DropDown.getList().setModel((ListModel)new CACertModel(pemCertInfoArray));
            this.linkTo(null, (BComponent)this.caCert2DropDown, (Slot)BListDropDown.listActionPerformed, (Slot)setModified);
        }
        if (this.caCert2DropDown == null) {
            if (bl4) {
                this.wpaCACert2FE = new BTextField("", 32);
                LabelUtil.addLabelWidgetPair((BGridPane)bGridPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"WifiNetworkManager.WPACAcert2.label"), (BWidget)this.wpaCACert2FE);
                this.linkTo(null, (BComponent)this.wpaCACert2FE, (Slot)BTextField.textModified, (Slot)setModified);
            }
            if (bl5) {
                this.wpaCACertDir2FE = new BTextField("", 32);
                LabelUtil.addLabelWidgetPair((BGridPane)bGridPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"WifiNetworkManager.WPACAcertDir2.label"), (BWidget)this.wpaCACertDir2FE);
                this.linkTo(null, (BComponent)this.wpaCACertDir2FE, (Slot)BTextField.textModified, (Slot)setModified);
            }
        }
        if (clientPrivateKeyInfoArray != null) {
            this.clientKey2DropDown = new BListDropDown();
            LabelUtil.addLabelWidgetPair((BGridPane)bGridPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"WifiNetworkManager.WPAClientKeyDropDown2.label"), (BWidget)this.clientKey2DropDown);
            this.clientKey2DropDown.getList().setModel((ListModel)new ClientKeyModel(clientPrivateKeyInfoArray));
            this.linkTo(null, (BComponent)this.clientKey2DropDown, (Slot)BListDropDown.listActionPerformed, (Slot)setModified);
        }
        if (this.clientKey2DropDown == null) {
            this.wpaClientCert2FE = new BTextField("", 32);
            LabelUtil.addLabelWidgetPair((BGridPane)bGridPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"WifiNetworkManager.WPAClientCert2.label"), (BWidget)this.wpaClientCert2FE);
            this.linkTo(null, (BComponent)this.wpaClientCert2FE, (Slot)BTextField.textModified, (Slot)setModified);
            this.wpaPrivateKeyFile2FE = new BTextField("", 32);
            LabelUtil.addLabelWidgetPair((BGridPane)bGridPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"WifiNetworkManager.WPAPrivateKeyFile2.label"), (BWidget)this.wpaPrivateKeyFile2FE);
            this.linkTo(null, (BComponent)this.wpaPrivateKeyFile2FE, (Slot)BTextField.textModified, (Slot)setModified);
        }
        this.wpaPrivateKeyPassword2FE = new BPasswordFE();
        LabelUtil.addLabelWidgetPair((BGridPane)bGridPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"WifiNetworkManager.WPAPrivateKeyPassword2.label"), (BWidget)this.wpaPrivateKeyPassword2FE);
        this.linkTo(null, (BComponent)this.wpaPrivateKeyPassword2FE, (Slot)BPasswordFE.pluginModified, (Slot)setModified);
        this.linkTo(null, (BComponent)this.wpaPrivateKeyPassword2FE, (Slot)BPasswordFE.pluginModified, (Slot)handlePrivateKeyPassword2Changed);
        this.wpaTunnelPhase1FE.setEnabled(false);
        this.wpaTunnelPhase2FE.setEnabled(false);
        if (this.wpaCACert2FE != null) {
            this.wpaCACert2FE.setEnabled(false);
            this.wpaCACert2FE.setEditable(false);
        }
        if (this.wpaCACertDir2FE != null) {
            this.wpaCACertDir2FE.setEnabled(false);
            this.wpaCACertDir2FE.setEditable(false);
        }
        if (this.wpaClientCert2FE != null) {
            this.wpaClientCert2FE.setEnabled(false);
            this.wpaClientCert2FE.setEditable(false);
        }
        if (this.wpaPrivateKeyFile2FE != null) {
            this.wpaPrivateKeyFile2FE.setEnabled(false);
            this.wpaPrivateKeyFile2FE.setEditable(false);
        }
        if (this.clientKey2DropDown != null) {
            this.clientKey2DropDown.setEnabled(false);
        }
        if (this.caCert2DropDown != null) {
            this.caCert2DropDown.setEnabled(false);
        }
        this.wpaPrivateKeyPassword2FE.setEnabled(false);
        this.wpaPrivateKeyPassword2FE.setReadonly(true);
        if (this.wpaCACert2FE != null) {
            this.wpaCACert2FE.setText(bWifiWPASettings.getCertAuthCertificate2());
        }
        if (this.wpaCACertDir2FE != null) {
            this.wpaCACertDir2FE.setText(bWifiWPASettings.getCertAuthDirectoryPath2());
        }
        if (this.wpaClientCert2FE != null) {
            this.wpaClientCert2FE.setText(bWifiWPASettings.getClientCertificate2());
        }
        if (this.wpaPrivateKeyFile2FE != null) {
            this.wpaPrivateKeyFile2FE.setText(bWifiWPASettings.getPrivateKeyFile2());
        }
        if (this.clientKey2DropDown != null) {
            ((ClientKeyModel)this.clientKey2DropDown.getList().getModel()).select(bWifiWPASettings.getPrivateKeyFile2());
        }
        if (this.caCert2DropDown != null) {
            ((CACertModel)this.caCert2DropDown.getList().getModel()).select(bWifiWPASettings.getCertAuthCertificate2());
        }
        this.wpaPrivateKeyPassword2FE.loadValue((BObject)bWifiWPASettings.getPrivateKeyPassword2(), context);
        this.eapPasswordDirty = false;
        this.eapIdentityDirty = false;
        this.eapAnonymousIdentityDirty = false;
        this.privateKeyPasswordDirty = false;
        this.privateKeyPassword2Dirty = false;
        BBorderPane bBorderPane = new BBorderPane((BWidget)bGridPane);
        bBorderPane.setBorder(BBorder.inset);
        bBorderPane.setLabel((BWidget)LabelUtil.makeLabel((LexiconText)LexiconText.make((String)"platWifi", (String)"WifiNetworkManager.WPATunnel.border.label"), (boolean)true));
        this.tunnelParametersPane = new BBorderPane((BWidget)bBorderPane, 10.0, 0.0, 0.0, 0.0);
        this.wpaEdgePane = new BEdgePane(null, (BWidget)this.tunnelParametersPane, null, null, (BWidget)this.mainPane);
        this.setContent((BWidget)this.wpaEdgePane);
        this.doSetReadonly(this.isReadonly());
        this.doSetEnabledStates();
        this.wpaTunnelPhase1FE.setSelectedItem((Object)bWifiWPASettings.getTunnelPhase1());
        this.wpaTunnelPhase2FE.setSelectedItem((Object)bWifiWPASettings.getTunnelPhase2());
        this.doHandlePhase2Changed();
    }

    public final BObject doSaveValue(BObject bObject, Context context) throws Exception {
        BWifiWPASettings bWifiWPASettings = (BWifiWPASettings)bObject;
        bWifiWPASettings.setSupported(((BBoolean)this.wpaSupportedFE.saveValue(context)).getBoolean());
        if (!bWifiWPASettings.getSupported()) {
            return bWifiWPASettings;
        }
        bWifiWPASettings.setUse(this.wpaEnabledCheckBox.isSelected());
        bWifiWPASettings.setAuthentication((BWifiAuthenticationMethod)this.authenticationFE.saveValue(context));
        bWifiWPASettings.setEap((BWifiEAPMethod)this.wpaEAPTypeFE.saveValue(context));
        bWifiWPASettings.setEncryption((BWifiEncryptionMethod)this.wpaEncryptionFE.saveValue(context));
        String string = null;
        if (this.eapIdentityDirty) {
            string = this.wpaEAPIdentityFE.getText().trim();
            if (string == null || string.length() == 0) {
                this.saveError("WifiNetworkConfigurationEditor.cannotSave.invalidIdentity");
            }
            bWifiWPASettings.setEapIdentity(string);
        } else if (bWifiWPASettings.getUse() && this.eapIdentityMustBeSet) {
            this.saveError("WifiNetworkConfigurationEditor.cannotSave.eapIdentityMustBeSet");
        }
        if (this.eapAnonymousIdentityDirty) {
            string = this.wpaEAPAnonymousIdentityFE.getText().trim();
            if (string == null || string.length() == 0) {
                bWifiWPASettings.setEapAnonymousIdentity("");
            } else {
                bWifiWPASettings.setEapAnonymousIdentity(string);
            }
        }
        boolean bl = false;
        boolean bl2 = false;
        if (this.wpaCACertFE != null) {
            string = this.wpaCACertFE.getText().trim();
            if (string == null || string.length() == 0) {
                bWifiWPASettings.setCertAuthCertificate("");
            } else {
                try {
                    if (new FilePath(string).isAbsolute()) {
                        bl = true;
                        bWifiWPASettings.setCertAuthCertificate(string);
                    } else {
                        this.saveError("WifiNetworkConfigurationEditor.cannotSave.invalidCACertFilePath");
                    }
                }
                catch (SyntaxException syntaxException) {
                    this.saveError("WifiNetworkConfigurationEditor.cannotSave.invalidCACertFilePath");
                }
            }
        }
        if (this.wpaCACertDirFE != null) {
            string = this.wpaCACertDirFE.getText().trim();
            if (string == null || string.length() == 0) {
                bWifiWPASettings.setCertAuthDirectoryPath("");
            } else {
                try {
                    if (new FilePath(string).isAbsolute()) {
                        bl2 = true;
                        bWifiWPASettings.setCertAuthDirectoryPath(string);
                    } else {
                        this.saveError("WifiNetworkConfigurationEditor.cannotSave.invalidCACertDirectoryFilePath");
                    }
                }
                catch (SyntaxException syntaxException) {
                    this.saveError("WifiNetworkConfigurationEditor.cannotSave.invalidCACertDirectoryFilePath");
                }
            }
        }
        if (this.caCertDropDown != null) {
            bWifiWPASettings.setCertAuthCertificate(((CACertModel)this.caCertDropDown.getList().getModel()).getSelectedCertPath(this.destCaCertsDirPath));
            bl = true;
        }
        if (bl && bl2) {
            this.saveError("WifiNetworkConfigurationEditor.cannotSave.invalidCACertConfigurationBoth");
        }
        if (this.wpaClientCertFE != null) {
            string = this.wpaClientCertFE.getText().trim();
            if (string == null || string.length() == 0) {
                bWifiWPASettings.setClientCertificate("");
            } else {
                try {
                    if (new FilePath(string).isAbsolute()) {
                        bWifiWPASettings.setClientCertificate(string);
                    } else {
                        this.saveError("WifiNetworkConfigurationEditor.cannotSave.invalidClientCertificate");
                    }
                }
                catch (SyntaxException syntaxException) {
                    this.saveError("WifiNetworkConfigurationEditor.cannotSave.invalidClientCertificate");
                }
            }
        }
        if (this.wpaPrivateKeyFileFE != null) {
            string = this.wpaPrivateKeyFileFE.getText().trim();
            if (string == null || string.length() == 0) {
                bWifiWPASettings.setPrivateKeyFile("");
            } else {
                try {
                    if (new FilePath(string).isAbsolute()) {
                        bWifiWPASettings.setPrivateKeyFile(string);
                    } else {
                        this.saveError("WifiNetworkConfigurationEditor.cannotSave.invalidKeyFile");
                    }
                }
                catch (SyntaxException syntaxException) {
                    this.saveError("WifiNetworkConfigurationEditor.cannotSave.invalidKeyFile");
                }
            }
        }
        if (this.clientKeyDropDown != null) {
            bWifiWPASettings.setPrivateKeyFile(((ClientKeyModel)this.clientKeyDropDown.getList().getModel()).getSelectedKeyPath(this.destClientKeysDirPath));
            bWifiWPASettings.setClientCertificate(((ClientKeyModel)this.clientKeyDropDown.getList().getModel()).getSelectedCertPath(this.destClientCertsDirPath));
        }
        if (this.eapPasswordDirty) {
            bWifiWPASettings.setEapPassword((BPassword)this.wpaEAPPasswordFE.saveValue(context));
        } else if (!bWifiWPASettings.getUse() || !this.eapPasswordMustBeSet || bWifiWPASettings.getEap().getOrdinal() != 1) {
            // empty if block
        }
        if (this.privateKeyPasswordDirty) {
            bWifiWPASettings.setPrivateKeyPassword((BPassword)this.wpaPrivateKeyPasswordFE.saveValue(context));
        }
        if (bWifiWPASettings.getEap() == BWifiEAPMethod.peap || bWifiWPASettings.getEap() == BWifiEAPMethod.ttls || bWifiWPASettings.getEap() == BWifiEAPMethod.fast) {
            String string2 = (String)this.wpaTunnelPhase1FE.getSelectedItem();
            bWifiWPASettings.setTunnelPhase1(string2 != null ? string2 : "");
            string2 = (String)this.wpaTunnelPhase2FE.getSelectedItem();
            bWifiWPASettings.setTunnelPhase2(string2 != null ? string2 : "");
        } else {
            bWifiWPASettings.setTunnelPhase1("");
            bWifiWPASettings.setTunnelPhase2("");
        }
        boolean bl3 = false;
        boolean bl4 = false;
        if (this.wpaCACert2FE != null) {
            string = this.wpaCACert2FE.getText().trim();
            if (string == null || string.length() == 0) {
                bWifiWPASettings.setCertAuthCertificate2("");
            } else {
                try {
                    if (new FilePath(string).isAbsolute()) {
                        bl3 = true;
                        bWifiWPASettings.setCertAuthCertificate2(string);
                    } else {
                        this.saveError("WifiNetworkConfigurationEditor.cannotSave.invalidCACertFilePath");
                    }
                }
                catch (SyntaxException syntaxException) {
                    this.saveError("WifiNetworkConfigurationEditor.cannotSave.invalidCACertFilePath");
                }
            }
        }
        if (this.wpaCACertDir2FE != null) {
            string = this.wpaCACertDir2FE.getText().trim();
            if (string == null || string.length() == 0) {
                bWifiWPASettings.setCertAuthDirectoryPath2("");
            } else {
                try {
                    if (new FilePath(string).isAbsolute()) {
                        bl4 = true;
                        bWifiWPASettings.setCertAuthDirectoryPath2(string);
                    } else {
                        this.saveError("WifiNetworkConfigurationEditor.cannotSave.invalidCACertDirectoryFilePath");
                    }
                }
                catch (SyntaxException syntaxException) {
                    this.saveError("WifiNetworkConfigurationEditor.cannotSave.invalidCACertDirectoryFilePath");
                }
            }
        }
        if (this.caCert2DropDown != null) {
            bWifiWPASettings.setCertAuthCertificate2(((CACertModel)this.caCert2DropDown.getList().getModel()).getSelectedCertPath(this.destCaCertsDirPath));
            bl3 = true;
        }
        if (bl3 && bl4) {
            this.saveError("WifiNetworkConfigurationEditor.cannotSave.invalidCACertConfigurationBoth");
        }
        if (this.wpaClientCert2FE != null) {
            string = this.wpaClientCert2FE.getText().trim();
            if (string == null || string.length() == 0) {
                bWifiWPASettings.setClientCertificate2("");
            } else {
                try {
                    if (new FilePath(string).isAbsolute()) {
                        bWifiWPASettings.setClientCertificate2(string);
                    } else {
                        this.saveError("WifiNetworkConfigurationEditor.cannotSave.invalidClientCertificate");
                    }
                }
                catch (SyntaxException syntaxException) {
                    this.saveError("WifiNetworkConfigurationEditor.cannotSave.invalidClientCertificate");
                }
            }
        }
        if (this.wpaPrivateKeyFile2FE != null) {
            string = this.wpaPrivateKeyFile2FE.getText().trim();
            if (string == null || string.length() == 0) {
                bWifiWPASettings.setPrivateKeyFile2("");
            } else {
                try {
                    if (new FilePath(string).isAbsolute()) {
                        bWifiWPASettings.setPrivateKeyFile2(string);
                    } else {
                        this.saveError("WifiNetworkConfigurationEditor.cannotSave.invalidKeyFile");
                    }
                }
                catch (SyntaxException syntaxException) {
                    this.saveError("WifiNetworkConfigurationEditor.cannotSave.invalidKeyFile");
                }
            }
        }
        if (this.clientKey2DropDown != null) {
            bWifiWPASettings.setPrivateKeyFile2(((ClientKeyModel)this.clientKey2DropDown.getList().getModel()).getSelectedKeyPath(this.destClientKeysDirPath));
            bWifiWPASettings.setClientCertificate2(((ClientKeyModel)this.clientKey2DropDown.getList().getModel()).getSelectedCertPath(this.destClientCertsDirPath));
        }
        if (this.privateKeyPassword2Dirty) {
            bWifiWPASettings.setPrivateKeyPassword2((BPassword)this.wpaPrivateKeyPassword2FE.saveValue(context));
        }
        this.eapPasswordDirty = false;
        this.eapIdentityDirty = false;
        this.eapAnonymousIdentityDirty = false;
        this.privateKeyPasswordDirty = false;
        this.privateKeyPassword2Dirty = false;
        return bWifiWPASettings;
    }

    public void doHandleEAPPasswordChanged() {
        this.eapPasswordDirty = true;
        this.setModified();
    }

    public boolean isEAPPasswordDirty() {
        return this.eapPasswordDirty;
    }

    public void doHandleEAPIdentityChanged() {
        this.eapIdentityDirty = true;
        this.setModified();
    }

    public boolean isEAPIdentityDirty() {
        return this.eapIdentityDirty;
    }

    public void doHandleEAPAnonymousIdentityChanged() {
        this.eapAnonymousIdentityDirty = true;
        this.setModified();
    }

    public boolean isEAPAnonymousIdentityDirty() {
        return this.eapAnonymousIdentityDirty;
    }

    public void doHandlePrivateKeyPasswordChanged() {
        this.privateKeyPasswordDirty = true;
        this.setModified();
    }

    public void doHandlePrivateKeyPassword2Changed() {
        this.privateKeyPassword2Dirty = true;
        this.setModified();
    }

    public boolean isPrivateKeyPasswordDirty() {
        return this.privateKeyPasswordDirty;
    }

    public boolean isPrivateKeyPassword2Dirty() {
        return this.privateKeyPassword2Dirty;
    }

    private void saveError(String string) throws CannotSaveException {
        throw new CannotSaveException(this.getLexicon().getText(string));
    }

    private BWidget left(BWidget bWidget) {
        BGridPane bGridPane = new BGridPane(1);
        bGridPane.setHalign(BHalign.left);
        bGridPane.setColumnAlign(BHalign.left);
        bGridPane.add(null, (BValue)bWidget);
        return bGridPane;
    }

    public final void doSetEnabledStates() {
        boolean bl = this.isReadonly();
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            bl2 = ((BBoolean)this.wpaSupportedFE.saveValue()).getBoolean();
        }
        catch (Exception exception) {
            bl2 = false;
        }
        this.wpaEnabledCheckBox.setEnabled(!bl && bl2);
        if (this.wpaEnabledCheckBox.isSelected() && !bl2) {
            this.wpaEnabledCheckBox.setSelected(false);
        }
        bl3 = this.wpaEnabledCheckBox.getSelected();
        boolean bl4 = !bl && bl2 && bl3;
        boolean bl5 = !bl4;
        this.authenticationFE.setEnabled(bl4);
        this.authenticationFE.setReadonly(bl5);
        this.wpaEAPIdentityFE.setEnabled(bl4);
        this.wpaEAPIdentityFE.setEditable(bl4);
        this.wpaEAPAnonymousIdentityFE.setEnabled(bl4);
        this.wpaEAPAnonymousIdentityFE.setEditable(bl4);
        this.wpaEAPPasswordFE.setEnabled(bl4);
        this.wpaEAPPasswordFE.setReadonly(bl5);
        this.wpaEncryptionFE.setEnabled(bl4);
        this.wpaEncryptionFE.setReadonly(bl5);
        this.wpaEAPTypeFE.setEnabled(bl4);
        this.wpaEAPTypeFE.setReadonly(bl5);
        if (this.wpaCACertFE != null) {
            this.wpaCACertFE.setEnabled(bl4);
            this.wpaCACertFE.setEditable(bl4);
        }
        if (this.wpaCACertDirFE != null) {
            this.wpaCACertDirFE.setEnabled(bl4);
            this.wpaCACertDirFE.setEditable(bl4);
        }
        if (this.wpaClientCertFE != null) {
            this.wpaClientCertFE.setEnabled(bl4);
            this.wpaClientCertFE.setEditable(bl4);
        }
        if (this.wpaPrivateKeyFileFE != null) {
            this.wpaPrivateKeyFileFE.setEnabled(bl4);
            this.wpaPrivateKeyFileFE.setEditable(bl4);
        }
        if (this.clientKeyDropDown != null) {
            this.clientKeyDropDown.setEnabled(bl4);
        }
        if (this.caCertDropDown != null) {
            this.caCertDropDown.setEnabled(bl4);
        }
        this.wpaPrivateKeyPasswordFE.setEnabled(bl4);
        this.wpaPrivateKeyPasswordFE.setReadonly(bl5);
        this.wpaTunnelPhase1FE.setEnabled(bl4);
        this.wpaTunnelPhase2FE.setEnabled(bl4);
        if (this.wpaCACert2FE != null) {
            this.wpaCACert2FE.setEnabled(bl4);
            this.wpaCACert2FE.setEditable(bl4);
        }
        if (this.wpaCACertDir2FE != null) {
            this.wpaCACertDir2FE.setEnabled(bl4);
            this.wpaCACertDir2FE.setEditable(bl4);
        }
        if (this.wpaClientCert2FE != null) {
            this.wpaClientCert2FE.setEnabled(bl4);
            this.wpaClientCert2FE.setEditable(bl4);
        }
        if (this.wpaPrivateKeyFile2FE != null) {
            this.wpaPrivateKeyFile2FE.setEnabled(bl4);
            this.wpaPrivateKeyFile2FE.setEditable(bl4);
        }
        if (this.clientKey2DropDown != null) {
            this.clientKey2DropDown.setEnabled(bl4);
        }
        if (this.caCert2DropDown != null) {
            this.caCert2DropDown.setEnabled(bl4);
        }
        this.wpaPrivateKeyPassword2FE.setEnabled(bl4);
        this.wpaPrivateKeyPassword2FE.setReadonly(bl5);
        this.doHandleEAPMethodChanged();
        this.doHandlePhase2Changed();
    }

    public void doHandleEAPMethodChanged() {
        boolean bl = this.isReadonly();
        boolean bl2 = false;
        boolean bl3 = this.wpaEnabledCheckBox.isSelected();
        try {
            bl2 = ((BBoolean)this.wpaSupportedFE.saveValue()).getBoolean();
        }
        catch (Exception exception) {
            bl2 = false;
        }
        boolean bl4 = !bl && bl2 && bl3;
        boolean bl5 = !bl4;
        this.wpaEdgePane.setBottom((BWidget)new BNullWidget());
        try {
            BWifiEAPMethod bWifiEAPMethod = (BWifiEAPMethod)this.wpaEAPTypeFE.saveValue();
            if (bWifiEAPMethod == BWifiEAPMethod.peap || bWifiEAPMethod == BWifiEAPMethod.ttls || bWifiEAPMethod == BWifiEAPMethod.fast) {
                this.wpaEAPPasswordFE.setEnabled(bl4);
                this.wpaEAPPasswordFE.setReadonly(bl5);
                if (bWifiEAPMethod == BWifiEAPMethod.ttls || bWifiEAPMethod == BWifiEAPMethod.peap) {
                    this.wpaEAPAnonymousIdentityFE.setEnabled(bl4);
                    this.wpaEAPAnonymousIdentityFE.setEditable(bl4);
                } else {
                    this.wpaEAPAnonymousIdentityFE.setEnabled(false);
                    this.wpaEAPAnonymousIdentityFE.setEditable(false);
                }
                if (this.wpaClientCertFE != null) {
                    this.wpaClientCertFE.setEnabled(false);
                    this.wpaClientCertFE.setEditable(false);
                }
                if (this.wpaPrivateKeyFileFE != null) {
                    this.wpaPrivateKeyFileFE.setEnabled(false);
                    this.wpaPrivateKeyFileFE.setEditable(false);
                }
                if (this.clientKeyDropDown != null) {
                    this.clientKeyDropDown.setEnabled(false);
                }
                this.wpaPrivateKeyPasswordFE.setEnabled(false);
                this.wpaPrivateKeyPasswordFE.setReadonly(true);
                if (this.wpaCACertFE != null) {
                    this.wpaCACertFE.setEnabled(bl4);
                    this.wpaCACertFE.setEditable(bl4);
                }
                if (this.wpaCACertDirFE != null) {
                    this.wpaCACertDirFE.setEnabled(bl4);
                    this.wpaCACertDirFE.setEditable(bl4);
                }
                if (this.caCertDropDown != null) {
                    this.caCertDropDown.setEnabled(bl4);
                }
                TunnelModel tunnelModel = null;
                TunnelModel tunnelModel2 = null;
                if (bWifiEAPMethod == BWifiEAPMethod.peap) {
                    if (this.wpaTunnelPhase1FE.getList().getModel() != this.peapPhase1Model || this.wpaTunnelPhase2FE.getList().getModel() != this.peapPhase2Model) {
                        tunnelModel = this.peapPhase1Model;
                        tunnelModel2 = this.peapPhase2Model;
                    }
                } else if (bWifiEAPMethod == BWifiEAPMethod.ttls) {
                    if (this.wpaTunnelPhase1FE.getList().getModel() != this.ttlsPhase1Model || this.wpaTunnelPhase2FE.getList().getModel() != this.ttlsPhase2Model) {
                        tunnelModel = this.ttlsPhase1Model;
                        tunnelModel2 = this.ttlsPhase2Model;
                    }
                } else if (bWifiEAPMethod == BWifiEAPMethod.fast && (this.wpaTunnelPhase1FE.getList().getModel() != this.fastPhase1Model || this.wpaTunnelPhase2FE.getList().getModel() != this.fastPhase2Model)) {
                    tunnelModel = this.fastPhase1Model;
                    tunnelModel2 = this.fastPhase2Model;
                }
                if (tunnelModel != null && tunnelModel2 != null) {
                    this.wpaTunnelPhase1FE.getList().getSelection().deselectAll();
                    this.wpaTunnelPhase2FE.getList().getSelection().deselectAll();
                    this.wpaTunnelPhase1FE.getList().setModel((ListModel)tunnelModel);
                    this.wpaTunnelPhase2FE.getList().setModel((ListModel)tunnelModel2);
                    if (tunnelModel == this.ttlsPhase1Model) {
                        this.wpaTunnelPhase1FE.setEnabled(false);
                    } else {
                        this.wpaTunnelPhase1FE.setEnabled(bl4);
                    }
                    this.doHandlePhase2Changed();
                    this.wpaTunnelPhase1FE.getList().getSelection().select(0);
                    this.wpaTunnelPhase2FE.getList().getSelection().select(0);
                    this.setModified();
                }
                this.wpaEdgePane.setBottom((BWidget)this.tunnelParametersPane);
            } else {
                if (bWifiEAPMethod == BWifiEAPMethod.leap) {
                    this.wpaEAPPasswordFE.setEnabled(bl4);
                    this.wpaEAPPasswordFE.setReadonly(bl5);
                    this.wpaEAPAnonymousIdentityFE.setEnabled(false);
                    this.wpaEAPAnonymousIdentityFE.setEditable(false);
                    if (this.wpaClientCertFE != null) {
                        this.wpaClientCertFE.setEnabled(false);
                        this.wpaClientCertFE.setEditable(false);
                    }
                    if (this.wpaPrivateKeyFileFE != null) {
                        this.wpaPrivateKeyFileFE.setEnabled(false);
                        this.wpaPrivateKeyFileFE.setEditable(false);
                    }
                    if (this.clientKeyDropDown != null) {
                        this.clientKeyDropDown.setEnabled(false);
                    }
                    this.wpaPrivateKeyPasswordFE.setEnabled(false);
                    this.wpaPrivateKeyPasswordFE.setReadonly(true);
                    if (this.wpaCACertFE != null) {
                        this.wpaCACertFE.setEnabled(false);
                        this.wpaCACertFE.setEditable(false);
                    }
                    if (this.wpaCACertDirFE != null) {
                        this.wpaCACertDirFE.setEnabled(false);
                        this.wpaCACertDirFE.setEditable(false);
                    }
                    if (this.caCertDropDown != null) {
                        this.caCertDropDown.setEnabled(false);
                    }
                } else if (bWifiEAPMethod == BWifiEAPMethod.tls) {
                    this.wpaEAPPasswordFE.setEnabled(false);
                    this.wpaEAPPasswordFE.setReadonly(true);
                    this.wpaEAPAnonymousIdentityFE.setEnabled(false);
                    this.wpaEAPAnonymousIdentityFE.setEditable(false);
                    if (this.wpaClientCertFE != null) {
                        this.wpaClientCertFE.setEnabled(bl4);
                        this.wpaClientCertFE.setEditable(bl4);
                    }
                    if (this.wpaPrivateKeyFileFE != null) {
                        this.wpaPrivateKeyFileFE.setEnabled(bl4);
                        this.wpaPrivateKeyFileFE.setEditable(bl4);
                    }
                    if (this.clientKeyDropDown != null) {
                        this.clientKeyDropDown.setEnabled(bl4);
                    }
                    this.wpaPrivateKeyPasswordFE.setEnabled(bl4);
                    this.wpaPrivateKeyPasswordFE.setReadonly(bl5);
                    if (this.wpaCACertFE != null) {
                        this.wpaCACertFE.setEnabled(bl4);
                        this.wpaCACertFE.setEditable(bl4);
                    }
                    if (this.wpaCACertDirFE != null) {
                        this.wpaCACertDirFE.setEnabled(bl4);
                        this.wpaCACertDirFE.setEditable(bl4);
                    }
                    if (this.caCertDropDown != null) {
                        this.caCertDropDown.setEnabled(bl4);
                    }
                }
                this.tunnelParametersPane.computePreferredSize();
                this.wpaEdgePane.setBottom((BWidget)new BEdgePane(null, (BWidget)new BBox(this.tunnelParametersPane.getPreferredWidth(), 0.0), (BWidget)new BBox(0.0, this.tunnelParametersPane.getPreferredHeight()), null, null));
                this.setModified();
            }
        }
        catch (Exception exception) {
            System.err.println("Error while handling EAPMethodChanged");
            exception.printStackTrace();
        }
    }

    public void doHandlePhase2Changed() {
        boolean bl = this.isReadonly();
        boolean bl2 = false;
        boolean bl3 = this.wpaEnabledCheckBox.isSelected();
        try {
            bl2 = ((BBoolean)this.wpaSupportedFE.saveValue()).getBoolean();
        }
        catch (Exception exception) {
            bl2 = false;
        }
        boolean bl4 = !bl && bl2 && bl3;
        boolean bl5 = !bl4;
        String string = (String)this.wpaTunnelPhase2FE.getList().getSelectedItem();
        if (string != null && (string.equals("auth=TLS") || string.equals("autheap=TLS"))) {
            if (this.wpaClientCert2FE != null) {
                this.wpaClientCert2FE.setEnabled(bl4);
                this.wpaClientCert2FE.setEditable(bl4);
            }
            if (this.wpaPrivateKeyFile2FE != null) {
                this.wpaPrivateKeyFile2FE.setEnabled(bl4);
                this.wpaPrivateKeyFile2FE.setEditable(bl4);
            }
            if (this.clientKey2DropDown != null) {
                this.clientKey2DropDown.setEnabled(bl4);
            }
            this.wpaPrivateKeyPassword2FE.setEnabled(bl4);
            this.wpaPrivateKeyPassword2FE.setReadonly(bl5);
            if (this.wpaCACert2FE != null) {
                this.wpaCACert2FE.setEnabled(bl4);
                this.wpaCACert2FE.setEditable(bl4);
            }
            if (this.wpaCACertDir2FE != null) {
                this.wpaCACertDir2FE.setEnabled(bl4);
                this.wpaCACertDir2FE.setEditable(bl4);
            }
            if (this.caCert2DropDown != null) {
                this.caCert2DropDown.setEnabled(bl4);
            }
        } else {
            if (this.wpaClientCert2FE != null) {
                this.wpaClientCert2FE.setEnabled(false);
                this.wpaClientCert2FE.setEditable(false);
            }
            if (this.wpaPrivateKeyFile2FE != null) {
                this.wpaPrivateKeyFile2FE.setEnabled(false);
                this.wpaPrivateKeyFile2FE.setEditable(false);
            }
            if (this.clientKey2DropDown != null) {
                this.clientKey2DropDown.setEnabled(false);
            }
            this.wpaPrivateKeyPassword2FE.setEnabled(false);
            this.wpaPrivateKeyPassword2FE.setReadonly(true);
            if (this.wpaCACert2FE != null) {
                this.wpaCACert2FE.setEnabled(false);
                this.wpaCACert2FE.setEditable(false);
            }
            if (this.wpaCACertDir2FE != null) {
                this.wpaCACertDir2FE.setEnabled(false);
                this.wpaCACertDir2FE.setEditable(false);
            }
            if (this.caCert2DropDown != null) {
                this.caCert2DropDown.setEnabled(false);
            }
        }
        this.setModified();
    }

    public void doEditorModified(BWidgetEvent bWidgetEvent) {
    }

    public void doSetReadonly(boolean bl) {
        if (this.wpaSupportedFE != null) {
            this.wpaSupportedFE.setEnabled(!bl);
            this.wpaSupportedFE.setReadonly(bl);
        }
        if (this.wpaEnabledCheckBox != null) {
            this.wpaEnabledCheckBox.setEnabled(!bl);
        }
        if (this.wpaEncryptionFE != null) {
            this.wpaEncryptionFE.setEnabled(!bl);
            this.wpaEncryptionFE.setReadonly(bl);
        }
        if (this.authenticationFE != null) {
            this.authenticationFE.setEnabled(!bl);
            this.authenticationFE.setReadonly(bl);
        }
        if (this.wpaEAPTypeFE != null) {
            this.wpaEAPTypeFE.setEnabled(!bl);
            this.wpaEAPTypeFE.setReadonly(bl);
        }
        if (this.wpaEAPIdentityFE != null) {
            this.wpaEAPIdentityFE.setEditable(!bl);
            this.wpaEAPIdentityFE.setEnabled(!bl);
        }
        if (this.wpaEAPAnonymousIdentityFE != null) {
            this.wpaEAPAnonymousIdentityFE.setEditable(!bl);
            this.wpaEAPAnonymousIdentityFE.setEnabled(!bl);
        }
        if (this.wpaEAPPasswordFE != null) {
            this.wpaEAPPasswordFE.setEnabled(!bl);
            this.wpaEAPPasswordFE.setReadonly(bl);
        }
        if (this.wpaClientCertFE != null) {
            this.wpaClientCertFE.setEnabled(!bl);
            this.wpaClientCertFE.setEditable(!bl);
        }
        if (this.wpaPrivateKeyFileFE != null) {
            this.wpaPrivateKeyFileFE.setEnabled(!bl);
            this.wpaPrivateKeyFileFE.setEditable(!bl);
        }
        if (this.clientKeyDropDown != null) {
            this.clientKeyDropDown.setEnabled(!bl);
        }
        if (this.wpaPrivateKeyPasswordFE != null) {
            this.wpaPrivateKeyPasswordFE.setEnabled(!bl);
            this.wpaPrivateKeyPasswordFE.setReadonly(bl);
        }
        if (this.wpaCACertFE != null) {
            this.wpaCACertFE.setEnabled(!bl);
            this.wpaCACertFE.setEditable(!bl);
        }
        if (this.wpaCACertDirFE != null) {
            this.wpaCACertDirFE.setEnabled(!bl);
            this.wpaCACertDirFE.setEditable(!bl);
        }
        if (this.caCertDropDown != null) {
            this.caCertDropDown.setEnabled(!bl);
        }
        if (this.wpaTunnelPhase1FE != null) {
            this.wpaTunnelPhase1FE.setEnabled(!bl);
        }
        if (this.wpaTunnelPhase2FE != null) {
            this.wpaTunnelPhase2FE.setEnabled(!bl);
        }
        if (this.wpaClientCert2FE != null) {
            this.wpaClientCert2FE.setEnabled(!bl);
            this.wpaClientCert2FE.setEditable(!bl);
        }
        if (this.wpaPrivateKeyFile2FE != null) {
            this.wpaPrivateKeyFile2FE.setEnabled(!bl);
            this.wpaPrivateKeyFile2FE.setEditable(!bl);
        }
        if (this.clientKey2DropDown != null) {
            this.clientKey2DropDown.setEnabled(!bl);
        }
        if (this.wpaPrivateKeyPassword2FE != null) {
            this.wpaPrivateKeyPassword2FE.setEnabled(!bl);
            this.wpaPrivateKeyPassword2FE.setReadonly(bl);
        }
        if (this.wpaCACert2FE != null) {
            this.wpaCACert2FE.setEnabled(!bl);
            this.wpaCACert2FE.setEditable(!bl);
        }
        if (this.wpaCACertDir2FE != null) {
            this.wpaCACertDir2FE.setEnabled(!bl);
            this.wpaCACertDir2FE.setEditable(!bl);
        }
        if (this.caCert2DropDown != null) {
            this.caCert2DropDown.setEnabled(!bl);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class ClientKeyModel
    extends ListModel {
        private Array items = new Array(class$com$tridium$platform$pki$ClientPrivateKeyInfo == null ? (class$com$tridium$platform$pki$ClientPrivateKeyInfo = BWifiWPAEditor.class$("com.tridium.platform.pki.ClientPrivateKeyInfo")) : class$com$tridium$platform$pki$ClientPrivateKeyInfo);

        public ClientKeyModel(ClientPrivateKeyInfo[] clientPrivateKeyInfoArray) {
            this.items.add((Object)ClientPrivateKeyInfo.BLANK_KEY_CERTIFICATE);
            for (int i = 0; i < clientPrivateKeyInfoArray.length; ++i) {
                if (clientPrivateKeyInfoArray[i].keyFile == null) continue;
                this.items.add((Object)clientPrivateKeyInfoArray[i]);
            }
        }

        public void select(String string) {
            if (string == null || string.length() == 0) {
                this.getSelection().select(0);
                return;
            }
            String string2 = new FilePath(string).getName();
            for (int i = 1; i < this.getItemCount(); ++i) {
                if (!this.keyInfo((int)i).keyFile.getFileName().equals(string2)) continue;
                this.getSelection().select(i);
                return;
            }
            this.getSelection().deselectAll();
        }

        public String getSelectedKeyPath(FilePath filePath) {
            int n = this.getSelection().getLead();
            if (n < 1) {
                return "";
            }
            return filePath.merge(this.keyInfo((int)n).keyFile.getFileName()).getBody();
        }

        public String getSelectedCertPath(FilePath filePath) {
            int n = this.getSelection().getLead();
            if (n < 1) {
                return "";
            }
            return filePath.merge(this.keyInfo((int)n).certFile.getFileName()).getBody();
        }

        public ClientPrivateKeyInfo keyInfo(int n) {
            return (ClientPrivateKeyInfo)this.items.get(n);
        }

        public Object getItem(int n) {
            if (n == 0) {
                return "NONE";
            }
            return this.keyInfo((int)n).keyFile.getFileName();
        }

        public int getItemCount() {
            return this.items.size();
        }
    }

    private static class TunnelModel
    extends ListModel {
        private Array items = new Array(class$java$lang$String == null ? (class$java$lang$String = BWifiWPAEditor.class$("java.lang.String")) : class$java$lang$String);

        public TunnelModel(String[] stringArray) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null) continue;
                this.items.add((Object)stringArray[i]);
            }
        }

        public String tunnelInfo(int n) {
            return (String)this.items.get(n);
        }

        public Object getItem(int n) {
            return this.tunnelInfo(n);
        }

        public int getItemCount() {
            return this.items.size();
        }
    }

    private static class CACertModel
    extends ListModel {
        private Array items = new Array(class$com$tridium$platform$pki$PemCertInfo == null ? (class$com$tridium$platform$pki$PemCertInfo = BWifiWPAEditor.class$("com.tridium.platform.pki.PemCertInfo")) : class$com$tridium$platform$pki$PemCertInfo);

        public CACertModel(PemCertInfo[] pemCertInfoArray) {
            this.items.add((Object)PemCertInfo.BLANK_CERTIFICATE);
            for (int i = 0; i < pemCertInfoArray.length; ++i) {
                if (pemCertInfoArray[i].file == null) continue;
                this.items.add((Object)pemCertInfoArray[i]);
            }
        }

        public void select(String string) {
            if (string == null || string.length() == 0) {
                this.getSelection().select(0);
                return;
            }
            String string2 = new FilePath(string).getName();
            for (int i = 1; i < this.getItemCount(); ++i) {
                if (!this.caCertInfo((int)i).file.getFileName().equals(string2)) continue;
                this.getSelection().select(i);
                return;
            }
            this.getSelection().deselectAll();
        }

        public String getSelectedCertPath(FilePath filePath) {
            int n = this.getSelection().getLead();
            if (n < 1) {
                return "";
            }
            return filePath.merge(this.caCertInfo((int)n).file.getFileName()).getBody();
        }

        public PemCertInfo caCertInfo(int n) {
            return (PemCertInfo)this.items.get(n);
        }

        public Object getItem(int n) {
            if (n == 0) {
                return "NONE";
            }
            return this.caCertInfo((int)n).file.getFileName();
        }

        public int getItemCount() {
            return this.items.size();
        }
    }
}

