/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platwifi.ui.daemon;

import com.tridium.platDaemon.ui.BDaemonSessionView;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.ui.util.BButtonPane;
import com.tridium.platwifi.BWifiHostSettings;
import com.tridium.platwifi.WifiUtil;
import com.tridium.platwifi.ui.BWifiNetworksManager;
import com.tridium.ui.theme.Theme;
import javax.baja.gx.BBrush;
import javax.baja.gx.BInsets;
import javax.baja.security.AuthenticationException;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.workbench.BWbShell;

public class BWifiConfiguration
extends BDaemonSessionView {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$platwifi$ui$daemon$BWifiConfiguration == null ? (class$com$tridium$platwifi$ui$daemon$BWifiConfiguration = BWifiConfiguration.class$("com.tridium.platwifi.ui.daemon.BWifiConfiguration")) : class$com$tridium$platwifi$ui$daemon$BWifiConfiguration));
    private static volatile Object settingsMonitor = new Object();
    private long lastNativeChangeTicks = -1L;
    private BFacets pollFacets = BFacets.make((String)"update", (boolean)true);
    private BDaemonSession daemonSession = null;
    private BWifiNetworksManager wifiEditor = new BWifiNetworksManager();
    private BWifiHostSettings wifiSettings = new BWifiHostSettings();
    private BScrollPane scrollpane = null;
    static /* synthetic */ Class class$com$tridium$platwifi$ui$daemon$BWifiConfiguration;

    public Type getType() {
        return TYPE;
    }

    public BWifiConfiguration() {
        BBrush bBrush = Theme.scrollPane().getControlBackground();
        this.scrollpane = new BScrollPane((BWidget)this.wifiEditor);
        this.scrollpane.setViewportBackground(bBrush);
        this.linkTo(null, (BComponent)this.wifiEditor, (Slot)BWifiNetworksManager.pluginModified, (Slot)setModified);
        this.setReadonly(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doLoadSession(BDaemonSession bDaemonSession, Context context) throws AuthenticationException {
        this.daemonSession = bDaemonSession;
        try {
            Object object;
            BWbShell bWbShell = this.getWbShell();
            if (bWbShell != null) {
                object = new BButtonPane();
                object.addWorkbenchButtons((BWidget)this);
                BEdgePane bEdgePane = new BEdgePane();
                bEdgePane.setCenter((BWidget)new BBorderPane((BWidget)this.scrollpane, BBorder.inset, BInsets.DEFAULT));
                bEdgePane.setBottom((BWidget)new BBorderPane((BWidget)object, 5.0, 10.0, 0.0, 10.0));
                this.setContent((BWidget)bEdgePane);
            } else {
                this.setContent((BWidget)new BBorderPane((BWidget)this.scrollpane, BBorder.inset, BInsets.DEFAULT));
            }
            object = settingsMonitor;
            synchronized (object) {
                WifiUtil.loadFromSession(this.wifiSettings, bDaemonSession);
                this.wifiEditor.loadValue((BObject)this.wifiSettings, context);
                this.setReadonly(!bDaemonSession.getHostProperties().hasFullAccess());
                this.startRefreshTimer();
            }
        }
        catch (AuthenticationException authenticationException) {
            throw authenticationException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new LocalizableRuntimeException("platWifi", "WifiConfiguration.parseError", (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final BObject doSaveValue(BObject bObject, Context context) throws Exception {
        if (!this.isModified()) {
            return bObject;
        }
        Object object = settingsMonitor;
        synchronized (object) {
            this.wifiSettings = (BWifiHostSettings)this.wifiEditor.saveValue((BObject)this.wifiSettings, context);
            WifiUtil.saveToSession(this.wifiSettings, this.getDaemonSession());
        }
        return bObject;
    }

    public BDaemonSession getDaemonSession() {
        return this.daemonSession;
    }

    public synchronized BWifiHostSettings getWifiHostSettings() {
        return this.wifiSettings;
    }

    protected void doSetReadonly(boolean bl) {
        this.wifiEditor.setReadonly(bl);
    }

    protected void finalize() throws Throwable {
        this.stopRefreshTimer();
    }

    public void activated() {
        super.activated();
        this.startRefreshTimer();
    }

    public void deactivated() {
        super.deactivated();
        this.stopRefreshTimer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRefresh() {
        if (this.daemonSession == null) {
            return;
        }
        try {
            Object object = settingsMonitor;
            synchronized (object) {
                if (this.wifiSettings != null && this.wifiEditor != null) {
                    if (WifiUtil.lastExternalChangeDetectedTicks > this.lastNativeChangeTicks) {
                        this.lastNativeChangeTicks = WifiUtil.lastExternalChangeDetectedTicks;
                        WifiUtil.loadFromSession(this.wifiSettings, this.daemonSession);
                        this.wifiEditor.loadValue((BObject)this.wifiSettings, (Context)new BasicContext());
                    } else {
                        WifiUtil.pollStatusFromSession(this.wifiSettings, this.daemonSession);
                        this.wifiEditor.refreshSettings(this.wifiSettings, (Context)new BasicContext((Context)this.pollFacets));
                    }
                }
            }
        }
        catch (AuthenticationException authenticationException) {
            this.reauthenticate(authenticationException);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

