/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platwifi.ui;

import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platwifi.BWifiNetwork;
import com.tridium.platwifi.BWifiPlatformService;
import com.tridium.platwifi.ui.BWifiNetworkEditor;
import com.tridium.platwifi.ui.BWifiNetworksManager;
import com.tridium.platwifi.ui.BWifiPlatformServicePlugin;
import com.tridium.platwifi.ui.daemon.BWifiConfiguration;
import com.tridium.ui.theme.Theme;
import javax.baja.naming.BOrd;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BWindowEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.workbench.CannotSaveException;

public class BWifiNetworkEditorDialog
extends BDialog {
    public static final Action enableOkCommand = BWifiNetworkEditorDialog.newAction((int)0, null);
    public static final Action disableOkCommand = BWifiNetworkEditorDialog.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$platwifi$ui$BWifiNetworkEditorDialog == null ? (class$com$tridium$platwifi$ui$BWifiNetworkEditorDialog = BWifiNetworkEditorDialog.class$("com.tridium.platwifi.ui.BWifiNetworkEditorDialog")) : class$com$tridium$platwifi$ui$BWifiNetworkEditorDialog));
    BWifiNetworkEditor networkEditor = null;
    BWifiNetwork content = null;
    Command okCommand;
    Command cancelCommand;
    int dialogResult;
    static /* synthetic */ Class class$com$tridium$platwifi$ui$BWifiNetworkEditorDialog;

    public void enableOkCommand() {
        this.invoke(enableOkCommand, null, null);
    }

    public void disableOkCommand() {
        this.invoke(disableOkCommand, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BWifiNetworkEditorDialog() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public BWifiNetworkEditorDialog(BWidget bWidget, String string, int n, BWifiNetwork bWifiNetwork) throws Exception {
        super(bWidget, string, true);
        this.okCommand = new Ok((BWidget)this);
        this.cancelCommand = new Cancel((BWidget)this);
        this.okCommand.setEnabled(false);
        this.cancelCommand.setEnabled(true);
        BGridPane bGridPane = new BGridPane();
        bGridPane.setColumnAlign(BHalign.fill);
        bGridPane.setUniformColumnWidth(true);
        bGridPane.add(null, (BValue)new BButton(this.okCommand));
        bGridPane.add(null, (BValue)new BButton(this.cancelCommand));
        boolean bl = false;
        BDaemonSession bDaemonSession = null;
        BWifiPlatformService bWifiPlatformService = null;
        BWifiNetworksManager bWifiNetworksManager = null;
        BWidget bWidget2 = bWidget;
        while ((bWidget2 = bWidget2.getParent()) != null) {
            if (bWidget2 instanceof BWifiConfiguration) {
                bDaemonSession = ((BWifiConfiguration)bWidget2).getDaemonSession();
                bl = false;
                break;
            }
            if (bWidget2 instanceof BWifiPlatformServicePlugin) {
                if (bWifiNetworksManager != null) {
                    bWifiPlatformService = (BWifiPlatformService)BOrd.make((String)"service:platWifi:WifiPlatformService").get(bWifiNetworksManager.getCurrentValue());
                    bl = true;
                    break;
                }
                bWidget2 = null;
                break;
            }
            if (!(bWidget2 instanceof BWifiNetworksManager)) continue;
            bWifiNetworksManager = (BWifiNetworksManager)bWidget2;
        }
        this.networkEditor = bWidget2 == null ? new BWifiNetworkEditor() : (bl ? new BWifiNetworkEditor(bWifiPlatformService) : new BWifiNetworkEditor(bDaemonSession));
        this.networkEditor.loadValue((BObject)bWifiNetwork, (Context)new BasicContext((Context)BFacets.make((String)"configureMode", (int)n)));
        this.linkTo(null, (BComponent)this.networkEditor, (Slot)BWifiNetworkEditor.pluginModified, (Slot)enableOkCommand);
        if (n == 2 && bWifiNetwork.getSecuritySupported().loadSlots().getSlotCount() == 1 && bWifiNetwork.getSecurityConfigurations().loadSlots().getSlotCount() == 0) {
            this.doEnableOkCommand();
        }
        BScrollPane bScrollPane = new BScrollPane((BWidget)new BEdgePane(null, (BWidget)new BBorderPane((BWidget)bGridPane, 0.0, 10.0, 10.0, 10.0), null, null, (BWidget)new BBorderPane((BWidget)this.networkEditor)));
        bScrollPane.setViewportBackground(Theme.scrollPane().getControlBackground());
        this.setContent((BWidget)bScrollPane);
    }

    public void doEnableOkCommand() {
        this.okCommand.setEnabled(true);
    }

    public void doDisableOkCommand() {
        this.okCommand.setEnabled(false);
    }

    public int getResult() {
        return this.dialogResult;
    }

    public BWifiNetwork getNetwork() throws Exception {
        if (this.content == null) {
            this.content = (BWifiNetwork)this.networkEditor.saveValue();
        }
        return this.content;
    }

    public void windowClosing(BWindowEvent bWindowEvent) {
        super.windowClosing(bWindowEvent);
        this.cancelCommand.invoke();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class Cancel
    extends Command {
        Cancel(BWidget bWidget) {
            super(bWidget, UiLexicon.bajaui().getText("dialog.cancel"));
        }

        public CommandArtifact doInvoke() {
            BWifiNetworkEditorDialog.this.dialogResult = 2;
            BWifiNetworkEditorDialog.this.close();
            return null;
        }
    }

    class Ok
    extends Command {
        Ok(BWidget bWidget) {
            super(bWidget, UiLexicon.bajaui().getText("dialog.ok"));
        }

        public CommandArtifact doInvoke() {
            try {
                BWifiNetworkEditorDialog.this.content = (BWifiNetwork)BWifiNetworkEditorDialog.this.networkEditor.saveValue();
            }
            catch (Exception exception) {
                CannotSaveException cannotSaveException;
                boolean bl = true;
                if (exception instanceof CannotSaveException && (cannotSaveException = (CannotSaveException)exception).isSilent()) {
                    bl = false;
                }
                if (bl) {
                    BDialog.error((BWidget)this.getOwner(), (String)BWifiNetworkEditorDialog.this.getLexicon().getText("WifiNetworkConfigurationEditor.cannotSave.title"), (Object)BWifiNetworkEditorDialog.this.getLexicon().getText(exception.getMessage()));
                }
                return null;
            }
            BWifiNetworkEditorDialog.this.dialogResult = 1;
            BWifiNetworkEditorDialog.this.close();
            return null;
        }
    }
}

