/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platwifi;

import com.tridium.net.HttpUtil;
import com.tridium.nre.util.LegacyStorageUtil;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.XmlResponseMessage;
import com.tridium.platwifi.BWifiHostSettings;
import com.tridium.platwifi.BWifiNetwork;
import com.tridium.platwifi.BWifiNetworkMode;
import com.tridium.platwifi.BWifiNetworkVector;
import com.tridium.platwifi.security.BWifiAuthenticationMethod;
import com.tridium.platwifi.security.BWifiEAPMethod;
import com.tridium.platwifi.security.BWifiEncryptionMethod;
import com.tridium.platwifi.security.BWifiSecurityPolicy;
import com.tridium.platwifi.security.BWifiSecuritySettings;
import com.tridium.platwifi.security.BWifiWEPSettings;
import com.tridium.platwifi.security.BWifiWPA2PSKSettings;
import com.tridium.platwifi.security.BWifiWPA2Settings;
import com.tridium.platwifi.security.BWifiWPAPSKSettings;
import com.tridium.platwifi.security.BWifiWPASettings;
import com.tridium.platwifi.status.BWifiDaemonStateEnum;
import com.tridium.platwifi.status.BWifiNetworkStateEnum;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import javax.baja.data.BIDataValue;
import javax.baja.log.Log;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.Array;
import javax.baja.security.BPassword;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.InvalidEnumException;
import javax.baja.sys.Property;
import javax.baja.xml.XContent;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class WifiUtil {
    public static long lastExternalChangeDetectedTicks = -1;
    static /* synthetic */ Class class$com$tridium$platwifi$BWifiNetwork;
    static /* synthetic */ Class class$com$tridium$platwifi$security$BWifiSecurityPolicy;
    static /* synthetic */ Class class$com$tridium$platwifi$security$BWifiSecuritySettings;

    public static void loadFromSession(BWifiHostSettings bWifiHostSettings, BDaemonSession bDaemonSession) throws Exception {
        InputStream inputStream = bDaemonSession.getInputStream(new DaemonMessage(){

            public final String getMessageString() {
                return "wifi?pollWifiSettings=true";
            }
        });
        XElem xElem = XParser.make((InputStream)inputStream).parse();
        WifiUtil.updateFields(bWifiHostSettings, xElem);
    }

    /*
     * Unable to fully structure code
     */
    public static void saveToSession(BWifiHostSettings var0, BDaemonSession var1_1) throws Exception {
        if (var0 == null) {
            return;
        }
        var1_1.sendMessage((DaemonMessage)new UpdateWifiHostSettingsMessage(var0));
        var2_2 = var0.getNetworkDatabase().loadSlots().getProperties();
        if (true) ** GOTO lbl11
        do {
            var3_3 = (BWifiNetwork)var2_2.get();
            var1_1.sendMessage((DaemonMessage)new UpdateWifiNetworkMessage(var0.getAdapterName(), var3_3));
lbl11:
            // 2 sources

            if ((v0 = WifiUtil.class$com$tridium$platwifi$BWifiNetwork) != null) continue;
            v0 = WifiUtil.class("[Lcom.tridium.platwifi.BWifiNetwork;", false);
        } while (var2_2.next(v0));
        var1_1.sendMessage((DaemonMessage)new PersistWifiNetworkSettings(var0.getAdapterName()));
    }

    public static BWifiNetworkVector discoverFromSession(final String string, BDaemonSession bDaemonSession) throws Exception {
        InputStream inputStream = bDaemonSession.getInputStream(new DaemonMessage(){

            public final String getMessageString() {
                return "wifi?discoverWifiNetworks=true&adapter=" + HttpUtil.encodeUrl((String)string);
            }
        });
        XElem xElem = XParser.make((InputStream)inputStream).parse();
        BWifiNetworkVector bWifiNetworkVector = new BWifiNetworkVector();
        BWifiNetwork bWifiNetwork = null;
        if (xElem.geti("wifiNetworks", 0) == 0) {
            return bWifiNetworkVector;
        }
        XElem[] xElemArray = xElem.elems("wifiNetwork");
        int n = 0;
        while (n < xElemArray.length) {
            bWifiNetwork = BWifiNetwork.makeNetwork(xElemArray[n].get("description"));
            try {
                bWifiNetworkVector.add(SlotPath.escape((String)bWifiNetwork.getSsid()), (BValue)bWifiNetwork, 3, (Context)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"platWifi:WifiNetworkEditor")));
            }
            catch (Exception exception) {}
            ++n;
        }
        return bWifiNetworkVector;
    }

    public static boolean addRemoveFromSession(String string, BWifiNetwork bWifiNetwork, BDaemonSession bDaemonSession, boolean bl) throws Exception {
        if (bWifiNetwork == null) {
            return false;
        }
        if (bl && bWifiNetwork.getMode().getOrdinal() == 1) {
            throw new BajaRuntimeException("WiFi network mode \"ad-hoc\" is not supported");
        }
        InputStream inputStream = bDaemonSession.getInputStream((DaemonMessage)new AddRemoveWifiNetworkMessage(string, bWifiNetwork, bl));
        XElem xElem = XParser.make((InputStream)inputStream).parse();
        return xElem.geti("statusCode", 0) == 200;
    }

    public static boolean disconnectFromSession(String string, String string2, BDaemonSession bDaemonSession) throws Exception {
        InputStream inputStream = bDaemonSession.getInputStream((DaemonMessage)new DisconnectNetworkMessage(string, string2));
        XElem xElem = XParser.make((InputStream)inputStream).parse();
        return xElem.geti("statusCode", 0) == 200;
    }

    public static boolean roamFromSession(final String string, BDaemonSession bDaemonSession) throws Exception {
        InputStream inputStream = bDaemonSession.getInputStream(new DaemonMessage(){

            public final String getMessageString() {
                return "wifi?roamWifiNetworks=true&adapter=" + HttpUtil.encodeUrl((String)string);
            }
        });
        XElem xElem = XParser.make((InputStream)inputStream).parse();
        return xElem.geti("statusCode", 0) == 200;
    }

    public static boolean connectFromSession(String string, String string2, BDaemonSession bDaemonSession) throws Exception {
        InputStream inputStream = bDaemonSession.getInputStream((DaemonMessage)new ConnectNetworkMessage(string, string2));
        XElem xElem = XParser.make((InputStream)inputStream).parse();
        return xElem.geti("statusCode", 0) == 200;
    }

    public static boolean hashCACertificatesFromSession(BDaemonSession bDaemonSession) throws Exception {
        InputStream inputStream = bDaemonSession.getInputStream(new DaemonMessage(){

            public final String getMessageString() {
                return "wifi?hashCACertificates=true";
            }
        });
        XElem xElem = XParser.make((InputStream)inputStream).parse();
        return xElem.geti("statusCode", 0) == 200;
    }

    public static Array getNetworkDatabaseFromSession(BDaemonSession bDaemonSession) throws Exception {
        InputStream inputStream = bDaemonSession.getInputStream(new DaemonMessage(){

            public final String getMessageString() {
                return "wifi?pollWifiSettings=true";
            }
        });
        XElem xElem = XParser.make((InputStream)inputStream).parse();
        XElem xElem2 = xElem.elem("wifiNetworkDatabase");
        XElem[] xElemArray = null;
        BWifiNetwork bWifiNetwork = null;
        Array array = null;
        if (xElem2 != null) {
            xElemArray = xElem2.elems("wifiNetwork");
            Class clazz = class$com$tridium$platwifi$BWifiNetwork;
            if (clazz == null) {
                clazz = class$com$tridium$platwifi$BWifiNetwork = WifiUtil.class("[Lcom.tridium.platwifi.BWifiNetwork;", false);
            }
            array = new Array(clazz);
            int n = 0;
            while (n < xElemArray.length) {
                bWifiNetwork = new BWifiNetwork();
                WifiUtil.updateFields(bWifiNetwork, xElemArray[n]);
                array.add((Object)bWifiNetwork);
                ++n;
            }
        }
        return array;
    }

    public static boolean pollStatusFromSession(BWifiHostSettings bWifiHostSettings, BDaemonSession bDaemonSession) throws Exception {
        if (bWifiHostSettings == null) {
            return false;
        }
        InputStream inputStream = bDaemonSession.getInputStream(new DaemonMessage(){

            public final String getMessageString() {
                return "wifi?getWifiStatus=true";
            }
        });
        XElem xElem = XParser.make((InputStream)inputStream).parse();
        bWifiHostSettings.setIsWifiEnabled(xElem.getb("wifiEnabled", false));
        bWifiHostSettings.setCurrentNetworkSsid(xElem.get("currentNetwork", ""));
        bWifiHostSettings.setDaemonState(BWifiDaemonStateEnum.make(xElem.geti("currentDaemonState", 0)));
        bWifiHostSettings.setAdapterName(xElem.get("adapter", ""));
        HashSet<String> hashSet = new HashSet<String>();
        BWifiNetwork bWifiNetwork = null;
        XElem xElem2 = xElem.elem("wifiNetworkDatabase");
        XElem[] xElemArray = null;
        if (xElem2 != null) {
            xElemArray = xElem2.elems("wifiNetwork");
            int n = 0;
            while (n < xElemArray.length) {
                String string = SlotPath.escape((String)xElemArray[n].get("ssid"));
                hashSet.add(string);
                bWifiNetwork = (BWifiNetwork)bWifiHostSettings.getNetworkDatabase().get(string);
                if (bWifiNetwork != null) {
                    bWifiNetwork.setSignalStrength(xElemArray[n].geti("strength", 0));
                    bWifiNetwork.setNetworkState(BWifiNetworkStateEnum.make(xElemArray[n].geti("status", 0)));
                } else {
                    lastExternalChangeDetectedTicks = Clock.ticks();
                }
                ++n;
            }
            Property[] propertyArray = bWifiHostSettings.getNetworkDatabase().getPropertiesArray();
            int n2 = 0;
            while (n2 < propertyArray.length) {
                if (!hashSet.contains(propertyArray[n2].getName())) {
                    bWifiHostSettings.getNetworkDatabase().remove(propertyArray[n2].getName());
                }
                ++n2;
            }
        } else if (bWifiHostSettings.getNetworkDatabase() != null) {
            bWifiHostSettings.getNetworkDatabase().removeAll();
        } else {
            bWifiHostSettings.setNetworkDatabase(new BWifiNetworkVector());
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public static XElem getWifiHostSettingsXml(BWifiHostSettings var0) {
        var1_1 = new XElem("wifiHostSettings");
        var1_1.addAttr("wifiEnabled", var0.getIsWifiEnabled() != false ? "true" : "false");
        var1_1.addAttr("adapter", HttpUtil.encodeUrl((String)var0.getAdapterName()));
        var1_1.addAttr("currentDaemonState", String.valueOf(var0.getDaemonState().getOrdinal()));
        var1_1.addAttr("currentNetwork", var0.getCurrentNetworkSsid() == null ? "" : HttpUtil.encodeUrl((String)var0.getCurrentNetworkSsid()));
        var2_2 = new XElem("wifiNetworkDatabase");
        var2_2.addAttr("numberNetworks", String.valueOf(var0.getNetworkDatabase().getSlotCount()));
        var3_3 = var0.getNetworkDatabase().loadSlots().getProperties();
        if (true) ** GOTO lbl18
        do {
            var2_2.addContent((XContent)WifiUtil.getWifiNetworksXml((BWifiNetwork)var3_3.get()));
lbl18:
            // 2 sources

            if ((v0 = WifiUtil.class$com$tridium$platwifi$BWifiNetwork) != null) continue;
            v0 = WifiUtil.class("[Lcom.tridium.platwifi.BWifiNetwork;", false);
        } while (var3_3.next(v0));
        var1_1.addContent((XContent)var2_2);
        return var1_1;
    }

    /*
     * Unable to fully structure code
     */
    public static XElem getWifiNetworksXml(BWifiNetwork var0) {
        var1_1 = new XElem("wifiNetwork");
        var1_1.addAttr("ssid", HttpUtil.encodeUrl((String)var0.getSsid()));
        var1_1.addAttr("bssid", HttpUtil.encodeUrl((String)var0.getBssid()));
        var1_1.addAttr("ssidBroadcasted", String.valueOf(var0.getSsidBroadcasted()));
        var1_1.addAttr("mode", String.valueOf(var0.getMode().getOrdinal()));
        var1_1.addAttr("channel", String.valueOf(var0.getChannel()));
        var1_1.addAttr("priority", String.valueOf(var0.getPriority()));
        var1_1.addAttr("strength", String.valueOf(var0.getSignalStrength()));
        var1_1.addAttr("status", String.valueOf(var0.getNetworkState().getOrdinal()));
        var2_2 = new XElem("wifiSecuritySupported");
        var2_2.addAttr("numberSupported", String.valueOf(var0.getSecuritySupported().getSlotCount()));
        var3_3 = var0.getSecuritySupported().loadSlots().getProperties();
        if (true) ** GOTO lbl29
        do {
            var4_4 = new XElem("wifiSecurity");
            var4_4.addAttr("type", ((BWifiSecurityPolicy)var3_3.get()).getTag());
            var2_2.addContent((XContent)var4_4);
lbl29:
            // 2 sources

            if ((v0 = WifiUtil.class$com$tridium$platwifi$security$BWifiSecurityPolicy) != null) continue;
            v0 = WifiUtil.class("[Lcom.tridium.platwifi.security.BWifiSecurityPolicy;", false);
        } while (var3_3.next(v0));
        var1_1.addContent((XContent)var2_2);
        var3_3 = new XElem("wifiSecurityConfiguration");
        var4_5 = var0.getSecurityConfigurations().getSlotCount();
        var3_3.addAttr("numberConfigured", String.valueOf(var4_5));
        var5_6 = var0.getSecurityConfigurations().loadSlots().getProperties();
        if (true) ** GOTO lbl43
        do {
            var3_3.addContent((XContent)WifiUtil.getSecurityConfigurationXml((BWifiSecuritySettings)var5_6.get()));
lbl43:
            // 2 sources

            if ((v1 = WifiUtil.class$com$tridium$platwifi$security$BWifiSecuritySettings) != null) continue;
            v1 = WifiUtil.class("[Lcom.tridium.platwifi.security.BWifiSecuritySettings;", false);
        } while (var5_6.next(v1));
        var1_1.addContent((XContent)var3_3);
        return var1_1;
    }

    public static XElem getSecurityConfigurationXml(BWifiSecuritySettings bWifiSecuritySettings) {
        XElem xElem = new XElem("configuration");
        try {
            if (bWifiSecuritySettings.getPolicy() == BWifiSecurityPolicy.none) {
                xElem.addAttr("type", "none");
                xElem.addAttr("supported", "true");
                xElem.addAttr("use", "true");
                xElem.addAttr("authentication", String.valueOf(1));
                xElem.addAttr("encryption", String.valueOf(1));
                xElem.addAttr("protocol", String.valueOf(3));
            } else if (bWifiSecuritySettings.getPolicy() == BWifiSecurityPolicy.wep) {
                BWifiWEPSettings bWifiWEPSettings = (BWifiWEPSettings)bWifiSecuritySettings;
                xElem.addAttr("type", "wep");
                xElem.addAttr("supported", bWifiWEPSettings.getSupported() ? "true" : "false");
                xElem.addAttr("use", bWifiWEPSettings.getUse() ? "true" : "false");
                xElem.addAttr("protocol", String.valueOf(3));
                xElem.addAttr("authentication", String.valueOf(bWifiWEPSettings.getAuthentication().getOrdinal()));
                xElem.addAttr("encryption", String.valueOf(bWifiWEPSettings.getEncryption().getOrdinal()));
                xElem.addAttr("key_mgmt", String.valueOf(1));
                xElem.addAttr("key1", bWifiWEPSettings.getKey1());
                xElem.addAttr("key2", bWifiWEPSettings.getKey2());
                xElem.addAttr("key3", bWifiWEPSettings.getKey3());
                xElem.addAttr("key4", bWifiWEPSettings.getKey4());
                xElem.addAttr("index", String.valueOf(bWifiWEPSettings.getKeyIndex()));
            } else if (bWifiSecuritySettings.getPolicy() == BWifiSecurityPolicy.wpa) {
                BWifiWPASettings bWifiWPASettings = (BWifiWPASettings)bWifiSecuritySettings;
                xElem.addAttr("type", "wpa");
                xElem.addAttr("supported", bWifiWPASettings.getSupported() ? "true" : "false");
                xElem.addAttr("use", bWifiWPASettings.getUse() ? "true" : "false");
                xElem.addAttr("protocol", String.valueOf(1));
                xElem.addAttr("authentication", String.valueOf(bWifiWPASettings.getAuthentication().getOrdinal()));
                xElem.addAttr("encryption", String.valueOf(bWifiWPASettings.getEncryption().getOrdinal()));
                xElem.addAttr("key_mgmt", String.valueOf(4));
                xElem.addAttr("eap", String.valueOf(bWifiWPASettings.getEap().getOrdinal()));
                xElem.addAttr("eapIdentity", bWifiWPASettings.getEapIdentity());
                xElem.addAttr("eapAnonymousIdentity", bWifiWPASettings.getEapIdentity());
                xElem.addAttr("eapPassword", bWifiWPASettings.getEapPassword().encodeToString());
                xElem.addAttr("CACertificateFile", bWifiWPASettings.getCertAuthCertificate());
                xElem.addAttr("CACertificateDir", bWifiWPASettings.getCertAuthDirectoryPath());
                xElem.addAttr("clientCertificate", bWifiWPASettings.getClientCertificate());
                xElem.addAttr("privateKeyFile", bWifiWPASettings.getPrivateKeyFile());
                xElem.addAttr("privateKeyPassword", bWifiWPASettings.getPrivateKeyPassword().encodeToString());
                xElem.addAttr("phase1", bWifiWPASettings.getTunnelPhase1());
                xElem.addAttr("phase2", bWifiWPASettings.getTunnelPhase2());
                xElem.addAttr("CACertificateFile2", bWifiWPASettings.getCertAuthCertificate2());
                xElem.addAttr("CACertificateDir2", bWifiWPASettings.getCertAuthDirectoryPath2());
                xElem.addAttr("clientCertificate2", bWifiWPASettings.getClientCertificate2());
                xElem.addAttr("privateKeyFile2", bWifiWPASettings.getPrivateKeyFile2());
                xElem.addAttr("privateKeyPassword2", bWifiWPASettings.getPrivateKeyPassword2().encodeToString());
            } else if (bWifiSecuritySettings.getPolicy() == BWifiSecurityPolicy.wpa_psk) {
                BWifiWPAPSKSettings bWifiWPAPSKSettings = (BWifiWPAPSKSettings)bWifiSecuritySettings;
                xElem.addAttr("type", "wpa_psk");
                xElem.addAttr("supported", bWifiWPAPSKSettings.getSupported() ? "true" : "false");
                xElem.addAttr("use", bWifiWPAPSKSettings.getUse() ? "true" : "false");
                xElem.addAttr("protocol", String.valueOf(1));
                xElem.addAttr("authentication", String.valueOf(bWifiWPAPSKSettings.getAuthentication().getOrdinal()));
                xElem.addAttr("encryption", String.valueOf(bWifiWPAPSKSettings.getEncryption().getOrdinal()));
                xElem.addAttr("key_mgmt", String.valueOf(2));
                xElem.addAttr("psk", bWifiWPAPSKSettings.getNetworkKey().encodeToString());
            } else if (bWifiSecuritySettings.getPolicy() == BWifiSecurityPolicy.wpa2) {
                BWifiWPA2Settings bWifiWPA2Settings = (BWifiWPA2Settings)bWifiSecuritySettings;
                xElem.addAttr("type", "wpa2");
                xElem.addAttr("supported", bWifiWPA2Settings.getSupported() ? "true" : "false");
                xElem.addAttr("use", bWifiWPA2Settings.getUse() ? "true" : "false");
                xElem.addAttr("protocol", String.valueOf(2));
                xElem.addAttr("authentication", String.valueOf(bWifiWPA2Settings.getAuthentication().getOrdinal()));
                xElem.addAttr("encryption", String.valueOf(bWifiWPA2Settings.getEncryption().getOrdinal()));
                xElem.addAttr("key_mgmt", String.valueOf(4));
                xElem.addAttr("eap", String.valueOf(bWifiWPA2Settings.getEap().getOrdinal()));
                xElem.addAttr("eapIdentity", bWifiWPA2Settings.getEapIdentity());
                xElem.addAttr("eapAnonymousIdentity", bWifiWPA2Settings.getEapIdentity());
                xElem.addAttr("eapPassword", bWifiWPA2Settings.getEapPassword().encodeToString());
                xElem.addAttr("CACertificateFile", bWifiWPA2Settings.getCertAuthCertificate());
                xElem.addAttr("CACertificateDir", bWifiWPA2Settings.getCertAuthDirectoryPath());
                xElem.addAttr("clientCertificate", bWifiWPA2Settings.getClientCertificate());
                xElem.addAttr("privateKeyFile", bWifiWPA2Settings.getPrivateKeyFile());
                xElem.addAttr("privateKeyPassword", bWifiWPA2Settings.getPrivateKeyPassword().encodeToString());
                xElem.addAttr("phase1", bWifiWPA2Settings.getTunnelPhase1());
                xElem.addAttr("phase2", bWifiWPA2Settings.getTunnelPhase2());
                xElem.addAttr("CACertificateFile2", bWifiWPA2Settings.getCertAuthCertificate2());
                xElem.addAttr("CACertificateDir2", bWifiWPA2Settings.getCertAuthDirectoryPath2());
                xElem.addAttr("clientCertificate2", bWifiWPA2Settings.getClientCertificate2());
                xElem.addAttr("privateKeyFile2", bWifiWPA2Settings.getPrivateKeyFile2());
                xElem.addAttr("privateKeyPassword2", bWifiWPA2Settings.getPrivateKeyPassword2().encodeToString());
            } else if (bWifiSecuritySettings.getPolicy() == BWifiSecurityPolicy.wpa2_psk) {
                BWifiWPA2PSKSettings bWifiWPA2PSKSettings = (BWifiWPA2PSKSettings)bWifiSecuritySettings;
                xElem.addAttr("type", "wps2_psk");
                xElem.addAttr("supported", bWifiWPA2PSKSettings.getSupported() ? "true" : "false");
                xElem.addAttr("use", bWifiWPA2PSKSettings.getUse() ? "true" : "false");
                xElem.addAttr("protocol", String.valueOf(2));
                xElem.addAttr("authentication", String.valueOf(bWifiWPA2PSKSettings.getAuthentication().getOrdinal()));
                xElem.addAttr("encryption", String.valueOf(bWifiWPA2PSKSettings.getEncryption().getOrdinal()));
                xElem.addAttr("key_mgmt", String.valueOf(2));
                xElem.addAttr("psk", bWifiWPA2PSKSettings.getNetworkKey().encodeToString());
            }
        }
        catch (IOException iOException) {}
        return xElem;
    }

    public static void updateFields(BWifiHostSettings bWifiHostSettings, XElem xElem) {
        bWifiHostSettings.setIsWifiEnabled(xElem.getb("wifiEnabled", false));
        bWifiHostSettings.setAdapterName(xElem.get("adapter", ""));
        bWifiHostSettings.setCurrentNetworkSsid(xElem.get("currentNetwork", ""));
        bWifiHostSettings.setDaemonState(BWifiDaemonStateEnum.make(xElem.geti("currentDaemonState", 0)));
        HashSet<String> hashSet = new HashSet<String>();
        BWifiNetwork bWifiNetwork = null;
        XElem xElem2 = xElem.elem("wifiNetworkDatabase");
        XElem[] xElemArray = null;
        if (xElem2 != null) {
            xElemArray = xElem2.elems("wifiNetwork");
            int n = 0;
            while (n < xElemArray.length) {
                String string = SlotPath.escape((String)xElemArray[n].get("ssid"));
                hashSet.add(string);
                bWifiNetwork = (BWifiNetwork)bWifiHostSettings.getNetworkDatabase().get(string);
                if (bWifiNetwork == null) {
                    bWifiNetwork = new BWifiNetwork();
                    bWifiHostSettings.getNetworkDatabase().add(string, (BValue)bWifiNetwork, 1, (Context)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"platWifi:WifiNetworkEditor")));
                }
                WifiUtil.updateFields(bWifiNetwork, xElemArray[n]);
                ++n;
            }
            Property[] propertyArray = bWifiHostSettings.getNetworkDatabase().getPropertiesArray();
            int n2 = 0;
            while (n2 < propertyArray.length) {
                if (!hashSet.contains(propertyArray[n2].getName())) {
                    bWifiHostSettings.getNetworkDatabase().remove(propertyArray[n2].getName());
                }
                ++n2;
            }
        } else if (bWifiHostSettings.getNetworkDatabase() != null) {
            bWifiHostSettings.getNetworkDatabase().removeAll();
        } else {
            bWifiHostSettings.setNetworkDatabase(new BWifiNetworkVector());
        }
    }

    public static void updateFields(BWifiNetwork bWifiNetwork, XElem xElem) {
        BFacets bFacets;
        Object object;
        Object object2;
        bWifiNetwork.setSsid(xElem.get("ssid", "SSID N/A"));
        bWifiNetwork.setBssid(xElem.get("bssid", "00:00:00:00:00:00"));
        bWifiNetwork.setSsidBroadcasted(Boolean.valueOf(xElem.get("ssidBroadcasted", String.valueOf("true"))));
        bWifiNetwork.setMode(BWifiNetworkMode.make(xElem.geti("mode", 2)));
        bWifiNetwork.setChannel(xElem.geti("channel", 0));
        bWifiNetwork.setSignalStrength(xElem.geti("strength", 0));
        bWifiNetwork.setPriority(xElem.geti("priority", 0));
        bWifiNetwork.setNetworkState(BWifiNetworkStateEnum.make(xElem.geti("status", 0)));
        BWifiSecurityPolicy bWifiSecurityPolicy = null;
        String string = null;
        XElem xElem2 = xElem.elem("wifiSecuritySupported");
        if (xElem2 != null) {
            object2 = xElem2.elems("wifiSecurity");
            object = new HashSet<String>();
            int n = 0;
            while (n < ((XElem[])object2).length) {
                string = SlotPath.escape((String)object2[n].get("type"));
                object.add(string);
                bWifiSecurityPolicy = (BWifiSecurityPolicy)bWifiNetwork.getSecuritySupported().get(string);
                if (bWifiSecurityPolicy == null) {
                    bWifiNetwork.getSecuritySupported().add(string, (BValue)BWifiSecurityPolicy.make(object2[n].get("type")), 3);
                }
                ++n;
            }
            bFacets = bWifiNetwork.getSecuritySupported().getPropertiesArray();
            int n2 = 0;
            while (n2 < ((Property[])bFacets).length) {
                if (!object.contains(bFacets[n2].getName())) {
                    bWifiNetwork.getSecuritySupported().remove(bFacets[n2].getName());
                }
                ++n2;
            }
        } else if (bWifiNetwork.getSecuritySupported() != null) {
            bWifiNetwork.getSecuritySupported().removeAll();
        } else {
            bWifiNetwork.setSecuritySupported(new BVector());
        }
        object2 = new HashSet();
        object = null;
        bFacets = null;
        XElem xElem3 = xElem.elem("wifiSecurityConfiguration");
        XElem[] xElemArray = null;
        if (xElem3 != null) {
            xElemArray = xElem3.elems("configuration");
            int n = 0;
            while (n < xElemArray.length) {
                String string2 = SlotPath.escape((String)xElemArray[n].get("type"));
                bFacets = null;
                object = null;
                if (!string2.equalsIgnoreCase("none")) {
                    ((HashSet)object2).add(string2);
                    object = (BWifiSecuritySettings)bWifiNetwork.getSecurityConfigurations().get(string2);
                    if (object == null) {
                        if (string2.equals(SlotPath.escape((String)BWifiSecurityPolicy.wep.getTag()))) {
                            object = BWifiSecuritySettings.make(BWifiSecurityPolicy.wep);
                            bFacets = BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"platWifi:WifiWEPEditor"));
                        } else if (string2.equals(SlotPath.escape((String)BWifiSecurityPolicy.wpa.getTag()))) {
                            object = BWifiSecuritySettings.make(BWifiSecurityPolicy.wpa);
                            bFacets = BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"platWifi:WifiWPAEditor"));
                        } else if (string2.equals(SlotPath.escape((String)BWifiSecurityPolicy.wpa2.getTag()))) {
                            object = BWifiSecuritySettings.make(BWifiSecurityPolicy.wpa2);
                            bFacets = BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"platWifi:WifiWPA2Editor"));
                        } else if (string2.equals(SlotPath.escape((String)BWifiSecurityPolicy.wpa_psk.getTag()))) {
                            object = BWifiSecuritySettings.make(BWifiSecurityPolicy.wpa_psk);
                            bFacets = BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"platWifi:WifiWPAPSKEditor"));
                        } else if (string2.equals(SlotPath.escape((String)BWifiSecurityPolicy.wpa2_psk.getTag()))) {
                            object = BWifiSecuritySettings.make(BWifiSecurityPolicy.wpa2_psk);
                            bFacets = BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"platWifi:WifiWPA2PSKEditor"));
                        }
                        if (object != null) {
                            bWifiNetwork.getSecurityConfigurations().add(string2, object, 3, (Context)bFacets);
                        }
                    }
                    WifiUtil.updateFields(object, xElemArray[n]);
                }
                ++n;
            }
            Property[] propertyArray = bWifiNetwork.getSecurityConfigurations().getPropertiesArray();
            int n3 = 0;
            while (n3 < propertyArray.length) {
                if (!((HashSet)object2).contains(propertyArray[n3].getName())) {
                    bWifiNetwork.getSecurityConfigurations().remove(propertyArray[n3].getName());
                }
                ++n3;
            }
        } else if (bWifiNetwork.getSecurityConfigurations() != null) {
            bWifiNetwork.getSecurityConfigurations().removeAll();
        } else {
            bWifiNetwork.setSecurityConfigurations(new BVector());
        }
    }

    public static void updateFields(BWifiSecuritySettings bWifiSecuritySettings, XElem xElem) {
        block16: {
            String string = null;
            try {
                if (bWifiSecuritySettings.getPolicy() == BWifiSecurityPolicy.none) break block16;
                if (bWifiSecuritySettings.getPolicy() == BWifiSecurityPolicy.wep) {
                    ((BWifiWEPSettings)bWifiSecuritySettings).setSupported(xElem.getb("supported", false));
                    ((BWifiWEPSettings)bWifiSecuritySettings).setUse(xElem.getb("use", false));
                    ((BWifiWEPSettings)bWifiSecuritySettings).setAuthentication(BWifiAuthenticationMethod.make(xElem.geti("authentication", 4)));
                    try {
                        int n = xElem.geti("encryption", 8);
                        ((BWifiWEPSettings)bWifiSecuritySettings).setEncryption(BWifiEncryptionMethod.make(n & 0x18));
                    }
                    catch (InvalidEnumException invalidEnumException) {
                        Log.getLog((String)"wifi").error("Could not create wep encryption enum with ordinal: " + xElem.geti("encryption"));
                        invalidEnumException.printStackTrace();
                        ((BWifiWEPSettings)bWifiSecuritySettings).setEncryption(BWifiEncryptionMethod.unknown);
                    }
                    ((BWifiWEPSettings)bWifiSecuritySettings).setKey1(xElem.get("key1", ""));
                    ((BWifiWEPSettings)bWifiSecuritySettings).setKey2(xElem.get("key2", ""));
                    ((BWifiWEPSettings)bWifiSecuritySettings).setKey3(xElem.get("key3", ""));
                    ((BWifiWEPSettings)bWifiSecuritySettings).setKey4(xElem.get("key4", ""));
                    ((BWifiWEPSettings)bWifiSecuritySettings).setKeyIndex(xElem.geti("index", 0));
                    break block16;
                }
                if (bWifiSecuritySettings.getPolicy() == BWifiSecurityPolicy.wpa) {
                    ((BWifiWPASettings)bWifiSecuritySettings).setSupported(xElem.getb("supported", false));
                    ((BWifiWPASettings)bWifiSecuritySettings).setUse(xElem.getb("use", false));
                    ((BWifiWPASettings)bWifiSecuritySettings).setAuthentication(BWifiAuthenticationMethod.make(xElem.geti("authentication", 4)));
                    try {
                        ((BWifiWPASettings)bWifiSecuritySettings).setEncryption(BWifiEncryptionMethod.make(xElem.geti("encryption", 30)));
                    }
                    catch (InvalidEnumException invalidEnumException) {
                        Log.getLog((String)"wifi").error("Could not create wpa encryption enum with ordinal: " + xElem.geti("encryption"));
                        invalidEnumException.printStackTrace();
                        ((BWifiWPASettings)bWifiSecuritySettings).setEncryption(BWifiEncryptionMethod.unknown);
                    }
                    ((BWifiWPASettings)bWifiSecuritySettings).setEap(BWifiEAPMethod.make(xElem.geti("eap", 1)));
                    ((BWifiWPASettings)bWifiSecuritySettings).setEapIdentity(xElem.get("eapIdentity", ""));
                    ((BWifiWPASettings)bWifiSecuritySettings).setEapAnonymousIdentity(xElem.get("eapAnonymousIdentity", ""));
                    string = xElem.get("eapPassword", "");
                    ((BWifiWPASettings)bWifiSecuritySettings).setEapPassword(BPassword.make((String)(string != null && !string.trim().equals("") ? LegacyStorageUtil.decode((String)string) : "")));
                    ((BWifiWPASettings)bWifiSecuritySettings).setCertAuthCertificate(xElem.get("CACertificateFile", ""));
                    ((BWifiWPASettings)bWifiSecuritySettings).setCertAuthDirectoryPath(xElem.get("CACertificateDir", ""));
                    ((BWifiWPASettings)bWifiSecuritySettings).setClientCertificate(xElem.get("clientCertificate", ""));
                    ((BWifiWPASettings)bWifiSecuritySettings).setPrivateKeyFile(xElem.get("privateKeyFile", ""));
                    string = xElem.get("privateKeyPassword", "");
                    ((BWifiWPASettings)bWifiSecuritySettings).setPrivateKeyPassword(BPassword.make((String)(string != null && !string.trim().equals("") ? LegacyStorageUtil.decode((String)string) : "")));
                    ((BWifiWPASettings)bWifiSecuritySettings).setTunnelPhase1(xElem.get("phase1", ""));
                    ((BWifiWPASettings)bWifiSecuritySettings).setTunnelPhase2(xElem.get("phase2", ""));
                    ((BWifiWPASettings)bWifiSecuritySettings).setCertAuthCertificate2(xElem.get("CACertificateFile2", ""));
                    ((BWifiWPASettings)bWifiSecuritySettings).setCertAuthDirectoryPath2(xElem.get("CACertificateDir2", ""));
                    ((BWifiWPASettings)bWifiSecuritySettings).setClientCertificate2(xElem.get("clientCertificate2", ""));
                    ((BWifiWPASettings)bWifiSecuritySettings).setPrivateKeyFile2(xElem.get("privateKeyFile2", ""));
                    string = xElem.get("privateKeyPassword2", "");
                    ((BWifiWPASettings)bWifiSecuritySettings).setPrivateKeyPassword2(BPassword.make((String)(string != null && !string.trim().equals("") ? LegacyStorageUtil.decode((String)string) : "")));
                    break block16;
                }
                if (bWifiSecuritySettings.getPolicy() == BWifiSecurityPolicy.wpa_psk) {
                    ((BWifiWPAPSKSettings)bWifiSecuritySettings).setSupported(xElem.getb("supported", false));
                    ((BWifiWPAPSKSettings)bWifiSecuritySettings).setUse(xElem.getb("use", false));
                    ((BWifiWPAPSKSettings)bWifiSecuritySettings).setAuthentication(BWifiAuthenticationMethod.make(xElem.geti("authentication", 4)));
                    try {
                        ((BWifiWPAPSKSettings)bWifiSecuritySettings).setEncryption(BWifiEncryptionMethod.make(xElem.geti("encryption", 30)));
                    }
                    catch (InvalidEnumException invalidEnumException) {
                        Log.getLog((String)"wifi").error("Could not create wpa_psk encryption enum with ordinal: " + xElem.geti("encryption"));
                        invalidEnumException.printStackTrace();
                        ((BWifiWPAPSKSettings)bWifiSecuritySettings).setEncryption(BWifiEncryptionMethod.unknown);
                    }
                    string = xElem.get("psk", "");
                    ((BWifiWPAPSKSettings)bWifiSecuritySettings).setNetworkKey(BPassword.make((String)(string != null && !string.trim().equals("") ? LegacyStorageUtil.decode((String)string) : "")));
                    break block16;
                }
                if (bWifiSecuritySettings.getPolicy() == BWifiSecurityPolicy.wpa2) {
                    ((BWifiWPA2Settings)bWifiSecuritySettings).setSupported(xElem.getb("supported", false));
                    ((BWifiWPA2Settings)bWifiSecuritySettings).setUse(xElem.getb("use", false));
                    ((BWifiWPA2Settings)bWifiSecuritySettings).setAuthentication(BWifiAuthenticationMethod.make(xElem.geti("authentication", 4)));
                    try {
                        ((BWifiWPA2Settings)bWifiSecuritySettings).setEncryption(BWifiEncryptionMethod.make(xElem.geti("encryption", 30)));
                    }
                    catch (InvalidEnumException invalidEnumException) {
                        Log.getLog((String)"wifi").error("Could not create wpa2 encryption enum with ordinal: " + xElem.geti("encryption"));
                        invalidEnumException.printStackTrace();
                        ((BWifiWPA2Settings)bWifiSecuritySettings).setEncryption(BWifiEncryptionMethod.unknown);
                    }
                    ((BWifiWPA2Settings)bWifiSecuritySettings).setEap(BWifiEAPMethod.make(xElem.geti("eap", 1)));
                    ((BWifiWPA2Settings)bWifiSecuritySettings).setEapIdentity(xElem.get("eapIdentity", ""));
                    ((BWifiWPA2Settings)bWifiSecuritySettings).setEapAnonymousIdentity(xElem.get("eapAnonymousIdentity", ""));
                    string = xElem.get("eapPassword", "");
                    ((BWifiWPA2Settings)bWifiSecuritySettings).setEapPassword(BPassword.make((String)(string != null && !string.trim().equals("") ? LegacyStorageUtil.decode((String)string) : "")));
                    ((BWifiWPA2Settings)bWifiSecuritySettings).setCertAuthCertificate(xElem.get("CACertificateFile", ""));
                    ((BWifiWPA2Settings)bWifiSecuritySettings).setCertAuthDirectoryPath(xElem.get("CACertificateDir", ""));
                    ((BWifiWPA2Settings)bWifiSecuritySettings).setClientCertificate(xElem.get("clientCertificate", ""));
                    ((BWifiWPA2Settings)bWifiSecuritySettings).setPrivateKeyFile(xElem.get("privateKeyFile", ""));
                    string = xElem.get("privateKeyPassword", "");
                    ((BWifiWPA2Settings)bWifiSecuritySettings).setPrivateKeyPassword(BPassword.make((String)(string != null && !string.trim().equals("") ? LegacyStorageUtil.decode((String)string) : "")));
                    ((BWifiWPA2Settings)bWifiSecuritySettings).setTunnelPhase1(xElem.get("phase1", ""));
                    ((BWifiWPA2Settings)bWifiSecuritySettings).setTunnelPhase2(xElem.get("phase2", ""));
                    ((BWifiWPA2Settings)bWifiSecuritySettings).setCertAuthCertificate2(xElem.get("CACertificateFile2", ""));
                    ((BWifiWPA2Settings)bWifiSecuritySettings).setCertAuthDirectoryPath2(xElem.get("CACertificateDir2", ""));
                    ((BWifiWPA2Settings)bWifiSecuritySettings).setClientCertificate2(xElem.get("clientCertificate2", ""));
                    ((BWifiWPA2Settings)bWifiSecuritySettings).setPrivateKeyFile2(xElem.get("privateKeyFile2", ""));
                    string = xElem.get("privateKeyPassword2", "");
                    ((BWifiWPA2Settings)bWifiSecuritySettings).setPrivateKeyPassword2(BPassword.make((String)(string != null && !string.trim().equals("") ? LegacyStorageUtil.decode((String)string) : "")));
                    break block16;
                }
                if (bWifiSecuritySettings.getPolicy() != BWifiSecurityPolicy.wpa2_psk) break block16;
                ((BWifiWPA2PSKSettings)bWifiSecuritySettings).setSupported(xElem.getb("supported", false));
                ((BWifiWPA2PSKSettings)bWifiSecuritySettings).setUse(xElem.getb("use", false));
                ((BWifiWPA2PSKSettings)bWifiSecuritySettings).setAuthentication(BWifiAuthenticationMethod.make(xElem.geti("authentication", 4)));
                try {
                    ((BWifiWPA2PSKSettings)bWifiSecuritySettings).setEncryption(BWifiEncryptionMethod.make(xElem.geti("encryption", 30)));
                }
                catch (InvalidEnumException invalidEnumException) {
                    Log.getLog((String)"wifi").error("Could not create wpa2_psk encryption enum with ordinal: " + xElem.geti("encryption"));
                    invalidEnumException.printStackTrace();
                    ((BWifiWPA2PSKSettings)bWifiSecuritySettings).setEncryption(BWifiEncryptionMethod.unknown);
                }
                string = xElem.get("psk", "");
                ((BWifiWPA2PSKSettings)bWifiSecuritySettings).setNetworkKey(BPassword.make((String)(string != null && !string.trim().equals("") ? LegacyStorageUtil.decode((String)string) : "")));
            }
            catch (IOException iOException) {}
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class UpdateWifiHostSettingsMessage
    extends XmlResponseMessage {
        private StringBuffer path = new StringBuffer("wifi?updateHostSettings=true");

        public String getMessageString() {
            return this.path.toString();
        }

        public UpdateWifiHostSettingsMessage(BWifiHostSettings bWifiHostSettings) {
            this.path.append("&wifiEnabled=").append(bWifiHostSettings.getIsWifiEnabled() ? "true" : "false");
            this.path.append("&currentDaemonState=").append(bWifiHostSettings.getDaemonState().getOrdinal());
            this.path.append("&currentNetwork=").append(bWifiHostSettings.getCurrentNetworkSsid() == null ? "" : HttpUtil.encodeUrl((String)bWifiHostSettings.getCurrentNetworkSsid()));
            this.path.append("&adapter=").append(HttpUtil.encodeUrl((String)bWifiHostSettings.getAdapterName()));
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class UpdateWifiNetworkMessage
    extends XmlResponseMessage {
        private StringBuffer path;
        static /* synthetic */ Class class$com$tridium$platwifi$security$BWifiSecurityPolicy;
        static /* synthetic */ Class class$com$tridium$platwifi$security$BWifiSecuritySettings;

        public String getMessageString() {
            String string = this.path.toString();
            return string;
        }

        static /* synthetic */ Class class(String string, boolean bl) {
            try {
                Class<?> clazz = Class.forName(string);
                if (!bl) {
                    clazz = clazz.getComponentType();
                }
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }

        /*
         * Unable to fully structure code
         */
        public UpdateWifiNetworkMessage(String var1_1, BWifiNetwork var2_2) {
            block17: {
                block16: {
                    super();
                    this.path = new StringBuffer("wifi?updateNetworkSettings=true");
                    this.path.append("&adapter=").append(HttpUtil.encodeUrl((String)var1_1));
                    this.path.append("&ssid=").append(HttpUtil.encodeUrl((String)var2_2.getSsid()));
                    this.path.append("&bssid=").append(HttpUtil.encodeUrl((String)var2_2.getBssid()));
                    this.path.append("&ssidBroadcasted=").append(String.valueOf(var2_2.getSsidBroadcasted()));
                    this.path.append("&mode=").append(var2_2.getMode().getOrdinal());
                    this.path.append("&channel=").append(var2_2.getChannel());
                    this.path.append("&strength=").append(var2_2.getSignalStrength());
                    this.path.append("&priority=").append(var2_2.getPriority());
                    this.path.append("&status=").append(var2_2.getNetworkState().getOrdinal());
                    var3_3 = new StringBuffer();
                    var4_4 = var2_2.getSecuritySupported().loadSlots().getProperties();
                    if (true) ** GOTO lbl30
                    do {
                        if (var3_3.length() > 0) {
                            var3_3.append("%2C");
                        }
                        var3_3.append(HttpUtil.encodeUrl((String)((BWifiSecurityPolicy)var4_4.get()).getTag()));
lbl30:
                        // 2 sources

                        if ((v0 = UpdateWifiNetworkMessage.class$com$tridium$platwifi$security$BWifiSecurityPolicy) != null) continue;
                        v0 = UpdateWifiNetworkMessage.class("[Lcom.tridium.platwifi.security.BWifiSecurityPolicy;", false);
                    } while (var4_4.next(v0));
                    this.path.append("&securitySupported=").append(var3_3.toString());
                    var4_4 = new StringBuffer();
                    if (var2_2.getSecurityConfigurations().loadSlots().getSlotCount() != 0) break block16;
                    var4_4.append("noneSupported=").append("true");
                    var4_4.append("&useNone=").append("true");
                    var4_4.append("&protocol=").append(3);
                    var4_4.append("&authentication=").append(1);
                    var4_4.append("&encryption=").append(1);
                    var4_4.append("&key_mgmt=").append(1);
                    break block17;
                }
                var5_5 = var2_2.getSecurityConfigurations().loadSlots().getProperties();
                if (true) ** GOTO lbl213
                do {
                    if ((var6_6 = (BWifiSecuritySettings)var5_5.get()).getUse()) {
                        try {
                            if (var6_6.getPolicy() != BWifiSecurityPolicy.none) {
                                if (var6_6.getPolicy() == BWifiSecurityPolicy.wep) {
                                    var7_7 = (BWifiWEPSettings)var6_6;
                                    var4_4.append("&wepSupported=").append(var7_7.getSupported() != false ? "true" : "false");
                                    var4_4.append("&useWep=").append(var7_7.getUse() != false ? "true" : "false");
                                    var4_4.append("&protocol=").append(3);
                                    var4_4.append("&authentication=").append(var7_7.getAuthentication().getOrdinal());
                                    var4_4.append("&encryption=").append(var7_7.getEncryption().getOrdinal());
                                    var4_4.append("&key_mgmt=").append(1);
                                    var4_4.append("&key1=").append(HttpUtil.encodeUrl((String)var7_7.getKey1()));
                                    var4_4.append("&key2=").append(HttpUtil.encodeUrl((String)var7_7.getKey2()));
                                    var4_4.append("&key3=").append(HttpUtil.encodeUrl((String)var7_7.getKey3()));
                                    var4_4.append("&key4=").append(HttpUtil.encodeUrl((String)var7_7.getKey4()));
                                    var4_4.append("&index=").append(var7_7.getKeyIndex() - 1);
                                } else if (var6_6.getPolicy() == BWifiSecurityPolicy.wpa) {
                                    var7_7 = (BWifiWPASettings)var6_6;
                                    var4_4.append("&wpaSupported=").append(var7_7.getSupported() != false ? "true" : "false");
                                    var4_4.append("&useWpa=").append(var7_7.getUse() != false ? "true" : "false");
                                    var4_4.append("&protocol=").append(1);
                                    var4_4.append("&authentication=").append(var7_7.getAuthentication().getOrdinal());
                                    var4_4.append("&key_mgmt=").append(4);
                                    var4_4.append("&encryption=").append(var7_7.getEncryption().getOrdinal());
                                    var4_4.append("&eap=").append(var7_7.getEap().getOrdinal());
                                    var4_4.append("&eapIdentity=").append(HttpUtil.encodeUrl((String)var7_7.getEapIdentity()));
                                    var4_4.append("&eapAnonymousIdentity=").append(HttpUtil.encodeUrl((String)var7_7.getEapAnonymousIdentity()));
                                    var4_4.append("&eapPassword=").append(HttpUtil.encodeUrl((String)var7_7.getEapPassword().encodeToString()));
                                    var4_4.append("&privateKeyPassword=").append(HttpUtil.encodeUrl((String)var7_7.getPrivateKeyPassword().encodeToString()));
                                    var4_4.append("&CACertificateFile=").append(HttpUtil.encodeUrl((String)var7_7.getCertAuthCertificate()));
                                    var4_4.append("&CACertificateDir=").append(HttpUtil.encodeUrl((String)var7_7.getCertAuthDirectoryPath()));
                                    var4_4.append("&clientCertificate=").append(HttpUtil.encodeUrl((String)var7_7.getClientCertificate()));
                                    var4_4.append("&privateKeyFile=").append(HttpUtil.encodeUrl((String)var7_7.getPrivateKeyFile()));
                                    var4_4.append("&phase1=").append(HttpUtil.encodeUrl((String)var7_7.getTunnelPhase1()));
                                    var4_4.append("&phase2=").append(HttpUtil.encodeUrl((String)var7_7.getTunnelPhase2()));
                                    var4_4.append("&privateKeyPassword2=").append(HttpUtil.encodeUrl((String)var7_7.getPrivateKeyPassword2().encodeToString()));
                                    var4_4.append("&CACertificateFile2=").append(HttpUtil.encodeUrl((String)var7_7.getCertAuthCertificate2()));
                                    var4_4.append("&CACertificateDir2=").append(HttpUtil.encodeUrl((String)var7_7.getCertAuthDirectoryPath2()));
                                    var4_4.append("&clientCertificate2=").append(HttpUtil.encodeUrl((String)var7_7.getClientCertificate2()));
                                    var4_4.append("&privateKeyFile2=").append(HttpUtil.encodeUrl((String)var7_7.getPrivateKeyFile2()));
                                } else if (var6_6.getPolicy() == BWifiSecurityPolicy.wpa_psk) {
                                    var7_7 = (BWifiWPAPSKSettings)var6_6;
                                    var4_4.append("&wpapskSupported=").append(var7_7.getSupported() != false ? "true" : "false");
                                    var4_4.append("&useWpapsk=").append(var7_7.getUse() != false ? "true" : "false");
                                    var4_4.append("&protocol=").append(1);
                                    var4_4.append("&authentication=").append(var7_7.getAuthentication().getOrdinal());
                                    var4_4.append("&key_mgmt=").append(2);
                                    var4_4.append("&encryption=").append(var7_7.getEncryption().getOrdinal());
                                    var4_4.append("&psk=").append(HttpUtil.encodeUrl((String)var7_7.getNetworkKey().encodeToString()));
                                } else if (var6_6.getPolicy() == BWifiSecurityPolicy.wpa2) {
                                    var7_7 = (BWifiWPA2Settings)var6_6;
                                    var4_4.append("&wpa2Supported=").append(var7_7.getSupported() != false ? "true" : "false");
                                    var4_4.append("&useWpa2=").append(var7_7.getUse() != false ? "true" : "false");
                                    var4_4.append("&protocol=").append(2);
                                    var4_4.append("&authentication=").append(var7_7.getAuthentication().getOrdinal());
                                    var4_4.append("&key_mgmt=").append(4);
                                    var4_4.append("&encryption=").append(var7_7.getEncryption().getOrdinal());
                                    var4_4.append("&eap=").append(var7_7.getEap().getOrdinal());
                                    var4_4.append("&eapIdentity=").append(HttpUtil.encodeUrl((String)var7_7.getEapIdentity()));
                                    var4_4.append("&eapAnonymousIdentity=").append(HttpUtil.encodeUrl((String)var7_7.getEapAnonymousIdentity()));
                                    var4_4.append("&eapPassword=").append(HttpUtil.encodeUrl((String)var7_7.getEapPassword().encodeToString()));
                                    var4_4.append("&privateKeyPassword=").append(HttpUtil.encodeUrl((String)var7_7.getPrivateKeyPassword().encodeToString()));
                                    var4_4.append("&CACertificateFile=").append(HttpUtil.encodeUrl((String)var7_7.getCertAuthCertificate()));
                                    var4_4.append("&CACertificateDir=").append(HttpUtil.encodeUrl((String)var7_7.getCertAuthDirectoryPath()));
                                    var4_4.append("&clientCertificate=").append(HttpUtil.encodeUrl((String)var7_7.getClientCertificate()));
                                    var4_4.append("&privateKeyFile=").append(HttpUtil.encodeUrl((String)var7_7.getPrivateKeyFile()));
                                    var4_4.append("&phase1=").append(HttpUtil.encodeUrl((String)var7_7.getTunnelPhase1()));
                                    var4_4.append("&phase2=").append(HttpUtil.encodeUrl((String)var7_7.getTunnelPhase2()));
                                    var4_4.append("&privateKeyPassword2=").append(HttpUtil.encodeUrl((String)var7_7.getPrivateKeyPassword2().encodeToString()));
                                    var4_4.append("&CACertificateFile2=").append(HttpUtil.encodeUrl((String)var7_7.getCertAuthCertificate2()));
                                    var4_4.append("&CACertificateDir2=").append(HttpUtil.encodeUrl((String)var7_7.getCertAuthDirectoryPath2()));
                                    var4_4.append("&clientCertificate2=").append(HttpUtil.encodeUrl((String)var7_7.getClientCertificate2()));
                                    var4_4.append("&privateKeyFile2=").append(HttpUtil.encodeUrl((String)var7_7.getPrivateKeyFile2()));
                                } else if (var6_6.getPolicy() == BWifiSecurityPolicy.wpa2_psk) {
                                    var7_7 = (BWifiWPA2PSKSettings)var6_6;
                                    var4_4.append("&wpa2pskSupported=").append(var7_7.getSupported() != false ? "true" : "false");
                                    var4_4.append("&useWpa2psk=").append(var7_7.getUse() != false ? "true" : "false");
                                    var4_4.append("&protocol=").append(2);
                                    var4_4.append("&authentication=").append(var7_7.getAuthentication().getOrdinal());
                                    var4_4.append("&key_mgmt=").append(2);
                                    var4_4.append("&encryption=").append(var7_7.getEncryption().getOrdinal());
                                    var4_4.append("&psk=").append(HttpUtil.encodeUrl((String)var7_7.getNetworkKey().encodeToString()));
                                }
                            }
                        }
                        catch (IOException var7_8) {
                            System.err.println("Error generating WiFi Network XML");
                            var7_8.printStackTrace();
                        }
                    }
lbl213:
                    // 9 sources

                    if ((v1 = UpdateWifiNetworkMessage.class$com$tridium$platwifi$security$BWifiSecuritySettings) != null) continue;
                    v1 = UpdateWifiNetworkMessage.class("[Lcom.tridium.platwifi.security.BWifiSecuritySettings;", false);
                } while (var5_5.next(v1));
            }
            this.path.append(var4_4.toString());
        }
    }

    public static class PersistWifiNetworkSettings
    extends XmlResponseMessage {
        private StringBuffer path = new StringBuffer("wifi?saveWifiSettings=true");

        public String getMessageString() {
            return this.path.toString();
        }

        public PersistWifiNetworkSettings(String string) {
            this.path.append("&adapter=").append(HttpUtil.encodeUrl((String)string));
        }
    }

    public static class AddRemoveWifiNetworkMessage
    extends XmlResponseMessage {
        private StringBuffer path;

        public String getMessageString() {
            return this.path.toString();
        }

        public AddRemoveWifiNetworkMessage(String string, BWifiNetwork bWifiNetwork, boolean bl) {
            this.path = bl ? new StringBuffer("wifi?addWifiNetwork=true") : new StringBuffer("wifi?removeWifiNetwork=true");
            this.path.append("&adapter=").append(HttpUtil.encodeUrl((String)string));
            this.path.append("&ssid=").append(HttpUtil.encodeUrl((String)bWifiNetwork.getSsid()));
            this.path.append("&strength=").append(bWifiNetwork.getSignalStrength());
            this.path.append("&status=").append(bWifiNetwork.getNetworkState().getOrdinal());
        }
    }

    public static class DisconnectNetworkMessage
    extends XmlResponseMessage {
        private StringBuffer path = new StringBuffer("wifi?disconnectWifiNetworks=true");

        public String getMessageString() {
            return this.path.toString();
        }

        public DisconnectNetworkMessage(String string, String string2) {
            this.path.append("&adapter=").append(HttpUtil.encodeUrl((String)string));
            this.path.append("&ssid=").append(HttpUtil.encodeUrl((String)string2));
        }
    }

    public static class ConnectNetworkMessage
    extends XmlResponseMessage {
        private StringBuffer path = new StringBuffer("wifi?connectToWifiNetwork=true");

        public String getMessageString() {
            return this.path.toString();
        }

        public ConnectNetworkMessage(String string, String string2) {
            this.path.append("&adapter=").append(HttpUtil.encodeUrl((String)string));
            this.path.append("&ssid=").append(HttpUtil.encodeUrl((String)string2));
        }
    }
}

