/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platwifi;

import com.tridium.nre.util.LegacyStorageUtil;
import com.tridium.platform.BOperatingSystemEnum;
import com.tridium.platform.BPlatformService;
import com.tridium.platwifi.BWifiCommandArgs;
import com.tridium.platwifi.BWifiHostSettings;
import com.tridium.platwifi.BWifiNetwork;
import com.tridium.platwifi.BWifiNetworkMode;
import com.tridium.platwifi.BWifiNetworkVector;
import com.tridium.platwifi.WifiPlatformLibrary;
import com.tridium.platwifi.security.BWifiAuthenticationMethod;
import com.tridium.platwifi.security.BWifiEAPMethod;
import com.tridium.platwifi.security.BWifiEncryptionMethod;
import com.tridium.platwifi.security.BWifiSecurityPolicy;
import com.tridium.platwifi.security.BWifiSecuritySettings;
import com.tridium.platwifi.security.BWifiWEPSettings;
import com.tridium.platwifi.security.BWifiWPA2PSKSettings;
import com.tridium.platwifi.security.BWifiWPA2Settings;
import com.tridium.platwifi.security.BWifiWPAPSKSettings;
import com.tridium.platwifi.security.BWifiWPASettings;
import com.tridium.platwifi.status.BWifiDaemonStateEnum;
import com.tridium.platwifi.status.BWifiNetworkStateEnum;
import java.io.File;
import java.util.HashSet;
import javax.baja.data.BIDataValue;
import javax.baja.log.Log;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.Array;
import javax.baja.security.BPassword;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.InvalidEnumException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BWifiPlatformService
extends BPlatformService {
    public static final Property settings = BWifiPlatformService.newProperty((int)3, (BValue)new BWifiHostSettings(), null);
    public static final Action discoverNetworks = BWifiPlatformService.newAction((int)4, (BValue)BString.make((String)"Enter wireless adapter"), null);
    public static final Action addNetwork = BWifiPlatformService.newAction((int)4, (BValue)new BWifiCommandArgs(), null);
    public static final Action removeNetwork = BWifiPlatformService.newAction((int)4, (BValue)new BWifiCommandArgs(), null);
    public static final Action disconnectFromNetwork = BWifiPlatformService.newAction((int)4, (BValue)new BWifiCommandArgs(), null);
    public static final Action connectToNetwork = BWifiPlatformService.newAction((int)4, (BValue)new BWifiCommandArgs(), null);
    public static final Action roamNetworks = BWifiPlatformService.newAction((int)4, (BValue)new BWifiCommandArgs(), null);
    public static final Action hashCACertificates = BWifiPlatformService.newAction((int)4, null);
    public static final Type TYPE;
    private static final BIcon icon;
    protected static final Log log;
    private boolean refreshRequired;
    static /* synthetic */ Class class$com$tridium$platwifi$BWifiPlatformService;
    static /* synthetic */ Class class$com$tridium$platwifi$BWifiNetwork;
    static /* synthetic */ Class class$com$tridium$platwifi$security$BWifiSecuritySettings;

    public BWifiHostSettings getSettings() {
        return (BWifiHostSettings)this.get(settings);
    }

    public void setSettings(BWifiHostSettings bWifiHostSettings) {
        this.set(settings, (BValue)bWifiHostSettings, null);
    }

    public BWifiNetworkVector discoverNetworks(BString bString) {
        return (BWifiNetworkVector)this.invoke(discoverNetworks, (BValue)bString, null);
    }

    public BBoolean addNetwork(BWifiCommandArgs bWifiCommandArgs) {
        return (BBoolean)this.invoke(addNetwork, (BValue)bWifiCommandArgs, null);
    }

    public BBoolean removeNetwork(BWifiCommandArgs bWifiCommandArgs) {
        return (BBoolean)this.invoke(removeNetwork, (BValue)bWifiCommandArgs, null);
    }

    public BBoolean disconnectFromNetwork(BWifiCommandArgs bWifiCommandArgs) {
        return (BBoolean)this.invoke(disconnectFromNetwork, (BValue)bWifiCommandArgs, null);
    }

    public BBoolean connectToNetwork(BWifiCommandArgs bWifiCommandArgs) {
        return (BBoolean)this.invoke(connectToNetwork, (BValue)bWifiCommandArgs, null);
    }

    public BBoolean roamNetworks(BWifiCommandArgs bWifiCommandArgs) {
        return (BBoolean)this.invoke(roamNetworks, (BValue)bWifiCommandArgs, null);
    }

    public BBoolean hashCACertificates() {
        return (BBoolean)this.invoke(hashCACertificates, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BRelTime getPollFrequency() {
        return BRelTime.makeSeconds((int)3);
    }

    public void serviceStopped() {
        if (!WifiPlatformLibrary.load()) {
            return;
        }
        BWifiPlatformService.unloadWifiSettings0();
        log.trace("wifi service stopped");
    }

    public void serviceStarted() {
        log.trace("wifi service started");
    }

    protected boolean startPollTimerOnSubscribe() {
        return true;
    }

    public boolean isValidPlatform() {
        if (BOperatingSystemEnum.isOS((BOperatingSystemEnum)BOperatingSystemEnum.qnx) || BOperatingSystemEnum.isOS((BOperatingSystemEnum)BOperatingSystemEnum.linux)) {
            return new File("/var/run/wpa_supplicant.pid").exists();
        }
        return false;
    }

    public int getSlotFlags() {
        return 0;
    }

    /*
     * Unable to fully structure code
     */
    public void doSavePlatformServiceProperties() throws Exception {
        if (!this.isRunning()) {
            return;
        }
        if (!WifiPlatformLibrary.load()) {
            return;
        }
        super.doSavePlatformServiceProperties();
        var1_1 = null;
        var2_2 = null;
        var3_3 = null;
        var4_4 = null;
        var5_5 = null;
        var6_6 = null;
        var7_7 = this.getSettings().getAdapterName();
        var8_8 = this.getSettings().getNetworkDatabase();
        var9_9 = var8_8.loadSlots().getProperties();
        if (true) ** GOTO lbl183
        do {
            block17: {
                block16: {
                    var10_10 = (BWifiNetwork)var9_9.get();
                    BWifiPlatformService.setSsidBroadcasted0(var7_7, var10_10.getSsid(), var10_10.getSsidBroadcasted());
                    BWifiPlatformService.setPreferredBssid0(var7_7, var10_10.getSsid(), var10_10.getBssid());
                    BWifiPlatformService.setSignalStrength0(var7_7, var10_10.getSsid(), var10_10.getSignalStrength());
                    BWifiPlatformService.setPriority0(var7_7, var10_10.getSsid(), var10_10.getPriority());
                    BWifiPlatformService.setNetworkStatus0(var7_7, var10_10.getSsid(), var10_10.getNetworkState().getOrdinal());
                    BWifiPlatformService.setNetworkMode0(var7_7, var10_10.getSsid(), var10_10.getMode().getOrdinal());
                    var11_11 = var10_10.getSecurityConfigurations();
                    if (var11_11.getSlotCount() < 1) break block16;
                    var12_12 = var11_11.loadSlots().getProperties();
                    if (true) ** GOTO lbl170
                    do {
                        if ((var1_1 = (BWifiSecuritySettings)var12_12.get()).getUse()) {
                            if (var1_1 instanceof BWifiWEPSettings) {
                                var2_2 = (BWifiWEPSettings)var1_1;
                                BWifiPlatformService.setAuthentication0(var7_7, var10_10.getSsid(), var2_2.getAuthentication().getOrdinal());
                                BWifiPlatformService.setEncryption0(var7_7, var10_10.getSsid(), var2_2.getEncryption().getOrdinal());
                                BWifiPlatformService.setKeyManagement0(var7_7, var10_10.getSsid(), 1);
                                BWifiPlatformService.setProtocol0(var7_7, var10_10.getSsid(), 3);
                                BWifiPlatformService.setWepIndex0(var7_7, var10_10.getSsid(), var2_2.getKeyIndex() - 1);
                                BWifiPlatformService.setWepKey0(var7_7, var10_10.getSsid(), 0, var2_2.getKey1());
                                BWifiPlatformService.setWepKey0(var7_7, var10_10.getSsid(), 1, var2_2.getKey2());
                                BWifiPlatformService.setWepKey0(var7_7, var10_10.getSsid(), 2, var2_2.getKey3());
                                BWifiPlatformService.setWepKey0(var7_7, var10_10.getSsid(), 3, var2_2.getKey4());
                            } else if (var1_1 instanceof BWifiWPA2Settings) {
                                var4_4 = (BWifiWPA2Settings)var1_1;
                                BWifiPlatformService.setAuthentication0(var7_7, var10_10.getSsid(), var4_4.getAuthentication().getOrdinal());
                                BWifiPlatformService.setEncryption0(var7_7, var10_10.getSsid(), var4_4.getEncryption().getOrdinal());
                                BWifiPlatformService.setKeyManagement0(var7_7, var10_10.getSsid(), 4);
                                BWifiPlatformService.setProtocol0(var7_7, var10_10.getSsid(), 2);
                                BWifiPlatformService.setEAPMethod0(var7_7, var10_10.getSsid(), var4_4.getEap().getOrdinal());
                                BWifiPlatformService.setEAPIdentity0(var7_7, var10_10.getSsid(), var4_4.getEapIdentity());
                                BWifiPlatformService.setEAPAnonymousIdentity0(var7_7, var10_10.getSsid(), var4_4.getEapAnonymousIdentity());
                                BWifiPlatformService.setEAPPassword0(var7_7, var10_10.getSsid(), var4_4.getEapPassword().encodeToString());
                                BWifiPlatformService.setCACertificate0(var7_7, var10_10.getSsid(), var4_4.getCertAuthCertificate());
                                BWifiPlatformService.setCACertificateDir0(var7_7, var10_10.getSsid(), var4_4.getCertAuthDirectoryPath());
                                BWifiPlatformService.setClientCertificate0(var7_7, var10_10.getSsid(), var4_4.getClientCertificate());
                                BWifiPlatformService.setPrivateKeyFile0(var7_7, var10_10.getSsid(), var4_4.getPrivateKeyFile());
                                BWifiPlatformService.setPrivateKeyPassword0(var7_7, var10_10.getSsid(), var4_4.getPrivateKeyPassword().encodeToString());
                                BWifiPlatformService.setTunnelPhase10(var7_7, var10_10.getSsid(), var4_4.getTunnelPhase1());
                                BWifiPlatformService.setTunnelPhase20(var7_7, var10_10.getSsid(), var4_4.getTunnelPhase2());
                                BWifiPlatformService.setCACertificate20(var7_7, var10_10.getSsid(), var4_4.getCertAuthCertificate2());
                                BWifiPlatformService.setCACertificateDir20(var7_7, var10_10.getSsid(), var4_4.getCertAuthDirectoryPath2());
                                BWifiPlatformService.setClientCertificate20(var7_7, var10_10.getSsid(), var4_4.getClientCertificate2());
                                BWifiPlatformService.setPrivateKeyFile20(var7_7, var10_10.getSsid(), var4_4.getPrivateKeyFile2());
                                BWifiPlatformService.setPrivateKeyPassword20(var7_7, var10_10.getSsid(), var4_4.getPrivateKeyPassword2().encodeToString());
                            } else if (var1_1 instanceof BWifiWPASettings) {
                                var3_3 = (BWifiWPASettings)var1_1;
                                BWifiPlatformService.setAuthentication0(var7_7, var10_10.getSsid(), var3_3.getAuthentication().getOrdinal());
                                BWifiPlatformService.setEncryption0(var7_7, var10_10.getSsid(), var3_3.getEncryption().getOrdinal());
                                BWifiPlatformService.setKeyManagement0(var7_7, var10_10.getSsid(), 4);
                                BWifiPlatformService.setProtocol0(var7_7, var10_10.getSsid(), 1);
                                BWifiPlatformService.setEAPMethod0(var7_7, var10_10.getSsid(), var3_3.getEap().getOrdinal());
                                BWifiPlatformService.setEAPIdentity0(var7_7, var10_10.getSsid(), var3_3.getEapIdentity());
                                BWifiPlatformService.setEAPAnonymousIdentity0(var7_7, var10_10.getSsid(), var3_3.getEapAnonymousIdentity());
                                BWifiPlatformService.setEAPPassword0(var7_7, var10_10.getSsid(), var3_3.getEapPassword().encodeToString());
                                BWifiPlatformService.setCACertificate0(var7_7, var10_10.getSsid(), var3_3.getCertAuthCertificate());
                                BWifiPlatformService.setCACertificateDir0(var7_7, var10_10.getSsid(), var3_3.getCertAuthDirectoryPath());
                                BWifiPlatformService.setClientCertificate0(var7_7, var10_10.getSsid(), var3_3.getClientCertificate());
                                BWifiPlatformService.setPrivateKeyFile0(var7_7, var10_10.getSsid(), var3_3.getPrivateKeyFile());
                                BWifiPlatformService.setPrivateKeyPassword0(var7_7, var10_10.getSsid(), var3_3.getPrivateKeyPassword().encodeToString());
                                BWifiPlatformService.setTunnelPhase10(var7_7, var10_10.getSsid(), var3_3.getTunnelPhase1());
                                BWifiPlatformService.setTunnelPhase20(var7_7, var10_10.getSsid(), var3_3.getTunnelPhase2());
                                BWifiPlatformService.setCACertificate20(var7_7, var10_10.getSsid(), var3_3.getCertAuthCertificate2());
                                BWifiPlatformService.setCACertificateDir20(var7_7, var10_10.getSsid(), var3_3.getCertAuthDirectoryPath2());
                                BWifiPlatformService.setClientCertificate20(var7_7, var10_10.getSsid(), var3_3.getClientCertificate2());
                                BWifiPlatformService.setPrivateKeyFile20(var7_7, var10_10.getSsid(), var3_3.getPrivateKeyFile2());
                                BWifiPlatformService.setPrivateKeyPassword20(var7_7, var10_10.getSsid(), var3_3.getPrivateKeyPassword2().encodeToString());
                            } else if (var1_1 instanceof BWifiWPA2PSKSettings) {
                                var6_6 = (BWifiWPA2PSKSettings)var1_1;
                                if (var6_6.getNetworkKey().getValue().length() != 0) {
                                    BWifiPlatformService.setPreSharedKey0(var7_7, var10_10.getSsid(), var6_6.getNetworkKey().encodeToString());
                                }
                                BWifiPlatformService.setEncryption0(var7_7, var10_10.getSsid(), var6_6.getEncryption().getOrdinal());
                                BWifiPlatformService.setAuthentication0(var7_7, var10_10.getSsid(), var6_6.getAuthentication().getOrdinal());
                                BWifiPlatformService.setKeyManagement0(var7_7, var10_10.getSsid(), 2);
                                BWifiPlatformService.setProtocol0(var7_7, var10_10.getSsid(), 2);
                            } else if (var1_1 instanceof BWifiWPAPSKSettings) {
                                var5_5 = (BWifiWPAPSKSettings)var1_1;
                                if (var5_5.getNetworkKey().getValue().length() != 0) {
                                    BWifiPlatformService.setPreSharedKey0(var7_7, var10_10.getSsid(), var5_5.getNetworkKey().encodeToString());
                                }
                                BWifiPlatformService.setEncryption0(var7_7, var10_10.getSsid(), var5_5.getEncryption().getOrdinal());
                                BWifiPlatformService.setAuthentication0(var7_7, var10_10.getSsid(), var5_5.getAuthentication().getOrdinal());
                                BWifiPlatformService.setKeyManagement0(var7_7, var10_10.getSsid(), 2);
                                BWifiPlatformService.setProtocol0(var7_7, var10_10.getSsid(), 1);
                            }
                        }
lbl170:
                        // 10 sources

                        if ((v0 = BWifiPlatformService.class$com$tridium$platwifi$security$BWifiSecuritySettings) != null) continue;
                        v0 = BWifiPlatformService.class("[Lcom.tridium.platwifi.security.BWifiSecuritySettings;", false);
                    } while (var12_12.next(v0));
                    break block17;
                }
                BWifiPlatformService.setProtocol0(var7_7, var10_10.getSsid(), 3);
                BWifiPlatformService.setAuthentication0(var7_7, var10_10.getSsid(), 1);
                BWifiPlatformService.setEncryption0(var7_7, var10_10.getSsid(), 1);
                BWifiPlatformService.setKeyManagement0(var7_7, var10_10.getSsid(), 1);
            }
            if ((v1 = BWifiPlatformService.class$com$tridium$platwifi$BWifiNetwork) != null) continue;
            v1 = BWifiPlatformService.class("[Lcom.tridium.platwifi.BWifiNetwork;", false);
        } while (var9_9.next(v1));
        BWifiPlatformService.saveHostSettings0();
        BWifiPlatformService.log.trace("wifi network settings saved");
    }

    public void loadPlatformServiceProperties() {
        super.loadPlatformServiceProperties();
        if (!WifiPlatformLibrary.load()) {
            return;
        }
        this.refreshProperties();
    }

    protected synchronized void refreshProperties() {
        block90: {
            String[] stringArray;
            block79: {
                Array array;
                block80: {
                    if (!WifiPlatformLibrary.load()) {
                        return;
                    }
                    this.getSettings().setIsWifiEnabled(BWifiPlatformService.isWifiEnabled0(null));
                    stringArray = BWifiPlatformService.getWifiAdapters0();
                    if (stringArray == null || stringArray.length == 0) {
                        return;
                    }
                    this.getSettings().setAdapterName(stringArray[0]);
                    int n = BWifiPlatformService.getDaemonStatus0(stringArray[0]);
                    this.getSettings().setDaemonState(BWifiDaemonStateEnum.make(n));
                    String string = BWifiPlatformService.getCurrentNetwork0(stringArray[0]);
                    if (string == null) {
                        string = "";
                    }
                    this.getSettings().setCurrentNetworkSsid(string);
                    if (!this.refreshRequired) break block79;
                    this.refreshRequired = false;
                    String[] stringArray2 = BWifiPlatformService.getNetworkDatabaseSsids0(stringArray[0]);
                    int n2 = 0;
                    int n3 = 0;
                    int n4 = 2;
                    int n5 = 0;
                    int n6 = 0;
                    String string2 = null;
                    boolean bl = false;
                    int n7 = 0;
                    int n8 = 0;
                    int n9 = 0;
                    int n10 = 0;
                    int n11 = 0;
                    String[] stringArray3 = null;
                    String string3 = null;
                    int n12 = 0;
                    String string4 = null;
                    String string5 = null;
                    String string6 = null;
                    String string7 = null;
                    String string8 = null;
                    String string9 = null;
                    String string10 = null;
                    String string11 = null;
                    String string12 = null;
                    String string13 = null;
                    String string14 = null;
                    String string15 = null;
                    String string16 = null;
                    String string17 = null;
                    String string18 = null;
                    Class clazz = class$com$tridium$platwifi$BWifiNetwork;
                    if (clazz == null) {
                        clazz = class$com$tridium$platwifi$BWifiNetwork = BWifiPlatformService.class("[Lcom.tridium.platwifi.BWifiNetwork;", false);
                    }
                    array = new Array(clazz);
                    BWifiNetwork bWifiNetwork = null;
                    BVector bVector = null;
                    BVector bVector2 = null;
                    BWifiSecuritySettings bWifiSecuritySettings = null;
                    if (stringArray2 == null) break block80;
                    int n13 = 0;
                    while (n13 < stringArray2.length) {
                        block82: {
                            block84: {
                                boolean bl2;
                                block78: {
                                    block89: {
                                        block88: {
                                            block85: {
                                                boolean bl3;
                                                block77: {
                                                    block87: {
                                                        block86: {
                                                            block81: {
                                                                block83: {
                                                                    bVector = new BVector();
                                                                    bVector2 = new BVector();
                                                                    bWifiSecuritySettings = null;
                                                                    n2 = 0;
                                                                    n3 = 0;
                                                                    n4 = 2;
                                                                    n5 = 0;
                                                                    n6 = 0;
                                                                    string2 = null;
                                                                    bl = false;
                                                                    n7 = 0;
                                                                    n8 = 0;
                                                                    n9 = 0;
                                                                    n11 = 0;
                                                                    n10 = 0;
                                                                    stringArray3 = null;
                                                                    string3 = null;
                                                                    n12 = 0;
                                                                    string4 = null;
                                                                    string5 = null;
                                                                    string6 = null;
                                                                    string7 = null;
                                                                    string8 = null;
                                                                    string9 = null;
                                                                    string10 = null;
                                                                    string11 = null;
                                                                    string12 = null;
                                                                    string13 = null;
                                                                    string14 = null;
                                                                    string15 = null;
                                                                    string16 = null;
                                                                    string17 = null;
                                                                    string18 = null;
                                                                    bWifiNetwork = new BWifiNetwork();
                                                                    string2 = stringArray2[n13];
                                                                    bWifiNetwork.setSsid(string2 != null ? string2 : "");
                                                                    string2 = BWifiPlatformService.getBssid0(stringArray[0], stringArray2[n13]);
                                                                    bWifiNetwork.setBssid(string2 != null ? string2 : "");
                                                                    n3 = BWifiPlatformService.getChannel0(stringArray[0], stringArray2[n13]);
                                                                    bWifiNetwork.setChannel(n3);
                                                                    n4 = BWifiPlatformService.getNetworkMode0(stringArray[0], stringArray2[n13]);
                                                                    bWifiNetwork.setMode(BWifiNetworkMode.make(n4));
                                                                    n5 = BWifiPlatformService.getStrength0(stringArray[0], stringArray2[n13]);
                                                                    bWifiNetwork.setSignalStrength(n5);
                                                                    n6 = BWifiPlatformService.getPriority0(stringArray[0], stringArray2[n13]);
                                                                    bWifiNetwork.setPriority(n6);
                                                                    bl = BWifiPlatformService.getSsidBroadcasted0(stringArray[0], stringArray2[n13]);
                                                                    bWifiNetwork.setSsidBroadcasted(bl);
                                                                    n7 = BWifiPlatformService.getProtocol0(stringArray[0], stringArray2[n13]);
                                                                    n8 = BWifiPlatformService.getKeyManagement0(stringArray[0], stringArray2[n13]);
                                                                    n9 = BWifiPlatformService.getSupportedEncrytptionMethods0(stringArray[0], stringArray2[n13]);
                                                                    n11 = BWifiPlatformService.getAuthentication0(stringArray[0], stringArray2[n13]);
                                                                    if (n7 != 3) break block81;
                                                                    if (n8 != 1) break block82;
                                                                    if ((n9 & 1) == 0) break block83;
                                                                    bVector.add(SlotPath.escape((String)BWifiSecurityPolicy.none.toString()), (BValue)BWifiSecurityPolicy.none, 3);
                                                                    break block84;
                                                                }
                                                                if ((n9 & 8) == 0 && (n9 & 0x10) == 0) break block82;
                                                                stringArray3 = BWifiPlatformService.getWepKeys0(stringArray[0], stringArray2[n13]);
                                                                n10 = BWifiPlatformService.getWepIndex0(stringArray[0], stringArray2[n13]) + 1;
                                                                bVector.add(SlotPath.escape((String)BWifiSecurityPolicy.wep.toString()), (BValue)BWifiSecurityPolicy.wep, 3);
                                                                bWifiSecuritySettings = new BWifiWEPSettings();
                                                                ((BWifiWEPSettings)bWifiSecuritySettings).setSupported(true);
                                                                ((BWifiWEPSettings)bWifiSecuritySettings).setUse(true);
                                                                ((BWifiWEPSettings)bWifiSecuritySettings).setAuthentication(BWifiAuthenticationMethod.make(n11));
                                                                try {
                                                                    ((BWifiWEPSettings)bWifiSecuritySettings).setEncryption(BWifiEncryptionMethod.make(n9 & 0x18));
                                                                }
                                                                catch (InvalidEnumException invalidEnumException) {
                                                                    log.error("Could not create wep encryption enum for network \"" + stringArray2[n13] + "\" with ordinal: " + n9);
                                                                    invalidEnumException.printStackTrace();
                                                                    ((BWifiWEPSettings)bWifiSecuritySettings).setEncryption(BWifiEncryptionMethod.unknown);
                                                                }
                                                                ((BWifiWEPSettings)bWifiSecuritySettings).setKeyIndex(n10);
                                                                if (stringArray3.length >= 1) {
                                                                    ((BWifiWEPSettings)bWifiSecuritySettings).setKey1(stringArray3[0]);
                                                                }
                                                                if (stringArray3.length >= 2) {
                                                                    ((BWifiWEPSettings)bWifiSecuritySettings).setKey2(stringArray3[1]);
                                                                }
                                                                if (stringArray3.length >= 3) {
                                                                    ((BWifiWEPSettings)bWifiSecuritySettings).setKey3(stringArray3[2]);
                                                                }
                                                                if (stringArray3.length == 4) {
                                                                    ((BWifiWEPSettings)bWifiSecuritySettings).setKey4(stringArray3[3]);
                                                                }
                                                                bVector2.add(SlotPath.escape((String)BWifiSecurityPolicy.wep.toString()), (BValue)bWifiSecuritySettings, 3, (Context)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"platWifi:WifiWEPEditor")));
                                                                break block84;
                                                            }
                                                            if (n7 != 1) break block85;
                                                            bl3 = false;
                                                            if (n8 != 6) break block86;
                                                            try {
                                                                string2 = BWifiPlatformService.getPreSharedKey0(stringArray[0], stringArray2[n13]);
                                                                String string19 = string3 = string2 != null && !string2.trim().equals("") ? LegacyStorageUtil.decode((String)string2) : "";
                                                                if (string3.length() > 0) {
                                                                    bl3 = true;
                                                                }
                                                                break block77;
                                                            }
                                                            catch (Exception exception) {}
                                                            break block77;
                                                        }
                                                        if (n8 != 2) break block87;
                                                        bl3 = true;
                                                        break block77;
                                                    }
                                                    if (n8 != 4) break block82;
                                                    bl3 = false;
                                                }
                                                if (bl3) {
                                                    bVector.add(SlotPath.escape((String)BWifiSecurityPolicy.wpa_psk.toString()), (BValue)BWifiSecurityPolicy.wpa_psk, 3);
                                                    bWifiSecuritySettings = new BWifiWPAPSKSettings();
                                                    if (string3 == null) {
                                                        try {
                                                            string2 = BWifiPlatformService.getPreSharedKey0(stringArray[0], stringArray2[n13]);
                                                            string3 = string2 != null && !string2.trim().equals("") ? LegacyStorageUtil.decode((String)string2) : "";
                                                        }
                                                        catch (Exception exception) {}
                                                    }
                                                    bWifiSecuritySettings.setSupported(true);
                                                    bWifiSecuritySettings.setUse(true);
                                                    try {
                                                        ((BWifiWPAPSKSettings)bWifiSecuritySettings).setEncryption(BWifiEncryptionMethod.make(n9));
                                                    }
                                                    catch (InvalidEnumException invalidEnumException) {
                                                        log.error("Could not create wpa_psk encryption enum for network \"" + stringArray2[n13] + "\" with ordinal: " + n9);
                                                        invalidEnumException.printStackTrace();
                                                        ((BWifiWPAPSKSettings)bWifiSecuritySettings).setEncryption(BWifiEncryptionMethod.unknown);
                                                    }
                                                    ((BWifiWPAPSKSettings)bWifiSecuritySettings).setAuthentication(BWifiAuthenticationMethod.make(n11));
                                                    ((BWifiWPAPSKSettings)bWifiSecuritySettings).setNetworkKey(BPassword.make((String)string3));
                                                    bVector2.add(SlotPath.escape((String)BWifiSecurityPolicy.wpa_psk.toString()), (BValue)bWifiSecuritySettings, 3, (Context)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"platWifi:WifiWPAPSKEditor")));
                                                } else {
                                                    bVector.add(SlotPath.escape((String)BWifiSecurityPolicy.wpa.toString()), (BValue)BWifiSecurityPolicy.wpa, 3);
                                                    bWifiSecuritySettings = new BWifiWPASettings();
                                                    ((BWifiWPASettings)bWifiSecuritySettings).setSupported(true);
                                                    ((BWifiWPASettings)bWifiSecuritySettings).setUse(true);
                                                    try {
                                                        ((BWifiWPASettings)bWifiSecuritySettings).setEncryption(BWifiEncryptionMethod.make(n9));
                                                    }
                                                    catch (InvalidEnumException invalidEnumException) {
                                                        log.error("Could not create wpa encryption enum for network \"" + stringArray2[n13] + "\" with ordinal: " + n9);
                                                        invalidEnumException.printStackTrace();
                                                        ((BWifiWPASettings)bWifiSecuritySettings).setEncryption(BWifiEncryptionMethod.unknown);
                                                    }
                                                    ((BWifiWPASettings)bWifiSecuritySettings).setAuthentication(BWifiAuthenticationMethod.make(n11));
                                                    n12 = BWifiPlatformService.getEAPMethod0(stringArray[0], stringArray2[n13]);
                                                    string5 = BWifiPlatformService.getEAPIdentity0(stringArray[0], stringArray2[n13]);
                                                    if (string5 == null) {
                                                        string5 = "";
                                                    }
                                                    if ((string6 = BWifiPlatformService.getEAPAnonymousIdentity0(stringArray[0], stringArray2[n13])) == null) {
                                                        string6 = "";
                                                    }
                                                    if ((string7 = BWifiPlatformService.getCACertificate0(stringArray[0], stringArray2[n13])) == null) {
                                                        string7 = "";
                                                    }
                                                    if ((string8 = BWifiPlatformService.getCACertificateDir0(stringArray[0], stringArray2[n13])) == null) {
                                                        string8 = "";
                                                    }
                                                    if ((string9 = BWifiPlatformService.getClientCertificate0(stringArray[0], stringArray2[n13])) == null) {
                                                        string9 = "";
                                                    }
                                                    if ((string10 = BWifiPlatformService.getPrivateKeyFile0(stringArray[0], stringArray2[n13])) == null) {
                                                        string10 = "";
                                                    }
                                                    try {
                                                        string2 = BWifiPlatformService.getEAPPassword0(stringArray[0], stringArray2[n13]);
                                                        string4 = string2 != null && !string2.trim().equals("") ? LegacyStorageUtil.decode((String)string2) : "";
                                                        string2 = BWifiPlatformService.getPrivateKeyPassword0(stringArray[0], stringArray2[n13]);
                                                        string11 = string2 != null && !string2.trim().equals("") ? LegacyStorageUtil.decode((String)string2) : "";
                                                    }
                                                    catch (Exception exception) {}
                                                    string12 = BWifiPlatformService.getTunnelPhase10(stringArray[0], stringArray2[n13]);
                                                    if (string12 == null) {
                                                        string12 = "";
                                                    }
                                                    if ((string13 = BWifiPlatformService.getTunnelPhase20(stringArray[0], stringArray2[n13])) == null) {
                                                        string13 = "";
                                                    }
                                                    if ((string14 = BWifiPlatformService.getCACertificate20(stringArray[0], stringArray2[n13])) == null) {
                                                        string14 = "";
                                                    }
                                                    if ((string15 = BWifiPlatformService.getCACertificateDir20(stringArray[0], stringArray2[n13])) == null) {
                                                        string15 = "";
                                                    }
                                                    if ((string16 = BWifiPlatformService.getClientCertificate20(stringArray[0], stringArray2[n13])) == null) {
                                                        string16 = "";
                                                    }
                                                    if ((string17 = BWifiPlatformService.getPrivateKeyFile20(stringArray[0], stringArray2[n13])) == null) {
                                                        string17 = "";
                                                    }
                                                    try {
                                                        string2 = BWifiPlatformService.getPrivateKeyPassword20(stringArray[0], stringArray2[n13]);
                                                        string18 = string2 != null && !string2.trim().equals("") ? LegacyStorageUtil.decode((String)string2) : "";
                                                    }
                                                    catch (Exception exception) {}
                                                    ((BWifiWPASettings)bWifiSecuritySettings).setEap(BWifiEAPMethod.make(n12));
                                                    ((BWifiWPASettings)bWifiSecuritySettings).setEapIdentity(string5);
                                                    ((BWifiWPASettings)bWifiSecuritySettings).setEapAnonymousIdentity(string6);
                                                    ((BWifiWPASettings)bWifiSecuritySettings).setEapPassword(BPassword.make((String)string4));
                                                    ((BWifiWPASettings)bWifiSecuritySettings).setCertAuthCertificate(string7);
                                                    ((BWifiWPASettings)bWifiSecuritySettings).setCertAuthDirectoryPath(string8);
                                                    ((BWifiWPASettings)bWifiSecuritySettings).setClientCertificate(string9);
                                                    ((BWifiWPASettings)bWifiSecuritySettings).setPrivateKeyFile(string10);
                                                    ((BWifiWPASettings)bWifiSecuritySettings).setPrivateKeyPassword(BPassword.make((String)string11));
                                                    ((BWifiWPASettings)bWifiSecuritySettings).setTunnelPhase1(string12);
                                                    ((BWifiWPASettings)bWifiSecuritySettings).setTunnelPhase2(string13);
                                                    ((BWifiWPASettings)bWifiSecuritySettings).setCertAuthCertificate2(string14);
                                                    ((BWifiWPASettings)bWifiSecuritySettings).setCertAuthDirectoryPath2(string15);
                                                    ((BWifiWPASettings)bWifiSecuritySettings).setClientCertificate2(string16);
                                                    ((BWifiWPASettings)bWifiSecuritySettings).setPrivateKeyFile2(string17);
                                                    ((BWifiWPASettings)bWifiSecuritySettings).setPrivateKeyPassword2(BPassword.make((String)string18));
                                                    bVector2.add(SlotPath.escape((String)BWifiSecurityPolicy.wpa.toString()), (BValue)bWifiSecuritySettings, 3, (Context)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"platWifi:WifiWPAEditor")));
                                                }
                                                break block84;
                                            }
                                            if (n7 != 2) break block82;
                                            bl2 = false;
                                            if (n8 != 6) break block88;
                                            try {
                                                string2 = BWifiPlatformService.getPreSharedKey0(stringArray[0], stringArray2[n13]);
                                                String string20 = string3 = string2 != null && !string2.trim().equals("") ? LegacyStorageUtil.decode((String)string2) : "";
                                                if (string3.length() > 0) {
                                                    bl2 = true;
                                                }
                                                break block78;
                                            }
                                            catch (Exception exception) {}
                                            break block78;
                                        }
                                        if (n8 != 2) break block89;
                                        bl2 = true;
                                        break block78;
                                    }
                                    if (n8 != 4) break block82;
                                    bl2 = false;
                                }
                                if (bl2) {
                                    bVector.add(SlotPath.escape((String)BWifiSecurityPolicy.wpa2_psk.toString()), (BValue)BWifiSecurityPolicy.wpa2_psk, 3);
                                    bWifiSecuritySettings = new BWifiWPA2PSKSettings();
                                    if (string3 == null) {
                                        try {
                                            string2 = BWifiPlatformService.getPreSharedKey0(stringArray[0], stringArray2[n13]);
                                            string3 = string2 != null && !string2.trim().equals("") ? LegacyStorageUtil.decode((String)string2) : "";
                                        }
                                        catch (Exception exception) {}
                                    }
                                    ((BWifiWPA2PSKSettings)bWifiSecuritySettings).setSupported(true);
                                    ((BWifiWPA2PSKSettings)bWifiSecuritySettings).setUse(true);
                                    try {
                                        ((BWifiWPA2PSKSettings)bWifiSecuritySettings).setEncryption(BWifiEncryptionMethod.make(n9));
                                    }
                                    catch (InvalidEnumException invalidEnumException) {
                                        log.error("Could not create wpa2_psk encryption enum for network \"" + stringArray2[n13] + "\" with ordinal: " + n9);
                                        invalidEnumException.printStackTrace();
                                        ((BWifiWPA2PSKSettings)bWifiSecuritySettings).setEncryption(BWifiEncryptionMethod.unknown);
                                    }
                                    ((BWifiWPA2PSKSettings)bWifiSecuritySettings).setAuthentication(BWifiAuthenticationMethod.make(n11));
                                    ((BWifiWPA2PSKSettings)bWifiSecuritySettings).setNetworkKey(BPassword.make((String)string3));
                                    bVector2.add(SlotPath.escape((String)BWifiSecurityPolicy.wpa2_psk.toString()), (BValue)bWifiSecuritySettings, 3, (Context)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"platWifi:WifiWPA2PSKEditor")));
                                } else {
                                    bVector.add(SlotPath.escape((String)BWifiSecurityPolicy.wpa2.toString()), (BValue)BWifiSecurityPolicy.wpa2, 3);
                                    bWifiSecuritySettings = new BWifiWPA2Settings();
                                    ((BWifiWPA2Settings)bWifiSecuritySettings).setSupported(true);
                                    ((BWifiWPA2Settings)bWifiSecuritySettings).setUse(true);
                                    try {
                                        ((BWifiWPA2Settings)bWifiSecuritySettings).setEncryption(BWifiEncryptionMethod.make(n9));
                                    }
                                    catch (InvalidEnumException invalidEnumException) {
                                        log.error("Could not create wpa2 encryption enum for network \"" + stringArray2[n13] + "\" with ordinal: " + n9);
                                        invalidEnumException.printStackTrace();
                                        ((BWifiWPA2Settings)bWifiSecuritySettings).setEncryption(BWifiEncryptionMethod.unknown);
                                    }
                                    ((BWifiWPA2Settings)bWifiSecuritySettings).setAuthentication(BWifiAuthenticationMethod.make(n11));
                                    n12 = BWifiPlatformService.getEAPMethod0(stringArray[0], stringArray2[n13]);
                                    string5 = BWifiPlatformService.getEAPIdentity0(stringArray[0], stringArray2[n13]);
                                    if (string5 == null) {
                                        string5 = "";
                                    }
                                    if ((string6 = BWifiPlatformService.getEAPAnonymousIdentity0(stringArray[0], stringArray2[n13])) == null) {
                                        string6 = "";
                                    }
                                    if ((string7 = BWifiPlatformService.getCACertificate0(stringArray[0], stringArray2[n13])) == null) {
                                        string7 = "";
                                    }
                                    if ((string8 = BWifiPlatformService.getCACertificateDir0(stringArray[0], stringArray2[n13])) == null) {
                                        string8 = "";
                                    }
                                    if ((string9 = BWifiPlatformService.getClientCertificate0(stringArray[0], stringArray2[n13])) == null) {
                                        string9 = "";
                                    }
                                    if ((string10 = BWifiPlatformService.getPrivateKeyFile0(stringArray[0], stringArray2[n13])) == null) {
                                        string10 = "";
                                    }
                                    try {
                                        string2 = BWifiPlatformService.getEAPPassword0(stringArray[0], stringArray2[n13]);
                                        string4 = string2 != null && !string2.trim().equals("") ? LegacyStorageUtil.decode((String)string2) : "";
                                        string2 = BWifiPlatformService.getPrivateKeyPassword0(stringArray[0], stringArray2[n13]);
                                        string11 = string2 != null && !string2.trim().equals("") ? LegacyStorageUtil.decode((String)string2) : "";
                                    }
                                    catch (Exception exception) {}
                                    string12 = BWifiPlatformService.getTunnelPhase10(stringArray[0], stringArray2[n13]);
                                    if (string12 == null) {
                                        string12 = "";
                                    }
                                    if ((string13 = BWifiPlatformService.getTunnelPhase20(stringArray[0], stringArray2[n13])) == null) {
                                        string13 = "";
                                    }
                                    if ((string14 = BWifiPlatformService.getCACertificate20(stringArray[0], stringArray2[n13])) == null) {
                                        string14 = "";
                                    }
                                    if ((string15 = BWifiPlatformService.getCACertificateDir20(stringArray[0], stringArray2[n13])) == null) {
                                        string15 = "";
                                    }
                                    if ((string16 = BWifiPlatformService.getClientCertificate20(stringArray[0], stringArray2[n13])) == null) {
                                        string16 = "";
                                    }
                                    if ((string17 = BWifiPlatformService.getPrivateKeyFile20(stringArray[0], stringArray2[n13])) == null) {
                                        string17 = "";
                                    }
                                    try {
                                        string2 = BWifiPlatformService.getPrivateKeyPassword20(stringArray[0], stringArray2[n13]);
                                        string18 = string2 != null && !string2.trim().equals("") ? LegacyStorageUtil.decode((String)string2) : "";
                                    }
                                    catch (Exception exception) {}
                                    ((BWifiWPA2Settings)bWifiSecuritySettings).setEap(BWifiEAPMethod.make(n12));
                                    ((BWifiWPA2Settings)bWifiSecuritySettings).setEapIdentity(string5);
                                    ((BWifiWPA2Settings)bWifiSecuritySettings).setEapAnonymousIdentity(string6);
                                    ((BWifiWPA2Settings)bWifiSecuritySettings).setEapPassword(BPassword.make((String)string4));
                                    ((BWifiWPA2Settings)bWifiSecuritySettings).setCertAuthCertificate(string7);
                                    ((BWifiWPA2Settings)bWifiSecuritySettings).setCertAuthDirectoryPath(string8);
                                    ((BWifiWPA2Settings)bWifiSecuritySettings).setClientCertificate(string9);
                                    ((BWifiWPA2Settings)bWifiSecuritySettings).setPrivateKeyFile(string10);
                                    ((BWifiWPA2Settings)bWifiSecuritySettings).setPrivateKeyPassword(BPassword.make((String)string11));
                                    ((BWifiWPA2Settings)bWifiSecuritySettings).setTunnelPhase1(string12);
                                    ((BWifiWPA2Settings)bWifiSecuritySettings).setTunnelPhase2(string13);
                                    ((BWifiWPA2Settings)bWifiSecuritySettings).setCertAuthCertificate2(string14);
                                    ((BWifiWPA2Settings)bWifiSecuritySettings).setCertAuthDirectoryPath2(string15);
                                    ((BWifiWPA2Settings)bWifiSecuritySettings).setClientCertificate2(string16);
                                    ((BWifiWPA2Settings)bWifiSecuritySettings).setPrivateKeyFile2(string17);
                                    ((BWifiWPA2Settings)bWifiSecuritySettings).setPrivateKeyPassword2(BPassword.make((String)string18));
                                    bVector2.add(SlotPath.escape((String)BWifiSecurityPolicy.wpa2.toString()), (BValue)bWifiSecuritySettings, 3, (Context)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"platWifi:WifiWPA2Editor")));
                                }
                            }
                            if (string != null && bWifiNetwork.getSsid().equals(string)) {
                                if (bWifiNetwork.getNetworkState() != BWifiNetworkStateEnum.connected) {
                                    bWifiNetwork.setNetworkState(BWifiNetworkStateEnum.connecting);
                                }
                            } else {
                                n2 = BWifiPlatformService.getNetworkStatus0(stringArray[0], stringArray2[n13]);
                                bWifiNetwork.setNetworkState(BWifiNetworkStateEnum.make(n2));
                            }
                            bWifiNetwork.setSecuritySupported(bVector);
                            bWifiNetwork.setSecurityConfigurations(bVector2);
                            array.add((Object)bWifiNetwork);
                        }
                        ++n13;
                    }
                }
                this.getSettings().getNetworkDatabase().sync((BWifiNetwork[])array.trim());
                break block90;
            }
            String[] stringArray4 = BWifiPlatformService.getNetworkDatabaseSsids0(stringArray[0]);
            HashSet<String> hashSet = new HashSet<String>();
            BWifiNetwork bWifiNetwork = null;
            int n = 0;
            while (n < stringArray4.length) {
                String string = SlotPath.escape((String)stringArray4[n]);
                hashSet.add(string);
                bWifiNetwork = (BWifiNetwork)this.getSettings().getNetworkDatabase().get(string);
                if (bWifiNetwork != null) {
                    bWifiNetwork.setNetworkState(BWifiNetworkStateEnum.make(BWifiPlatformService.getNetworkStatus0(stringArray[0], bWifiNetwork.getSsid())));
                    bWifiNetwork.setSignalStrength(BWifiPlatformService.getStrength0(stringArray[0], bWifiNetwork.getSsid()));
                } else {
                    this.refreshRequired = true;
                }
                ++n;
            }
            Property[] propertyArray = this.getSettings().getNetworkDatabase().getPropertiesArray();
            int n14 = 0;
            while (n14 < propertyArray.length) {
                if (!hashSet.contains(propertyArray[n14].getName())) {
                    this.getSettings().getNetworkDatabase().remove(propertyArray[n14].getName());
                }
                ++n14;
            }
        }
    }

    public void doPoll(Context context) {
        if (!this.isRunning()) {
            return;
        }
        super.doPoll(context);
        this.refreshProperties();
    }

    public BWifiNetworkVector doDiscoverNetworks(BString bString) {
        if (!WifiPlatformLibrary.load()) {
            return null;
        }
        String[] stringArray = BWifiPlatformService.discoverNetworks0(bString.toString());
        BWifiNetworkVector bWifiNetworkVector = new BWifiNetworkVector();
        BWifiNetwork bWifiNetwork = null;
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                bWifiNetwork = BWifiNetwork.makeNetwork(stringArray[n]);
                if (bWifiNetwork.getSsid() != null && bWifiNetwork.getSsid().length() != 0) {
                    try {
                        bWifiNetworkVector.add(SlotPath.escape((String)bWifiNetwork.getSsid()), (BValue)bWifiNetwork, 3, (Context)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"platWifi:WifiNetworkEditor")));
                    }
                    catch (Exception exception) {}
                }
                ++n;
            }
        }
        log.trace("discovered " + bWifiNetworkVector.getSlotCount() + " 802.11 networks");
        return bWifiNetworkVector;
    }

    public BBoolean doAddNetwork(BWifiCommandArgs bWifiCommandArgs) {
        if (!WifiPlatformLibrary.load()) {
            return BBoolean.make((boolean)false);
        }
        BWifiNetwork bWifiNetwork = (BWifiNetwork)bWifiCommandArgs.getWifiNetwork().newCopy(true);
        String string = bWifiCommandArgs.getAdapter();
        bWifiCommandArgs = null;
        if (bWifiNetwork.getMode().getOrdinal() == 1) {
            throw new BajaRuntimeException("WiFi network mode \"ad-hoc\" is not supported");
        }
        if (BWifiPlatformService.addNetwork0(string, bWifiNetwork.getSsid())) {
            BWifiPlatformService.setSignalStrength0(string, bWifiNetwork.getSsid(), bWifiNetwork.getSignalStrength());
            BWifiPlatformService.setNetworkStatus0(string, bWifiNetwork.getSsid(), bWifiNetwork.getNetworkState().getOrdinal());
            this.getSettings().getNetworkDatabase().add(SlotPath.escape((String)bWifiNetwork.getSsid()), (BValue)bWifiNetwork, 1, (Context)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"platWifi:WifiNetworkEditor")));
            log.trace("successfully added 802.11 network " + bWifiNetwork.getSsid());
            return BBoolean.make((boolean)true);
        }
        log.error("failed to add 802.11 network " + bWifiNetwork.getSsid());
        return BBoolean.make((boolean)false);
    }

    public BBoolean doRemoveNetwork(BWifiCommandArgs bWifiCommandArgs) {
        if (!WifiPlatformLibrary.load()) {
            return BBoolean.make((boolean)false);
        }
        BWifiNetwork bWifiNetwork = (BWifiNetwork)bWifiCommandArgs.getWifiNetwork().newCopy(true);
        String string = bWifiCommandArgs.getAdapter();
        bWifiCommandArgs = null;
        if (BWifiPlatformService.removeNetwork0(string, bWifiNetwork.getSsid())) {
            this.getSettings().getNetworkDatabase().remove(SlotPath.escape((String)bWifiNetwork.getSsid()));
            if (this.getSettings().getCurrentNetworkSsid() != null && this.getSettings().getCurrentNetworkSsid().equalsIgnoreCase(bWifiNetwork.getSsid())) {
                this.getSettings().setCurrentNetworkSsid("");
            }
            log.trace("successfully removed 802.11 network " + bWifiNetwork.getSsid());
            return BBoolean.make((boolean)true);
        }
        log.error("failed to remove 802.11 network " + bWifiNetwork.getSsid());
        return BBoolean.make((boolean)false);
    }

    public BBoolean doDisconnectFromNetwork(BWifiCommandArgs bWifiCommandArgs) {
        if (!WifiPlatformLibrary.load()) {
            return BBoolean.make((boolean)false);
        }
        BWifiNetwork bWifiNetwork = (BWifiNetwork)bWifiCommandArgs.getWifiNetwork().newCopy(true);
        String string = bWifiCommandArgs.getAdapter();
        bWifiCommandArgs = null;
        if (BWifiPlatformService.disconnectFromNetwork0(string, bWifiNetwork.getSsid())) {
            BWifiNetwork bWifiNetwork2 = (BWifiNetwork)this.getSettings().getNetworkDatabase().get(SlotPath.escape((String)bWifiNetwork.getSsid()));
            if (bWifiNetwork2 != null && bWifiNetwork2.getNetworkState() != BWifiNetworkStateEnum.disabled) {
                bWifiNetwork2.setNetworkState(BWifiNetworkStateEnum.disconnected);
            }
            if (bWifiNetwork2 != null && this.getSettings().getCurrentNetworkSsid() != null && this.getSettings().getCurrentNetworkSsid().equalsIgnoreCase(bWifiNetwork2.getSsid())) {
                this.getSettings().setCurrentNetworkSsid("");
            }
            this.getSettings().setDaemonState(BWifiDaemonStateEnum.disconnected);
            log.trace("successfully initiated disconnection from 802.11 network " + bWifiNetwork.getSsid());
            return BBoolean.make((boolean)true);
        }
        log.error("failed to disconnect from 802.11 network " + bWifiNetwork.getSsid());
        return BBoolean.make((boolean)false);
    }

    public BBoolean doRoamNetworks(BWifiCommandArgs bWifiCommandArgs) {
        if (!WifiPlatformLibrary.load()) {
            return BBoolean.make((boolean)false);
        }
        String string = bWifiCommandArgs.getAdapter();
        bWifiCommandArgs = null;
        if (BWifiPlatformService.roamNetworks0(string)) {
            log.trace("successfully entered 802.11 network roaming mode");
            return BBoolean.make((boolean)true);
        }
        log.error("failed to enter 802.11 network roaming mode");
        return BBoolean.make((boolean)false);
    }

    public BBoolean doConnectToNetwork(BWifiCommandArgs bWifiCommandArgs) {
        if (!WifiPlatformLibrary.load()) {
            return BBoolean.make((boolean)false);
        }
        BWifiNetwork bWifiNetwork = (BWifiNetwork)bWifiCommandArgs.getWifiNetwork().newCopy(true);
        String string = bWifiCommandArgs.getAdapter();
        bWifiCommandArgs = null;
        if (BWifiPlatformService.connectToNetwork0(string, bWifiNetwork.getSsid())) {
            BWifiNetwork bWifiNetwork2;
            if (this.getSettings().getCurrentNetworkSsid() != null && !this.getSettings().getCurrentNetworkSsid().equalsIgnoreCase(bWifiNetwork.getSsid())) {
                bWifiNetwork2 = (BWifiNetwork)this.getSettings().getNetworkDatabase().get(SlotPath.escape((String)this.getSettings().getCurrentNetworkSsid()));
                if (bWifiNetwork2 != null && bWifiNetwork2.getNetworkState() != BWifiNetworkStateEnum.disabled) {
                    bWifiNetwork2.setNetworkState(BWifiNetworkStateEnum.disconnected);
                }
                this.getSettings().setCurrentNetworkSsid("");
            }
            if (this.getSettings().getCurrentNetworkSsid() == null || this.getSettings().getCurrentNetworkSsid().length() == 0) {
                this.getSettings().setCurrentNetworkSsid(bWifiNetwork.getSsid());
            }
            bWifiNetwork2 = (BWifiNetwork)this.getSettings().getNetworkDatabase().get(SlotPath.escape((String)bWifiNetwork.getSsid()));
            bWifiNetwork2.setNetworkState(BWifiNetworkStateEnum.connecting);
            log.trace("successfully initiated connection to 802.11 network " + bWifiNetwork2.getSsid());
            return BBoolean.make((boolean)true);
        }
        log.error("failed to connect to 802.11 network " + bWifiNetwork.getSsid());
        return BBoolean.make((boolean)false);
    }

    public BBoolean doHashCACertificates() {
        return BBoolean.make((boolean)BWifiPlatformService.hashCACertificates0());
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    public boolean hasNavChildren() {
        return false;
    }

    public BIcon getIcon() {
        return icon;
    }

    private static final native String[] discoverNetworks0(String var0);

    private static final native boolean connectToNetwork0(String var0, String var1);

    private static final native boolean disconnectFromNetwork0(String var0, String var1);

    private static final native boolean addNetwork0(String var0, String var1);

    private static final native boolean removeNetwork0(String var0, String var1);

    private static final native boolean roamNetworks0(String var0);

    private static final native boolean saveHostSettings0();

    private static final native boolean unloadWifiSettings0();

    private static final native boolean hashCACertificates0();

    private static final native String[] getWifiAdapters0();

    private static final native boolean isWifiEnabled0(String var0);

    private static final native int getDaemonStatus0(String var0);

    private static final native int getNetworkStatus0(String var0, String var1);

    private static final native String getCurrentNetwork0(String var0);

    private static final native String[] getNetworkDatabaseSsids0(String var0);

    private static final native String getBssid0(String var0, String var1);

    private static final native boolean getSsidBroadcasted0(String var0, String var1);

    private static final native int getStrength0(String var0, String var1);

    private static final native int getPriority0(String var0, String var1);

    private static final native int getChannel0(String var0, String var1);

    private static final native int getNetworkMode0(String var0, String var1);

    private static final native int getProtocol0(String var0, String var1);

    private static final native int getKeyManagement0(String var0, String var1);

    private static final native int getAuthentication0(String var0, String var1);

    private static final native int getSupportedEncrytptionMethods0(String var0, String var1);

    private static final native String[] getWepKeys0(String var0, String var1);

    private static final native int getWepIndex0(String var0, String var1);

    private static final native String getPreSharedKey0(String var0, String var1);

    private static final native int getEAPMethod0(String var0, String var1);

    private static final native String getEAPAnonymousIdentity0(String var0, String var1);

    private static final native String getEAPIdentity0(String var0, String var1);

    private static final native String getEAPPassword0(String var0, String var1);

    private static final native String getCACertificate0(String var0, String var1);

    private static final native String getCACertificateDir0(String var0, String var1);

    private static final native String getClientCertificate0(String var0, String var1);

    private static final native String getPrivateKeyFile0(String var0, String var1);

    private static final native String getPrivateKeyPassword0(String var0, String var1);

    private static final native String getTunnelPhase10(String var0, String var1);

    private static final native String getTunnelPhase20(String var0, String var1);

    private static final native String getCACertificate20(String var0, String var1);

    private static final native String getCACertificateDir20(String var0, String var1);

    private static final native String getClientCertificate20(String var0, String var1);

    private static final native String getPrivateKeyFile20(String var0, String var1);

    private static final native String getPrivateKeyPassword20(String var0, String var1);

    private static final native boolean setEncryption0(String var0, String var1, int var2);

    private static final native boolean setAuthentication0(String var0, String var1, int var2);

    private static final native boolean setKeyManagement0(String var0, String var1, int var2);

    private static final native boolean setProtocol0(String var0, String var1, int var2);

    private static final native boolean setPreferredBssid0(String var0, String var1, String var2);

    private static final native boolean setSsidBroadcasted0(String var0, String var1, boolean var2);

    private static final native boolean setSignalStrength0(String var0, String var1, int var2);

    private static final native boolean setPriority0(String var0, String var1, int var2);

    private static final native boolean setNetworkStatus0(String var0, String var1, int var2);

    private static final native boolean setNetworkMode0(String var0, String var1, int var2);

    private static final native boolean setPreSharedKey0(String var0, String var1, String var2);

    private static final native boolean setEAPIdentity0(String var0, String var1, String var2);

    private static final native boolean setEAPAnonymousIdentity0(String var0, String var1, String var2);

    private static final native boolean setEAPPassword0(String var0, String var1, String var2);

    private static final native boolean setEAPMethod0(String var0, String var1, int var2);

    private static final native boolean setCACertificate0(String var0, String var1, String var2);

    private static final native boolean setCACertificateDir0(String var0, String var1, String var2);

    private static final native boolean setPrivateKeyFile0(String var0, String var1, String var2);

    private static final native boolean setClientCertificate0(String var0, String var1, String var2);

    private static final native boolean setPrivateKeyPassword0(String var0, String var1, String var2);

    private static final native boolean setTunnelPhase10(String var0, String var1, String var2);

    private static final native boolean setTunnelPhase20(String var0, String var1, String var2);

    private static final native boolean setCACertificate20(String var0, String var1, String var2);

    private static final native boolean setCACertificateDir20(String var0, String var1, String var2);

    private static final native boolean setClientCertificate20(String var0, String var1, String var2);

    private static final native boolean setPrivateKeyFile20(String var0, String var1, String var2);

    private static final native boolean setPrivateKeyPassword20(String var0, String var1, String var2);

    private static final native boolean setWepIndex0(String var0, String var1, int var2);

    private static final native boolean setWepKey0(String var0, String var1, int var2, String var3);

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.refreshRequired = true;
    }

    public BWifiPlatformService() {
        this.this();
        this.setPlatformServiceDescription(this.getLexicon().getText("WifiPlatformService.description"));
    }

    static {
        Class clazz = class$com$tridium$platwifi$BWifiPlatformService;
        if (clazz == null) {
            clazz = class$com$tridium$platwifi$BWifiPlatformService = BWifiPlatformService.class("[Lcom.tridium.platwifi.BWifiPlatformService;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.std((String)"wireless.png");
        log = Log.getLog((String)"wifi.service");
    }
}

