/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platCcn;

import com.tridium.platCcn.CcnDataWrapper;

public class CcnUnsolicitedMsg
implements CcnDataWrapper {
    private boolean wait;
    private long timestamp;
    private long dwIdleTime;
    private byte destAddr;
    private byte destBus;
    private byte srcAddr;
    private byte srcBus;
    private byte pid;
    private byte extension;
    private byte command;
    private byte[] data;
    private short dataLength;

    public void SetParams(byte by, byte by2, byte by3, byte by4, byte by5, byte by6, byte by7, byte[] byArray, short s) {
        this.destAddr = by;
        this.destBus = by2;
        this.srcAddr = by3;
        this.srcBus = by4;
        this.pid = by5;
        this.extension = by6;
        this.command = by7;
        this.data = byArray;
        this.dataLength = s;
    }

    public int getDestAddr() {
        return this.destAddr & 0xFF;
    }

    public int getDestBus() {
        return this.destBus & 0xFF;
    }

    public int getSrcAddr() {
        return this.srcAddr & 0xFF;
    }

    public int getSrcBus() {
        return this.srcBus & 0xFF;
    }

    public int getCommand() {
        return this.command & 0xFF;
    }

    public byte[] getDataCopy() {
        byte[] byArray = new byte[this.dataLength];
        int n = 0;
        while (n < this.dataLength) {
            byArray[n] = this.data[n];
            ++n;
        }
        return byArray;
    }

    private static final String get2DigHexString(int n) {
        String string = "00" + Integer.toHexString(n);
        return string.substring(string.length() - 2);
    }

    public String toString() {
        String string = "";
        string = string + '[';
        string = string + "wt=" + this.wait + ',';
        string = string + "tm=" + (this.timestamp & (long)-1) + ',';
        string = string + "idleTm=" + (this.dwIdleTime & (long)-1) + ',';
        string = string + "dAddr=" + (this.destAddr & 0xFF) + ',';
        string = string + "dBus=" + (this.destBus & 0xFF) + ',';
        string = string + "sAddr=" + (this.srcAddr & 0xFF) + ',';
        string = string + "sBus=" + (this.srcBus & 0xFF) + ',';
        string = string + "pid=" + (this.pid & 0xFF) + ',';
        string = string + "ext=" + (this.extension & 0xFF) + ',';
        string = string + "cmd=0x" + CcnUnsolicitedMsg.get2DigHexString(this.command & 0xFF) + ',';
        string = string + "dataLen=" + (this.dataLength & (char)-1) + ',';
        string = string + "dataAsc=" + new String(this.data) + ',';
        string = string + "dataHex = {";
        int n = 0;
        while (n < this.dataLength) {
            string = string + CcnUnsolicitedMsg.get2DigHexString(this.data[n] & 0xFF);
            string = string + ' ';
            ++n;
        }
        string = string + "}]";
        return string;
    }

    public byte[] getData() {
        return this.data;
    }

    public CcnUnsolicitedMsg() {
        this.destAddr = 0;
        this.destBus = 0;
        this.srcAddr = 0;
        this.srcBus = 0;
        this.pid = 0;
        this.extension = 0;
        this.command = 0;
        this.data = new byte[0];
        this.dataLength = 0;
    }

    public CcnUnsolicitedMsg(byte by, byte by2, byte by3, byte by4, byte by5, byte by6, byte by7, byte[] byArray, short s) {
        this.destAddr = by;
        this.destBus = by2;
        this.srcAddr = by3;
        this.srcBus = by4;
        this.pid = by5;
        this.extension = by6;
        this.command = by7;
        this.data = byArray;
        this.dataLength = s;
    }
}

