/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platCcn;

public class CcnResponseBuffer {
    private byte requestStatus;
    private byte responseCommand;
    private short responseDataLength;
    private byte[] responseData;

    public boolean isValidResponse() {
        boolean bl = false;
        if (this.responseDataLength > 0) {
            bl = true;
        }
        return bl;
    }

    private static final String get2DigHexString(int n) {
        String string = "00" + Integer.toHexString(n);
        return string.substring(string.length() - 2);
    }

    public String toString() {
        String string = "";
        string = string + '[';
        if (this.responseCommand == 6) {
            string = string + "stat=00,";
        } else {
            boolean bl = false;
            if (this.responseCommand == 21) {
                bl = true;
            }
            boolean bl2 = false;
            if (this.responseData.length > 0) {
                bl2 = true;
            }
            string = bl & bl2 ? string + "stat=" + CcnResponseBuffer.get2DigHexString(this.responseData[0] & 0xFF) + ',' : string + "stat=ff,";
        }
        string = string + "cmd=0x" + CcnResponseBuffer.get2DigHexString(this.responseCommand & 0xFF) + ',';
        string = string + "dataLen=" + (this.responseDataLength & (char)-1) + ',';
        string = string + "dataHex = {";
        int n = 0;
        while (n < this.responseDataLength) {
            string = string + CcnResponseBuffer.get2DigHexString(this.responseData[n] & 0xFF);
            string = string + ' ';
            ++n;
        }
        string = string + "}]";
        return string;
    }

    public byte getRequestStatus() {
        return this.requestStatus;
    }

    public byte getResponseCommand() {
        return this.responseCommand;
    }

    public short getResponseDataLength() {
        return this.responseDataLength;
    }

    public byte[] getResponseData() {
        return this.responseData;
    }

    public CcnResponseBuffer(byte by, byte by2, byte by3, byte[] byArray) {
        this.requestStatus = by;
        this.responseCommand = by2;
        this.responseDataLength = (short)(by3 & 0xFF);
        this.responseData = new byte[this.responseDataLength];
        int n = 0;
        while (n < this.responseDataLength) {
            this.responseData[n] = byArray[n];
            ++n;
        }
    }
}

