/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platCcn;

import com.tridium.platCcn.BCcnPlatformService;
import com.tridium.platCcn.CcnCommProps;
import com.tridium.platCcn.CcnObjectDef;
import com.tridium.platCcn.CcnResponseBuffer;
import com.tridium.platCcn.CcnTableDef;
import com.tridium.platCcn.CcnUnsolicitedMsg;
import com.tridium.platCcn.CcnVariableDef;
import com.tridium.platform.BOperatingSystemEnum;
import java.io.File;
import javax.baja.license.FeatureNotLicensedException;
import javax.baja.license.LicenseDatabaseException;
import javax.baja.serial.BISerialPort;
import javax.baja.serial.BISerialService;
import javax.baja.serial.PortDeniedException;
import javax.baja.serial.PortNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BCcnPlatformServiceQnx
extends BCcnPlatformService {
    public static final Type TYPE;
    boolean nativesLoaded;
    private boolean commOpened;
    private Thread rcvThread;
    private CcnUnsolictedRcvDriver rcvDrvr;
    private BISerialPort port;
    private Process ccnd;
    private boolean timeToDie;
    static /* synthetic */ Class class$com$tridium$platCcn$BCcnPlatformServiceQnx;

    public Type getType() {
        return TYPE;
    }

    public boolean isValidPlatform() {
        return BOperatingSystemEnum.isOS((BOperatingSystemEnum)BOperatingSystemEnum.qnx);
    }

    protected synchronized boolean loadLibraries() {
        if (this.nativesLoaded) {
            return true;
        }
        try {
            System.loadLibrary("platccn");
            this.nativesLoaded = true;
        }
        catch (Throwable throwable) {
            log.error("Unable load platccn native", throwable);
        }
        return this.nativesLoaded;
    }

    public void serviceStarted() throws Exception {
        File file = new File("/dev/ccn1");
        if (file.exists()) {
            log.message("CCN daemon already running");
            this.loadLibraries();
        } else {
            try {
                Sys.getLicenseManager().checkFeature("tridium", this.getLicenseFeature());
                this.ccnd = Runtime.getRuntime().exec("/proc/boot/ccnd -i 1");
                this.loadLibraries();
            }
            catch (FeatureNotLicensedException featureNotLicensedException) {
            }
            catch (LicenseDatabaseException licenseDatabaseException) {}
        }
        super.serviceStarted();
    }

    public void serviceStopped() throws Exception {
        if (this.ccnd != null) {
            this.ccnd.destroy();
            this.ccnd = null;
        }
        super.serviceStopped();
    }

    private final synchronized native int openDriverCommJNI(CcnCommProps var1);

    private final synchronized native CcnResponseBuffer changeTableNameJNI(CcnTableDef var1);

    private final synchronized native CcnResponseBuffer readTableJNI(CcnTableDef var1);

    private final synchronized native CcnResponseBuffer writeTableJNI(CcnTableDef var1, byte[] var2);

    private final synchronized native CcnResponseBuffer readVariableJNI(CcnVariableDef var1);

    private final synchronized native CcnResponseBuffer writeVariableJNI(CcnVariableDef var1, int var2);

    private final synchronized native CcnResponseBuffer autoVariableJNI(CcnVariableDef var1);

    private final synchronized native CcnResponseBuffer readObjectDataJNI(CcnObjectDef var1);

    private final synchronized native CcnResponseBuffer sendByteArrayJNI(byte[] var1);

    private final synchronized native void setLowLevelDebugJNI(boolean var1, int var2);

    private final native CcnUnsolicitedMsg getNextUnsolicitedMessageJNI();

    private final synchronized native int changeExtendedParamsJNI(boolean var1, boolean var2, short var3, byte var4, byte var5, int var6);

    private final synchronized native void closeDriverJNI();

    public void openDriverComm(CcnCommProps ccnCommProps) {
        BISerialService bISerialService = (BISerialService)Sys.getService((Type)BISerialService.TYPE);
        bISerialService.checkPropertiesLoaded();
        try {
            this.port = bISerialService.openPort(ccnCommProps.getCommPortName(), "ccn");
        }
        catch (PortNotFoundException portNotFoundException) {
            throw new RuntimeException(portNotFoundException);
        }
        catch (PortDeniedException portDeniedException) {
            throw new RuntimeException(portDeniedException);
        }
        String string = this.port.getOsPortName();
        ccnCommProps.setCommPortName(string);
        System.out.println("CCN osName " + string);
        int n = this.openDriverCommJNI(ccnCommProps);
        if (n == 0) {
            this.commOpened = true;
            this.timeToDie = false;
        }
        this.rcvDrvr = new CcnUnsolictedRcvDriver();
        this.rcvThread = new Thread((Runnable)this.rcvDrvr, "ccnUnRcv");
        this.rcvThread.start();
        if (this.commOpened) {
            return;
        }
        throw new RuntimeException("Error opening " + new String(ccnCommProps.getCommPortName()) + "; return code = " + n);
    }

    public CcnResponseBuffer changeTableName(CcnTableDef ccnTableDef) {
        if (this.commOpened) {
            return this.changeTableNameJNI(ccnTableDef);
        }
        throw new RuntimeException("Cannot proceed because this vxWorksCcnDriver has no open comm port.");
    }

    public CcnResponseBuffer readTable(CcnTableDef ccnTableDef) {
        if (this.commOpened) {
            return this.readTableJNI(ccnTableDef);
        }
        throw new RuntimeException("Cannot proceed because this vxWorksCcnDriver has no open comm port.");
    }

    public CcnResponseBuffer writeTable(CcnTableDef ccnTableDef, byte[] byArray) {
        if (this.commOpened) {
            return this.writeTableJNI(ccnTableDef, byArray);
        }
        throw new RuntimeException("Cannot proceed because this vxWorksCcnDriver has no open comm port.");
    }

    public CcnResponseBuffer readVariable(CcnVariableDef ccnVariableDef) {
        if (this.commOpened) {
            return this.readVariableJNI(ccnVariableDef);
        }
        throw new RuntimeException("Cannot proceed because this vxWorksCcnDriver has no open comm port.");
    }

    public CcnResponseBuffer writeVariable(CcnVariableDef ccnVariableDef, float f) {
        if (this.commOpened) {
            int n = Float.floatToIntBits(f);
            return this.writeVariableJNI(ccnVariableDef, n);
        }
        throw new RuntimeException("Cannot proceed because this vxWorksCcnDriver has no open comm port.");
    }

    public CcnResponseBuffer autoVariable(CcnVariableDef ccnVariableDef) {
        if (this.commOpened) {
            return this.autoVariableJNI(ccnVariableDef);
        }
        throw new RuntimeException("Cannot proceed because this vxWorksCcnDriver has no open comm port.");
    }

    public void closeDriver() {
        if (!this.commOpened) {
            throw new RuntimeException("Cannot proceed because this vxWorksCcnDriver has no open comm port.");
        }
        this.port.close();
        this.closeDriverJNI();
        this.timeToDie = true;
    }

    public CcnResponseBuffer readObjectData(CcnObjectDef ccnObjectDef) {
        if (this.commOpened) {
            return this.readObjectDataJNI(ccnObjectDef);
        }
        throw new RuntimeException("Cannot proceed because this vxWorksCcnDriver has no open comm port.");
    }

    public CcnResponseBuffer sendByteArray(byte[] byArray) {
        if (this.commOpened) {
            return this.sendByteArrayJNI(byArray);
        }
        throw new RuntimeException("Cannot proceed because this vxWorksCcnDriver has no open comm port.");
    }

    public void setLowLevelDebug(boolean bl, int n) {
        this.setLowLevelDebugJNI(bl, n);
    }

    public int changeExtendedParams(boolean bl, boolean bl2, short s, byte by, byte by2, int n) {
        return this.changeExtendedParamsJNI(bl, bl2, s, by, by2, n);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.nativesLoaded = false;
        this.commOpened = false;
        this.timeToDie = false;
    }

    public BCcnPlatformServiceQnx() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$platCcn$BCcnPlatformServiceQnx;
        if (clazz == null) {
            clazz = class$com$tridium$platCcn$BCcnPlatformServiceQnx = BCcnPlatformServiceQnx.class("[Lcom.tridium.platCcn.BCcnPlatformServiceQnx;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class CcnUnsolictedRcvDriver
    implements Runnable {
        public void run() {
            while (!BCcnPlatformServiceQnx.this.timeToDie) {
                CcnUnsolicitedMsg ccnUnsolicitedMsg = BCcnPlatformServiceQnx.this.getNextUnsolicitedMessageJNI();
                if (BCcnPlatformServiceQnx.this.timeToDie) break;
                if (ccnUnsolicitedMsg == null) continue;
                BCcnPlatformServiceQnx.this.unsolicitedMessageReceived(ccnUnsolicitedMsg);
            }
        }

        CcnUnsolictedRcvDriver() {
        }
    }
}

