/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ldap;

import com.tridium.ldap.BPrototypeFolder;
import javax.baja.ldap.BLdapExt;
import javax.baja.log.Log;
import javax.baja.naming.SlotPath;
import javax.baja.security.AuthenticationException;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.AuthenticateUtil;
import javax.baja.user.BUser;
import javax.baja.user.BUserPrototypes;
import javax.baja.user.BUserService;
import javax.baja.util.Lexicon;
import javax.naming.CommunicationException;
import javax.naming.ConfigurationException;
import javax.naming.NamingException;
import javax.naming.ServiceUnavailableException;

public class BLdapUserService
extends BUserService {
    public static final Property userPrototypes = BLdapUserService.newProperty((int)0, (BValue)new BPrototypeFolder(), null);
    public static final Type TYPE = Sys.loadType((Class)(class$javax$baja$ldap$BLdapUserService == null ? (class$javax$baja$ldap$BLdapUserService = BLdapUserService.class$("javax.baja.ldap.BLdapUserService")) : class$javax$baja$ldap$BLdapUserService));
    protected static final String EXTENSION_PROP = "ldapExtension";
    protected static final String ERR_LDAP_CONNECT = "ldap.error.ldapConnect";
    protected static final String ERR_LDAP_LOCKOUT = "ldap.error.lockout";
    protected static final String ERR_LDAP_AUTH_FAILED = "ldap.error.authFailed";
    protected static final String LDAP_LOGIN_SUCCESS = "ldap.login.success";
    private static final Lexicon lex = Lexicon.make((Class)(class$javax$baja$ldap$BLdapUserService == null ? (class$javax$baja$ldap$BLdapUserService = BLdapUserService.class$("javax.baja.ldap.BLdapUserService")) : class$javax$baja$ldap$BLdapUserService));
    protected static final Log log = Log.getLog((String)"ldap");
    protected static final Log authLog = Log.getLog((String)"ldap.auth");
    static /* synthetic */ Class class$javax$baja$ldap$BLdapUserService;
    static /* synthetic */ Class class$javax$baja$ldap$BLdapExt;
    static /* synthetic */ Class class$javax$baja$user$BUser;

    public BUserPrototypes getUserPrototypes() {
        return (BUserPrototypes)this.get(userPrototypes);
    }

    public void setUserPrototypes(BUserPrototypes bUserPrototypes) {
        this.set(userPrototypes, (BValue)bUserPrototypes, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BUser authenticateBasic(String string, String string2, Context context) throws AuthenticationException {
        if (string == null || string.length() == 0) {
            throw new AuthenticationException();
        }
        if (this.isLocalUser(string)) {
            return AuthenticateUtil.authenticateUsernameAndPassword((String)string, (String)string2, (BUserService)this, (Context)context);
        }
        BUser bUser = this.getUser(string);
        this.validateUser(bUser, context);
        BLdapExt[] bLdapExtArray = this.getLdapExtensionsForUser(string);
        if (bLdapExtArray.length == 0) {
            log.error(this.toPathString() + " missing child BLdapExt instance.");
            throw new AuthenticationException();
        }
        BUser bUser2 = null;
        AuthenticationException authenticationException = null;
        for (int i = 0; i < bLdapExtArray.length; ++i) {
            try {
                authLog.trace("Attempting to authenticate <" + string + "> against LDAP extension <" + bLdapExtArray[i].getName() + ">");
                bUser2 = bLdapExtArray[i].authenticate(string, string2, context);
                if (bUser2 == null) continue;
                authLog.trace("Authentication against LDAP extension <" + bLdapExtArray[i].getName() + "> successful.");
                this.setLdapExtensionForUser(bUser2, bLdapExtArray[i].getName());
                break;
            }
            catch (CommunicationException communicationException) {
                log.warning(lex.getText(ERR_LDAP_CONNECT, new Object[]{bLdapExtArray[i].getConnectionUrl()}) + " [" + communicationException.toString() + "]");
                if (bLdapExtArray.length == 1) {
                    authLog.message("Attempting to authenicate cached user: " + string);
                    return AuthenticateUtil.authenticateUsernameAndPassword((String)string, (String)string2, (BUserService)this, (Context)context);
                }
                authenticationException = new AuthenticationException(lex.getText(ERR_LDAP_AUTH_FAILED, new Object[]{string}), (Throwable)communicationException, null);
                continue;
            }
            catch (ServiceUnavailableException serviceUnavailableException) {
                log.warning(lex.getText(ERR_LDAP_CONNECT, new Object[]{bLdapExtArray[i].getConnectionUrl()}) + " [" + serviceUnavailableException.toString() + "]");
                if (bLdapExtArray.length == 1) {
                    authLog.message("Attempting to authenicate cached user: " + string);
                    return AuthenticateUtil.authenticateUsernameAndPassword((String)string, (String)string2, (BUserService)this, (Context)context);
                }
                authenticationException = new AuthenticationException(lex.getText(ERR_LDAP_AUTH_FAILED, new Object[]{string}), (Throwable)serviceUnavailableException, null);
                continue;
            }
            catch (ConfigurationException configurationException) {
                log.warning(lex.getText(ERR_LDAP_CONNECT, new Object[]{bLdapExtArray[i].getConnectionUrl()}) + " [" + configurationException.toString() + "]");
                if (bLdapExtArray.length == 1) {
                    authLog.message("Attempting to authenicate cached user: " + string);
                    return AuthenticateUtil.authenticateUsernameAndPassword((String)string, (String)string2, (BUserService)this, (Context)context);
                }
                authenticationException = new AuthenticationException(lex.getText(ERR_LDAP_AUTH_FAILED, new Object[]{string}), (Throwable)configurationException, null);
                continue;
            }
            catch (NamingException namingException) {
                log.trace("Authentication against LDAP extension <" + bLdapExtArray[i].getName() + "> failed. Cause is: " + namingException.getLocalizedMessage());
                authenticationException = new AuthenticationException(lex.getText(ERR_LDAP_AUTH_FAILED, new Object[]{string}), (Throwable)namingException, null);
                continue;
            }
            catch (AuthenticationException authenticationException2) {
                authLog.trace("Authentication against LDAP extension <" + bLdapExtArray[i].getName() + "> failed. Cause is: " + authenticationException2.getLocalizedMessage());
                authenticationException = authenticationException2;
            }
        }
        if (bUser2 == null) {
            if (bUser != null) {
                bUser.authenticateFailed((BUserService)this);
                this.auditLoginAttempt(false, bUser, context);
            }
            log.error(lex.getText(ERR_LDAP_AUTH_FAILED, new Object[]{string}) + " [" + authenticationException.toString() + "]");
            throw authenticationException;
        }
        log.message(lex.getText(LDAP_LOGIN_SUCCESS));
        bUser2.authenticateOk((BUserService)this);
        this.auditLoginAttempt(true, bUser2, context);
        return bUser2;
    }

    public boolean isDistributable() {
        return false;
    }

    public void addLdapUser(String string, BUser bUser, String string2) {
        Property property = this.add(SlotPath.escape((String)string), (BValue)bUser, 0x10000000);
        BUser bUser2 = (BUser)this.get(property);
        bUser2.setPrototypeName(string2);
    }

    public void removeLdapUser(String string) {
        this.remove(SlotPath.escape((String)string));
    }

    public void removeLdapUser(BUser bUser) {
        this.remove((BComplex)bUser);
    }

    public BLdapExt ext() {
        SlotCursor slotCursor = this.getProperties();
        if (slotCursor.next(class$javax$baja$ldap$BLdapExt == null ? (class$javax$baja$ldap$BLdapExt = BLdapUserService.class$("javax.baja.ldap.BLdapExt")) : class$javax$baja$ldap$BLdapExt)) {
            return (BLdapExt)slotCursor.get();
        }
        return null;
    }

    public BLdapExt[] getLdapExtensions() {
        return (BLdapExt[])this.getChildren(class$javax$baja$ldap$BLdapExt == null ? (class$javax$baja$ldap$BLdapExt = BLdapUserService.class$("javax.baja.ldap.BLdapExt")) : class$javax$baja$ldap$BLdapExt);
    }

    public BLdapExt[] getLdapExtensionsForUser(String string) {
        if (this.isLocalUser(string)) {
            throw new IllegalArgumentException("Cannot find LDAP extensions for local users.");
        }
        log.trace("Looking for extensions for user <" + string + ">.");
        BUser bUser = this.getUser(string);
        if (bUser != null && bUser.get(EXTENSION_PROP) != null) {
            String string2 = ((BString)bUser.get(EXTENSION_PROP)).getString();
            log.trace("Found configured extension <" + string2 + "> for user <" + string + ">.");
            BLdapExt bLdapExt = (BLdapExt)this.get(string2);
            if (bLdapExt != null) {
                return new BLdapExt[]{bLdapExt};
            }
            log.trace("Extension <" + string2 + "> not found in LdapUserService. Attempting all extensions.");
        } else {
            log.trace("User  <" + string + ">  does not have a configured extension. Attempting all extensions.");
        }
        return this.getLdapExtensions();
    }

    public void setLdapExtensionForUser(BUser bUser, String string) {
        if (bUser == null) {
            throw new IllegalArgumentException("Cannot set LDAP extensions for null users.");
        }
        if (this.isLocalUser(bUser.getName())) {
            throw new IllegalArgumentException("Cannot set LDAP extensions for local users.");
        }
        log.trace("Setting LDAP extension <" + string + "> for user <" + bUser.getName() + ">.");
        if (bUser.getProperty(EXTENSION_PROP) == null) {
            bUser.add(EXTENSION_PROP, (BValue)BString.make((String)string));
        } else {
            bUser.set(EXTENSION_PROP, (BValue)BString.make((String)string));
        }
    }

    public boolean canUsePasswordFeatures(BUser bUser) {
        return this.isLocalUser(bUser.getName());
    }

    public boolean isLocalUser(String string) {
        if (string == null) {
            return false;
        }
        BUser bUser = this.getUser(string);
        if (bUser == null) {
            return false;
        }
        return !Flags.isUserDefined1((BComplex)this, (Slot)bUser.getPropertyInParent());
    }

    public void validateUser(BUser bUser, Context context) throws AuthenticationException {
        if (bUser != null && bUser.getLockOut()) {
            bUser.authenticateFailed((BUserService)this);
            this.auditLoginAttempt(false, bUser, context);
            throw new AuthenticationException(lex.getText(ERR_LDAP_LOCKOUT, new Object[]{bUser.getUsername()}));
        }
    }

    public void renamed(Property property, String string, Context context) {
        if ((class$javax$baja$ldap$BLdapExt == null ? (class$javax$baja$ldap$BLdapExt = BLdapUserService.class$("javax.baja.ldap.BLdapExt")) : class$javax$baja$ldap$BLdapExt).isAssignableFrom(property.getType().getTypeClass())) {
            BUser[] bUserArray = (BUser[])this.getChildren(class$javax$baja$user$BUser == null ? (class$javax$baja$user$BUser = BLdapUserService.class$("javax.baja.user.BUser")) : class$javax$baja$user$BUser);
            for (int i = 0; i < bUserArray.length; ++i) {
                BString bString = (BString)bUserArray[i].get(EXTENSION_PROP);
                if (bString == null || !string.equals(bString.getString())) continue;
                bUserArray[i].set(EXTENSION_PROP, (BValue)BString.make((String)property.getName()));
            }
        }
    }

    public void removed(Property property, BValue bValue, Context context) {
        if (bValue instanceof BLdapExt) {
            BUser[] bUserArray = (BUser[])this.getChildren(class$javax$baja$user$BUser == null ? (class$javax$baja$user$BUser = BLdapUserService.class$("javax.baja.user.BUser")) : class$javax$baja$user$BUser);
            for (int i = 0; i < bUserArray.length; ++i) {
                BString bString = (BString)bUserArray[i].get(EXTENSION_PROP);
                if (bString == null || !property.getName().equals(bString.getString())) continue;
                bUserArray[i].remove(EXTENSION_PROP);
            }
        }
    }

    public void checkAdd(String string, BValue bValue, int n, BFacets bFacets, Context context) {
        BLdapExt[] bLdapExtArray;
        if (Sys.isStationStarted() && bValue instanceof BLdapExt && (bLdapExtArray = this.getLdapExtensions()).length > 0) {
            if (!((BLdapExt)bValue).supportsMultipleExtensions()) {
                throw new LocalizableRuntimeException("ldap", "ldap.addExt.error.noMultiple.new", new Object[]{string});
            }
            for (int i = 0; i < bLdapExtArray.length; ++i) {
                if (bLdapExtArray[i].supportsMultipleExtensions()) continue;
                throw new LocalizableRuntimeException("ldap", "ldap.addExt.error.noMultiple.old", new Object[]{bLdapExtArray[i].getName()});
            }
        }
        super.checkAdd(string, bValue, n, bFacets, context);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

