/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ldap;

import java.io.Serializable;
import java.util.Hashtable;
import javax.baja.ldap.BLdapExt;
import javax.baja.security.AuthenticationException;
import javax.baja.security.BICredentials;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.security.crypto.CertManagerFactory;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;

public class BActiveDirectoryExt
extends BLdapExt {
    public static final Property domain = BActiveDirectoryExt.newProperty((int)0, (String)"", null);
    public static final Type TYPE = Sys.loadType((Class)(class$javax$baja$ldap$BActiveDirectoryExt == null ? (class$javax$baja$ldap$BActiveDirectoryExt = BActiveDirectoryExt.class$("javax.baja.ldap.BActiveDirectoryExt")) : class$javax$baja$ldap$BActiveDirectoryExt));
    static /* synthetic */ Class class$javax$baja$ldap$BActiveDirectoryExt;

    public String getDomain() {
        return this.getString(domain);
    }

    public void setDomain(String string) {
        this.setString(domain, string, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BUser authenticate(BICredentials bICredentials, Context context) throws AuthenticationException, NamingException {
        if (bICredentials instanceof BUsernameAndPassword) {
            BUsernameAndPassword bUsernameAndPassword = (BUsernameAndPassword)bICredentials;
            return this.authenticate(bUsernameAndPassword.getUsername(), bUsernameAndPassword.getPassword().getValue(), context);
        }
        throw new AuthenticationException("Unsupported credential type for LdapV2 ActiveDirectory.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BUser authenticate(String string, String string2, Context context) throws AuthenticationException, NamingException {
        String string3;
        Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        BUser bUser = this.service.getUser(string);
        DirContext dirContext = null;
        try {
            string3 = this.getConnectionUrl();
            if (string3.length() > 0) {
                dirContext = this.initialDirContext(string3, string, string2);
            }
        }
        catch (NamingException namingException) {
            throw namingException;
        }
        catch (Exception exception) {
            log.warning(lex.getText("ldap.error.authFailed", new Object[]{string}), (Throwable)exception);
            throw new AuthenticationException(lex.getText("ldap.error.authFailed", new Object[]{string}));
        }
        if (dirContext == null) {
            return null;
        }
        try {
            Serializable serializable;
            string3 = this.getUserLoginAttr() + "=" + string;
            SearchResult searchResult = null;
            try {
                serializable = new SearchControls();
                serializable.setSearchScope(2);
                serializable.setCountLimit(1L);
                NamingEnumeration namingEnumeration = dirContext.search(this.getUserBase(), string3, (SearchControls)serializable);
                try {
                    if (namingEnumeration.hasMore()) {
                        searchResult = (SearchResult)namingEnumeration.next();
                    }
                }
                finally {
                    namingEnumeration.close();
                }
            }
            catch (Exception exception) {
                log.warning(lex.getText("ldap.error.ldapsearch", new Object[]{string3}), (Throwable)exception);
                throw new AuthenticationException(lex.getText("ldap.error.ldapsearch", new Object[]{string3}));
            }
            serializable = null;
            if (searchResult != null) {
                try {
                    string3 = this.getUserBase();
                    string3 = string3.length() > 0 ? searchResult.getName() + "," + string3 : searchResult.getName();
                    serializable = dirContext.getAttributes(string3);
                }
                catch (Exception exception) {
                    log.warning(lex.getText("ldap.error.authFailed", new Object[]{string}), (Throwable)exception);
                    throw new AuthenticationException(lex.getText("ldap.error.authFailed", new Object[]{string}));
                }
            } else {
                log.message(lex.getText("ldap.error.userNotFound", new Object[]{string3}));
                throw new AuthenticationException(lex.getText("ldap.error.userNotFound", new Object[]{string3}));
            }
            if (log.isTraceOn()) {
                this.traceDebug((Attributes)serializable);
            }
            try {
                bUser = this.prepareUser(string, string2, bUser, (Attributes)serializable, dirContext);
            }
            catch (Exception exception) {
                log.error(lex.getText("ldap.error.attributes", new Object[]{string3}), (Throwable)exception);
                throw new AuthenticationException(lex.getText("ldap.error.attributes", new Object[]{string3}));
            }
        }
        finally {
            try {
                dirContext.close();
            }
            catch (Exception exception) {
                log.trace("Closing connection.", (Throwable)exception);
            }
        }
        if (!this.service.canLogin(bUser)) {
            throw new AuthenticationException();
        }
        return bUser;
    }

    protected DirContext initialDirContext(String string, String string2, String string3) throws NamingException {
        String string4;
        if (!this.getDomain().equals("") && string2.indexOf("@") < 0) {
            string2 = string2 + "@" + this.getDomain();
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("java.naming.factory.initial", this.getInitialContextFactory());
        hashtable.put("java.naming.provider.url", string);
        hashtable.put("java.naming.security.authentication", "simple");
        hashtable.put("java.naming.security.principal", string2);
        hashtable.put("java.naming.security.credentials", string3);
        if (!this.getEnableConnectionPooling()) {
            hashtable.put("com.sun.jndi.ldap.connect.pool", "false");
        }
        if (this.getSSL()) {
            try {
                log.trace("SSL enabled");
                hashtable.put("java.naming.security.protocol", "ssl");
                if (CertManagerFactory.isCertManagerActive()) {
                    hashtable.put("java.naming.ldap.factory.socket", "javax.baja.security.crypto.se.BajaSSLSocketFactory");
                }
            }
            catch (Exception exception) {
                log.warning(lex.getText("ldap.error.SSLSocketFactory"));
            }
        }
        if ((string4 = this.getReferral()).length() > 0) {
            hashtable.put("java.naming.referral", string4);
            log.trace("Referral: " + string4);
        }
        return new InitialDirContext(hashtable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void traceDebug(Attributes attributes) {
        try {
            System.out.println("User attributes:");
            NamingEnumeration namingEnumeration = attributes.getAll();
            try {
                while (namingEnumeration.hasMore()) {
                    Attribute attribute = (Attribute)namingEnumeration.next();
                    String string = attribute.getID();
                    int n = attribute.size();
                    for (int i = 0; i < n; ++i) {
                        System.out.print(string);
                        System.out.print(": ");
                        System.out.println(attribute.get(i));
                    }
                }
            }
            finally {
                namingEnumeration.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

