/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ldap.v3.auth;

import com.tridium.ldap.v3.BLdapV3Ext;
import com.tridium.ldap.v3.auth.BKerberosAuthenticator;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;
import javax.baja.security.crypto.CertManagerFactory;
import javax.naming.directory.InitialDirContext;

class LdapKerberosAuthAction
implements PrivilegedExceptionAction {
    BLdapV3Ext ext;

    public LdapKerberosAuthAction(BLdapV3Ext bLdapV3Ext) {
        this.ext = bLdapV3Ext;
    }

    public Object run() throws Exception {
        String string;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        hashtable.put("java.naming.security.authentication", "GSSAPI");
        hashtable.put("java.naming.referral", "follow");
        String string2 = this.ext.getConnectionUrl();
        if (string2.length() == 0) {
            return null;
        }
        hashtable.put("java.naming.provider.url", this.ext.getConnectionUrl());
        if (!this.ext.getEnableConnectionPooling()) {
            hashtable.put("com.sun.jndi.ldap.connect.pool", "false");
        }
        if (this.ext.getSSL()) {
            BKerberosAuthenticator.log.trace("SSL enabled");
            hashtable.put("java.naming.security.protocol", "ssl");
            if (CertManagerFactory.isCertManagerActive()) {
                hashtable.put("java.naming.ldap.factory.socket", "javax.baja.security.crypto.se.BajaSSLSocketFactory");
            }
        }
        if ((string = this.ext.getReferral()).length() > 0) {
            hashtable.put("java.naming.referral", string);
            BKerberosAuthenticator.log.trace("Referral: " + string);
        }
        InitialDirContext initialDirContext = new InitialDirContext(hashtable);
        return initialDirContext;
    }
}

