/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ldap.v3.auth;

import com.sun.security.jgss.GSSUtil;
import com.tridium.fox.kerberos.KerberosCallbackHandler;
import com.tridium.fox.kerberos.KerberosConfig;
import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.session.FoxAuthenticationException;
import com.tridium.fox.session.FoxSession;
import com.tridium.ldap.v3.BLdapV3Ext;
import com.tridium.ldap.v3.auth.AcquireCredentialsAction;
import com.tridium.ldap.v3.auth.BAuthenticator;
import com.tridium.ldap.v3.auth.KerberosKeytabConfig;
import com.tridium.ldap.v3.auth.LdapKerberosAuthAction;
import com.tridium.nre.auth.SecurityUtil;
import com.tridium.nre.security.Aes256PasswordManager;
import com.tridium.nre.security.KeyRing;
import com.tridium.sys.Nre;
import com.tridium.util.ValueByteBuffer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import javax.baja.file.BFileSystem;
import javax.baja.file.FileUtil;
import javax.baja.ldap.BLdapUserService;
import javax.baja.license.FeatureNotLicensedException;
import javax.baja.license.LicenseException;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.security.AuthenticationException;
import javax.baja.security.BHttpFoxCredentials;
import javax.baja.security.BICredentials;
import javax.baja.security.BPassword;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.security.kerberos.BKerberosCredentials;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUserService;
import javax.naming.directory.DirContext;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.kerberos.KerberosKey;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KeyTab;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.ietf.jgss.GSSCredential;
import sun.security.krb5.KrbException;

public class BKerberosAuthenticator
extends BAuthenticator {
    public static final Property realm = BKerberosAuthenticator.newProperty((int)0, (String)"EXAMPLE.COM", null);
    public static final Property realmDisplayName = BKerberosAuthenticator.newProperty((int)0, (String)"", null);
    public static final Property keyDistributionCenter = BKerberosAuthenticator.newProperty((int)0, (String)"kdc.example.com", null);
    public static final Property stationKerberosName = BKerberosAuthenticator.newProperty((int)0, (String)"station name", null);
    public static final Property stationKerberosPassword = BKerberosAuthenticator.newProperty((int)0, (BValue)BPassword.DEFAULT, null);
    public static final Property keyTabLocation = BKerberosAuthenticator.newProperty((int)0, (BValue)BOrd.DEFAULT, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$ldap$v3$auth$BKerberosAuthenticator == null ? (class$com$tridium$ldap$v3$auth$BKerberosAuthenticator = BKerberosAuthenticator.class$("com.tridium.ldap.v3.auth.BKerberosAuthenticator")) : class$com$tridium$ldap$v3$auth$BKerberosAuthenticator));
    private Subject subject = null;
    private static final String LDAP_KERB_NOT_LICENSED = "ldap.kerberos.notLicensed";
    private static final String LDAP_KERB_BIND = "ldap.kerberos.bind";
    private static final String LDAP_KERB_UNSUPPORTED_CREDS = "ldap.kerberos.unsupportedCreds";
    private static final String LDAP_KERB_PRIN_NOT_FOUND = "ldap.kerberos.station.principalNotFound";
    private static final String LDAP_KERB_STAT_INVALID_CREDS = "ldap.kerberos.station.invalidCreds";
    private static final String LDAP_KERB_STAT_LOGIN_FAIL = "ldap.kerberos.station.loginFailed";
    private static final String ENCRYPTION_PREFIX = "[aes]";
    private static final int KRB_EXC_C_PRINCIPAL_UNKNOWN = 6;
    private static final int KRB_EXC_PREAUTH_FAILED = 24;
    static /* synthetic */ Class class$com$tridium$ldap$v3$auth$BKerberosAuthenticator;

    public String getRealm() {
        return this.getString(realm);
    }

    public void setRealm(String string) {
        this.setString(realm, string, null);
    }

    public String getRealmDisplayName() {
        return this.getString(realmDisplayName);
    }

    public void setRealmDisplayName(String string) {
        this.setString(realmDisplayName, string, null);
    }

    public String getKeyDistributionCenter() {
        return this.getString(keyDistributionCenter);
    }

    public void setKeyDistributionCenter(String string) {
        this.setString(keyDistributionCenter, string, null);
    }

    public String getStationKerberosName() {
        return this.getString(stationKerberosName);
    }

    public void setStationKerberosName(String string) {
        this.setString(stationKerberosName, string, null);
    }

    public BPassword getStationKerberosPassword() {
        return (BPassword)this.get(stationKerberosPassword);
    }

    public void setStationKerberosPassword(BPassword bPassword) {
        this.set(stationKerberosPassword, (BValue)bPassword, null);
    }

    public BOrd getKeyTabLocation() {
        return (BOrd)this.get(keyTabLocation);
    }

    public void setKeyTabLocation(BOrd bOrd) {
        this.set(keyTabLocation, (BValue)bOrd, null);
    }

    public Type getType() {
        return TYPE;
    }

    public FoxMessage getRejectedData() {
        FoxMessage foxMessage = new FoxMessage();
        foxMessage.add("kerberosRealm", this.getRealm());
        return foxMessage;
    }

    public BICredentials challenge(FoxSession foxSession) throws Exception {
        FoxMessage foxMessage = new FoxMessage();
        foxMessage.add("method", "kerberos");
        foxMessage.add("realm", this.getRealm());
        foxMessage.add("kdc", this.getKeyDistributionCenter());
        foxMessage.add("server", this.getStationKerberosName());
        foxSession.setState("server.tune sendChallenge kerberos");
        foxSession.sendTuning("challenge", foxMessage);
        foxSession.setState("server.tune receive firstMessage");
        FoxMessage foxMessage2 = foxSession.receiveTuning("authMessage1");
        String string = foxMessage2.getString("authInput");
        foxSession.setState("server.tune receivedChallengeResponse authInputType=" + string);
        if (string.equals("authInputLocal")) {
            foxSession.setState("server.tune receiveLogin");
            FoxMessage foxMessage3 = foxSession.receiveTuning("login");
            String string2 = foxMessage3.getString("username", null);
            String string3 = foxMessage3.getString("password", null);
            BLdapUserService bLdapUserService = (BLdapUserService)Sys.getService((Type)BUserService.TYPE);
            if (!bLdapUserService.isLocalUser(string2)) {
                return null;
            }
            return new BUsernameAndPassword(string2, string3);
        }
        if (string.equals("authInputHttp")) {
            byte[] byArray = foxMessage2.getBlob("credentials");
            BHttpFoxCredentials bHttpFoxCredentials = (BHttpFoxCredentials)ValueByteBuffer.unmarshal((byte[])byArray);
            return bHttpFoxCredentials;
        }
        return this.acquireKerberosCredentials(foxSession);
    }

    private BKerberosCredentials acquireKerberosCredentials(FoxSession foxSession) throws Exception {
        try {
            this.requireKerberosFeature();
        }
        catch (LicenseException licenseException) {
            String string = lex.getText(LDAP_KERB_NOT_LICENSED);
            log.error(string);
            this.sendTokenTuningError(foxSession, string);
            throw new FoxAuthenticationException(string, string, null, foxSession);
        }
        System.setProperty("java.security.krb5.realm", this.getRealm());
        System.setProperty("java.security.krb5.kdc", this.getKeyDistributionCenter());
        Subject subject = null;
        try {
            subject = this.getSubject();
        }
        catch (LoginException loginException) {
            Throwable throwable = loginException.getCause();
            if (throwable instanceof KrbException) {
                this.handleKrbException(foxSession, (KrbException)throwable);
            }
            log.error(lex.getText(LDAP_KERB_STAT_LOGIN_FAIL));
            throw new FoxAuthenticationException(lex.getText(LDAP_KERB_STAT_LOGIN_FAIL), null, null, foxSession);
        }
        BKerberosCredentials bKerberosCredentials = (BKerberosCredentials)Subject.doAs(subject, new AcquireCredentialsAction(foxSession));
        return bKerberosCredentials;
    }

    private void handleKrbException(FoxSession foxSession, KrbException krbException) {
        int n = krbException.returnCode();
        switch (n) {
            case 6: {
                log.error(lex.getText(LDAP_KERB_PRIN_NOT_FOUND));
                break;
            }
            default: {
                log.error(lex.getText(LDAP_KERB_STAT_INVALID_CREDS));
                this.sendTokenTuningError(foxSession, lex.getText(LDAP_KERB_STAT_INVALID_CREDS));
            }
        }
    }

    private void sendTokenTuningError(FoxSession foxSession, String string) {
        try {
            FoxMessage foxMessage = new FoxMessage();
            foxMessage.add("error", string);
            foxSession.setState("server.token " + string);
            foxSession.sendTuning("serverToken", foxMessage);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public DirContext authenticate(BICredentials bICredentials, Context context) throws Exception {
        Subject subject;
        Object object;
        this.requireKerberosFeature();
        if (bICredentials instanceof BUsernameAndPassword) {
            object = (BUsernameAndPassword)bICredentials;
            KerberosConfig kerberosConfig = new KerberosConfig(object.getUsername());
            System.setProperty("java.security.krb5.realm", this.getRealm());
            System.setProperty("java.security.krb5.kdc", this.getKeyDistributionCenter());
            LoginContext loginContext = null;
            try {
                loginContext = new LoginContext("com.tridium.ldap.v3.auth.BKerberosAuthenticator", null, (CallbackHandler)new KerberosCallbackHandler(object.getUsername(), object.getPassword().getValue()), (Configuration)kerberosConfig);
                loginContext.login();
            }
            catch (LoginException loginException) {
                log.error(lex.getText(LDAP_KERB_STAT_LOGIN_FAIL));
                throw new AuthenticationException("Invalid Credentials");
            }
            subject = loginContext.getSubject();
        } else if (bICredentials instanceof BKerberosCredentials) {
            object = ((BKerberosCredentials)bICredentials).getCredential();
            subject = GSSUtil.createSubject(object.getName(), (GSSCredential)object);
        } else {
            throw new AuthenticationException(lex.getText(LDAP_KERB_UNSUPPORTED_CREDS));
        }
        log.trace(lex.getText(LDAP_KERB_BIND));
        try {
            object = (DirContext)Subject.doAs(subject, new LdapKerberosAuthAction((BLdapV3Ext)this.getParent()));
            return object;
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (Exception)privilegedActionException.getCause();
        }
    }

    private Subject getSubject() throws LoginException {
        Object object;
        Subject subject;
        String string = null;
        BOrd bOrd = this.getKeyTabLocation();
        if (bOrd != BOrd.NULL && !bOrd.isNull()) {
            try {
                string = BFileSystem.INSTANCE.pathToLocalFile(bOrd.resolve().getFilePath()).getPath();
            }
            catch (Exception exception) {
                string = null;
            }
        }
        if (string != null) {
            try {
                if (!this.encryptKeytab(new File(string))) {
                    this.subject = null;
                }
            }
            catch (Exception exception) {
                this.subject = null;
            }
        }
        if ((subject = this.subject) != null) {
            return subject;
        }
        String string2 = this.getStationKerberosName();
        if (string != null) {
            object = new KerberosKeytabConfig(string2, string + "_plain");
        } else {
            object = new KerberosConfig(string2);
            object.setIsInitiator(false);
        }
        LoginContext loginContext = new LoginContext("com.tridium.ldap.auth.BKerberosAuthenticator", null, (CallbackHandler)new KerberosCallbackHandler(string2, this.getStationKerberosPassword().getValue()), (Configuration)object);
        loginContext.login();
        Subject subject2 = loginContext.getSubject();
        if (string == null) {
            return subject2;
        }
        try {
            this.decryptKeytab(new File(string));
        }
        catch (Exception exception) {
            // empty catch block
        }
        HashSet hashSet = new HashSet();
        Iterator<Object> iterator = subject2.getPrivateCredentials().iterator();
        while (iterator.hasNext()) {
            KerberosKey[] kerberosKeyArray;
            Object object2 = iterator.next();
            if (!(object2 instanceof KeyTab)) continue;
            KerberosPrincipal kerberosPrincipal = null;
            Iterator<Principal> iterator2 = subject2.getPrincipals().iterator();
            while (iterator2.hasNext()) {
                kerberosKeyArray = iterator2.next();
                if (!(kerberosKeyArray instanceof KerberosPrincipal)) continue;
                kerberosPrincipal = (KerberosPrincipal)kerberosKeyArray;
                break;
            }
            kerberosKeyArray = ((KeyTab)object2).getKeys(kerberosPrincipal);
            Collections.addAll(hashSet, kerberosKeyArray);
        }
        new File(string + "_plain").delete();
        subject = !hashSet.isEmpty() ? (this.subject = new Subject(subject2.isReadOnly(), subject2.getPrincipals(), subject2.getPublicCredentials(), hashSet)) : subject2;
        return subject;
    }

    public void changed(Property property, Context context) {
        if (property.equals(keyTabLocation)) {
            this.subject = null;
            BOrd bOrd = this.getKeyTabLocation();
            if (bOrd != null && !bOrd.isNull()) {
                String string = null;
                try {
                    string = BFileSystem.INSTANCE.pathToLocalFile(bOrd.resolve().getFilePath()).getPath();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (string != null) {
                    try {
                        this.encryptKeytab(new File(string));
                    }
                    catch (Exception exception) {}
                }
            }
        } else if (property.equals(stationKerberosName)) {
            this.subject = null;
        }
    }

    public void started() {
        BOrd bOrd = this.getKeyTabLocation();
        if (bOrd != null && !bOrd.isNull()) {
            String string = null;
            try {
                string = BFileSystem.INSTANCE.pathToLocalFile(bOrd.resolve().getFilePath()).getPath();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (string != null) {
                try {
                    this.encryptKeytab(new File(string));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean encryptKeytab(File file) throws Exception {
        byte[] byArray;
        FileOutputStream fileOutputStream;
        block9: {
            boolean bl;
            fileOutputStream = null;
            byArray = null;
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                byArray = FileUtil.read((InputStream)fileInputStream, (long)file.length());
                if (!new String(byArray).startsWith(ENCRYPTION_PREFIX)) break block9;
                bl = true;
            }
            catch (Throwable throwable) {
                SecurityUtil.zeroByteArray(byArray);
                try {
                    fileOutputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            SecurityUtil.zeroByteArray((byte[])byArray);
            try {
                fileOutputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return bl;
        }
        String string = this.encrypt(byArray);
        fileOutputStream = new FileOutputStream(file);
        fileOutputStream.write(string.getBytes());
        boolean bl = false;
        SecurityUtil.zeroByteArray((byte[])byArray);
        try {
            fileOutputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decryptKeytab(File file) throws Exception {
        FileOutputStream fileOutputStream = null;
        byte[] byArray = null;
        try {
            String string = FileUtil.readString((File)file);
            if (string.startsWith(ENCRYPTION_PREFIX)) {
                byArray = this.decrypt(string);
                File file2 = new File(file.getAbsolutePath() + "_plain");
                fileOutputStream = new FileOutputStream(file2);
                fileOutputStream.write(byArray);
            }
        }
        finally {
            SecurityUtil.zeroByteArray(byArray);
            try {
                fileOutputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    private String encrypt(byte[] byArray) throws Exception {
        byte[] byArray2 = new byte[16];
        new SecureRandom().nextBytes(byArray2);
        byte[] byArray3 = Aes256PasswordManager.getManager((KeyRing)Nre.getSecurityInfoProvider().getKeyRing()).encrypt(byArray, byArray2);
        return ENCRYPTION_PREFIX + ByteArrayUtil.toHexString((byte[])byArray2) + ":" + ByteArrayUtil.toHexString((byte[])byArray3);
    }

    private byte[] decrypt(String string) throws Exception {
        string = string.replace(ENCRYPTION_PREFIX, "");
        String[] stringArray = string.split(":");
        return Aes256PasswordManager.getManager((KeyRing)Nre.getSecurityInfoProvider().getKeyRing()).decryptToBytes(stringArray[1], stringArray[0]);
    }

    private void requireKerberosFeature() throws LicenseException {
        if (!this.getLdapV3Ext().getLdapv3Feature().getb("kerberos", false)) {
            throw new FeatureNotLicensedException(lex.getText(LDAP_KERB_NOT_LICENSED));
        }
    }

    public boolean supportsMultipleExtensions() {
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

