/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ldap.v3.auth;

import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.session.FoxSession;
import com.tridium.ldap.v3.auth.BKerberosAuthenticator;
import java.security.PrivilegedAction;
import javax.baja.security.kerberos.BKerberosCredentials;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSManager;

class AcquireCredentialsAction
implements PrivilegedAction {
    private FoxSession session;

    public AcquireCredentialsAction(FoxSession foxSession) {
        this.session = foxSession;
    }

    public Object run() {
        GSSCredential gSSCredential = null;
        try {
            GSSManager gSSManager = GSSManager.getInstance();
            GSSContext gSSContext = gSSManager.createContext((GSSCredential)null);
            byte[] byArray = null;
            while (!gSSContext.isEstablished()) {
                this.session.setState("server.tune receiveToken");
                FoxMessage foxMessage = this.session.receiveTuning("clientToken");
                byArray = foxMessage.getBlob("token");
                if (byArray.length == 0) {
                    return null;
                }
                if ((byArray = gSSContext.acceptSecContext(byArray, 0, byArray.length)) == null) continue;
                FoxMessage foxMessage2 = new FoxMessage();
                foxMessage2.add("token", byArray);
                this.session.setState("server.tune sendToken");
                this.session.sendTuning("serverToken", foxMessage2);
            }
            gSSCredential = gSSContext.getDelegCred();
            if (gSSCredential == null) {
                return null;
            }
        }
        catch (Exception exception) {
            BKerberosAuthenticator.log.error("Error acquiring credentials. Cause is: " + exception);
            return null;
        }
        return new BKerberosCredentials(gSSCredential);
    }
}

