/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.modbusTcp.comm;

import com.tridium.basicdriver.comm.CommTransmitter;
import com.tridium.basicdriver.message.Message;
import com.tridium.modbusCore.BModbusNetwork;
import com.tridium.modbusCore.messages.ModbusMessageConst;
import com.tridium.modbusTcp.BModbusTcpDevice;
import com.tridium.modbusTcp.BModbusTcpGateway;
import com.tridium.modbusTcp.comm.ModbusTcpComm;
import com.tridium.modbusTcp.comm.ModbusTcpRxDriver;

public class ModbusTcpTxDriver
extends CommTransmitter
implements ModbusMessageConst {
    public void writeMessage(Message message) {
        ModbusTcpRxDriver modbusTcpRxDriver = (ModbusTcpRxDriver)this.getComm().getCommReceiver();
        BModbusTcpDevice bModbusTcpDevice = null;
        try {
            ModbusTcpComm modbusTcpComm = (ModbusTcpComm)this.getComm();
            BModbusNetwork bModbusNetwork = (BModbusNetwork)modbusTcpComm.getNetwork();
            bModbusTcpDevice = (BModbusTcpDevice)modbusTcpComm.getDevice();
            if (bModbusTcpDevice != null) {
                if (bModbusNetwork.getLog().isTraceOn()) {
                    bModbusNetwork.getLog().trace("**** ModbusTcp Send Bytes [destination " + bModbusTcpDevice.getIpAddress() + ':' + bModbusTcpDevice.getPort() + "]: " + message.toDebugString());
                }
            } else if (bModbusNetwork.getLog().isTraceOn()) {
                bModbusNetwork.getLog().trace("**** ModbusTcp Send Bytes [destination " + ((BModbusTcpGateway)bModbusNetwork).getIpAddress() + ':' + ((BModbusTcpGateway)bModbusNetwork).getPort() + "]: " + message.toDebugString());
            }
            modbusTcpRxDriver.writeOutputStream(message);
        }
        catch (Exception exception) {
            if (bModbusTcpDevice != null) {
                this.getComm().getNetwork().getLog().error("[" + bModbusTcpDevice.getIpAddress() + ':' + bModbusTcpDevice.getPort() + "]: Problem sending ModbusTcp message: " + exception.getMessage());
            }
            this.getComm().getNetwork().getLog().error("Problem sending ModbusTcp message: " + exception.getMessage());
        }
    }
}

