/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.modbusTcp;

import com.tridium.basicdriver.comm.Comm;
import com.tridium.basicdriver.message.Message;
import com.tridium.modbusCore.BModbusNetwork;
import com.tridium.modbusCore.client.BModbusClientDevice;
import com.tridium.modbusCore.messages.ModbusMessage;
import com.tridium.modbusCore.messages.ModbusResponse;
import com.tridium.modbusTcp.BModbusTcpGatewayDevice;
import com.tridium.modbusTcp.BModbusTcpGatewayDeviceFolder;
import com.tridium.modbusTcp.BModbusTcpNetwork;
import com.tridium.modbusTcp.BSocketStatusEnum;
import com.tridium.modbusTcp.comm.ModbusTcpComm;
import com.tridium.modbusTcp.comm.ModbusTcpRxDriver;
import java.net.InetAddress;
import javax.baja.agent.AgentList;
import javax.baja.driver.BDevice;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BModbusTcpGateway
extends BModbusTcpNetwork {
    public static final Property ipAddress = BModbusTcpGateway.newProperty((int)0, (String)"###.###.###.###", null);
    public static final Property port = BModbusTcpGateway.newProperty((int)0, (int)502, (BFacets)BFacets.makeInt(null, (int)0, (int)((char)-1)));
    public static final Property socketStatus = BModbusTcpGateway.newProperty((int)3, (BValue)BSocketStatusEnum.closed, null);
    public static final Type TYPE;
    static /* synthetic */ Class class$com$tridium$modbusTcp$BModbusTcpGateway;

    public String getIpAddress() {
        return this.getString(ipAddress);
    }

    public void setIpAddress(String string) {
        this.setString(ipAddress, string, null);
    }

    public int getPort() {
        return this.getInt(port);
    }

    public void setPort(int n) {
        this.setInt(port, n, null);
    }

    public BSocketStatusEnum getSocketStatus() {
        return (BSocketStatusEnum)this.get(socketStatus);
    }

    public void setSocketStatus(BSocketStatusEnum bSocketStatusEnum) {
        this.set(socketStatus, (BValue)bSocketStatusEnum, null);
    }

    public Type getType() {
        return TYPE;
    }

    public Type getDeviceType() {
        return BModbusTcpGatewayDevice.TYPE;
    }

    public Type getDeviceFolderType() {
        return BModbusTcpGatewayDeviceFolder.TYPE;
    }

    protected Comm makeComm() {
        return new ModbusTcpComm((BModbusNetwork)this);
    }

    protected boolean initializeNetwork() {
        if (this.networkInitialized) {
            return true;
        }
        this.commActive = true;
        if (!this.getComm().isCommStarted()) {
            if (this.getModbusLog().isTraceOn()) {
                this.getModbusLog().warning("Unable to start TCP/IP Comm for " + (Object)((Object)this));
            }
            this.commActive = false;
            return false;
        }
        this.networkInitialized = true;
        return true;
    }

    public boolean isCommActive() {
        boolean bl = false;
        if (this.getComm().isCommStarted() && this.commActive && !this.isDisabled() && !this.isDown() && !this.isFatalFault()) {
            bl = true;
        }
        return bl;
    }

    public InetAddress getInetAddr() {
        InetAddress inetAddress;
        try {
            String string = this.getIpAddress().trim();
            inetAddress = string.equalsIgnoreCase("###.###.###.###") || string.length() == 0 ? null : InetAddress.getByName(string);
        }
        catch (Exception exception) {
            inetAddress = null;
        }
        return inetAddress;
    }

    public void changed(Property property, Context context) {
        block5: {
            super.changed(property, context);
            try {
                if ((property.equals((Object)ipAddress) || property.equals((Object)port)) && this.getComm() != null && this.getComm().isCommStarted()) {
                    this.getComm().stop();
                    InetAddress inetAddress = this.getInetAddr();
                    if (inetAddress == null && this.getModbusLog() != null) {
                        this.getModbusLog().error("\nCould not resolve IP address [" + this.getIpAddress() + "].");
                    }
                    this.getComm().start();
                    BDevice[] bDeviceArray = this.getDevices();
                    int n = 0;
                    while (n < bDeviceArray.length) {
                        bDeviceArray[n].ping();
                        ++n;
                    }
                }
            }
            catch (Exception exception) {
                if (this.getModbusLog() == null) break block5;
                this.getModbusLog().error("Caught exception in BModbusTcpGateway.changed()", (Throwable)exception);
            }
        }
    }

    public Message sendSync(Message message, BRelTime bRelTime, int n) {
        if (!this.isCommActive()) {
            return null;
        }
        int n2 = this.getSocketStatus().getOrdinal();
        if (n2 == 0 || n2 == 2) {
            ((ModbusTcpRxDriver)this.getComm().getCommReceiver()).initSocketConnection();
            n2 = this.getSocketStatus().getOrdinal();
        }
        Message message2 = null;
        if (n2 == 3) {
            message2 = super.sendSync(message, bRelTime, n);
        }
        try {
            BModbusClientDevice bModbusClientDevice = this.findDeviceInNetwork(((ModbusMessage)message).deviceAddress);
            if (bModbusClientDevice != null) {
                if (message2 != null && ((ModbusResponse)message2).exceptionCode != 10 && ((ModbusResponse)message2).exceptionCode != 11) {
                    bModbusClientDevice.pingOk();
                    bModbusClientDevice.resetPingsFailed();
                } else if (bModbusClientDevice.incrementPingsFailed() > this.getMaxFailsUntilDeviceDown()) {
                    String string = this.getLexicon().getText("pingFail");
                    if (message2 != null) {
                        string = string + ": " + ((ModbusResponse)message2).getExceptionString();
                    }
                    bModbusClientDevice.pingFail(string);
                }
            }
        }
        catch (Exception exception) {}
        return message2;
    }

    public AgentList getAgents(Context context) {
        TypeInfo typeInfo = Sys.getRegistry().getType("modbusTcp:ModbusTcpDeviceManager");
        AgentList agentList = super.getAgents(context);
        agentList.remove(typeInfo.getAgentInfo());
        return agentList;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$modbusTcp$BModbusTcpGateway;
        if (clazz == null) {
            clazz = class$com$tridium$modbusTcp$BModbusTcpGateway = BModbusTcpGateway.class("[Lcom.tridium.modbusTcp.BModbusTcpGateway;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

