/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.modbusTcpSlave.comm;

import com.tridium.modbusCore.BModbusDevice;
import com.tridium.modbusCore.ModbusException;
import com.tridium.modbusCore.messages.ModbusMessage;
import com.tridium.modbusCore.messages.ModbusMessageConst;
import com.tridium.modbusCore.messages.ModbusResponse;
import com.tridium.modbusCore.messages.ModbusWriteRequest;
import com.tridium.modbusCore.server.messages.ModbusServerReadFileRequest;
import com.tridium.modbusCore.server.messages.ModbusServerReadFileResponse;
import com.tridium.modbusCore.server.messages.ModbusServerReadRequest;
import com.tridium.modbusCore.server.messages.ModbusServerWriteFileRequest;
import com.tridium.modbusCore.server.messages.ModbusServerWriteFileResponse;
import com.tridium.modbusCore.server.messages.ModbusServerWriteRequest;
import com.tridium.modbusCore.server.util.TLinkedListElement;
import com.tridium.modbusCore.server.util.TLinkedListManager;
import com.tridium.modbusTcpSlave.BModbusTcpSlaveDevice;
import com.tridium.modbusTcpSlave.BModbusTcpSlaveNetwork;
import com.tridium.modbusTcpSlave.comm.ModbusTcpSlaveSession;
import com.tridium.modbusTcpSlave.comm.UnsolicitedMessageElement;
import javax.baja.driver.BDevice;
import javax.baja.sys.Clock;
import javax.baja.sys.Sys;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ModbusUnsolicitedReceive
implements Runnable,
ModbusMessageConst {
    private TLinkedListManager unsolicitedMessageManager;
    private BModbusTcpSlaveNetwork host;
    private boolean timeToDie;
    private Thread myThread;
    private long delayedStartTicks;

    public final void init() {
    }

    public final void cleanup() {
    }

    public final void start() {
        this.timeToDie = false;
        this.myThread = new Thread((Runnable)this, "ModTcpSlave:UnsolRcv");
        this.myThread.start();
    }

    public final void stop() {
        this.timeToDie = true;
        this.myThread.stop();
    }

    public boolean isDying() {
        return this.timeToDie;
    }

    public void atSteadyState() {
        this.delayedStartTicks = Clock.ticks() + 1000L;
    }

    public void run() {
        this.delayedStartTicks = Sys.atSteadyState() ? Clock.ticks() + 10000L : Clock.ticks() + 120000L;
        this.unsolicitedMessageManager = new TLinkedListManager("ModbusTcpUnsolicitedReceive Manager");
        while (!this.timeToDie) {
            ModbusTcpSlaveSession modbusTcpSlaveSession;
            UnsolicitedMessageElement unsolicitedMessageElement;
            try {
                unsolicitedMessageElement = (UnsolicitedMessageElement)this.unsolicitedMessageManager.removeFromHead((long)-1);
                if (this.delayedStartTicks > 0L) {
                    long l = this.delayedStartTicks - Clock.ticks();
                    if (l > 0L) {
                        this.host.getModbusLog().message("delayedStartsTicks: " + l);
                        unsolicitedMessageElement = null;
                    } else if (unsolicitedMessageElement != null) {
                        this.delayedStartTicks = 0L;
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                this.host.getModbusLog().error("ModbusUnsolicitedReceive.run Problem with " + this.unsolicitedMessageManager.getName() + ": ", (Throwable)interruptedException);
                unsolicitedMessageElement = null;
                modbusTcpSlaveSession = null;
            }
            try {
                if (unsolicitedMessageElement == null) continue;
                byte[] byArray = unsolicitedMessageElement.getMessage();
                modbusTcpSlaveSession = unsolicitedMessageElement.getTcpSession();
                int n = unsolicitedMessageElement.getTransactionIdentifier();
                if (byArray.length == 0) continue;
                int n2 = byArray[0] & 0xFF;
                BModbusTcpSlaveDevice bModbusTcpSlaveDevice = this.findModbusDevice(n2);
                if (bModbusTcpSlaveDevice != null) {
                    bModbusTcpSlaveDevice.incrementRequest();
                    if (!bModbusTcpSlaveDevice.getStatus().isDisabled()) {
                        switch (byArray[1]) {
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: {
                                ModbusServerReadRequest modbusServerReadRequest = new ModbusServerReadRequest(2, (BModbusDevice)bModbusTcpSlaveDevice, byArray);
                                modbusServerReadRequest.setTransactionIdentifier(n);
                                modbusTcpSlaveSession.sendMessage((ModbusMessage)this.processReadRequest(bModbusTcpSlaveDevice, modbusServerReadRequest));
                                break;
                            }
                            case 5: 
                            case 6: 
                            case 15: 
                            case 16: {
                                ModbusServerWriteRequest modbusServerWriteRequest = new ModbusServerWriteRequest(2, (BModbusDevice)bModbusTcpSlaveDevice, byArray);
                                modbusServerWriteRequest.setTransactionIdentifier(n);
                                modbusTcpSlaveSession.sendMessage((ModbusMessage)this.processWriteRequest(bModbusTcpSlaveDevice, modbusServerWriteRequest));
                                break;
                            }
                            case 20: {
                                ModbusServerReadFileRequest modbusServerReadFileRequest = new ModbusServerReadFileRequest(byArray);
                                modbusTcpSlaveSession.sendMessage((ModbusMessage)this.processReadFileRequest(bModbusTcpSlaveDevice, modbusServerReadFileRequest, n));
                                break;
                            }
                            case 21: {
                                ModbusServerWriteFileRequest modbusServerWriteFileRequest = new ModbusServerWriteFileRequest(byArray);
                                modbusTcpSlaveSession.sendMessage((ModbusMessage)this.processWriteFileRequest(bModbusTcpSlaveDevice, modbusServerWriteFileRequest, n));
                                break;
                            }
                            default: {
                                ModbusResponse modbusResponse = new ModbusResponse(this.host.getModbusMode(), (BModbusDevice)bModbusTcpSlaveDevice);
                                modbusResponse.transactionIdentifier = n;
                                modbusResponse.setResponseExpected(false);
                                modbusResponse.deviceAddress = (byte)n2;
                                modbusResponse.functionCode = (byte)(byArray[1] | 0x80);
                                modbusResponse.byteCount = 1;
                                modbusResponse.data = new byte[0];
                                modbusTcpSlaveSession.sendMessage((ModbusMessage)modbusResponse);
                                break;
                            }
                        }
                        continue;
                    }
                    if (!this.host.getModbusLog().isTraceOn()) continue;
                    this.host.getModbusLog().trace("ModbusTcpUnsolicitedReceive found device is disabled: " + n2);
                    continue;
                }
                if (!this.host.getModbusLog().isTraceOn()) continue;
                this.host.getModbusLog().trace("ModbusTcpUnsolicitedReceive did not find device: " + n2);
            }
            catch (Exception exception) {
                this.host.getModbusLog().error(" ModbusTcpUnsolicitedReceive thread caught Exception: ", (Throwable)exception);
            }
        }
    }

    private final ModbusResponse processReadRequest(BModbusTcpSlaveDevice bModbusTcpSlaveDevice, ModbusServerReadRequest modbusServerReadRequest) {
        ModbusResponse modbusResponse = new ModbusResponse(2, (BModbusDevice)bModbusTcpSlaveDevice);
        modbusResponse.deviceAddress = (byte)modbusServerReadRequest.deviceAddress;
        modbusResponse.functionCode = (byte)modbusServerReadRequest.functionCode;
        modbusResponse.transactionIdentifier = modbusServerReadRequest.transactionIdentifier;
        int n = modbusServerReadRequest.startAddress;
        int n2 = modbusServerReadRequest.functionCode;
        int n3 = modbusServerReadRequest.numberPoints;
        boolean bl = false;
        try {
            switch (n2) {
                case 1: {
                    modbusResponse.data = bModbusTcpSlaveDevice.getCoilStatusValues(n, n3);
                    break;
                }
                case 2: {
                    modbusResponse.data = bModbusTcpSlaveDevice.getInputStatusValues(n, n3);
                    break;
                }
                case 3: {
                    modbusResponse.data = bModbusTcpSlaveDevice.getHoldingRegisterValues(n, n3);
                    break;
                }
                case 4: {
                    modbusResponse.data = bModbusTcpSlaveDevice.getInputRegisterValues(n, n3);
                    break;
                }
                default: {
                    bl = true;
                    break;
                }
            }
        }
        catch (ModbusException modbusException) {
            bl = true;
        }
        if (bl) {
            modbusResponse.functionCode = (byte)(modbusResponse.functionCode | 0x80);
            modbusResponse.byteCount = 2;
            modbusResponse.data = new byte[0];
            return modbusResponse;
        }
        modbusResponse.byteCount = (byte)modbusResponse.data.length;
        return modbusResponse;
    }

    private final ModbusResponse processWriteRequest(BModbusTcpSlaveDevice bModbusTcpSlaveDevice, ModbusServerWriteRequest modbusServerWriteRequest) {
        ModbusResponse modbusResponse = new ModbusResponse(2, (BModbusDevice)bModbusTcpSlaveDevice, (ModbusWriteRequest)modbusServerWriteRequest);
        modbusResponse.transactionIdentifier = modbusServerWriteRequest.transactionIdentifier;
        int n = modbusServerWriteRequest.startAddress;
        int n2 = modbusServerWriteRequest.functionCode;
        boolean bl = false;
        switch (n2) {
            case 5: {
                if (bModbusTcpSlaveDevice.isCoilAddressValid(n, modbusServerWriteRequest.numberPoints)) {
                    boolean bl2 = false;
                    if ((modbusServerWriteRequest.data[0] & 0xFF) == 255) {
                        bl2 = true;
                    }
                    bModbusTcpSlaveDevice.setCoilStatusValue(n, bl2);
                    break;
                }
                bl = true;
                break;
            }
            case 15: {
                if (bModbusTcpSlaveDevice.isCoilAddressValid(n, modbusServerWriteRequest.numberPoints)) {
                    bModbusTcpSlaveDevice.setCoilStatusValue(n, modbusServerWriteRequest.numberPoints, modbusServerWriteRequest.data);
                    break;
                }
                bl = true;
                break;
            }
            case 6: 
            case 16: {
                if (bModbusTcpSlaveDevice.isHoldingRegisterAddressValid(n, modbusServerWriteRequest.numberPoints)) {
                    bModbusTcpSlaveDevice.setHoldingRegisterValues(n, modbusServerWriteRequest.data);
                    break;
                }
                bl = true;
                break;
            }
            default: {
                bl = true;
            }
        }
        if (bl) {
            modbusResponse.functionCode = (byte)(modbusResponse.functionCode | 0x80);
            modbusResponse.byteCount = 2;
            return modbusResponse;
        }
        return modbusResponse;
    }

    private final ModbusResponse processReadFileRequest(BModbusTcpSlaveDevice bModbusTcpSlaveDevice, ModbusServerReadFileRequest modbusServerReadFileRequest, int n) {
        ModbusServerReadFileResponse modbusServerReadFileResponse = new ModbusServerReadFileResponse(this.host.getModbusMode(), (BModbusDevice)bModbusTcpSlaveDevice, modbusServerReadFileRequest);
        modbusServerReadFileResponse.transactionIdentifier = n;
        int n2 = modbusServerReadFileRequest.getNumSubRequests();
        boolean bl = false;
        try {
            int n3 = 0;
            while (n3 < n2) {
                modbusServerReadFileResponse.addSubRequestData(modbusServerReadFileRequest.getFileNumber(n3), modbusServerReadFileRequest.getStartingRecordNumber(n3), modbusServerReadFileRequest.getRecordLength(n3), bModbusTcpSlaveDevice.getFileRecordData(modbusServerReadFileRequest.getFileNumber(n3), modbusServerReadFileRequest.getStartingRecordNumber(n3), modbusServerReadFileRequest.getRecordLength(n3)));
                ++n3;
            }
        }
        catch (Exception exception) {
            bl = true;
        }
        if (bl) {
            modbusServerReadFileResponse.functionCode = (byte)(modbusServerReadFileResponse.functionCode | 0x80);
            modbusServerReadFileResponse.byteCount = 2;
            modbusServerReadFileResponse.data = new byte[0];
        } else {
            modbusServerReadFileResponse.byteCount = (byte)modbusServerReadFileResponse.data.length;
        }
        return modbusServerReadFileResponse;
    }

    private final ModbusResponse processWriteFileRequest(BModbusTcpSlaveDevice bModbusTcpSlaveDevice, ModbusServerWriteFileRequest modbusServerWriteFileRequest, int n) {
        ModbusServerWriteFileResponse modbusServerWriteFileResponse = new ModbusServerWriteFileResponse(this.host.getModbusMode(), (BModbusDevice)bModbusTcpSlaveDevice, modbusServerWriteFileRequest);
        modbusServerWriteFileResponse.transactionIdentifier = n;
        int n2 = modbusServerWriteFileRequest.getNumSubRequests();
        boolean bl = false;
        try {
            int n3 = 0;
            while (n3 < n2) {
                modbusServerWriteFileResponse.addSubRequestData(modbusServerWriteFileRequest.getFileNumber(n3), modbusServerWriteFileRequest.getStartingRecordNumber(n3), modbusServerWriteFileRequest.getRecordLength(n3), bModbusTcpSlaveDevice.setFileRecordData(modbusServerWriteFileRequest.getFileNumber(n3), modbusServerWriteFileRequest.getStartingRecordNumber(n3), modbusServerWriteFileRequest.getRecordLength(n3), modbusServerWriteFileRequest.getRecordData(n3)));
                ++n3;
            }
        }
        catch (Exception exception) {
            bl = true;
        }
        if (bl) {
            modbusServerWriteFileResponse.functionCode = (byte)(modbusServerWriteFileResponse.functionCode | 0x80);
            modbusServerWriteFileResponse.byteCount = 2;
            modbusServerWriteFileResponse.data = new byte[0];
        } else {
            modbusServerWriteFileResponse.byteCount = (byte)modbusServerWriteFileResponse.data.length;
        }
        return modbusServerWriteFileResponse;
    }

    public void receiveMessage(UnsolicitedMessageElement unsolicitedMessageElement) {
        if (this.unsolicitedMessageManager != null) {
            this.unsolicitedMessageManager.addToTail((TLinkedListElement)unsolicitedMessageElement);
        }
    }

    public BModbusTcpSlaveDevice findModbusDevice(int n) {
        BDevice[] bDeviceArray = this.host.getDevices();
        int n2 = 0;
        while (n2 < bDeviceArray.length) {
            if (bDeviceArray[n2] != null && bDeviceArray[n2] instanceof BModbusTcpSlaveDevice && ((BModbusTcpSlaveDevice)bDeviceArray[n2]).getDeviceAddress() == n) {
                return (BModbusTcpSlaveDevice)bDeviceArray[n2];
            }
            ++n2;
        }
        return null;
    }

    private final /* synthetic */ void this() {
        this.unsolicitedMessageManager = null;
        this.timeToDie = true;
        this.delayedStartTicks = 0L;
    }

    public ModbusUnsolicitedReceive(BModbusTcpSlaveNetwork bModbusTcpSlaveNetwork) {
        this.this();
        this.host = bModbusTcpSlaveNetwork;
    }
}

