/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.pdf.gx;

import com.tridium.pdf.gx.PdfDocument;
import com.tridium.pdf.gx.PdfObject;
import com.tridium.pdf.gx.PdfStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class PdfPage
extends PdfObject {
    private PdfStream content = this.getParent().createStream();
    private Vector xObjects = new Vector();
    private Hashtable xObjectsRef = new Hashtable();
    private Hashtable fontRef = new Hashtable();

    public PdfStream getContentStream() {
        return this.content;
    }

    public void addXObject(String string, PdfStream pdfStream) {
        this.xObjectsRef.put(string, new Integer(pdfStream.getObjectId()));
        this.xObjects.add(pdfStream);
    }

    public void addXObject(String string, int n) {
        this.xObjectsRef.put(string, new Integer(n));
    }

    public void addFont(String string, int n) {
        this.fontRef.put(string, new Integer(n));
    }

    public void toPdf() throws IOException {
        String string;
        Enumeration<Object> enumeration;
        PdfDocument pdfDocument = this.getParent();
        pdfDocument.markOffset(this.getObjectId());
        pdfDocument.writeln("" + this.getObjectId() + ' ' + this.getGenerationNum() + " obj");
        pdfDocument.write("<< /Type /Page /Parent " + pdfDocument.getPageTreeId() + " 0 R");
        pdfDocument.write(" /MediaBox [0 0 " + pdfDocument.getPageSize().width + ' ' + pdfDocument.getPageSize().height + ']');
        pdfDocument.write(" /Contents " + this.content.getObjectId() + " 0 R");
        pdfDocument.write(" /Resources << /ProcSet [/PDF /Text /ImageC]");
        if (!this.fontRef.isEmpty()) {
            pdfDocument.write(" /Font <<");
            enumeration = this.fontRef.keys();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                pdfDocument.write(" /" + string + ' ' + this.fontRef.get(string) + " 0 R");
            }
            pdfDocument.write(" >>");
        }
        if (!this.xObjects.isEmpty()) {
            pdfDocument.write(" /XObject <<");
            enumeration = this.xObjectsRef.keys();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                pdfDocument.write(" /" + string + ' ' + this.xObjectsRef.get(string) + " 0 R");
            }
            pdfDocument.write(" >>");
        }
        pdfDocument.writeln(" >> >>");
        pdfDocument.writeln("endobj");
        this.content.toPdf();
        enumeration = this.xObjects.elements();
        while (enumeration.hasMoreElements()) {
            ((PdfStream)enumeration.nextElement()).toPdf();
        }
    }

    public PdfPage(PdfDocument pdfDocument, int n, int n2) {
        super(pdfDocument, n, n2);
    }
}

