/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.pdf.gx;

import com.tridium.gx.micro.MicroEnv;
import com.tridium.gx.micro.MicroFontPeer;
import com.tridium.pdf.PdfCidFontInfo;
import com.tridium.pdf.gx.PathSupport;
import com.tridium.pdf.gx.PdfImageStream;
import com.tridium.pdf.gx.PdfPage;
import com.tridium.pdf.gx.PdfStream;
import java.io.IOException;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.BPen;
import javax.baja.gx.BTransform;
import javax.baja.gx.Graphics;
import javax.baja.gx.IEllipseGeom;
import javax.baja.gx.IGeom;
import javax.baja.gx.ILineGeom;
import javax.baja.gx.IPathGeom;
import javax.baja.gx.IPoint;
import javax.baja.gx.IPolygonGeom;
import javax.baja.gx.IRectGeom;
import javax.baja.gx.Point;
import javax.baja.gx.RectGeom;
import javax.baja.gx.Size;
import javax.baja.log.Log;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PdfGraphics
implements Graphics {
    public static final Log log = Log.getLog((String)"pdf");
    static MicroEnv env;
    private BFont font;
    private String pdfFontDescription;
    private BBrush brush;
    private BPen pen;
    public BTransform tx;
    protected PdfPage target;
    private int imageNum;
    private RectGeom clip;
    private int clipStackSize;

    public void setPage(PdfPage pdfPage) {
        this.target = pdfPage;
        this.setPen(BPen.make((String)"1 capSquare joinMiter"));
        Size size = this.target.getParent().getPageSize();
        this.clip = new RectGeom(0.0, 0.0, size.width, size.height);
    }

    public void useAntiAliasing(boolean bl) {
    }

    public BBrush getBrush() {
        return this.brush;
    }

    public void setBrush(BBrush bBrush) {
        this.brush = bBrush;
        try {
            BColor bColor = BColor.white;
            BBrush.Paint paint = bBrush.getPaint();
            if (paint instanceof BBrush.Solid) {
                bColor = ((BBrush.Solid)paint).getColor();
            } else if (paint instanceof BBrush.Gradient) {
                BBrush.Stop stop = ((BBrush.Gradient)bBrush.getPaint()).getStops()[0];
                bColor = stop.getColor();
            }
            float f = (float)bColor.getRed() / 255.0f;
            float f2 = (float)bColor.getGreen() / 255.0f;
            float f3 = (float)bColor.getBlue() / 255.0f;
            PdfStream pdfStream = this.target.getContentStream();
            pdfStream.println("" + f + ' ' + f2 + ' ' + f3 + " rg");
            pdfStream.println("" + f + ' ' + f2 + ' ' + f3 + " RG");
        }
        catch (IOException iOException) {
            throw new BajaRuntimeException((Throwable)iOException);
        }
    }

    public void setBrush(BColor bColor) {
        this.setBrush(bColor.toBrush());
    }

    public BPen getPen() {
        return this.pen;
    }

    public void setPen(BPen bPen) {
        this.pen = bPen;
        try {
            PdfStream pdfStream = this.target.getContentStream();
            pdfStream.println(bPen.getWidth() + " w");
            switch (bPen.getCap()) {
                case 101: {
                    pdfStream.println("0 J");
                    break;
                }
                case 103: {
                    pdfStream.println("1 J");
                    break;
                }
                case 102: {
                    pdfStream.println("2 J");
                    break;
                }
            }
            switch (bPen.getJoin()) {
                case 201: {
                    pdfStream.println("0 j");
                    break;
                }
                case 202: {
                    pdfStream.println("1 j");
                    break;
                }
                case 203: {
                    pdfStream.println("2 j");
                    break;
                }
            }
            double[] dArray = bPen.getDash();
            pdfStream.print("[");
            int n = 0;
            while (n < dArray.length) {
                pdfStream.print("" + dArray[n] + ' ');
                ++n;
            }
            pdfStream.println("] 0 d");
        }
        catch (IOException iOException) {
            throw new BajaRuntimeException((Throwable)iOException);
        }
    }

    public BFont getFont() {
        return this.font;
    }

    public void setFont(BFont bFont) {
        this.font = bFont;
    }

    public BTransform getTransform() {
        return null;
    }

    public void transform(BTransform bTransform) {
        try {
            PdfStream pdfStream = this.target.getContentStream();
            BTransform.Transform[] transformArray = bTransform.getTransforms();
            int n = 0;
            while (n < transformArray.length) {
                double d = 0.0;
                double d2 = 0.0;
                double d3 = 0.0;
                double d4 = 0.0;
                switch (transformArray[n].getTransformCase()) {
                    case 1: {
                        BTransform.Translate translate = (BTransform.Translate)transformArray[n];
                        pdfStream.println("1 0 0 1 " + translate.getX() + ' ' + -translate.getY() + " cm");
                        break;
                    }
                    case 2: {
                        BTransform.Scale scale = (BTransform.Scale)transformArray[n];
                        pdfStream.println(scale.getX() + " 0 0 " + scale.getY() + " 0 0 cm");
                        if (scale.getY() == 1.0) break;
                        this.tx = bTransform.getInverse();
                        break;
                    }
                    case 3: {
                        BTransform.Rotate rotate = (BTransform.Rotate)transformArray[n];
                        d = -rotate.getAngle() / 180.0 * Math.PI;
                        d2 = this.round(Math.sin(d));
                        d3 = this.round(Math.cos(d));
                        pdfStream.println("" + d3 + ' ' + d2 + ' ' + -d2 + ' ' + d3 + " 0 0 cm");
                        break;
                    }
                    case 4: {
                        BTransform.SkewX skewX = (BTransform.SkewX)transformArray[n];
                        d = -skewX.getAngle() / 180.0 * Math.PI;
                        d4 = this.round(Math.tan(d));
                        pdfStream.println("1 0 " + d4 + " 1 0 0 cm");
                        break;
                    }
                    case 5: {
                        BTransform.SkewY skewY = (BTransform.SkewY)transformArray[n];
                        d = -skewY.getAngle() / 180.0 * Math.PI;
                        d4 = this.round(Math.tan(d));
                        pdfStream.println("1 " + d4 + " 0 1 0 0 cm");
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                ++n;
            }
        }
        catch (IOException iOException) {
            throw new BajaRuntimeException((Throwable)iOException);
        }
    }

    public void translate(double d, double d2) {
        try {
            PdfStream pdfStream = this.target.getContentStream();
            pdfStream.println("1 0 0 1 " + d + ' ' + -d2 + " cm");
        }
        catch (IOException iOException) {
            throw new BajaRuntimeException((Throwable)iOException);
        }
    }

    public IGeom getClip() {
        return this.getClipBounds();
    }

    public IRectGeom getClipBounds() {
        return this.clip;
    }

    public void clip(IGeom iGeom) {
        IRectGeom iRectGeom = iGeom.bounds();
        this.clip(iRectGeom.x(), iRectGeom.y(), iRectGeom.width(), iRectGeom.height());
    }

    public void clip(double d, double d2, double d3, double d4) {
        try {
            PdfStream pdfStream = this.target.getContentStream();
            pdfStream.println("" + this.transX(d) + ' ' + (this.transY(d2) - d4) + ' ' + d3 + ' ' + d4 + " re");
            pdfStream.println("W n");
        }
        catch (IOException iOException) {
            throw new BajaRuntimeException((Throwable)iOException);
        }
    }

    public void stroke(IGeom iGeom) {
        switch (iGeom.getGeomCase()) {
            case 1: {
                ILineGeom iLineGeom = (ILineGeom)iGeom;
                this.strokeLine(iLineGeom.x1(), iLineGeom.y1(), iLineGeom.x2(), iLineGeom.y2());
                break;
            }
            case 2: {
                IRectGeom iRectGeom = (IRectGeom)iGeom;
                this.strokeRect(iRectGeom.x(), iRectGeom.y(), iRectGeom.width(), iRectGeom.height());
                break;
            }
            case 3: {
                this.strokeEllipse((IEllipseGeom)iGeom);
                break;
            }
            case 4: {
                this.strokePolygon((IPolygonGeom)iGeom);
                break;
            }
            case 5: {
                this.strokePath((IPathGeom)iGeom);
                break;
            }
        }
    }

    public void fill(IGeom iGeom) {
        switch (iGeom.getGeomCase()) {
            case 2: {
                IRectGeom iRectGeom = (IRectGeom)iGeom;
                this.fillRect(iRectGeom.x(), iRectGeom.y(), iRectGeom.width(), iRectGeom.height());
                break;
            }
            case 3: {
                this.fillEllipse((IEllipseGeom)iGeom);
                break;
            }
            case 4: {
                this.fillPolygon((IPolygonGeom)iGeom);
                break;
            }
            case 5: {
                this.fillPath((IPathGeom)iGeom);
                break;
            }
        }
    }

    public void strokeLine(double d, double d2, double d3, double d4) {
        if (Double.isNaN(d) || Double.isNaN(d2) || Double.isNaN(d3) || Double.isNaN(d4)) {
            return;
        }
        try {
            PdfStream pdfStream = this.target.getContentStream();
            pdfStream.println("" + this.transX(d) + ' ' + this.transY(d2) + " m");
            pdfStream.println("" + this.transX(d3) + ' ' + this.transY(d4) + " l");
            pdfStream.println("S");
        }
        catch (IOException iOException) {
            throw new BajaRuntimeException((Throwable)iOException);
        }
    }

    public void fillRect(double d, double d2, double d3, double d4) {
        try {
            PdfStream pdfStream = this.target.getContentStream();
            pdfStream.println("" + this.transX(d) + ' ' + (this.transY(d2) - d4) + ' ' + d3 + ' ' + d4 + " re");
            pdfStream.println("B");
        }
        catch (IOException iOException) {
            throw new BajaRuntimeException((Throwable)iOException);
        }
    }

    public void strokeRect(double d, double d2, double d3, double d4) {
        try {
            PdfStream pdfStream = this.target.getContentStream();
            pdfStream.println("" + this.transX(d) + ' ' + (this.transY(d2) - d4) + ' ' + d3 + ' ' + d4 + " re");
            pdfStream.println("S");
        }
        catch (IOException iOException) {
            throw new BajaRuntimeException((Throwable)iOException);
        }
    }

    public void drawString(String string, double d, double d2) {
        try {
            Object object;
            String string2 = "";
            String string3 = "ISO-8859-1";
            int n = this.cjkFontType(string);
            if (n != 0) {
                string2 = PdfCidFontInfo.getFontNameForType(n);
                string3 = PdfCidFontInfo.getFontEncodingForType(n);
                this.target.addFont(string2, this.target.getParent().getReferenceFontId(string2, n));
                log.trace("Added CJK font " + string2 + " with encoding " + string3 + " with ID = " + this.target.getParent().getReferenceFontId(string2, n));
            } else {
                object = (MicroFontPeer)env.makeFontPeer(this.font);
                string2 = object.getPostScriptName();
                this.target.addFont(string2, this.target.getParent().getFontId((MicroFontPeer)object));
                log.trace("Added micro font " + string2 + " with encoding " + string3 + " with ID = " + this.target.getParent().getFontId((MicroFontPeer)object));
            }
            object = string.getBytes(string3);
            PdfByteBuffer pdfByteBuffer = new PdfByteBuffer(((MicroFontPeer)object).length * 4);
            int n2 = 0;
            while (n2 < ((MicroFontPeer)object).length) {
                MicroFontPeer microFontPeer = object[n2];
                switch (microFontPeer) {
                    case 40: 
                    case 41: 
                    case 92: {
                        pdfByteBuffer.append_i(92).append_i((int)microFontPeer);
                        break;
                    }
                    default: {
                        pdfByteBuffer.append_i((int)microFontPeer);
                    }
                }
                ++n2;
            }
            byte[] byArray = pdfByteBuffer.toByteArray();
            PdfStream pdfStream = this.target.getContentStream();
            pdfStream.print("BT /" + string2 + ' ' + this.font.getSize() + " Tf " + this.transX(d) + ' ' + this.transY(d2) + " Td (");
            pdfStream.print(byArray);
            pdfStream.println(") Tj ET");
            if (this.font.isUnderline()) {
                this.drawUnderline(string, d, d2);
            }
        }
        catch (IOException iOException) {
            throw new BajaRuntimeException((Throwable)iOException);
        }
    }

    public void drawString(char[] cArray, int n, int n2, double d, double d2) {
        this.drawString(new String(cArray, n, n2), d, d2);
    }

    public double getWidth(BImage bImage) {
        System.out.println("getWidth(image)");
        return 0.0;
    }

    public double getHeight(BImage bImage) {
        System.out.println("getHeight(image)");
        return 0.0;
    }

    public void drawImage(BImage bImage, double d, double d2) {
        int n = (int)bImage.getWidth();
        int n2 = (int)bImage.getHeight();
        int[] nArray = bImage.getPixels();
        this.drawImage(nArray, n, n2, d, d2);
    }

    public void drawImage(int[] nArray, int n, int n2, double d, double d2) {
        if (nArray == null || nArray.length == 0) {
            return;
        }
        try {
            int n3;
            PdfStream pdfStream = this.target.getContentStream();
            PdfImageStream pdfImageStream = this.target.getParent().createImageStream();
            String string = "Im" + this.imageNum++;
            this.target.addXObject(string, pdfImageStream);
            BitStream bitStream = new BitStream();
            int n4 = 0;
            while (n4 < n2) {
                n3 = 0;
                while (n3 < n) {
                    int n5 = n4 * n + n3;
                    byte by = (byte)(nArray[n5] >> 24 & 0xFF);
                    byte by2 = (byte)(nArray[n5] >> 16 & 0xFF);
                    byte by3 = (byte)(nArray[n5] >> 8 & 0xFF);
                    byte by4 = (byte)(nArray[n5] & 0xFF);
                    int n6 = 0;
                    if (by == 0) {
                        n6 = 1;
                    }
                    bitStream.write(n6);
                    byte[] byArray = new byte[]{by2, by3, by4};
                    pdfImageStream.print(byArray);
                    ++n3;
                }
                bitStream.next();
                ++n4;
            }
            byte[] byArray = bitStream.bits;
            n3 = 0;
            while (n3 < byArray.length) {
                pdfImageStream.mask(byArray[n3]);
                ++n3;
            }
            pdfImageStream.println("");
            pdfImageStream.setImageSize(n, n2);
            pdfStream.println("q");
            pdfStream.println("1 0 0 1 " + this.transX(d) + ' ' + (this.transY(d2) - (double)n2) + " cm");
            pdfStream.println(n + " 0 0 " + n2 + " 0 0 cm");
            pdfStream.println("/" + string + " Do");
            pdfStream.println("Q");
        }
        catch (IOException iOException) {
            throw new BajaRuntimeException((Throwable)iOException);
        }
    }

    public void push() {
        try {
            this.target.getContentStream().println("q");
            ++this.clipStackSize;
        }
        catch (IOException iOException) {
            throw new BajaRuntimeException((Throwable)iOException);
        }
    }

    public void pop() {
        try {
            if (this.clipStackSize == 0) {
                return;
            }
            this.target.getContentStream().println("Q");
            --this.clipStackSize;
        }
        catch (IOException iOException) {
            throw new BajaRuntimeException((Throwable)iOException);
        }
    }

    public void dispose() {
    }

    public Object support() {
        return null;
    }

    private final int cjkFontType(String string) {
        int n;
        if (this.pdfFontDescription == null) {
            this.pdfFontDescription = Lexicon.make((String)"pdf").getText("pdf.font");
        }
        if ((n = PdfCidFontInfo.cjkFontType(this.pdfFontDescription)) != 0) {
            char[] cArray = string.toCharArray();
            int n2 = 0;
            while (n2 < cArray.length) {
                if (cArray[n2] > '\u0100') {
                    return n;
                }
                ++n2;
            }
        }
        return 0;
    }

    protected void strokeEllipse(IEllipseGeom iEllipseGeom) {
        try {
            this.doEllipse(iEllipseGeom);
            PdfStream pdfStream = this.target.getContentStream();
            pdfStream.println("h S");
        }
        catch (IOException iOException) {
            throw new BajaRuntimeException((Throwable)iOException);
        }
    }

    protected void fillEllipse(IEllipseGeom iEllipseGeom) {
        try {
            this.doEllipse(iEllipseGeom);
            PdfStream pdfStream = this.target.getContentStream();
            pdfStream.println("h f");
        }
        catch (IOException iOException) {
            throw new BajaRuntimeException((Throwable)iOException);
        }
    }

    protected void doEllipse(IEllipseGeom iEllipseGeom) {
        try {
            double d = this.transX(iEllipseGeom.x());
            double d2 = this.transX(iEllipseGeom.x() + iEllipseGeom.width());
            double d3 = this.transY(iEllipseGeom.y() + iEllipseGeom.height() / (double)2);
            double d4 = d + iEllipseGeom.width() / (double)4;
            double d5 = d2 - iEllipseGeom.width() / (double)4;
            double d6 = this.transY(iEllipseGeom.y());
            double d7 = this.transY(iEllipseGeom.y() + iEllipseGeom.height());
            PdfStream pdfStream = this.target.getContentStream();
            this.strokeRect(iEllipseGeom.x(), iEllipseGeom.y(), iEllipseGeom.width(), iEllipseGeom.height());
            pdfStream.println("" + d + ' ' + d3 + " m");
            pdfStream.println("" + d4 + ' ' + d6 + ' ' + d5 + ' ' + d6 + ' ' + d2 + ' ' + d3 + " c");
            pdfStream.println("" + d5 + ' ' + d7 + ' ' + d4 + ' ' + d7 + ' ' + d + ' ' + d3 + " c");
        }
        catch (IOException iOException) {
            throw new BajaRuntimeException((Throwable)iOException);
        }
    }

    protected void strokePolygon(IPolygonGeom iPolygonGeom) {
        try {
            this.doPolygon(iPolygonGeom);
            PdfStream pdfStream = this.target.getContentStream();
            pdfStream.println("h S");
        }
        catch (IOException iOException) {
            throw new BajaRuntimeException((Throwable)iOException);
        }
    }

    protected void fillPolygon(IPolygonGeom iPolygonGeom) {
        try {
            this.doPolygon(iPolygonGeom);
            PdfStream pdfStream = this.target.getContentStream();
            pdfStream.println("h f");
        }
        catch (IOException iOException) {
            throw new BajaRuntimeException((Throwable)iOException);
        }
    }

    protected void doPolygon(IPolygonGeom iPolygonGeom) {
        try {
            PdfStream pdfStream = this.target.getContentStream();
            int n = 0;
            while (n < iPolygonGeom.size()) {
                double d = this.transX(iPolygonGeom.x(n));
                double d2 = this.transY(iPolygonGeom.y(n));
                if (n == 0) {
                    pdfStream.println("" + d + ' ' + d2 + " m");
                } else {
                    pdfStream.println("" + d + ' ' + d2 + " l");
                }
                ++n;
            }
        }
        catch (IOException iOException) {
            throw new BajaRuntimeException((Throwable)iOException);
        }
    }

    protected void strokePath(IPathGeom iPathGeom) {
        try {
            PdfStream pdfStream = this.target.getContentStream();
            PathSupport.doPath(this, iPathGeom);
            pdfStream.println("h S");
        }
        catch (IOException iOException) {
            throw new BajaRuntimeException((Throwable)iOException);
        }
    }

    protected void fillPath(IPathGeom iPathGeom) {
        try {
            PdfStream pdfStream = this.target.getContentStream();
            PathSupport.doPath(this, iPathGeom);
            pdfStream.println("h f");
        }
        catch (IOException iOException) {
            throw new BajaRuntimeException((Throwable)iOException);
        }
    }

    public double transX(double d) {
        return this.round(d);
    }

    public double transY(double d) {
        if (this.tx == null) {
            return this.round(this.target.getParent().getPageSize().height - d);
        }
        double d2 = this.target.getParent().getPageSize().height;
        return this.round(this.tx.transform((IPoint)new Point((double)0.0, (double)d2), null).y - d);
    }

    protected void drawUnderline(String string, double d, double d2) {
        double d3 = this.font.width(string);
        this.strokeLine(d, d2 + (double)2, d + d3, d2 + (double)2);
    }

    protected double round(double d) {
        return d < 1.0E-5 ? 0.0 : d;
    }

    private final /* synthetic */ void this() {
        this.pdfFontDescription = null;
        this.brush = BBrush.DEFAULT;
        this.pen = BPen.DEFAULT;
        this.tx = null;
        this.imageNum = 1;
        this.clip = null;
        this.clipStackSize = 0;
    }

    protected PdfGraphics() {
        this.this();
        if (env == null) {
            env = new MicroEnv();
        }
        this.font = BFont.make((String)Lexicon.make((String)"pdf").getText("pdf.font"));
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class PdfByteBuffer {
        protected int count;
        protected byte[] buf;

        public PdfByteBuffer append_i(int n) {
            int n2 = this.count + 1;
            if (n2 > this.buf.length) {
                byte[] byArray = new byte[Math.max(this.buf.length << 1, n2)];
                System.arraycopy(this.buf, 0, byArray, 0, this.count);
                this.buf = byArray;
            }
            this.buf[this.count] = (byte)n;
            this.count = n2;
            return this;
        }

        public byte[] toByteArray() {
            byte[] byArray = new byte[this.count];
            System.arraycopy(this.buf, 0, byArray, 0, this.count);
            return byArray;
        }

        public PdfByteBuffer() {
            this(128);
        }

        public PdfByteBuffer(int n) {
            if (n < 1) {
                n = 128;
            }
            this.buf = new byte[n];
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class BitStream {
        byte[] bits;
        int c;

        public void write(int n) {
            if (this.c == -1) {
                byte[] byArray = new byte[this.bits.length + 1];
                System.arraycopy(this.bits, 0, byArray, 0, this.bits.length);
                this.bits = byArray;
                this.c = 7;
            }
            this.bits[this.bits.length - 1] = (byte)(this.bits[this.bits.length - 1] | (byte)(0xFF & n) << this.c--);
        }

        public void next() {
            this.c = -1;
        }

        private final /* synthetic */ void this() {
            this.bits = new byte[1];
            this.c = 7;
        }

        BitStream() {
            this.this();
        }
    }
}

