/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.pdf;

import com.tridium.gx.parser.ParseException;
import com.tridium.gx.parser.Parser;
import java.util.HashMap;
import javax.baja.log.Log;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PdfCidFontInfo {
    public static final int JA = 1;
    public static final String JA_NAME = "KozMinPro-Regular";
    public static final String JA_ORDERING = "Japan1";
    public static final String JA_ENCODING = "UniJIS-UCS2-H";
    public static final String JA_STRING_ENCODING = "UTF-16BE";
    public static final String JA_FONT_BBOX = "[-195 -272 1110 1075]";
    public static final String JA_FLAGS = "6";
    public static final String JA_PANOSE = "\u0001\u0005\u0002\u0002\u0004\u0000\u0000\u0000\u0000\u0000\u0000\u0000";
    public static final int JA_DEFAULT_WIDTH = 1000;
    public static final int KO = 2;
    public static final String KO_NAME = "HYGoThic-Medium";
    public static final String KO_ORDERING = "Korea1";
    public static final String KO_ENCODING = "UniKS-UCS2-H";
    public static final String KO_STRING_ENCODING = "UTF-16BE";
    public static final String KO_FONT_BBOX = "[-6 -145 1003 880]";
    public static final String KO_FLAGS = "4";
    public static final String KO_PANOSE = "\b\u0001\u0002\u000b\u0006\u0000\u0000\u0000\u0000\u0000\u0000\u0000";
    public static final int KO_DEFAULT_WIDTH = 1000;
    public static final int ZH = 3;
    public static final String ZH_NAME = "STSong-Light";
    public static final String ZH_ORDERING = "GB1";
    public static final String ZH_ENCODING = "UniGB-UCS2-H";
    public static final String ZH_STRING_ENCODING = "UTF-16BE";
    public static final String ZH_FONT_BBOX = "[-25 -254 1000 880]";
    public static final String ZH_FLAGS = "6";
    public static final String ZH_PANOSE = "\u0001\u0005\u0002\u0002\u0004\u0000\u0000\u0000\u0000\u0000\u0000\u0000";
    public static final int ZH_DEFAULT_WIDTH = 1000;
    public static final int ZH_TW = 4;
    public static final String ZH_TW_NAME = "MHei-Medium";
    public static final String ZH_TW_ORDERING = "CNS1";
    public static final String ZH_TW_ENCODING = "UniCNS-UCS2-H";
    public static final String ZH_TW_STRING_ENCODING = "UTF-16BE";
    public static final String ZH_TW_FONT_BBOX = "[-45 -250 1015 887]";
    public static final String ZH_TW_FLAGS = "4";
    public static final String ZH_TW_PANOSE = "\b\u0001\u0002\u000b\u0006\u0000\u0000\u0000\u0000\u0000\u0000\u0000";
    public static final int ZH_TW_DEFAULT_WIDTH = 1000;
    private static int loadedWidthMap = 0;
    private static HashMap widthMap = new HashMap();
    public static final Log log = Log.getLog((String)"pdf");
    private static int[][] JA_WIDTH_LIST = new int[][]{{1, 278}, {2, 278}, {3, 355}, {4, 556}, {5, 556}, {6, 889}, {7, 667}, {8, 222}, {9, 333}, {10, 333}, {11, 389}, {12, 584}, {13, 278}, {14, 333}, {15, 278}, {16, 278}, {17, 556}, {18, 556}, {19, 556}, {20, 556}, {21, 556}, {22, 556}, {23, 556}, {24, 556}, {25, 556}, {26, 556}, {27, 278}, {28, 278}, {29, 584}, {30, 584}, {31, 584}, {32, 556}, {33, 1015}, {34, 667}, {35, 667}, {36, 722}, {37, 722}, {38, 667}, {39, 611}, {40, 778}, {41, 722}, {42, 278}, {43, 500}, {44, 667}, {45, 556}, {46, 833}, {47, 722}, {48, 778}, {49, 667}, {50, 778}, {51, 722}, {52, 667}, {53, 611}, {54, 722}, {55, 667}, {56, 944}, {57, 667}, {58, 667}, {59, 611}, {60, 278}, {61, 278}, {62, 278}, {63, 469}, {64, 556}, {65, 222}, {66, 556}, {67, 556}, {68, 500}, {69, 556}, {70, 556}, {71, 278}, {72, 556}, {73, 556}, {74, 222}, {75, 222}, {76, 500}, {77, 222}, {78, 833}, {79, 556}, {80, 556}, {81, 556}, {82, 556}, {83, 333}, {84, 500}, {85, 278}, {86, 556}, {87, 500}, {88, 722}, {89, 500}, {90, 500}, {91, 500}, {92, 334}, {93, 260}, {94, 334}, {95, 584}, {96, 737}, {13648, 500}, {13649, 500}, {13650, 500}, {13651, 500}, {13652, 500}, {13653, 500}, {13654, 500}, {13655, 500}, {13656, 500}, {13657, 500}, {13658, 500}, {13659, 500}, {13660, 500}, {13661, 500}, {13662, 500}, {13663, 500}, {13664, 500}, {13665, 500}, {13666, 500}, {13667, 500}, {13668, 500}, {13669, 500}, {13670, 500}, {13671, 500}, {13672, 500}, {13673, 500}, {13674, 500}, {13675, 500}, {13676, 500}, {13677, 500}, {13678, 500}, {13679, 500}, {13680, 500}, {13681, 500}, {13682, 500}, {13683, 500}, {13684, 500}, {13685, 500}, {13686, 500}, {13687, 500}, {13688, 500}, {13689, 500}, {13690, 500}, {13691, 500}, {13692, 500}, {13693, 500}, {13694, 500}, {13695, 500}, {13696, 500}, {13697, 500}, {13698, 500}, {13699, 500}, {13700, 500}, {13701, 500}, {13702, 500}, {13703, 500}, {13704, 500}, {13705, 500}, {13706, 500}, {13707, 500}, {13708, 500}, {13709, 500}, {13710, 500}, {13711, 500}, {13712, 500}, {13713, 500}, {13714, 500}, {13715, 500}, {13716, 500}, {13717, 500}, {13718, 500}, {13719, 500}, {13720, 500}, {13721, 500}, {13722, 500}, {13723, 500}, {13724, 500}, {13725, 500}, {13726, 500}, {13727, 500}, {13728, 500}, {13729, 500}, {13730, 500}, {13731, 500}, {13732, 500}, {13733, 500}, {13734, 500}, {13735, 500}, {13736, 500}, {13737, 500}, {13738, 500}, {13739, 500}, {13740, 500}, {13741, 500}, {13742, 500}};
    private static int[][] KO_WIDTH_LIST = new int[][]{{1, 333}, {2, 416}, {3, 416}, {4, 833}, {5, 666}, {6, 916}, {7, 750}, {8, 250}, {9, 416}, {10, 416}, {11, 583}, {12, 833}, {13, 375}, {14, 833}, {15, 375}, {16, 375}, {17, 583}, {18, 583}, {19, 583}, {20, 583}, {21, 583}, {22, 583}, {23, 583}, {24, 583}, {25, 583}, {26, 583}, {27, 416}, {28, 416}, {29, 833}, {30, 833}, {31, 833}, {32, 583}, {34, 666}, {35, 708}, {36, 750}, {37, 750}, {38, 666}, {39, 625}, {40, 833}, {41, 750}, {42, 291}, {43, 541}, {44, 708}, {45, 583}, {46, 875}, {47, 750}, {48, 791}, {49, 666}, {50, 791}, {51, 708}, {52, 666}, {53, 583}, {54, 750}, {55, 625}, {56, 916}, {57, 625}, {58, 625}, {59, 625}, {60, 416}, {61, 375}, {62, 416}, {63, 500}, {64, 500}, {65, 500}, {66, 583}, {67, 625}, {68, 583}, {69, 625}, {70, 583}, {71, 375}, {72, 625}, {73, 583}, {74, 250}, {75, 250}, {76, 541}, {77, 250}, {78, 916}, {79, 625}, {80, 625}, {81, 625}, {82, 625}, {83, 333}, {84, 541}, {85, 333}, {86, 583}, {87, 500}, {88, 750}, {89, 500}, {90, 500}, {91, 500}, {92, 500}, {93, 500}, {94, 500}, {95, 750}, {96, 958}, {97, 500}, {98, 881}, {99, 963}, {8094, 500}, {8095, 500}, {8096, 500}, {8097, 500}, {8098, 500}, {8099, 500}, {8100, 500}, {8101, 500}, {8102, 500}, {8103, 500}, {8104, 500}, {8105, 500}, {8106, 500}, {8107, 500}, {8108, 500}, {8109, 500}, {8110, 500}, {8111, 500}, {8112, 500}, {8113, 500}, {8114, 500}, {8115, 500}, {8116, 500}, {8117, 500}, {8118, 500}, {8119, 500}, {8120, 500}, {8121, 500}, {8122, 500}, {8123, 500}, {8124, 500}, {8125, 500}, {8126, 500}, {8127, 500}, {8128, 500}, {8129, 500}, {8130, 500}, {8131, 500}, {8132, 500}, {8133, 500}, {8134, 500}, {8135, 500}, {8136, 500}, {8137, 500}, {8138, 500}, {8139, 500}, {8140, 500}, {8141, 500}, {8142, 500}, {8143, 500}, {8144, 500}, {8145, 500}, {8146, 500}, {8147, 500}, {8148, 500}, {8149, 500}, {8150, 500}, {8151, 500}, {8152, 500}, {8153, 500}, {8154, 500}, {8155, 500}, {8156, 500}, {8157, 500}, {8158, 500}, {8159, 500}, {8160, 500}, {8161, 500}, {8162, 500}, {8163, 500}, {8164, 500}, {8165, 500}, {8166, 500}, {8167, 500}, {8168, 500}, {8169, 500}, {8170, 500}, {8171, 500}, {8172, 500}, {8173, 500}, {8174, 500}, {8175, 500}, {8176, 500}, {8177, 500}, {8178, 500}, {8179, 500}, {8180, 500}, {8181, 500}, {8182, 500}, {8183, 500}, {8184, 500}, {8185, 500}, {8186, 500}, {8187, 500}, {8188, 500}, {8189, 500}, {8190, 500}};
    private static int[][] ZH_WIDTH_LIST = new int[][]{{1, 207}, {2, 270}, {3, 342}, {4, 467}, {5, 462}, {6, 797}, {7, 710}, {8, 239}, {9, 374}, {10, 374}, {11, 423}, {12, 605}, {13, 238}, {14, 375}, {15, 238}, {16, 334}, {17, 462}, {18, 462}, {19, 462}, {20, 462}, {21, 462}, {22, 462}, {23, 462}, {24, 462}, {25, 462}, {26, 462}, {27, 238}, {28, 238}, {29, 605}, {30, 605}, {31, 605}, {32, 344}, {33, 748}, {34, 684}, {35, 560}, {36, 695}, {37, 739}, {38, 563}, {39, 511}, {40, 729}, {41, 793}, {42, 318}, {43, 312}, {44, 666}, {45, 526}, {46, 896}, {47, 758}, {48, 772}, {49, 544}, {50, 772}, {51, 628}, {52, 465}, {53, 607}, {54, 753}, {55, 711}, {56, 972}, {57, 647}, {58, 620}, {59, 607}, {60, 374}, {61, 333}, {62, 374}, {63, 606}, {64, 500}, {65, 239}, {66, 417}, {67, 503}, {68, 427}, {69, 529}, {70, 415}, {71, 264}, {72, 444}, {73, 518}, {74, 241}, {75, 230}, {76, 495}, {77, 228}, {78, 793}, {79, 527}, {80, 524}, {81, 524}, {82, 504}, {83, 338}, {84, 336}, {85, 277}, {86, 517}, {87, 450}, {88, 652}, {89, 466}, {90, 452}, {91, 407}, {92, 370}, {93, 258}, {94, 370}, {95, 605}, {814, 500}, {815, 500}, {816, 500}, {817, 500}, {818, 500}, {819, 500}, {820, 500}, {821, 500}, {822, 500}, {823, 500}, {824, 500}, {825, 500}, {826, 500}, {827, 500}, {828, 500}, {829, 500}, {830, 500}, {831, 500}, {832, 500}, {833, 500}, {834, 500}, {835, 500}, {836, 500}, {837, 500}, {838, 500}, {839, 500}, {840, 500}, {841, 500}, {842, 500}, {843, 500}, {844, 500}, {845, 500}, {846, 500}, {847, 500}, {848, 500}, {849, 500}, {850, 500}, {851, 500}, {852, 500}, {853, 500}, {854, 500}, {855, 500}, {856, 500}, {857, 500}, {858, 500}, {859, 500}, {860, 500}, {861, 500}, {862, 500}, {863, 500}, {864, 500}, {865, 500}, {866, 500}, {867, 500}, {868, 500}, {869, 500}, {870, 500}, {871, 500}, {872, 500}, {873, 500}, {874, 500}, {875, 500}, {876, 500}, {877, 500}, {878, 500}, {879, 500}, {880, 500}, {881, 500}, {882, 500}, {883, 500}, {884, 500}, {885, 500}, {886, 500}, {887, 500}, {888, 500}, {889, 500}, {890, 500}, {891, 500}, {892, 500}, {893, 500}, {894, 500}, {895, 500}, {896, 500}, {897, 500}, {898, 500}, {899, 500}, {900, 500}, {901, 500}, {902, 500}, {903, 500}, {904, 500}, {905, 500}, {906, 500}, {907, 500}, {908, 500}, {909, 500}, {910, 500}, {911, 500}, {912, 500}, {913, 500}, {914, 500}, {915, 500}, {916, 500}, {917, 500}, {918, 500}, {919, 500}, {920, 500}, {921, 500}, {922, 500}, {923, 500}, {924, 500}, {925, 500}, {926, 500}, {927, 500}, {928, 500}, {929, 500}, {930, 500}, {931, 500}, {932, 500}, {933, 500}, {934, 500}, {935, 500}, {936, 500}, {937, 500}, {938, 500}, {939, 500}, {7712, 517}, {7713, 684}, {7714, 723}, {7716, 500}};
    private static int[][] ZH_TW_WIDTH_LIST = new int[][]{{1, 278}, {2, 278}, {3, 355}, {4, 556}, {5, 556}, {6, 889}, {7, 667}, {8, 222}, {9, 333}, {10, 333}, {11, 389}, {12, 584}, {13, 278}, {14, 333}, {15, 278}, {16, 278}, {17, 556}, {18, 556}, {19, 556}, {20, 556}, {21, 556}, {22, 556}, {23, 556}, {24, 556}, {25, 556}, {26, 556}, {27, 278}, {28, 278}, {29, 584}, {30, 584}, {31, 584}, {32, 556}, {33, 1015}, {34, 667}, {35, 667}, {36, 722}, {37, 722}, {38, 667}, {39, 611}, {40, 778}, {41, 722}, {42, 278}, {43, 500}, {44, 667}, {45, 556}, {46, 833}, {47, 722}, {48, 778}, {49, 667}, {50, 778}, {51, 722}, {52, 667}, {53, 611}, {54, 722}, {55, 667}, {56, 944}, {57, 667}, {58, 667}, {59, 611}, {60, 278}, {61, 278}, {62, 278}, {63, 469}, {64, 556}, {65, 222}, {66, 556}, {67, 556}, {68, 500}, {69, 556}, {70, 556}, {71, 278}, {72, 556}, {73, 556}, {74, 222}, {75, 222}, {76, 500}, {77, 222}, {78, 833}, {79, 556}, {80, 556}, {81, 556}, {82, 556}, {83, 333}, {84, 500}, {85, 278}, {86, 556}, {87, 500}, {88, 722}, {89, 500}, {90, 500}, {91, 500}, {92, 334}, {93, 260}, {94, 334}, {95, 584}, {96, 737}, {13648, 500}, {13649, 500}, {13650, 500}, {13651, 500}, {13652, 500}, {13653, 500}, {13654, 500}, {13655, 500}, {13656, 500}, {13657, 500}, {13658, 500}, {13659, 500}, {13660, 500}, {13661, 500}, {13662, 500}, {13663, 500}, {13664, 500}, {13665, 500}, {13666, 500}, {13667, 500}, {13668, 500}, {13669, 500}, {13670, 500}, {13671, 500}, {13672, 500}, {13673, 500}, {13674, 500}, {13675, 500}, {13676, 500}, {13677, 500}, {13678, 500}, {13679, 500}, {13680, 500}, {13681, 500}, {13682, 500}, {13683, 500}, {13684, 500}, {13685, 500}, {13686, 500}, {13687, 500}, {13688, 500}, {13689, 500}, {13690, 500}, {13691, 500}, {13692, 500}, {13693, 500}, {13694, 500}, {13695, 500}, {13696, 500}, {13697, 500}, {13698, 500}, {13699, 500}, {13700, 500}, {13701, 500}, {13702, 500}, {13703, 500}, {13704, 500}, {13705, 500}, {13706, 500}, {13707, 500}, {13708, 500}, {13709, 500}, {13710, 500}, {13711, 500}, {13712, 500}, {13713, 500}, {13714, 500}, {13715, 500}, {13716, 500}, {13717, 500}, {13718, 500}, {13719, 500}, {13720, 500}, {13721, 500}, {13722, 500}, {13723, 500}, {13724, 500}, {13725, 500}, {13726, 500}, {13727, 500}, {13728, 500}, {13729, 500}, {13730, 500}, {13731, 500}, {13732, 500}, {13733, 500}, {13734, 500}, {13735, 500}, {13736, 500}, {13737, 500}, {13738, 500}, {13739, 500}, {13740, 500}, {13741, 500}, {13742, 500}};
    private String fontName;
    private int type;
    private double size;
    private int style;

    public static String getFontNameForType(int n) {
        switch (n) {
            case 1: {
                return JA_NAME;
            }
            case 2: {
                return KO_NAME;
            }
            case 3: {
                return ZH_NAME;
            }
            case 4: {
                return ZH_TW_NAME;
            }
        }
        return "";
    }

    public static String getFontEncodingForType(int n) {
        switch (n) {
            case 1: {
                return "UTF-16BE";
            }
            case 2: {
                return "UTF-16BE";
            }
            case 3: {
                return "UTF-16BE";
            }
            case 4: {
                return "UTF-16BE";
            }
        }
        return "";
    }

    public static String getOrderingForType(int n) {
        switch (n) {
            case 1: {
                return JA_ORDERING;
            }
            case 2: {
                return KO_ORDERING;
            }
            case 3: {
                return ZH_ORDERING;
            }
            case 4: {
                return ZH_ORDERING;
            }
        }
        return "";
    }

    public static String getEncodingForType(int n) {
        switch (n) {
            case 1: {
                return JA_ENCODING;
            }
            case 2: {
                return KO_ENCODING;
            }
            case 3: {
                return ZH_ENCODING;
            }
            case 4: {
                return ZH_TW_ENCODING;
            }
        }
        return "";
    }

    public static int getDefaultWidthForType(int n) {
        switch (n) {
            case 1: {
                return 1000;
            }
            case 2: {
                return 1000;
            }
            case 3: {
                return 1000;
            }
            case 4: {
                return 1000;
            }
        }
        return 1000;
    }

    public static String getFlagsForType(int n) {
        switch (n) {
            case 1: {
                return "6";
            }
            case 2: {
                return "4";
            }
            case 3: {
                return "6";
            }
            case 4: {
                return "6";
            }
        }
        return "4";
    }

    public static String getFontBoxForType(int n) {
        switch (n) {
            case 1: {
                return JA_FONT_BBOX;
            }
            case 2: {
                return KO_FONT_BBOX;
            }
            case 3: {
                return ZH_FONT_BBOX;
            }
            case 4: {
                return ZH_FONT_BBOX;
            }
        }
        return "[0 0 0 0]";
    }

    public static String getPanoseForType(int n) {
        switch (n) {
            case 1: {
                return "\u0001\u0005\u0002\u0002\u0004\u0000\u0000\u0000\u0000\u0000\u0000\u0000";
            }
            case 2: {
                return "\b\u0001\u0002\u000b\u0006\u0000\u0000\u0000\u0000\u0000\u0000\u0000";
            }
            case 3: {
                return "\u0001\u0005\u0002\u0002\u0004\u0000\u0000\u0000\u0000\u0000\u0000\u0000";
            }
            case 4: {
                return "\u0001\u0005\u0002\u0002\u0004\u0000\u0000\u0000\u0000\u0000\u0000\u0000";
            }
        }
        return "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000";
    }

    public static int cjkFontType(String string) {
        if (string == null) {
            return 0;
        }
        if (string.indexOf(JA_NAME) >= 0) {
            return 1;
        }
        if (string.indexOf(KO_NAME) >= 0) {
            return 2;
        }
        if (string.indexOf(ZH_NAME) >= 0) {
            return 3;
        }
        if (string.indexOf(ZH_TW_NAME) >= 0) {
            return 4;
        }
        return 0;
    }

    private final void parseFont(String string) {
        String string2;
        Parser parser = new Parser(string);
        if (parser.cur.id("null")) {
            parser.eat();
            return;
        }
        int n = 0;
        while (n < 3) {
            if (parser.cur.id("bold")) {
                parser.consume();
                this.style |= 1;
            } else if (parser.cur.id("italic")) {
                parser.consume();
                this.style |= 2;
            } else if (parser.cur.id("underline")) {
                parser.consume();
                this.style |= 4;
            }
            ++n;
        }
        if (!parser.cur.dimen("pt")) {
            throw new ParseException("Expecting {size}pt");
        }
        this.size = parser.cur.num;
        parser.consume();
        this.fontName = string2 = parser.eat();
    }

    public String getFontName() {
        return this.fontName;
    }

    public int getType() {
        return this.type;
    }

    public double getSize() {
        return this.size;
    }

    private final int[][] getWidthListForType(int n) {
        switch (n) {
            case 1: {
                return JA_WIDTH_LIST;
            }
            case 2: {
                return KO_WIDTH_LIST;
            }
            case 3: {
                return ZH_WIDTH_LIST;
            }
            case 4: {
                return ZH_TW_WIDTH_LIST;
            }
        }
        return new int[0][0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void loadWidthMap(int n) {
        int[][] nArray = this.getWidthListForType(n);
        HashMap hashMap = widthMap;
        synchronized (hashMap) {
            if (n == loadedWidthMap) {
                return;
            }
            widthMap.clear();
            int n2 = 0;
            while (n2 < nArray.length) {
                widthMap.put(new Integer(nArray[n2][0]), new Integer(nArray[n2][1]));
                ++n2;
            }
            loadedWidthMap = n;
            return;
        }
    }

    public double width(String string, int n) {
        this.loadWidthMap(n);
        double d = 0.0;
        int n2 = PdfCidFontInfo.getDefaultWidthForType(n);
        char[] cArray = string.toCharArray();
        double d2 = this.size / 72.0;
        int n3 = 0;
        while (n3 < cArray.length) {
            int n4 = n2;
            Object v = widthMap.get(new Integer(cArray[n3]));
            if (v != null) {
                n4 = (Integer)v;
            }
            d += (double)n4 * d2 / 13.4;
            ++n3;
        }
        log.trace("  PdfCidFontInfo.width(" + string + ") = " + (d += 1000.0 * d2 / 13.4) + " for factor = " + d2);
        return d;
    }

    private final /* synthetic */ void this() {
        this.fontName = "";
        this.type = 0;
        this.size = 12.0;
        this.style = 0;
    }

    public PdfCidFontInfo(String string) {
        this.this();
        this.parseFont(string);
        this.type = PdfCidFontInfo.cjkFontType(string);
    }

    public PdfCidFontInfo() {
        this.this();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class CJK {
        public static final int JA = 1;
        public static final int KO = 2;
        public static final int ZH = 3;
        public static final int ZH_TW = 4;
        public static final int UNKNOWN = 0;
    }
}

