/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.widget;

import com.tridium.platform.daemon.DaemonFileUtil;
import javax.baja.file.BIFile;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.gx.RectGeom;
import javax.baja.gx.Size;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.event.BWindowEvent;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.pane.BTabbedPane;

public class BReplaceDialog
extends BDialog {
    public static final Property yesButton = BReplaceDialog.newProperty((int)0, (BValue)new BButton("yes"), null);
    public static final Property yesAllButton = BReplaceDialog.newProperty((int)0, (BValue)new BButton("yes all"), null);
    public static final Property noButton = BReplaceDialog.newProperty((int)0, (BValue)new BButton("no"), null);
    public static final Property noAllButton = BReplaceDialog.newProperty((int)0, (BValue)new BButton("no all"), null);
    public static final Property cancelButton = BReplaceDialog.newProperty((int)0, (BValue)new BButton("_cancel"), null);
    public static final Action buttonPressed = BReplaceDialog.newAction((int)0, (BValue)new BWidgetEvent(), null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$platDaemon$ui$widget$BReplaceDialog == null ? (class$com$tridium$platDaemon$ui$widget$BReplaceDialog = BReplaceDialog.class$("com.tridium.platDaemon.ui.widget.BReplaceDialog")) : class$com$tridium$platDaemon$ui$widget$BReplaceDialog));
    private static String cancelText;
    private static String yesText;
    private static String yesAllText;
    private static String noText;
    private static String noAllText;
    public static final int YES_ALL = 16;
    public static final int NO_ALL = 32;
    private BImage icon = QUESTION_ICON;
    private RectGeom iconRect = new RectGeom();
    private RectGeom contentRect = new RectGeom();
    private RectGeom buttonsRect = new RectGeom();
    private Size buttonDim = new Size();
    private int result = 4;
    private static final long MAX_FILE_SIZE_CRC = 0x2000000L;
    static /* synthetic */ Class class$com$tridium$platDaemon$ui$widget$BReplaceDialog;

    public BButton getYesButton() {
        return (BButton)this.get(yesButton);
    }

    public void setYesButton(BButton bButton) {
        this.set(yesButton, (BValue)bButton, null);
    }

    public BButton getYesAllButton() {
        return (BButton)this.get(yesAllButton);
    }

    public void setYesAllButton(BButton bButton) {
        this.set(yesAllButton, (BValue)bButton, null);
    }

    public BButton getNoButton() {
        return (BButton)this.get(noButton);
    }

    public void setNoButton(BButton bButton) {
        this.set(noButton, (BValue)bButton, null);
    }

    public BButton getNoAllButton() {
        return (BButton)this.get(noAllButton);
    }

    public void setNoAllButton(BButton bButton) {
        this.set(noAllButton, (BValue)bButton, null);
    }

    public BButton getCancelButton() {
        return (BButton)this.get(cancelButton);
    }

    public void setCancelButton(BButton bButton) {
        this.set(cancelButton, (BValue)bButton, null);
    }

    public void buttonPressed(BWidgetEvent bWidgetEvent) {
        this.invoke(buttonPressed, (BValue)bWidgetEvent, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BReplaceDialog() {
        throw new UnsupportedOperationException();
    }

    public BReplaceDialog(BWidget bWidget) {
        super(bWidget, TYPE.getModule().getLexicon().getText("ReplaceDialog.title"), true);
        this.linkTo("linkA", (BComponent)this.getCancelButton(), (Slot)BButton.actionPerformed, (Slot)buttonPressed);
        this.linkTo("linkB", (BComponent)this.getYesButton(), (Slot)BButton.actionPerformed, (Slot)buttonPressed);
        this.linkTo("linkC", (BComponent)this.getYesAllButton(), (Slot)BButton.actionPerformed, (Slot)buttonPressed);
        this.linkTo("linkD", (BComponent)this.getNoButton(), (Slot)BButton.actionPerformed, (Slot)buttonPressed);
        this.linkTo("linkE", (BComponent)this.getNoAllButton(), (Slot)BButton.actionPerformed, (Slot)buttonPressed);
        BReplaceDialog.initButtonText();
        this.getYesButton().setText(yesText);
        this.getYesAllButton().setText(yesAllText);
        this.getNoButton().setText(noText);
        this.getNoAllButton().setText(noAllText);
        this.getCancelButton().setText(cancelText);
        this.setDefaultButton(this.getYesButton());
        this.setContent((BWidget)new BNullWidget());
    }

    public int promptResult(BIFile bIFile, BIFile bIFile2) {
        Object[] objectArray;
        String string;
        if (this.getResult() == 16) {
            return 4;
        }
        if (this.getResult() == 32) {
            return 8;
        }
        if (bIFile.isDirectory()) {
            string = bIFile2.isDirectory() ? this.getLexicon().getText("ReplaceDialog.message.replaceDirWithDir", new Object[]{bIFile.getFileName()}) : this.getLexicon().getText("ReplaceDialog.message.replaceFileWithDir", new Object[]{bIFile.getFileName()});
        } else if (bIFile2.isDirectory()) {
            string = this.getLexicon().getText("ReplaceDialog.message.replaceDirWithFile", new Object[]{bIFile.getFileName()});
        } else if (BReplaceDialog.tooLargeForCRC(bIFile) || BReplaceDialog.tooLargeForCRC(bIFile2)) {
            objectArray = new Object[]{bIFile.getFileName(), new Long(bIFile.getSize()), new Long(bIFile2.getSize())};
            string = this.getLexicon().getText("ReplaceDialog.message.replaceFileWithFileNoCRC", objectArray);
        } else {
            objectArray = new Object[]{bIFile.getFileName(), new Long(bIFile.getSize()), Long.toHexString(DaemonFileUtil.getCrc((BIFile)bIFile)), new Long(bIFile2.getSize()), Long.toHexString(DaemonFileUtil.getCrc((BIFile)bIFile2))};
            string = this.getLexicon().getText("ReplaceDialog.message.replaceFileWithFile", objectArray);
        }
        objectArray = new BLabel(string);
        objectArray.setHalign(BHalign.left);
        this.setContent((BWidget)objectArray);
        this.setBoundsCenteredOnOwner();
        this.open();
        if (this.getResult() == 16) {
            return 4;
        }
        if (this.getResult() == 32) {
            return 8;
        }
        return this.getResult();
    }

    static void initButtonText() {
        if (cancelText != null) {
            return;
        }
        cancelText = TYPE.getModule().getLexicon().getText("ReplaceDialog.cancel");
        yesText = TYPE.getModule().getLexicon().getText("ReplaceDialog.yes");
        yesAllText = TYPE.getModule().getLexicon().getText("ReplaceDialog.yesAll");
        noText = TYPE.getModule().getLexicon().getText("ReplaceDialog.no");
        noAllText = TYPE.getModule().getLexicon().getText("ReplaceDialog.noAll");
    }

    public void computePreferredSize() {
        this.computeIconPrefSize();
        this.computeContentPrefSize();
        this.computeButtonsPrefSize();
        double d = this.iconRect.width;
        double d2 = this.iconRect.height;
        double d3 = this.contentRect.width;
        double d4 = this.contentRect.height;
        double d5 = this.buttonsRect.width;
        double d6 = this.buttonsRect.height;
        double d7 = Math.max(d + d3, d5);
        double d8 = Math.max(d2, d4) + d6;
        this.setPreferredSize(d7, d8);
    }

    public void doLayout(BWidget[] bWidgetArray) {
        this.computePreferredSize();
        double d = this.getWidth();
        double d2 = this.getHeight();
        this.layoutButtons(d, d2);
        this.layoutContentAndIcon(d, d2);
    }

    private void computeIconPrefSize() {
        this.iconRect.width = this.icon.getWidth() + 8.0;
        this.iconRect.height = this.icon.getHeight() + 8.0;
    }

    private void computeContentPrefSize() {
        BWidget bWidget = this.getContent();
        bWidget.computePreferredSize();
        this.contentRect.width = bWidget.getPreferredWidth() + 12.0;
        this.contentRect.height = bWidget.getPreferredHeight() + 8.0;
        if (bWidget instanceof BScrollPane || bWidget instanceof BTabbedPane) {
            this.contentRect.width = 400.0;
            this.contentRect.height = 300.0;
        }
    }

    private void computeButtonsPrefSize() {
        double d = 0.0;
        double d2 = 0.0;
        int n = 0;
        BButton bButton = this.getYesButton();
        bButton.computePreferredSize();
        d2 = Math.max(d2, bButton.getPreferredWidth());
        d = Math.max(d, bButton.getPreferredHeight());
        ++n;
        bButton = this.getYesAllButton();
        bButton.computePreferredSize();
        d2 = Math.max(d2, bButton.getPreferredWidth());
        d = Math.max(d, bButton.getPreferredHeight());
        ++n;
        bButton = this.getNoButton();
        bButton.computePreferredSize();
        d2 = Math.max(d2, bButton.getPreferredWidth());
        d = Math.max(d, bButton.getPreferredHeight());
        ++n;
        bButton = this.getNoAllButton();
        bButton.computePreferredSize();
        d2 = Math.max(d2, bButton.getPreferredWidth());
        d = Math.max(d, bButton.getPreferredHeight());
        ++n;
        bButton = this.getCancelButton();
        bButton.computePreferredSize();
        d2 = Math.max(d2, bButton.getPreferredWidth());
        d = Math.max(d, bButton.getPreferredHeight());
        this.buttonDim.width = d2;
        this.buttonDim.height = d;
        this.buttonsRect.width = d2 * (double)(++n) + (double)(4 * (n - 1)) + 8.0;
        this.buttonsRect.height = d + 8.0;
    }

    private void layoutButtons(double d, double d2) {
        double d3 = this.buttonsRect.x = (d - this.buttonsRect.width) / 2.0 + 4.0;
        double d4 = this.buttonsRect.y = d2 - this.buttonDim.height - 4.0;
        double d5 = this.buttonDim.width;
        double d6 = this.buttonDim.height;
        this.getYesButton().setBounds(d3, d4, d5, d6);
        this.getYesAllButton().setBounds(d3 += d5 + 4.0, d4, d5, d6);
        this.getNoButton().setBounds(d3 += d5 + 4.0, d4, d5, d6);
        this.getNoAllButton().setBounds(d3 += d5 + 4.0, d4, d5, d6);
        this.getCancelButton().setBounds(d3 += d5 + 4.0, d4, d5, d6);
        d3 += d5 + 4.0;
    }

    private void layoutContentAndIcon(double d, double d2) {
        double d3;
        double d4 = this.buttonsRect.y - 8.0;
        this.iconRect.x = 4.0;
        this.iconRect.y = (d4 - this.iconRect.height) / 2.0 + 4.0;
        double d5 = this.iconRect.x + this.iconRect.width + 4.0;
        double d6 = 4.0;
        double d7 = d3 = d - d5 - 4.0;
        double d8 = d4;
        this.contentRect.x = d5;
        this.contentRect.y = d6;
        this.contentRect.width = d7;
        this.contentRect.height = d8;
        this.getContent().setBounds(d5, d6, d7, d8);
    }

    public void paint(Graphics graphics) {
        this.paintChildren(graphics);
        graphics.drawImage(this.icon, this.iconRect.x, this.iconRect.y);
    }

    public int getResult() {
        return this.result;
    }

    public void close(int n) {
        this.result = n;
        this.close();
    }

    public void doButtonPressed(BWidgetEvent bWidgetEvent) {
        BWidget bWidget = bWidgetEvent.getWidget();
        if (bWidget == this.getCancelButton()) {
            this.close(2);
        }
        if (bWidget == this.getYesButton()) {
            this.close(4);
        }
        if (bWidget == this.getYesAllButton()) {
            this.close(16);
        }
        if (bWidget == this.getNoButton()) {
            this.close(8);
        }
        if (bWidget == this.getNoAllButton()) {
            this.close(32);
        }
    }

    public void windowClosing(BWindowEvent bWindowEvent) {
        this.result = 2;
        this.close();
    }

    public static boolean tooLargeForCRC(BIFile bIFile) {
        return bIFile.getSize() > 0x2000000L;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

