/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.widget;

import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.ui.util.AsyncCommand;
import com.tridium.platform.ui.util.BBox;
import com.tridium.platform.ui.util.BToolTipTextField;
import com.tridium.platform.ui.util.LabelUtil;
import com.tridium.ui.BOptionDialog;
import com.tridium.ui.theme.Theme;
import java.io.File;
import java.util.HashMap;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSpace;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.BIFileStore;
import javax.baja.file.BLocalFileStore;
import javax.baja.file.FilePath;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.nre.util.Array;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BTextField;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.text.TextModel;
import javax.baja.ui.tree.BTree;
import javax.baja.ui.tree.TreeController;
import javax.baja.ui.tree.TreeModel;
import javax.baja.ui.tree.TreeNode;
import javax.baja.ui.tree.TreeSelection;
import javax.baja.util.LexiconText;

public class BDirectoryChoice
extends BEdgePane {
    public static final Topic dirModified = BDirectoryChoice.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$platDaemon$ui$widget$BDirectoryChoice == null ? (class$com$tridium$platDaemon$ui$widget$BDirectoryChoice = BDirectoryChoice.class$("com.tridium.platDaemon.ui.widget.BDirectoryChoice")) : class$com$tridium$platDaemon$ui$widget$BDirectoryChoice));
    private BToolTipTextField text;
    private BDirectory dirValue;
    private boolean showNormalized = true;
    private BFileSpace fileSpace;
    private ChangeDirectoryCommand command;
    static /* synthetic */ Class class$com$tridium$platDaemon$ui$widget$BDirectoryChoice;
    static /* synthetic */ Class class$com$tridium$platDaemon$ui$widget$BDirectoryChoice$DirectoryTreeNode;

    public void fireDirModified(BWidgetEvent bWidgetEvent) {
        this.fire(dirModified, (BValue)bWidgetEvent, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BDirectoryChoice(BDirectory bDirectory, Command command) {
        this(command, (BFileSpace)BFileSystem.INSTANCE, true, 30);
        this.setDirectory(bDirectory);
    }

    public BDirectoryChoice(BDirectory bDirectory) {
        this(null, (BFileSpace)BFileSystem.INSTANCE, true, 30);
        this.setDirectory(bDirectory);
    }

    public BDirectoryChoice(boolean bl) {
        this(null, (BFileSpace)BFileSystem.INSTANCE, bl, 30);
    }

    public BDirectoryChoice(boolean bl, int n) {
        this(null, (BFileSpace)BFileSystem.INSTANCE, bl, n);
    }

    public BDirectoryChoice() {
        this(null, (BFileSpace)BFileSystem.INSTANCE, true, 30);
    }

    public BDirectoryChoice(Command command, BFileSpace bFileSpace) {
        this(command, bFileSpace, true, 30);
    }

    public BDirectoryChoice(Command command, BFileSpace bFileSpace, boolean bl, int n) {
        this.text = new BToolTipTextField("", n);
        this.text.setEditable(false);
        this.setCenter((BWidget)new BBorderPane((BWidget)this.text, 3.0, 0.0, 0.0, 0.0));
        this.command = new ChangeDirectoryCommand(command);
        if (bl) {
            BButton bButton = new BButton((Command)this.command, false, true);
            bButton.setButtonStyle(BButtonStyle.toolBar);
            BToolBar bToolBar = new BToolBar();
            bToolBar.add("edit", (BValue)bButton);
            this.setRight((BWidget)bToolBar);
        }
        this.setFileSpace(bFileSpace);
    }

    public void setDirectory(BDirectory bDirectory) {
        if (bDirectory != null && !bDirectory.isDirectory()) {
            throw new IllegalArgumentException("Argument must be a directory");
        }
        this.dirValue = bDirectory;
        this.text.setText(this.getDisplayPath());
        if (this.dirValue != null) {
            this.setFileSpace(this.dirValue.getFileSpace());
        }
        this.fireDirModified(new BWidgetEvent(1, (BWidget)this));
    }

    public BDirectory getDirectory() {
        return this.dirValue;
    }

    public File getDirectoryFile() {
        if (this.dirValue == null) {
            return null;
        }
        return ((BLocalFileStore)this.dirValue.getStore()).getLocalFile();
    }

    public String getDisplayPath() {
        if (this.dirValue == null) {
            return null;
        }
        if (this.showNormalizedPath()) {
            return this.getNormalizedFilePath().getBody();
        }
        return this.getFilePath().getBody();
    }

    public BFileSpace getFileSpace() {
        return this.fileSpace;
    }

    public void setFileSpace(BFileSpace bFileSpace) {
        this.fileSpace = bFileSpace;
    }

    public FilePath getFilePath() {
        if (this.dirValue == null) {
            return null;
        }
        return this.dirValue.getFilePath();
    }

    public ChangeDirectoryCommand getChangeDirectoryCommand() {
        return this.command;
    }

    public FilePath getNormalizedFilePath() {
        if (this.dirValue == null) {
            return null;
        }
        return DaemonFileUtil.getNormalizedFilePath((BIFileStore)this.dirValue.getStore());
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.text.setEnabled(bl);
        this.command.setEnabled(bl);
    }

    public boolean showNormalizedPath() {
        return this.showNormalized;
    }

    public void setShowNormalizedPath(boolean bl) {
        this.showNormalized = bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class DirectoryTreeNode
    extends TreeNode {
        private BDirectory dir;
        private Array children = null;
        private HashMap childByName = null;

        public DirectoryTreeNode(BDirectory bDirectory, TreeNode treeNode) {
            super(treeNode);
            this.dir = bDirectory;
        }

        public String getText() {
            return this.dir.getNavDisplayName(null);
        }

        public BImage getIcon() {
            return BImage.make((BIcon)this.dir.getNavIcon());
        }

        public boolean hasChildren() {
            if (this.children == null) {
                return true;
            }
            return this.children.size() > 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized int getChildCount() {
            if (this.children == null) {
                try {
                    if (!(this.dir.getFileSpace() instanceof BFileSystem)) {
                        this.getTree().enterBusy();
                    }
                    this.children = new Array(class$com$tridium$platDaemon$ui$widget$BDirectoryChoice$DirectoryTreeNode == null ? (class$com$tridium$platDaemon$ui$widget$BDirectoryChoice$DirectoryTreeNode = BDirectoryChoice.class$("com.tridium.platDaemon.ui.widget.BDirectoryChoice$DirectoryTreeNode")) : class$com$tridium$platDaemon$ui$widget$BDirectoryChoice$DirectoryTreeNode);
                    this.childByName = new HashMap();
                    if (this.dir.hasNavChildren()) {
                        BIFile[] bIFileArray = this.dir.listFiles();
                        for (int i = 0; i < bIFileArray.length; ++i) {
                            if (!(bIFileArray[i] instanceof BDirectory)) continue;
                            DirectoryTreeNode directoryTreeNode = new DirectoryTreeNode((BDirectory)bIFileArray[i], this);
                            this.children.add((Object)directoryTreeNode);
                            this.childByName.put(bIFileArray[i].getFileName(), directoryTreeNode);
                        }
                    }
                }
                finally {
                    if (!(this.dir.getFileSpace() instanceof BFileSystem)) {
                        this.getTree().exitBusy();
                    }
                }
            }
            return this.children.size();
        }

        public TreeNode getChild(int n) {
            this.getChildCount();
            return (TreeNode)this.children.get(n);
        }

        public DirectoryTreeNode getChild(String string) {
            this.getChildCount();
            return (DirectoryTreeNode)((Object)this.childByName.get(string));
        }

        public BDirectory getDirectory() {
            return this.dir;
        }

        public FilePath getFilePath() {
            return this.dir.getFilePath();
        }

        public String toString() {
            return this.dir.getFilePath().getBody();
        }
    }

    private static class DirectoryTreeRoot
    extends TreeNode {
        private BFileSpace fileSpace;
        private Array children;

        public DirectoryTreeRoot(BFileSpace bFileSpace, TreeModel treeModel) {
            super(treeModel);
            this.fileSpace = bFileSpace;
            this.children = new Array(class$com$tridium$platDaemon$ui$widget$BDirectoryChoice$DirectoryTreeNode == null ? (class$com$tridium$platDaemon$ui$widget$BDirectoryChoice$DirectoryTreeNode = BDirectoryChoice.class$("com.tridium.platDaemon.ui.widget.BDirectoryChoice$DirectoryTreeNode")) : class$com$tridium$platDaemon$ui$widget$BDirectoryChoice$DirectoryTreeNode);
            BIFile[] bIFileArray = bFileSpace.listFiles();
            for (int i = 0; i < bIFileArray.length; ++i) {
                if (!(bIFileArray[i] instanceof BDirectory)) continue;
                BDirectory bDirectory = (BDirectory)bIFileArray[i];
                DirectoryTreeNode directoryTreeNode = new DirectoryTreeNode(bDirectory, this);
                this.children.add((Object)directoryTreeNode);
            }
            this.setExpanded(true);
        }

        public String getText() {
            return this.fileSpace.getNavDisplayName(null);
        }

        public BImage getIcon() {
            return BImage.make((BIcon)this.fileSpace.getNavIcon());
        }

        public int getChildCount() {
            return this.children.size();
        }

        public TreeNode getChild(int n) {
            return (TreeNode)this.children.get(n);
        }

        public DirectoryTreeNode getChild(FilePath filePath) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                DirectoryTreeNode directoryTreeNode = (DirectoryTreeNode)this.getChild(i);
                if (!DaemonFileUtil.isSubPath((FilePath)filePath, (FilePath)directoryTreeNode.getFilePath())) continue;
                return directoryTreeNode;
            }
            return null;
        }
    }

    private static class DirectoryTreeModel
    extends TreeModel {
        private DirectoryTreeRoot root;

        public DirectoryTreeModel(BFileSpace bFileSpace) {
            this.root = new DirectoryTreeRoot(bFileSpace, this);
        }

        public int getRootCount() {
            return 1;
        }

        public TreeNode getRoot(int n) {
            return this.root;
        }

        public DirectoryTreeNode findNode(FilePath filePath) {
            DirectoryTreeNode directoryTreeNode;
            block2: {
                if (filePath == null) {
                    return null;
                }
                directoryTreeNode = this.root.getChild(filePath);
                if (directoryTreeNode == null) break block2;
                while (directoryTreeNode.getFilePath().depth() < filePath.depth() && (directoryTreeNode = directoryTreeNode.getChild(filePath.nameAt(directoryTreeNode.getFilePath().depth()))) != null) {
                }
            }
            return directoryTreeNode;
        }
    }

    private static class DirectoryTreeSelection
    extends TreeSelection {
        private BTextField textField;

        public DirectoryTreeSelection(BTextField bTextField) {
            this.textField = bTextField;
        }

        public void select(TreeNode treeNode) {
            if (treeNode instanceof DirectoryTreeNode) {
                super.select(treeNode);
                BDirectory bDirectory = ((DirectoryTreeNode)treeNode).getDirectory();
                this.textField.setText(bDirectory.getFilePath().getBody());
            }
        }

        public void deselectAll() {
            super.deselectAll();
            if (this.getNode() == null) {
                this.textField.setText("");
            }
        }

        public void deselect(TreeNode treeNode) {
            super.deselect(treeNode);
            if (this.getNode() == null) {
                this.textField.setText("");
            }
        }
    }

    private static class DirectoryTreeController
    extends TreeController {
        private BOptionDialog dialog;

        private DirectoryTreeController(BOptionDialog bOptionDialog) {
            this.dialog = bOptionDialog;
        }

        protected void nodeDoubleClicked(BMouseEvent bMouseEvent, TreeNode treeNode) {
            if (this.dialog.getOkButton().isEnabled()) {
                this.dialog.close(1);
            }
        }
    }

    private static class DirectoryPathTextModel
    extends TextModel {
        private BButton button;

        public DirectoryPathTextModel(BButton bButton) {
            this.button = bButton;
        }

        protected void textModified() {
            this.button.setEnabled(this.getText().trim().length() > 0);
        }
    }

    public class ChangeDirectoryCommand
    extends AsyncCommand {
        private Command selectCommand;

        public ChangeDirectoryCommand(Command command) {
            super((BWidget)BDirectoryChoice.this, TYPE.getModule(), "DirectoryChoice.changeDirectory");
            this.selectCommand = command;
        }

        public void doInvokeAsync() {
            DirectoryTreeNode directoryTreeNode;
            DirectoryTreeModel directoryTreeModel = new DirectoryTreeModel(BDirectoryChoice.this.fileSpace);
            BToolTipTextField bToolTipTextField = new BToolTipTextField("", 30);
            BTree bTree = new BTree((TreeModel)directoryTreeModel);
            BScrollPane bScrollPane = new BScrollPane((BWidget)bTree);
            bScrollPane.setViewportBackground(Theme.scrollPane().getControlBackground());
            BEdgePane bEdgePane = new BEdgePane(null, null, (BWidget)new BBorderPane((BWidget)LabelUtil.makeLabel((LexiconText)LexiconText.make((String)"platDaemon", (String)"DirectoryChoice.changeDirectory.path"), (boolean)true), 0.0, 5.0, 0.0, 0.0), null, (BWidget)bToolTipTextField);
            bTree.setSelection((TreeSelection)new DirectoryTreeSelection((BTextField)bToolTipTextField));
            BOptionDialog bOptionDialog = new BOptionDialog((BWidget)BDirectoryChoice.this, BDirectoryChoice.this.getLexicon().getText("DirectoryChoice.changeDirectory.dlgTitle"), (BWidget)new BEdgePane((BWidget)new BBox(400.0, 0.0), (BWidget)new BBorderPane((BWidget)bEdgePane, 0.0, 10.0, 10.0, 10.0), (BWidget)new BBox(0.0, 350.0), null, (BWidget)new BBorderPane((BWidget)new BBorderPane((BWidget)bScrollPane, BBorder.inset, BInsets.DEFAULT), 10.0, 10.0, 5.0, 10.0)), 3, null, null);
            bToolTipTextField.setModel((TextModel)new DirectoryPathTextModel(bOptionDialog.getOkButton()));
            bTree.setController((TreeController)new DirectoryTreeController(bOptionDialog));
            bOptionDialog.setBoundsCenteredOnScreen();
            if (BDirectoryChoice.this.dirValue != null && (directoryTreeNode = directoryTreeModel.findNode(DaemonFileUtil.getNormalizedFilePath((BIFileStore)BDirectoryChoice.this.dirValue.getStore()))) != null) {
                bTree.getSelection().select((TreeNode)directoryTreeNode);
                bTree.scrollNodeToVisible((TreeNode)directoryTreeNode);
            }
            bOptionDialog.open();
            if (bOptionDialog.getResult() == 1) {
                try {
                    directoryTreeNode = new FilePath(bToolTipTextField.getText());
                }
                catch (Exception exception) {
                    BDialog.error((BWidget)BDirectoryChoice.this, (Object)BDirectoryChoice.this.getLexicon().getText("DirectoryChoice.changeDirectory.badFilePath"));
                    return;
                }
                BIFile bIFile = BDirectoryChoice.this.fileSpace.findFile((FilePath)directoryTreeNode);
                if (bIFile == null) {
                    BDialog.error((BWidget)BDirectoryChoice.this, (Object)BDirectoryChoice.this.getLexicon().getText("DirectoryChoice.changeDirectory.notFound", new Object[]{directoryTreeNode.getBody()}));
                } else if (bIFile instanceof BDirectory) {
                    BDirectoryChoice.this.dirValue = (BDirectory)bIFile;
                    BDirectoryChoice.this.text.setText(BDirectoryChoice.this.getDisplayPath());
                    BDirectoryChoice.this.fireDirModified(new BWidgetEvent(1, (BWidget)BDirectoryChoice.this));
                    if (this.selectCommand != null) {
                        this.selectCommand.invoke();
                    }
                } else {
                    BDialog.error((BWidget)BDirectoryChoice.this, (Object)BDirectoryChoice.this.getLexicon().getText("DirectoryChoice.changeDirectory.notDirectory", new Object[]{directoryTreeNode.getBody()}));
                }
            }
        }

        public void setLabel(String string) {
            this.label = string;
        }

        public void setDescription(String string) {
            this.description = string;
        }
    }
}

