/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.stationtransfer;

import com.tridium.file.types.bog.BBogFile;
import com.tridium.install.BDaemonPlatform;
import com.tridium.install.BDependency;
import com.tridium.install.BRemoteDaemonPlatform;
import com.tridium.install.BRemoteModuleList;
import com.tridium.install.DependencyUtil;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.installable.LocalInstallableRegistry;
import com.tridium.nre.util.FileLock;
import com.tridium.platDaemon.ui.BDaemonSessionView;
import com.tridium.platDaemon.ui.DaemonSessionTaskHandler;
import com.tridium.platDaemon.ui.commissioningwizard.CommissioningWizardModel;
import com.tridium.platDaemon.ui.stationtransfer.BStationContentEnum;
import com.tridium.platDaemon.ui.stationtransfer.BStationCopier;
import com.tridium.platDaemon.ui.stationtransfer.BStationCopierOptions;
import com.tridium.platDaemon.ui.stationtransfer.BStationDispositionEnum;
import com.tridium.platDaemon.ui.stationtransfer.FinalStep;
import com.tridium.platDaemon.ui.stationtransfer.StationNameController;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BStationSurrogate;
import com.tridium.platform.daemon.file.FilePathComparator;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.platform.ui.util.BBox;
import com.tridium.platform.ui.util.BDirectoryTree;
import com.tridium.platform.ui.util.BIndentPane;
import com.tridium.platform.ui.util.BTreeCascadePolicy;
import com.tridium.platform.ui.util.EnumRadioGroup;
import com.tridium.platform.ui.util.LabelUtil;
import com.tridium.ui.theme.Theme;
import java.io.File;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSpace;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.BLocalFileStore;
import javax.baja.file.FilePath;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.gx.Size;
import javax.baja.naming.BOrd;
import javax.baja.naming.BViewScheme;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.SlotPath;
import javax.baja.nav.BINavNode;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.IFilter;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.list.BList;
import javax.baja.ui.list.ListModel;
import javax.baja.ui.list.ListSelection;
import javax.baja.ui.options.BOptions;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.text.TextController;
import javax.baja.ui.text.TextModel;
import javax.baja.ui.tree.TreeModel;
import javax.baja.ui.wizard.BWizard;
import javax.baja.ui.wizard.BWizardHeader;
import javax.baja.ui.wizard.WizardModel;
import javax.baja.util.Lexicon;
import javax.baja.util.LexiconText;
import javax.baja.util.PatternFilter;
import javax.baja.workbench.BWbShell;

public class StationWizardModel
extends WizardModel {
    BDirectoryTree.DirectoryTreeModel directoryTreeModel;
    private BDirectory stationDir;
    private String targetStationName = null;
    private BDaemonSession session;
    private DependencyUtil.AnalysisResults analysisResults;
    private DaemonSessionTaskHandler sessionTaskHandler;
    private Array stationsToDelete = new Array(class$java$lang$String == null ? (class$java$lang$String = StationWizardModel.class$("java.lang.String")) : class$java$lang$String);
    private boolean isLocalToRemote;
    private boolean startStation = true;
    private boolean autoStart = true;
    private boolean autoRestart = true;
    private BStationCopier stationCopier;
    private boolean openApplicationDirector = false;
    private BStationCopierOptions stationCopierOptions = null;
    private PatternFilter[] fileExcludePatterns = null;
    private PatternFilter[] directoryExcludePatterns = null;
    private BStationContentEnum stationContent = BStationContentEnum.configOnly;
    private BStationDispositionEnum stationDisposition = BStationDispositionEnum.replaceDuplicates;
    private StationWizardStep currentStep;
    private ContentStep contentStep;
    private StationNameStep nameStep;
    private DispositionStep dispositionStep;
    private ModulesStep modulesStep;
    private StartStationStep startStep;
    private LockedStep lockedStep;
    private StopStationStep stopStep;
    private DeleteStep deleteStep;
    private RebootStep rebootStep;
    private FileLock localStationBogLock = null;
    private boolean sourceHasSubdirs = false;
    private boolean targetDirectoryExists = false;
    private boolean reboot = false;
    private BDirectory targetStationsRoot;
    private BRemoteModuleList remoteModuleList;
    private BStationSurrogate stationSurrogate;
    public static final BImage wizImage = BImage.make((String)"module://icons/x32/sync.png");
    private static final Lexicon lex = Lexicon.make((String)"platDaemon");
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;

    public static boolean open(BDirectory bDirectory, BDirectory bDirectory2, BRemoteModuleList bRemoteModuleList, BStationCopier bStationCopier) throws Exception {
        Object object;
        BDaemonSession bDaemonSession = bStationCopier.getDaemonSession();
        DaemonSessionTaskHandler daemonSessionTaskHandler = new DaemonSessionTaskHandler((BWidget)bStationCopier);
        DependencyUtil.AnalysisResults analysisResults = null;
        if (bDirectory.getStore() instanceof BLocalFileStore && (analysisResults = DependencyUtil.analyzeAllDependencies((BDaemonPlatform)(object = BRemoteDaemonPlatform.make((BDaemonSession)bDaemonSession, (DaemonSessionTaskListener)daemonSessionTaskHandler)), (BFileSpace)bDirectory.getFileSpace(), (FilePath)bDirectory.getFilePath(), null, (DaemonSessionTaskListener)daemonSessionTaskHandler)).anyUnsolvable()) {
            if (bDaemonSession.usesLocalNiagaraEnvironment()) {
                BDialog.error((BWidget)bStationCopier, (String)BDaemonSessionView.lexicon.getText("StationWizard.mustCommission.title"), (Object)BDaemonSessionView.lexicon.getText("StationWizard.mustCommission.message"));
                return false;
            }
            if (4 == BDialog.confirm((BWidget)bStationCopier, (String)BDaemonSessionView.lexicon.getText("StationWizard.mustCommission.title"), (Object)BDaemonSessionView.lexicon.getText("StationWizard.mustCommission.prompt"), (int)12)) {
                BWizard.open((BWidget)bStationCopier, (WizardModel)new CommissioningWizardModel((BWidget)bStationCopier, bDaemonSession, true));
                return true;
            }
            return false;
        }
        object = new StationWizardModel(bDaemonSession, daemonSessionTaskHandler, analysisResults, bDirectory, bDirectory2, bRemoteModuleList, bStationCopier);
        BWizard.open((BWidget)bStationCopier, (WizardModel)object);
        bStationCopier.resetAppSurrogates();
        if (((StationWizardModel)((Object)object)).shouldReboot()) {
            return false;
        }
        BWbShell bWbShell = BWbShell.getWbShell((BWidget)bStationCopier);
        if (((StationWizardModel)((Object)object)).openApplicationDirector() && bWbShell != null) {
            bWbShell.hyperlink(BOrd.make((BOrd)bDaemonSession.getNavOrd(), (OrdQuery)BViewScheme.INSTANCE.parse("platDaemon:ApplicationDirector")));
            return true;
        }
        return false;
    }

    private StationWizardModel(BDaemonSession bDaemonSession, DaemonSessionTaskHandler daemonSessionTaskHandler, DependencyUtil.AnalysisResults analysisResults, BDirectory bDirectory, BDirectory bDirectory2, BRemoteModuleList bRemoteModuleList, BStationCopier bStationCopier) throws Exception {
        BDirectoryTree.DirectoryTreeNode directoryTreeNode;
        BDirectoryTree.DirectoryTreeNode directoryTreeNode2;
        BDirectoryTree.DirectoryTreeNode directoryTreeNode3;
        BDirectoryTree.DirectoryTreeNode directoryTreeNode4;
        this.session = bDaemonSession;
        this.sessionTaskHandler = daemonSessionTaskHandler;
        this.analysisResults = analysisResults;
        daemonSessionTaskHandler = new DaemonSessionTaskHandler((BWidget)bStationCopier);
        this.stationDir = bDirectory;
        this.targetStationsRoot = bDirectory2;
        this.remoteModuleList = bRemoteModuleList;
        this.stationCopier = bStationCopier;
        try {
            this.sourceHasSubdirs = false;
            directoryTreeNode4 = this.getStationDirectory().listFiles();
            for (int i = 0; i < ((BIFile[])directoryTreeNode4).length; ++i) {
                if (!directoryTreeNode4[i].isDirectory()) continue;
                this.sourceHasSubdirs = true;
                break;
            }
        }
        catch (Exception exception) {
            BDaemonSessionView.log.error("error checking for station directory existance", (Throwable)exception);
            this.sourceHasSubdirs = false;
        }
        this.isLocalToRemote = bDirectory.getStore() instanceof BLocalFileStore;
        bRemoteModuleList.init((DaemonSessionTaskListener)daemonSessionTaskHandler);
        this.directoryTreeModel = new BDirectoryTree.DirectoryTreeModel();
        this.directoryTreeModel.setRootDirectory((BIDirectory)bDirectory);
        this.stationCopierOptions = BStationCopierOptions.make();
        directoryTreeNode4 = (BDirectoryTree.DirectoryTreeNode)((BDirectoryTree.DirectoryTreeNode)this.directoryTreeModel.getRoot(0)).getChild("history");
        if (directoryTreeNode4 != null) {
            directoryTreeNode4.setChecked(this.isLocalToRemote() ? false : this.stationCopierOptions.getCopyRemoteStationHistoryData(), BTreeCascadePolicy.always, BTreeCascadePolicy.never, false);
            directoryTreeNode4.setCheckEnabled(false, true);
            directoryTreeNode4.setExpanded(false);
        }
        if ((directoryTreeNode3 = (BDirectoryTree.DirectoryTreeNode)((BDirectoryTree.DirectoryTreeNode)this.directoryTreeModel.getRoot(0)).getChild("alarm")) != null) {
            directoryTreeNode3.setChecked(this.isLocalToRemote() ? false : this.stationCopierOptions.getCopyRemoteStationAlarmData(), BTreeCascadePolicy.always, BTreeCascadePolicy.never, false);
            directoryTreeNode3.setCheckEnabled(false, true);
            directoryTreeNode3.setExpanded(false);
        }
        if ((directoryTreeNode2 = (BDirectoryTree.DirectoryTreeNode)((BDirectoryTree.DirectoryTreeNode)this.directoryTreeModel.getRoot(0)).getChild("jobs")) != null) {
            directoryTreeNode2.setChecked(this.isLocalToRemote() ? false : this.stationCopierOptions.getCopyRemoteStationJobsData(), BTreeCascadePolicy.always, BTreeCascadePolicy.never, false);
            if (this.isLocalToRemote()) {
                directoryTreeNode2.setCheckEnabled(false, true);
                directoryTreeNode2.setExpanded(false);
            }
        }
        if ((directoryTreeNode = (BDirectoryTree.DirectoryTreeNode)((BDirectoryTree.DirectoryTreeNode)this.directoryTreeModel.getRoot(0)).getChild("dataRecovery")) != null) {
            directoryTreeNode.setChecked(this.isLocalToRemote() ? false : this.stationCopierOptions.getCopyRemoteStationDataRecovery(), BTreeCascadePolicy.always, BTreeCascadePolicy.never, false);
            if (this.isLocalToRemote()) {
                directoryTreeNode.setCheckEnabled(false, true);
                directoryTreeNode.setExpanded(false);
            }
        }
        this.setStationSurrogate(bStationCopier.getStationSurrogate(bDirectory.getFileName(), true));
        if (this.isLocalToRemote && this.getStationSurrogate() != null) {
            this.setAutoStart(this.getStationSurrogate().getIsAutoStart());
            this.setAutoRestart(this.getStationSurrogate().getIsAutoRestart());
        }
        String string = this.stationCopierOptions.getFilePatternExcludeList();
        String string2 = this.stationCopierOptions.getDirectoryPatternExcludeList();
        this.fileExcludePatterns = PatternFilter.parseList((String)string, (String)" ");
        this.directoryExcludePatterns = PatternFilter.parseList((String)string2, (String)" ");
        if (BDaemonSessionView.log.isTraceOn()) {
            int n;
            StringBuffer stringBuffer = new StringBuffer();
            for (n = 0; n < this.fileExcludePatterns.length; ++n) {
                stringBuffer.append(this.fileExcludePatterns[n].getPattern()).append(' ');
            }
            BDaemonSessionView.log.trace("Excluding file patterns: \"" + stringBuffer.toString() + "\" in station transfer");
            stringBuffer = new StringBuffer();
            for (n = 0; n < this.directoryExcludePatterns.length; ++n) {
                stringBuffer.append(this.directoryExcludePatterns[n].getPattern()).append(' ');
            }
            BDaemonSessionView.log.trace("Excluding directory patterns: \"" + stringBuffer.toString() + "\" in station transfer");
        }
        this.directoryTreeModel.setDirectoryStates((BDirectoryTree.DirectoryTreeNode)this.directoryTreeModel.getRoot(0), this.directoryExcludePatterns, false, false, false);
        this.reboot = this.isLocalToRemote() && !this.allowStationRestart();
        this.nameStep = new StationNameStep();
        this.deleteStep = new DeleteStep();
        this.nameStep.setNextStep(this.deleteStep);
        this.contentStep = new ContentStep();
        this.deleteStep.setNextStep(this.contentStep);
        this.dispositionStep = new DispositionStep();
        this.contentStep.setNextStep(this.dispositionStep);
        this.startStep = new StartStationStep();
        this.dispositionStep.setNextStep(this.startStep);
        DetailsStep detailsStep = new DetailsStep();
        this.startStep.setNextStep(detailsStep);
        this.modulesStep = new ModulesStep();
        detailsStep.setNextStep(this.modulesStep);
        this.stopStep = new StopStationStep();
        this.modulesStep.setNextStep(this.stopStep);
        this.rebootStep = new RebootStep();
        this.stopStep.setNextStep(this.rebootStep);
        this.rebootStep.setNextStep(new ReviewStep());
        this.lockedStep = new LockedStep();
    }

    public void setWizard(BWizard bWizard) {
        super.setWizard(bWizard);
        this.sessionTaskHandler.setOwner((BWidget)bWizard);
    }

    public String getTitle() {
        return BDaemonSessionView.lexicon.getText("StationWizard.title");
    }

    public boolean cancel() {
        if (this.getCurrentStep().getMode() == 0) {
            if (this.localStationBogLock != null) {
                try {
                    this.localStationBogLock.unlock();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return true;
        }
        if (BDialog.confirm((BWidget)this.getWizard(), (String)BDaemonSessionView.lexicon.getText("StationWizard.cancel.title"), (Object)BDaemonSessionView.lexicon.getText("StationWizard.cancel.message")) == 4 && this.getCurrentStep().cancel()) {
            if (this.localStationBogLock != null) {
                try {
                    this.localStationBogLock.unlock();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return true;
        }
        return false;
    }

    public void init() {
        Object object;
        this.localStationBogLock = null;
        if (this.isLocalToRemote()) {
            object = (BBogFile)BFileSystem.INSTANCE.findFile(new FilePath("!stations").merge(this.getSourceStationName()).merge("config.bog"));
            if (object != null && object.isModified()) {
                this.update(this.lockedStep);
                return;
            }
        } else {
            object = (BBogFile)BFileSystem.INSTANCE.findFile(new FilePath("!stations").merge(this.getTargetStationName()).merge("config.bog"));
            if (object != null) {
                File file = ((BLocalFileStore)object.getStore()).getLocalFile();
                try {
                    this.localStationBogLock = FileLock.lock((File)file);
                }
                catch (Exception exception) {
                    this.update(this.lockedStep);
                    return;
                }
            }
        }
        for (object = this.nameStep; object != null && ((StationWizardStep)object).isSkipped(); object = ((StationWizardStep)object).getNextStep()) {
        }
        this.update((StationWizardStep)object);
        try {
            ((StationWizardStep)object).enter();
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
    }

    public void back() {
        StationWizardStep stationWizardStep = this.getCurrentStep().getPriorStep();
        if (stationWizardStep != null && this.getCurrentStep().exit()) {
            this.update(stationWizardStep);
            try {
                stationWizardStep.enter();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new BajaRuntimeException((Throwable)exception);
            }
        }
    }

    public void next() {
        StationWizardStep stationWizardStep = this.getCurrentStep().getNextStep();
        if (stationWizardStep != null && this.getCurrentStep().exit()) {
            while (stationWizardStep != null && stationWizardStep.isSkipped()) {
                stationWizardStep = stationWizardStep.getNextStep();
            }
            stationWizardStep.setPriorStep(this.getCurrentStep());
            this.update(stationWizardStep);
            try {
                stationWizardStep.enter();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new BajaRuntimeException((Throwable)exception);
            }
        }
    }

    public boolean finish() {
        if (this.localStationBogLock != null) {
            try {
                this.localStationBogLock.unlock();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (new FinalStep(this).open()) {
            this.setOpenApplicationDirector();
        }
        return true;
    }

    private StationWizardStep getCurrentStep() {
        return this.currentStep;
    }

    public void update(StationWizardStep stationWizardStep) {
        this.currentStep = stationWizardStep;
        this.update(stationWizardStep.getWidget(), stationWizardStep.getMode());
    }

    public Size getPreferredSizeOfSteps() {
        return new Size(450.0, 300.0);
    }

    public void setReboot(boolean bl) {
        this.reboot = bl;
    }

    public boolean shouldReboot() {
        return this.reboot;
    }

    public BDirectory getStationDirectory() {
        return this.stationDir;
    }

    public String getSourceStationName() {
        return this.stationDir.getFileName();
    }

    public String getTargetStationName() {
        if (this.targetStationName == null) {
            this.targetStationName = this.getSourceStationName();
        }
        return this.targetStationName;
    }

    public void setTargetStationName(String string) {
        this.targetStationName = string;
        try {
            BDirectory bDirectory = this.getTargetStationsRoot();
            BDirectory bDirectory2 = (BDirectory)bDirectory.getNavChild(this.getTargetStationName());
            if (bDirectory2 == null) {
                this.targetDirectoryExists = false;
                this.stationContent = BStationContentEnum.everything;
            } else {
                this.targetDirectoryExists = true;
                this.stationContent = BStationContentEnum.configOnly;
            }
        }
        catch (Exception exception) {
            BDaemonSessionView.log.error("error checking for station directory existance", (Throwable)exception);
            this.targetDirectoryExists = false;
        }
    }

    public BDirectory getTargetStationsRoot() {
        return this.targetStationsRoot;
    }

    public BRemoteModuleList getRemoteModuleList() {
        return this.remoteModuleList;
    }

    public String getTargetSystemName() {
        return this.isLocalToRemote() ? "\"" + this.getDaemonSession().getRemoteAddressString() + "\"" : BDaemonSessionView.lexicon.getText("StationCopier.localSystemName");
    }

    public String getSourceSystemName() {
        return this.isLocalToRemote() ? BDaemonSessionView.lexicon.getText("StationCopier.localSystemName") : "\"" + this.getDaemonSession().getRemoteAddressString() + "\"";
    }

    public boolean isLocalToRemote() {
        return this.isLocalToRemote;
    }

    public boolean allowStationRestart() {
        return this.getDaemonSession().getHostProperties().getAllowStationRestart();
    }

    public boolean mustStopStations() throws Exception {
        if (!this.isLocalToRemote()) {
            return false;
        }
        if (this.getDependencyAnalysis().getSolution().getToInstall().length > 0 && BStationSurrogate.isAnyStationRunning((BDaemonSession)this.getDaemonSession())) {
            return true;
        }
        return this.getStationSurrogate() != null && this.getStationSurrogate().isStationRunning();
    }

    public void setIsLocalToRemote(boolean bl) {
        if (this.isLocalToRemote != bl) {
            this.isLocalToRemote = bl;
            this.stationDir = null;
            this.directoryTreeModel = new BDirectoryTree.DirectoryTreeModel();
        }
    }

    public void setStationContent(BStationContentEnum bStationContentEnum) {
        this.stationContent = bStationContentEnum;
    }

    public BStationContentEnum getStationContent() {
        return this.stationContent;
    }

    public void setStationDisposition(BStationDispositionEnum bStationDispositionEnum) {
        this.stationDisposition = bStationDispositionEnum;
    }

    public BStationDispositionEnum getStationDisposition() {
        return this.stationDisposition;
    }

    public DependencyUtil.AnalysisResults getDependencyAnalysis() {
        return this.analysisResults;
    }

    public BDaemonPlatform getDaemonPlatform() {
        try {
            return BRemoteDaemonPlatform.make((BDaemonSession)this.session, (DaemonSessionTaskListener)this.sessionTaskHandler);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
    }

    public BDaemonSession getDaemonSession() {
        return this.session;
    }

    public void setStationSurrogate(BStationSurrogate bStationSurrogate) {
        this.stationSurrogate = bStationSurrogate;
    }

    public BStationSurrogate getStationSurrogate() {
        return this.stationSurrogate;
    }

    public BStationSurrogate getStationSurrogate(String string) {
        return this.stationCopier.getStationSurrogate(string, true);
    }

    public void setStartStation(boolean bl) {
        this.startStation = bl;
    }

    public boolean startStation() {
        return this.isLocalToRemote() && this.startStation;
    }

    public void setAutoStart(boolean bl) {
        this.autoStart = bl;
    }

    public boolean isAutoStart() {
        return this.autoStart;
    }

    public void setAutoRestart(boolean bl) {
        this.autoRestart = bl;
    }

    public boolean isAutoRestart() {
        return this.autoRestart;
    }

    public Array getStationsToDelete() {
        return this.stationsToDelete;
    }

    public Array getTransferContents() {
        Array array = new Array();
        if (this.getStationContent() == BStationContentEnum.selectedDirectories) {
            Iterator iterator = this.directoryTreeModel.getCheckedDirectories();
            while (iterator.hasNext()) {
                BDirectory bDirectory = (BDirectory)iterator.next();
                BIFile[] bIFileArray = bDirectory.listFiles();
                for (int i = 0; i < bIFileArray.length; ++i) {
                    if (bIFileArray[i].isDirectory() || this.ignoreFile(bIFileArray[i])) continue;
                    array.add((Object)bIFileArray[i]);
                }
            }
        } else if (this.getStationContent() == BStationContentEnum.everything) {
            TreeSet<FilePath> treeSet = new TreeSet<FilePath>((Comparator<FilePath>)FilePathComparator.INSTANCE);
            if (this.isLocalToRemote || !this.stationCopierOptions.getCopyRemoteStationAlarmData()) {
                treeSet.add(this.stationDir.getFilePath().merge("alarm"));
            }
            if (this.isLocalToRemote || !this.stationCopierOptions.getCopyRemoteStationDataRecovery()) {
                treeSet.add(this.stationDir.getFilePath().merge("dataRecovery"));
            }
            if (this.isLocalToRemote || !this.stationCopierOptions.getCopyRemoteStationHistoryData()) {
                treeSet.add(this.stationDir.getFilePath().merge("history"));
            }
            if (this.isLocalToRemote || !this.stationCopierOptions.getCopyRemoteStationJobsData()) {
                treeSet.add(this.stationDir.getFilePath().merge("jobs"));
            }
            this.addAllDataFiles(this.stationDir, treeSet, array);
        } else if (this.getStationContent() == BStationContentEnum.configOnly) {
            BINavNode bINavNode = this.stationDir.getNavChild("config.bog");
            if (bINavNode != null) {
                array.add((Object)bINavNode);
            }
        } else {
            throw new UnsupportedOperationException();
        }
        return array;
    }

    public boolean openApplicationDirector() {
        return this.openApplicationDirector;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setOpenApplicationDirector() {
        if (this.isLocalToRemote()) {
            if (this.shouldReboot()) {
                this.openApplicationDirector = false;
                return;
            }
            try {
                BOptions bOptions = BOptions.load((String)BStationCopier.TYPE.toString(), (Type)BOptions.TYPE);
                BBoolean bBoolean = (BBoolean)bOptions.get("openApplicationDirector");
                if (bBoolean == null) {
                    BGridPane bGridPane = new BGridPane(1);
                    bGridPane.setRowGap(12.0);
                    BCheckBox bCheckBox = new BCheckBox(BDaemonSessionView.lexicon.getText("StationCopier.openApplicationDirector.dontAsk"), false);
                    bGridPane.add(null, (BValue)new BLabel(BDaemonSessionView.lexicon.getText("StationCopier.openApplicationDirector.question")));
                    bGridPane.add(null, (BValue)bCheckBox);
                    boolean bl = this.openApplicationDirector = 4 == BDialog.confirm((BWidget)this.getWizard(), (String)BDaemonSessionView.lexicon.getText("StationCopier.openApplicationDirector.dlgTitle"), (Object)new BBorderPane((BWidget)bGridPane, 0.0, 5.0, 5.0, 5.0));
                    if (!bCheckBox.isSelected()) return;
                    bOptions.add("openApplicationDirector", (BValue)BBoolean.make((boolean)this.openApplicationDirector()));
                    bOptions.save();
                    return;
                }
                this.openApplicationDirector = bBoolean.getBoolean();
                return;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new BajaRuntimeException((Throwable)exception);
            }
        } else {
            this.openApplicationDirector = false;
        }
    }

    public DaemonSessionTaskHandler getTaskHandler() {
        return this.sessionTaskHandler;
    }

    private void addAllDataFiles(BDirectory bDirectory, Set set, Array array) {
        BIFile[] bIFileArray = bDirectory.listFiles();
        for (int i = 0; i < bIFileArray.length; ++i) {
            if (set.contains(bIFileArray[i].getFilePath())) continue;
            if (bIFileArray[i].isDirectory()) {
                if (this.ignoreDirectory((BDirectory)bIFileArray[i])) continue;
                this.addAllDataFiles((BDirectory)bIFileArray[i], set, array);
                continue;
            }
            if (this.ignoreFile(bIFileArray[i])) continue;
            array.add((Object)bIFileArray[i]);
        }
    }

    private boolean ignoreFile(BIFile bIFile) {
        for (int i = 0; i < this.fileExcludePatterns.length; ++i) {
            if (!this.fileExcludePatterns[i].accept(bIFile)) continue;
            return true;
        }
        return false;
    }

    private boolean ignoreDirectory(BDirectory bDirectory) {
        for (int i = 0; i < this.directoryExcludePatterns.length; ++i) {
            if (!this.directoryExcludePatterns[i].accept((BIFile)bDirectory)) continue;
            return true;
        }
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class DeleteStationListModel
    extends ListModel {
        private Array names = new Array(class$java$lang$String == null ? (class$java$lang$String = StationWizardModel.class$("java.lang.String")) : class$java$lang$String);

        private DeleteStationListModel() {
        }

        public void load(BStationSurrogate[] bStationSurrogateArray, BStationSurrogate bStationSurrogate) {
            this.names.clear();
            for (int i = 0; i < bStationSurrogateArray.length; ++i) {
                if (bStationSurrogate != null && bStationSurrogate.getStationName().equals(bStationSurrogateArray[i].getStationName())) continue;
                this.names.add((Object)bStationSurrogateArray[i].getStationName());
            }
            this.updateList();
        }

        public int getItemCount() {
            return this.names.size();
        }

        public String getStationName(int n) {
            return (String)this.names.get(n);
        }

        public Object getItem(int n) {
            return this.getStationName(n);
        }
    }

    private class DeleteStationListSelection
    extends ListSelection {
        private StationWizardStep step;

        public DeleteStationListSelection(StationWizardStep stationWizardStep) {
            this.step = stationWizardStep;
        }

        public void updateList() {
            StationWizardModel.this.update(this.step.getMode());
            super.updateList();
        }
    }

    private class DeleteStep
    extends StationWizardStep {
        private BStationSurrogate[] surrogates;
        private int max;
        private DeleteStationListModel listModel = null;

        public DeleteStep() {
            if (!StationWizardModel.this.isLocalToRemote()) {
                return;
            }
            try {
                Array array = new Array((Object[])StationWizardModel.this.stationCopier.getAppSurrogates());
                array = array.filter(new IFilter(){

                    public boolean accept(Object object) {
                        return object instanceof BStationSurrogate;
                    }
                });
                this.surrogates = new BStationSurrogate[array.size()];
                for (int i = 0; i < array.size(); ++i) {
                    this.surrogates[i] = (BStationSurrogate)array.get(i);
                }
                this.max = StationWizardModel.this.getDaemonSession().getHostProperties().getMaxStations();
                if (this.surrogates.length == 1) {
                    BLabel bLabel = new BLabel(BDialog.WARNING_ICON, lex.getText("StationCopier.DeleteStep.deleteOnlyStation", new Object[]{this.surrogates[0].getStationName()}));
                    bLabel.setHalign(BHalign.left);
                    bLabel.setWordWrapEnabled(true);
                    this.setContent((BWidget)new BEdgePane((BWidget)bLabel, null, null, null, null));
                } else if (this.surrogates.length > 1) {
                    BLabel bLabel = new BLabel(BDialog.WARNING_ICON, lex.getText("StationCopier.DeleteStep.deleteStation", new Object[]{String.valueOf(this.max)}));
                    bLabel.setHalign(BHalign.left);
                    this.listModel = new DeleteStationListModel();
                    BList bList = new BList((ListModel)this.listModel);
                    this.setContent((BWidget)new BEdgePane((BWidget)new BBorderPane((BWidget)bLabel, 0.0, 0.0, 5.0, 0.0), null, null, null, (BWidget)new BBorderPane((BWidget)bList, BBorder.inset, BInsets.DEFAULT)));
                    bList.setSelection((ListSelection)new DeleteStationListSelection(this));
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new BajaRuntimeException((Throwable)exception);
            }
        }

        public String getStepName() {
            return "DeleteStep";
        }

        public void enter() {
            if (this.listModel != null) {
                int n;
                this.listModel.load(this.surrogates, StationWizardModel.this.getStationSurrogate());
                Array array = new Array(class$java$lang$Integer == null ? (class$java$lang$Integer = StationWizardModel.class$("java.lang.Integer")) : class$java$lang$Integer);
                for (int i = 0; i < StationWizardModel.this.getStationsToDelete().size(); ++i) {
                    n = this.listModel.indexOfItem(StationWizardModel.this.getStationsToDelete().get(i));
                    if (n < 0) continue;
                    array.add((Object)new Integer(n));
                }
                int[] nArray = new int[array.size()];
                for (n = 0; n < nArray.length; ++n) {
                    nArray[n] = (Integer)array.get(n);
                }
                this.listModel.getList().getSelection().select(nArray);
            }
        }

        public boolean isSkipped() {
            if (!StationWizardModel.this.isLocalToRemote()) {
                return true;
            }
            try {
                int n = this.max;
                if (StationWizardModel.this.getStationSurrogate() != null) {
                    ++n;
                }
                if (this.surrogates.length < n) {
                    StationWizardModel.this.getStationsToDelete().clear();
                    return true;
                }
                return false;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new BajaRuntimeException((Throwable)exception);
            }
        }

        public boolean exit() {
            StationWizardModel.this.getStationsToDelete().clear();
            if (this.surrogates.length == 1) {
                StationWizardModel.this.getStationsToDelete().add((Object)this.surrogates[0].getStationName());
            } else {
                int[] nArray = this.listModel.getList().getSelection().getItems();
                for (int i = 0; i < nArray.length; ++i) {
                    StationWizardModel.this.getStationsToDelete().add((Object)this.listModel.getStationName(nArray[i]));
                }
            }
            return true;
        }

        public int getMode() {
            int n;
            StationWizardStep stationWizardStep;
            int n2 = 0;
            for (stationWizardStep = this.getPriorStep(); stationWizardStep != null && stationWizardStep.isSkipped(); stationWizardStep = stationWizardStep.getPriorStep()) {
            }
            if (stationWizardStep != null) {
                n2 |= 1;
            }
            int n3 = this.max;
            if (StationWizardModel.this.getStationSurrogate() != null) {
                ++n3;
            }
            if (this.surrogates.length - (n = this.listModel == null ? 1 : this.listModel.getList().getSelection().getItems().length) < n3) {
                StationWizardStep stationWizardStep2;
                for (stationWizardStep2 = this.getNextStep(); stationWizardStep2 != null && stationWizardStep2.isSkipped(); stationWizardStep2 = stationWizardStep2.getNextStep()) {
                }
                if (stationWizardStep2 != null) {
                    n2 |= 2;
                }
            }
            return n2;
        }
    }

    private class RebootStep
    extends StationWizardStep {
        private BCheckBox rebootCheckBox;

        public RebootStep() {
            if (!StationWizardModel.this.isLocalToRemote()) {
                return;
            }
            BGridPane bGridPane = new BGridPane(1);
            bGridPane.setHalign(BHalign.left);
            bGridPane.setValign(BValign.top);
            this.rebootCheckBox = new BCheckBox(lex.getText("StationCopier.RebootStep.label"));
            bGridPane.add(null, (BValue)this.rebootCheckBox);
            this.setContent((BWidget)new BEdgePane((BWidget)new BBorderPane((BWidget)bGridPane, 0.0, 0.0, 8.0, 0.0), null, null, null, null));
        }

        public String getStepName() {
            return "RebootStep";
        }

        public void enter() {
            this.rebootCheckBox.setSelected(StationWizardModel.this.shouldReboot());
        }

        public boolean isSkipped() {
            return !StationWizardModel.this.isLocalToRemote() || StationWizardModel.this.allowStationRestart();
        }

        public boolean exit() {
            StationWizardModel.this.setReboot(this.rebootCheckBox.isSelected());
            return true;
        }

        public int getMode() {
            return this.getNavMode();
        }
    }

    private class StartStationStep
    extends StationWizardStep {
        private BCheckBox startStationCheckBox;
        private BCheckBox autoStartCheckBox;

        public StartStationStep() {
            BGridPane bGridPane = new BGridPane(1);
            bGridPane.setHalign(BHalign.left);
            bGridPane.setValign(BValign.top);
            this.startStationCheckBox = new BCheckBox(lex.getText("StationCopier.StartStationStep.start.description"));
            bGridPane.add(null, (BValue)this.startStationCheckBox);
            this.autoStartCheckBox = new BCheckBox(lex.getText("StationCopier.StartStationStep.autoStart.description"));
            bGridPane.add(null, (BValue)this.autoStartCheckBox);
            this.setContent((BWidget)new BEdgePane((BWidget)new BBorderPane((BWidget)bGridPane, 0.0, 0.0, 8.0, 0.0), null, null, null, null));
        }

        public String getStepName() {
            return "StartStationStep";
        }

        public void enter() throws Exception {
            if (StationWizardModel.this.allowStationRestart()) {
                this.startStationCheckBox.setSelected(StationWizardModel.this.startStation());
                this.startStationCheckBox.setEnabled(true);
            } else {
                this.startStationCheckBox.setSelected(false);
                this.startStationCheckBox.setEnabled(false);
                StationWizardModel.this.setStartStation(false);
            }
            this.autoStartCheckBox.setSelected(StationWizardModel.this.isAutoStart());
        }

        public boolean isSkipped() {
            return !StationWizardModel.this.isLocalToRemote() || !StationWizardModel.this.getDependencyAnalysis().getSolution().canCommit();
        }

        public boolean exit() {
            StationWizardModel.this.setStartStation(this.startStationCheckBox.isSelected());
            StationWizardModel.this.setAutoStart(this.autoStartCheckBox.isSelected());
            return true;
        }

        public int getMode() {
            return this.getNavMode();
        }
    }

    private class StopStationStep
    extends StationWizardStep {
        public StopStationStep() {
            BGridPane bGridPane = new BGridPane(1);
            bGridPane.setHalign(BHalign.left);
            bGridPane.setValign(BValign.top);
            bGridPane.add(null, (BValue)new BLabel(lex.getText("StationCopier.StopStationStep.message"), BHalign.left));
            this.setContent((BWidget)bGridPane);
        }

        public String getStepName() {
            return "StopStationStep";
        }

        public void enter() {
        }

        public boolean isSkipped() {
            try {
                if (StationWizardModel.this.getStationDisposition() == BStationDispositionEnum.clean) {
                    return true;
                }
                return !StationWizardModel.this.isLocalToRemote() || (StationWizardModel.this.getDependencyAnalysis().getSolution().getToInstall().length <= 0 || !BStationSurrogate.isAnyStationRunning((BDaemonSession)StationWizardModel.this.getDaemonSession())) && (StationWizardModel.this.getStationSurrogate() == null || !StationWizardModel.this.getStationSurrogate().isStationRunning());
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new BajaRuntimeException((Throwable)exception);
            }
        }

        public boolean exit() {
            return true;
        }

        public int getMode() {
            return this.getNavMode();
        }
    }

    private class LockedStep
    extends StationWizardStep {
        public LockedStep() {
            BGridPane bGridPane = new BGridPane(1);
            bGridPane.setHalign(BHalign.left);
            bGridPane.setValign(BValign.top);
            if (StationWizardModel.this.isLocalToRemote()) {
                bGridPane.add(null, (BValue)new BLabel(lex.getText("StationCopier.LockedStep.message.upload"), BHalign.left));
            } else {
                bGridPane.add(null, (BValue)new BLabel(lex.getText("StationCopier.LockedStep.message.download"), BHalign.left));
            }
            this.setContent((BWidget)bGridPane);
        }

        public String getStepName() {
            return "LockedStep";
        }

        public int getMode() {
            return StationWizardModel.this.isLocalToRemote() ? 0 : 1;
        }

        public StationWizardStep getPriorStep() {
            return StationWizardModel.this.isLocalToRemote() ? null : StationWizardModel.this.nameStep;
        }
    }

    private class ReviewStep
    extends StationWizardStep {
        private BIndentPane indent;
        private BIcon dirIconRef = BIcon.std((String)"folder.png");

        public ReviewStep() {
            this.indent = new BIndentPane();
            BScrollPane bScrollPane = new BScrollPane((BWidget)new BBorderPane((BWidget)this.indent, 3.0, 5.0, 3.0, 5.0));
            bScrollPane.setBorderPolicy(BScrollBarPolicy.asNeeded);
            bScrollPane.setViewportBackground(Theme.scrollPane().getControlBackground());
            this.setContent((BWidget)bScrollPane);
        }

        public String getStepName() {
            return "ReviewStep";
        }

        public int getMode() {
            StationWizardStep stationWizardStep;
            int n = 4;
            for (stationWizardStep = this.getPriorStep(); stationWizardStep != null && stationWizardStep.isSkipped(); stationWizardStep = stationWizardStep.getPriorStep()) {
            }
            if (stationWizardStep != null) {
                n |= 1;
            }
            return n;
        }

        public void enter() {
            String string = StationWizardModel.this.getSourceSystemName();
            String string2 = StationWizardModel.this.getTargetSystemName();
            this.indent.clear();
            if (StationWizardModel.this.getStationContent() == BStationContentEnum.everything) {
                this.indent.add(LexiconText.make((String)"platDaemon", (String)"StationCopier.ReviewStep.content.everything"), new Object[]{string, string2});
            } else if (StationWizardModel.this.getStationContent() == BStationContentEnum.configOnly) {
                this.indent.add(LexiconText.make((String)"platDaemon", (String)"StationCopier.ReviewStep.content.configOnly"), new Object[]{string, string2});
            } else if (StationWizardModel.this.getStationContent() == BStationContentEnum.selectedDirectories) {
                this.indent.add(LexiconText.make((String)"platDaemon", (String)"StationCopier.ReviewStep.content.selectedDirectories"), new Object[]{string, string2});
                this.indent.indent();
                Iterator iterator = StationWizardModel.this.directoryTreeModel.getCheckedDirectories();
                while (iterator.hasNext()) {
                    this.indent.add((BWidget)new BLabel(BImage.make((BIcon)this.dirIconRef), ((BIFile)iterator.next()).getFilePath().getBody()));
                }
                this.indent.unindent();
            }
            this.indent.add((BWidget)new BBox(0.0, 5.0));
            if (StationWizardModel.this.isLocalToRemote() && StationWizardModel.this.getDependencyAnalysis().getSolution().getToInstall().length > 0) {
                this.indent.add(LexiconText.make((String)"platDaemon", (String)"StationCopier.ModulesStep.top"));
                boolean bl = false;
                this.indent.indent();
                for (int i = 0; i < StationWizardModel.this.getDependencyAnalysis().getSolution().getToInstall().length; ++i) {
                    BInstallable bInstallable = StationWizardModel.this.getDependencyAnalysis().getSolution().getToInstall()[i];
                    if (!bl) {
                        try {
                            BInstallable bInstallable2 = LocalInstallableRegistry.getInstance().findInstallable(BDependency.forModule((String)bInstallable.getInstallableName()), null);
                            if (bInstallable2.getVersion().getVendorVersion().compareTo((Object)bInstallable.getVersion().getVendorVersion()) > 0) {
                                bl = true;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    this.indent.add((BWidget)new BLabel(BImage.make((BIcon)bInstallable.getIcon()), bInstallable.toString()));
                }
                this.indent.unindent();
                if (bl) {
                    this.indent.add((BWidget)new BBox(0.0, 5.0));
                    BLabel bLabel = new BLabel(BImage.make((BIcon)BIcon.std((String)"warning.png")), lex.getText("StationCopier.ModulesStep.confirm.laterVersionAvail"));
                    bLabel.setHalign(BHalign.left);
                    this.indent.add((BWidget)bLabel);
                } else {
                    this.indent.add(LexiconText.make((String)"platDaemon", (String)"StationCopier.ModulesStep.confirm.bottom"));
                }
                this.indent.add((BWidget)new BBox(0.0, 5.0));
            }
            this.indent.add(LexiconText.make((String)"platDaemon", (String)"StationCopier.ReviewStep.footer"));
        }
    }

    private class ModulesStep
    extends StationWizardStep {
        private BIcon iconRef = BIcon.std((String)"module.png");
        private BIndentPane indent = new BIndentPane();

        public ModulesStep() {
            BScrollPane bScrollPane = new BScrollPane((BWidget)new BBorderPane((BWidget)this.indent, 3.0, 5.0, 3.0, 5.0));
            bScrollPane.setBorderPolicy(BScrollBarPolicy.asNeeded);
            bScrollPane.setViewportBackground(Theme.scrollPane().getControlBackground());
            this.setContent((BWidget)bScrollPane);
        }

        public void enter() {
            this.indent.clear();
            this.indent.add(LexiconText.make((String)"platDaemon", (String)"StationCopier.ModulesStep.top"));
            this.indent.indent();
            String[] stringArray = StationWizardModel.this.getDependencyAnalysis().getPartNames();
            for (int i = 0; i < stringArray.length; ++i) {
                if (StationWizardModel.this.getDependencyAnalysis().isUnavailable(stringArray[i])) {
                    this.indent.add((BWidget)new BLabel(BImage.make((BIcon)this.iconRef), stringArray[i] + "*"));
                    continue;
                }
                this.indent.add((BWidget)new BLabel(BImage.make((BIcon)this.iconRef), stringArray[i]));
            }
            this.indent.unindent();
            this.indent.add(LexiconText.make((String)"platDaemon", (String)"StationCopier.ModulesStep.cancel.bottom"));
        }

        public String getStepName() {
            return "ModulesStep";
        }

        public boolean isSkipped() {
            return !StationWizardModel.this.isLocalToRemote() || StationWizardModel.this.getDependencyAnalysis().getSolution().canCommit();
        }

        public int getMode() {
            StationWizardStep stationWizardStep;
            int n = 0;
            for (stationWizardStep = this.getPriorStep(); stationWizardStep != null && stationWizardStep.isSkipped(); stationWizardStep = stationWizardStep.getPriorStep()) {
            }
            if (stationWizardStep != null) {
                n |= 1;
            }
            if (this.getNextStep() != null && (!StationWizardModel.this.isLocalToRemote() || StationWizardModel.this.getDependencyAnalysis().getSolution().canCommit())) {
                n |= 2;
            }
            return n;
        }
    }

    private class DispositionStep
    extends StationWizardStep {
        private EnumRadioGroup group;

        private DispositionStep() {
        }

        public String getStepName() {
            return "DispositionStep";
        }

        public int getMode() {
            StationWizardStep stationWizardStep;
            int n = 2;
            for (stationWizardStep = this.getPriorStep(); stationWizardStep != null && stationWizardStep.isSkipped(); stationWizardStep = stationWizardStep.getPriorStep()) {
            }
            if (stationWizardStep != null) {
                n |= 1;
            }
            return n;
        }

        public boolean isSkipped() {
            if (StationWizardModel.this.isLocalToRemote() && !StationWizardModel.this.getDependencyAnalysis().getSolution().canCommit()) {
                return true;
            }
            return !StationWizardModel.this.targetDirectoryExists;
        }

        public void enter() {
            BGridPane bGridPane = new BGridPane(1);
            bGridPane.setValign(BValign.top);
            bGridPane.setHalign(BHalign.left);
            this.group = new EnumRadioGroup((BWidget)StationWizardModel.this.getWizard(), new String[]{lex.getText("StationCopier.clean.fullDesc", new Object[]{StationWizardModel.this.getTargetStationName()}), BStationDispositionEnum.replaceDuplicates.getDisplayTag(null)}, (BEnum[])new BFrozenEnum[]{BStationDispositionEnum.clean, BStationDispositionEnum.replaceDuplicates}, (BEnum)StationWizardModel.this.getStationDisposition());
            BWidget[] bWidgetArray = this.group.getWidgets();
            for (int i = 0; i < bWidgetArray.length; ++i) {
                bGridPane.add(null, (BValue)bWidgetArray[i]);
            }
            this.setContent((BWidget)bGridPane);
        }

        public boolean exit() {
            StationWizardModel.this.setStationDisposition((BStationDispositionEnum)this.group.getValue());
            return true;
        }
    }

    private class DetailsStep
    extends StationWizardStep {
        private BDirectoryTree tree = null;
        private BEdgePane rightPane = new BEdgePane();

        public DetailsStep() {
            BLabel bLabel = new BLabel(lex.getText("StationCopier.DetailsStep.description"));
            bLabel.setHalign(BHalign.left);
            this.rightPane.setTop((BWidget)new BBorderPane((BWidget)bLabel, 0.0, 0.0, 8.0, 0.0));
            this.setContent((BWidget)this.rightPane);
        }

        public void enter() {
            if (this.tree == null) {
                this.tree = new BDirectoryTree((TreeModel)StationWizardModel.this.directoryTreeModel);
                this.rightPane.setCenter((BWidget)new BScrollPane((BWidget)new BBorderPane((BWidget)this.tree, BBorder.inset, BInsets.DEFAULT)));
            } else if (StationWizardModel.this.directoryTreeModel != this.tree.getModel()) {
                this.tree.setModel((TreeModel)StationWizardModel.this.directoryTreeModel);
            }
            this.getWidget().relayout();
        }

        public int getMode() {
            return this.getNavMode();
        }

        public String getStepName() {
            return "DetailsStep";
        }

        public boolean isSkipped() {
            if (StationWizardModel.this.getStationContent() != BStationContentEnum.selectedDirectories || StationWizardModel.this.isLocalToRemote() && !StationWizardModel.this.getDependencyAnalysis().getSolution().canCommit()) {
                return true;
            }
            try {
                BIFile[] bIFileArray = StationWizardModel.this.getStationDirectory().listFiles();
                for (int i = 0; i < bIFileArray.length; ++i) {
                    if (!bIFileArray[i].isDirectory()) continue;
                    return false;
                }
            }
            catch (Exception exception) {
                BDaemonSessionView.log.error("error checking for subdirectories", (Throwable)exception);
            }
            return true;
        }
    }

    private class ContentStep
    extends StationWizardStep {
        private EnumRadioGroup group;
        private boolean hasSetDispositionDefault = false;

        private ContentStep() {
        }

        public String getStepName() {
            return "ContentStep";
        }

        public int getMode() {
            return 3;
        }

        public boolean isSkipped() {
            if (StationWizardModel.this.isLocalToRemote() && !StationWizardModel.this.getDependencyAnalysis().getSolution().canCommit()) {
                return true;
            }
            return this.configBogOnly();
        }

        public void enter() {
            BGridPane bGridPane = new BGridPane(1);
            bGridPane.setValign(BValign.top);
            bGridPane.setHalign(BHalign.left);
            this.group = StationWizardModel.this.sourceHasSubdirs ? new EnumRadioGroup((BWidget)StationWizardModel.this.getWizard(), (BEnum[])new BFrozenEnum[]{BStationContentEnum.selectedDirectories, BStationContentEnum.everything, BStationContentEnum.configOnly}, (BEnum)StationWizardModel.this.getStationContent(), null) : new EnumRadioGroup((BWidget)StationWizardModel.this.getWizard(), (BEnum[])new BFrozenEnum[]{BStationContentEnum.everything, BStationContentEnum.configOnly}, (BEnum)StationWizardModel.this.getStationContent(), null);
            BWidget[] bWidgetArray = this.group.getWidgets();
            for (int i = 0; i < bWidgetArray.length; ++i) {
                bGridPane.add(null, (BValue)bWidgetArray[i]);
            }
            this.setContent((BWidget)bGridPane);
        }

        public boolean exit() {
            StationWizardModel.this.setStationContent((BStationContentEnum)this.group.getValue());
            if (!this.hasSetDispositionDefault) {
                this.hasSetDispositionDefault = true;
                if (this.group.getValue() == BStationContentEnum.everything) {
                    StationWizardModel.this.setStationDisposition(BStationDispositionEnum.clean);
                }
            }
            return true;
        }

        private boolean configBogOnly() {
            try {
                BIFile[] bIFileArray = StationWizardModel.this.getStationDirectory().listFiles();
                for (int i = 0; i < bIFileArray.length; ++i) {
                    if (!(bIFileArray[i].isDirectory() ? !StationWizardModel.this.ignoreDirectory((BDirectory)bIFileArray[i]) : !bIFileArray[i].getFileName().equals("config.bog") && !StationWizardModel.this.ignoreFile(bIFileArray[i]))) continue;
                    return false;
                }
            }
            catch (Exception exception) {
                BDaemonSessionView.log.error("error checking for station directory existance", (Throwable)exception);
            }
            return true;
        }
    }

    private class StationNameStep
    extends StationWizardStep {
        private BTextField nameTextField;

        public StationNameStep() {
            BGridPane bGridPane = new BGridPane(2);
            bGridPane.setValign(BValign.top);
            bGridPane.setHalign(BHalign.left);
            this.nameTextField = new BTextField("", 30);
            LabelUtil.addLabelWidgetPair((BGridPane)bGridPane, (LexiconText)LexiconText.make((String)"platDaemon", (String)"StationCopier.StationNameStep.name"), (BWidget)this.nameTextField);
            this.nameTextField.setController((TextController)new StationNameController());
            this.nameTextField.setModel((TextModel)new StationNameModel());
            this.setContent((BWidget)bGridPane);
        }

        public String getStepName() {
            return "StationNameStep";
        }

        public int getMode() {
            return 2;
        }

        public void enter() {
            this.nameTextField.setText(StationWizardModel.this.getTargetStationName());
        }

        public boolean exit() {
            if (this.nameTextField.getText().trim().length() == 0) {
                return false;
            }
            StationWizardModel.this.setTargetStationName(this.nameTextField.getText());
            if (StationWizardModel.this.isLocalToRemote()) {
                StationWizardModel.this.setStationSurrogate(StationWizardModel.this.stationCopier.getStationSurrogate(StationWizardModel.this.getTargetStationName(), true));
                if (StationWizardModel.this.getStationSurrogate() != null) {
                    StationWizardModel.this.setAutoStart(StationWizardModel.this.getStationSurrogate().getIsAutoStart());
                    StationWizardModel.this.setAutoRestart(StationWizardModel.this.getStationSurrogate().getIsAutoRestart());
                }
            } else {
                BBogFile bBogFile;
                this.setNextStep(StationWizardModel.this.contentStep);
                if (StationWizardModel.this.localStationBogLock != null) {
                    try {
                        StationWizardModel.this.localStationBogLock.unlock();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    StationWizardModel.this.localStationBogLock = null;
                }
                if ((bBogFile = (BBogFile)BFileSystem.INSTANCE.findFile(new FilePath("!stations").merge(StationWizardModel.this.getTargetStationName()).merge("config.bog"))) != null) {
                    File file = ((BLocalFileStore)bBogFile.getStore()).getLocalFile();
                    try {
                        StationWizardModel.this.localStationBogLock = FileLock.lock((File)file);
                    }
                    catch (Exception exception) {
                        this.setNextStep(StationWizardModel.this.lockedStep);
                    }
                }
            }
            return true;
        }

        public boolean isSkipped() {
            return StationWizardModel.this.isLocalToRemote() && !StationWizardModel.this.getDependencyAnalysis().getSolution().canCommit();
        }

        class StationNameModel
        extends TextModel {
            StationNameModel() {
            }

            protected void textModified() {
                String string = StationNameStep.this.nameTextField.getText();
                if (StationWizardModel.this.getWizard() != null) {
                    StationWizardModel.this.getWizard().setNextEnabled(SlotPath.isValidName((String)string) && string.length() <= 32);
                }
            }
        }
    }

    public abstract class StationWizardStep {
        private BEdgePane contentPane = new BEdgePane(null, null, null, null, null);
        private BEdgePane widget;
        private StationWizardStep priorStep = null;
        private StationWizardStep nextStep = null;

        public StationWizardStep() {
            this.widget = new BEdgePane((BWidget)new BWizardHeader(wizImage, lex.getText("StationCopier.headerTitle", new Object[]{StationWizardModel.this.getStationDirectory().getFilePath().getName()}), lex.getText("StationCopier." + this.getStepName() + ".desc")), null, null, null, (BWidget)new BBorderPane((BWidget)this.contentPane, 5.0, 10.0, 4.0, 10.0));
        }

        public abstract String getStepName();

        public BWidget getWidget() {
            return this.widget;
        }

        protected void setContent(BWidget bWidget) {
            this.contentPane.setCenter(bWidget);
        }

        public int getMode() {
            return 0;
        }

        public int getNavMode() {
            StationWizardStep stationWizardStep;
            StationWizardStep stationWizardStep2;
            int n = 0;
            for (stationWizardStep2 = this.getPriorStep(); stationWizardStep2 != null && stationWizardStep2.isSkipped(); stationWizardStep2 = stationWizardStep2.getPriorStep()) {
            }
            if (stationWizardStep2 != null) {
                n |= 1;
            }
            for (stationWizardStep = this.getNextStep(); stationWizardStep != null && stationWizardStep.isSkipped(); stationWizardStep = stationWizardStep.getNextStep()) {
            }
            if (stationWizardStep != null) {
                n |= 2;
            }
            return n;
        }

        public StationWizardStep getPriorStep() {
            return this.priorStep;
        }

        public StationWizardStep getNextStep() {
            return this.nextStep;
        }

        public void setNextStep(StationWizardStep stationWizardStep) {
            this.nextStep = stationWizardStep;
        }

        public void enter() throws Exception {
        }

        public boolean exit() {
            return true;
        }

        public void setPriorStep(StationWizardStep stationWizardStep) {
            this.priorStep = stationWizardStep;
        }

        public boolean cancel() {
            return true;
        }

        public boolean isSkipped() {
            return false;
        }
    }
}

