/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.stationtransfer;

import com.tridium.install.BRemoteModuleList;
import com.tridium.platDaemon.ui.BDaemonSessionView;
import com.tridium.platDaemon.ui.stationtransfer.BStationTransferGridPane;
import com.tridium.platDaemon.ui.stationtransfer.StationNameController;
import com.tridium.platDaemon.ui.stationtransfer.StationWizardModel;
import com.tridium.platDaemon.ui.widget.BDirectoryChoice;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BStationSurrogate;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.file.BCacheAccessPolicy;
import com.tridium.platform.daemon.file.BDaemonDirectoryStore;
import com.tridium.platform.daemon.file.BDaemonFileSpace;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.DeleteStationMessage;
import com.tridium.platform.daemon.message.FileTransferMessage;
import com.tridium.platform.daemon.message.UpdateStationMessage;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.platform.ui.util.AsyncCommand;
import com.tridium.platform.ui.util.AsyncGroup;
import com.tridium.platform.ui.util.BStringPromptDialog;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.platform.ui.util.FavoriteDirectory;
import com.tridium.sys.Nre;
import com.tridium.ui.theme.Theme;
import java.net.ConnectException;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.BIFileStore;
import javax.baja.file.FilePath;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.naming.BLocalHost;
import javax.baja.nav.BINavNode;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.platform.ICancelHint;
import javax.baja.security.AuthenticationException;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.list.BList;
import javax.baja.ui.list.ListModel;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.text.TextController;
import javax.baja.workbench.BWbShell;

public class BStationCopier
extends BDaemonSessionView {
    public static final Action handleSelectionChanged = BStationCopier.newAction((int)4, (BValue)new BWidgetEvent(), null);
    public static final Action handleStationDirectoryChanged = BStationCopier.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$platDaemon$ui$stationtransfer$BStationCopier == null ? (class$com$tridium$platDaemon$ui$stationtransfer$BStationCopier = BStationCopier.class$("com.tridium.platDaemon.ui.stationtransfer.BStationCopier")) : class$com$tridium$platDaemon$ui$stationtransfer$BStationCopier));
    private BList localList;
    private BList remoteList;
    private StationListModel localStations = new StationListModel();
    private StationListModel remoteStations;
    private BLabel localLabel;
    private BLabel remoteLabel;
    private WizardCommand installRemoteCommand;
    private WizardCommand installLocalCommand;
    private DeleteCommand deleteCommand;
    private RenameCommand renameCommand;
    private boolean sourceTargetDirsSame = true;
    private boolean processSelectionEvents = true;
    private BDirectory localStationsRoot = this.loadLocalStationDirectory();
    private BDirectory remoteStationsRoot;
    private BDirectoryChoice dirChoice;
    private BTextField remotePath;
    public static FilePath STATIONS_PATH = new FilePath("!stations");
    static /* synthetic */ Class class$com$tridium$platDaemon$ui$stationtransfer$BStationCopier;

    public void handleSelectionChanged(BWidgetEvent bWidgetEvent) {
        this.invoke(handleSelectionChanged, (BValue)bWidgetEvent, null);
    }

    public void handleStationDirectoryChanged() {
        this.invoke(handleStationDirectoryChanged, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BStationCopier() {
        try {
            this.localStations.loadValue(this.localStationsRoot);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.remoteStations = new StationListModel();
        BStationTransferGridPane bStationTransferGridPane = new BStationTransferGridPane();
        BFlowPane bFlowPane = new BFlowPane(BHalign.left);
        bStationTransferGridPane.setTopLeft((BWidget)bFlowPane);
        this.localLabel = new BLabel();
        bFlowPane.add(null, (BValue)this.localLabel);
        bFlowPane = new BFlowPane(BHalign.left);
        bStationTransferGridPane.setTopRight((BWidget)bFlowPane);
        this.remoteLabel = new BLabel();
        bFlowPane.add(null, (BValue)this.remoteLabel);
        this.dirChoice = new BDirectoryChoice(this.localStationsRoot);
        bStationTransferGridPane.setCenterLeft((BWidget)this.dirChoice);
        this.linkTo((BComponent)this.dirChoice, (Slot)BDirectoryChoice.dirModified, (Slot)handleStationDirectoryChanged);
        this.remotePath = new BTextField("", 35, false);
        bStationTransferGridPane.setCenterRight((BWidget)this.remotePath);
        this.localList = new BList((ListModel)this.localStations);
        bStationTransferGridPane.setBottomLeft((BWidget)new BBorderPane((BWidget)this.localList, BBorder.inset, BInsets.DEFAULT));
        this.localList.setMultipleSelection(false);
        this.linkTo((BComponent)this.localList, (Slot)BList.selectionModified, (Slot)handleSelectionChanged);
        BGridPane bGridPane = new BGridPane(1);
        bGridPane.setColumnAlign(BHalign.fill);
        AsyncGroup asyncGroup = new AsyncGroup();
        this.installLocalCommand = new WizardCommand(this.localStations, "StationCopier.installLocal");
        bGridPane.add(null, (BValue)new BButton((Command)this.installLocalCommand));
        asyncGroup.add((AsyncGroup.AsyncGroupMember)this.installLocalCommand);
        this.installRemoteCommand = new WizardCommand(this.remoteStations, "StationCopier.installRemote");
        bGridPane.add(null, (BValue)new BButton((Command)this.installRemoteCommand));
        asyncGroup.add((AsyncGroup.AsyncGroupMember)this.installRemoteCommand);
        this.renameCommand = new RenameCommand();
        bGridPane.add(null, (BValue)new BButton((Command)this.renameCommand));
        asyncGroup.add((AsyncGroup.AsyncGroupMember)this.renameCommand);
        this.deleteCommand = new DeleteCommand();
        bGridPane.add(null, (BValue)new BButton((Command)this.deleteCommand));
        asyncGroup.add((AsyncGroup.AsyncGroupMember)this.deleteCommand);
        this.installLocalCommand.setEnabled(false);
        this.installRemoteCommand.setEnabled(false);
        this.renameCommand.setEnabled(false);
        this.deleteCommand.setEnabled(false);
        bStationTransferGridPane.setBottomCenter((BWidget)bGridPane);
        this.remoteList = new BList((ListModel)this.remoteStations);
        bStationTransferGridPane.setBottomRight((BWidget)new BBorderPane((BWidget)this.remoteList, BBorder.inset, BInsets.DEFAULT));
        this.remoteList.setMultipleSelection(false);
        this.linkTo((BComponent)this.remoteList, (Slot)BList.selectionModified, (Slot)handleSelectionChanged);
        this.localLabel.setText(this.getLexicon().getText("StationCopier.localStations.heading"));
        this.localLabel.setImage(BImage.make((BIcon)BLocalHost.INSTANCE.getIcon()));
        BScrollPane bScrollPane = new BScrollPane((BWidget)bStationTransferGridPane);
        bScrollPane.setBorderPolicy(BScrollBarPolicy.asNeeded);
        bScrollPane.setViewportBackground(Theme.scrollPane().getControlBackground());
        this.setContent((BWidget)bScrollPane);
    }

    public void doHandleStationDirectoryChanged() throws Exception {
        this.localStationsRoot = this.dirChoice.getDirectory();
        this.localStations.loadValue(this.localStationsRoot);
        this.checkSourceTargetDirsSame();
        this.saveStationDirectory();
    }

    protected BDirectory loadLocalStationDirectory() {
        return FavoriteDirectory.loadByPath((String)this.getType().toString(), (String)"stationsDir", (FilePath)STATIONS_PATH);
    }

    protected void saveStationDirectory() {
        FavoriteDirectory.savePath((String)this.getType().toString(), (String)"stationsDir", (BDirectory)this.localStationsRoot);
    }

    protected final void doLoadSession(BDaemonSession bDaemonSession, Context context) throws AuthenticationException {
        try {
            this.remoteLabel.setText(this.getLexicon().getText("StationCopier.remoteStations.heading", new Object[]{bDaemonSession.getRemoteAddressString()}));
            this.remoteLabel.setImage(BImage.make((BIcon)bDaemonSession.getIcon()));
            DaemonFileUtil.transfer((BDaemonSession)bDaemonSession, (FileTransferMessage)FileTransferMessage.makeMkDir((FilePath)STATIONS_PATH, (BDaemonFileSpace)bDaemonSession.getFileSpace()), null, null);
            this.remoteStationsRoot = (BDirectory)bDaemonSession.getFileSpace().findFile(STATIONS_PATH, BCacheAccessPolicy.forceFetch);
            this.remotePath.setText(DaemonFileUtil.getNormalizedFilePath((BIFileStore)this.remoteStationsRoot.getStore()).getBody());
            this.checkSourceTargetDirsSame();
            this.remoteStations.loadValue(this.remoteStationsRoot);
        }
        catch (AuthenticationException authenticationException) {
            throw authenticationException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
    }

    private void checkSourceTargetDirsSame() throws ConnectException, AuthenticationException {
        this.sourceTargetDirsSame = this.getDaemonSession().getHostProperties().getHostId().equals(Nre.getHostId());
        if (this.sourceTargetDirsSame) {
            this.sourceTargetDirsSame = TextUtil.toLowerCase((String)this.remotePath.getText()).equals(TextUtil.toLowerCase((String)this.localStationsRoot.getFilePath().getBody()));
        }
        if (this.sourceTargetDirsSame) {
            this.installLocalCommand.setEnabled(false);
            this.installRemoteCommand.setEnabled(false);
        }
    }

    public void doHandleSelectionChanged(BWidgetEvent bWidgetEvent) {
        if (!this.processSelectionEvents) {
            return;
        }
        this.processSelectionEvents = false;
        if (bWidgetEvent.getWidget() == this.localList && this.localList.getSelectedIndex() >= 0) {
            this.remoteList.getSelection().deselectAll();
        } else if (bWidgetEvent.getWidget() == this.remoteList && this.remoteList.getSelectedIndex() >= 0) {
            this.localList.getSelection().deselectAll();
        }
        if (this.localList.getSelectedIndex() >= 0) {
            this.installLocalCommand.setEnabled(!this.sourceTargetDirsSame);
            this.installRemoteCommand.setEnabled(false);
            this.deleteCommand.setEnabled(true);
            this.renameCommand.setEnabled(true);
        } else if (this.remoteList.getSelectedIndex() >= 0) {
            this.installLocalCommand.setEnabled(false);
            this.installRemoteCommand.setEnabled(!this.sourceTargetDirsSame);
            this.deleteCommand.setEnabled(true);
            this.renameCommand.setEnabled(true);
        } else {
            this.installLocalCommand.setEnabled(false);
            this.installRemoteCommand.setEnabled(false);
            this.deleteCommand.setEnabled(false);
            this.renameCommand.setEnabled(false);
        }
        this.processSelectionEvents = true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class StationListModel
    extends ListModel {
        private Array list = new Array();

        public void loadValue(BDirectory bDirectory) {
            this.list.clear();
            if (bDirectory != null) {
                try {
                    if (bDirectory.getStore() instanceof BDaemonDirectoryStore) {
                        ((BDaemonDirectoryStore)bDirectory.getStore()).reset();
                    }
                    BIFile[] bIFileArray = bDirectory.listFiles();
                    for (int i = 0; i < bIFileArray.length; ++i) {
                        if (!bIFileArray[i].isDirectory()) continue;
                        this.list.add((Object)bIFileArray[i]);
                    }
                }
                catch (Exception exception) {
                    BDaemonSessionView.log.error("error loading station list", (Throwable)exception);
                }
            }
            this.updateList();
        }

        public int getItemCount() {
            return this.list.size();
        }

        public Object getItem(int n) {
            return this.getDirectoryAt(n).getFileName();
        }

        public BDirectory getDirectoryAt(int n) {
            return (BDirectory)this.list.get(n);
        }

        public BImage getItemIcon(int n) {
            return null;
        }
    }

    private class DeleteCommand
    extends AsyncCommand {
        public DeleteCommand() {
            super((BWidget)BStationCopier.this, TYPE.getModule(), "StationCopier.delete");
        }

        public void doInvokeAsync() {
            block8: {
                try {
                    if (BStationCopier.this.localList.getSelectedIndex() >= 0) {
                        if (4 == BDialog.confirm((BWidget)BStationCopier.this, (String)BStationCopier.this.getLexicon().getText("StationCopier.deleteStation.title"), (Object)BStationCopier.this.getLexicon().getText("StationCopier.deleteStation.message", new Object[]{BStationCopier.this.localStations.getItem(BStationCopier.this.localList.getSelectedIndex())}))) {
                            BStationCopier.this.localStations.getDirectoryAt(BStationCopier.this.localList.getSelectedIndex()).delete();
                            BStationCopier.this.localStations.loadValue(BStationCopier.this.localStationsRoot);
                            BStationCopier.this.localList.getSelection().deselectAll();
                        }
                        break block8;
                    }
                    if (4 != BDialog.confirm((BWidget)BStationCopier.this, (String)BStationCopier.this.getLexicon().getText("StationCopier.deleteStation.title"), (Object)BStationCopier.this.getLexicon().getText("StationCopier.deleteStation.message", new Object[]{BStationCopier.this.remoteStations.getItem(BStationCopier.this.remoteList.getSelectedIndex())}))) break block8;
                    BStationCopier.this.processSelectionEvents = false;
                    BDirectory bDirectory = BStationCopier.this.remoteStations.getDirectoryAt(BStationCopier.this.remoteList.getSelectedIndex());
                    String string = bDirectory.getFileName();
                    try {
                        BStationSurrogate bStationSurrogate = BStationCopier.this.getStationSurrogate(string, true);
                        if (bStationSurrogate != null) {
                            bStationSurrogate.deleteStation(null, (DaemonSessionTaskListener)BStationCopier.this);
                        } else {
                            BStationCopier.this.getDaemonSession().sendMessage((DaemonMessage)new DeleteStationMessage(string));
                            DaemonFileUtil.transfer((BDaemonSession)BStationCopier.this.getDaemonSession(), (FileTransferMessage)FileTransferMessage.makeDelete((FilePath)bDirectory.getFilePath(), (BDaemonFileSpace)BStationCopier.this.getDaemonSession().getFileSpace()), null, (DaemonSessionTaskListener)BStationCopier.this);
                        }
                        BStationCopier.this.resetAppSurrogates();
                        BStationCopier.this.remoteStations.loadValue(BStationCopier.this.remoteStationsRoot);
                        BStationCopier.this.localStations.loadValue(BStationCopier.this.localStationsRoot);
                    }
                    catch (ICancelHint.CanceledException canceledException) {
                        // empty catch block
                    }
                    BStationCopier.this.processSelectionEvents = true;
                    BStationCopier.this.remoteList.getSelection().deselectAll();
                }
                catch (Throwable throwable) {
                    CommandUtil.error((Command)this, (Throwable)throwable);
                }
            }
        }
    }

    private class RenameCommand
    extends AsyncCommand {
        public RenameCommand() {
            super((BWidget)BStationCopier.this, TYPE.getModule(), "StationCopier.rename");
        }

        public void doInvokeAsync() {
            try {
                String string = BStringPromptDialog.getString((BWidget)BStationCopier.this, (BImage)BImage.make((String)BStationCopier.this.getLexicon().getText("StationCopier.rename.dlgIcon")), (String)BStationCopier.this.getLexicon().getText("StationCopier.rename.dlgTitle"), (String)BStationCopier.this.getLexicon().getText("StationCopier.rename.dlgMessage"), (TextController)new StationNameController());
                if (string == null) {
                    return;
                }
                if (BStationCopier.this.localList.getSelectedIndex() >= 0) {
                    BDirectory bDirectory = BStationCopier.this.localStations.getDirectoryAt(BStationCopier.this.localList.getSelectedIndex());
                    if (string.equalsIgnoreCase(bDirectory.getFileName())) {
                        return;
                    }
                    for (int i = 0; i < BStationCopier.this.localStations.getItemCount(); ++i) {
                        if (i == BStationCopier.this.localList.getSelectedIndex() || !string.equalsIgnoreCase(BStationCopier.this.localStations.getDirectoryAt(i).getFileName().toString())) continue;
                        throw new Exception(BStationCopier.this.getLexicon().getText("StationCopier.rename.duplicateErrorDetails"));
                    }
                    BFileSystem.INSTANCE.move(bDirectory.getFilePath(), bDirectory.getFilePath().getParent().merge(string), null);
                    BStationCopier.this.localStations.loadValue(BStationCopier.this.localStationsRoot);
                    BStationCopier.this.localList.getSelection().deselectAll();
                } else {
                    BDirectory bDirectory = BStationCopier.this.remoteStations.getDirectoryAt(BStationCopier.this.remoteList.getSelectedIndex());
                    if (string.equalsIgnoreCase(bDirectory.getFileName())) {
                        return;
                    }
                    for (int i = 0; i < BStationCopier.this.remoteStations.getItemCount(); ++i) {
                        if (i == BStationCopier.this.remoteList.getSelectedIndex() || !string.equalsIgnoreCase(BStationCopier.this.remoteStations.getDirectoryAt(i).getFileName().toString())) continue;
                        throw new Exception(BStationCopier.this.getLexicon().getText("StationCopier.rename.duplicateErrorDetails"));
                    }
                    BStationSurrogate bStationSurrogate = BStationCopier.this.getStationSurrogate(bDirectory.getFileName(), true);
                    boolean bl = bStationSurrogate.isStationRunning();
                    boolean bl2 = false;
                    if (bl) {
                        if (bStationSurrogate.isRestartEnabled()) {
                            if (4 != BDialog.confirm((BWidget)BStationCopier.this, (String)BStationCopier.this.getLexicon().getText("StationCopier.rename.stopTitle"), (Object)BStationCopier.this.getLexicon().getText("StationCopier.rename.stopMessage"))) {
                                return;
                            }
                        } else {
                            if (4 != BDialog.confirm((BWidget)BStationCopier.this, (String)BStationCopier.this.getLexicon().getText("StationCopier.rename.promptRebootTitle"), (Object)BStationCopier.this.getLexicon().getText("StationCopier.rename.promptRebootMessage"))) {
                                return;
                            }
                            bl2 = true;
                        }
                        bStationSurrogate.stopStation((ICancelHint)BStationCopier.this, (DaemonSessionTaskListener)BStationCopier.this);
                    }
                    UpdateStationMessage updateStationMessage = new UpdateStationMessage(string, false, bStationSurrogate.getIsAutoStart(), bStationSurrogate.getIsAutoRestart(), true);
                    DeleteStationMessage deleteStationMessage = new DeleteStationMessage(bStationSurrogate.getStationName());
                    DaemonFileUtil.transfer((BDaemonSession)BStationCopier.this.getDaemonSession(), (FileTransferMessage)FileTransferMessage.makeRename((FilePath)new FilePath("!stations/" + bStationSurrogate.getStationName()), (String)string, (BDaemonFileSpace)BStationCopier.this.getDaemonSession().getFileSpace()), null, (DaemonSessionTaskListener)BStationCopier.this);
                    BStationCopier.this.getDaemonSession().sendMessage((DaemonMessage)deleteStationMessage);
                    BStationCopier.this.getDaemonSession().sendMessage((DaemonMessage)new UpdateStationMessage());
                    BStationCopier.this.resetAppSurrogates();
                    BStationCopier.this.getDaemonSession().sendMessage((DaemonMessage)updateStationMessage);
                    if (bl2) {
                        BWbShell bWbShell = BWbShell.getWbShell((BWidget)BStationCopier.this);
                        BStationCopier.this.getDaemonSession().sendRebootRequest();
                        BDialog.message((BWidget)bWbShell, (String)BStationCopier.this.getLexicon().getText("DaemonSessionView.reboot.notifyTitle", new Object[]{BStationCopier.this.getDaemonSession().getRemoteAddressString()}), (Object)BStationCopier.this.getLexicon().getText("DaemonSessionView.reboot.notifyMessage", new Object[]{BStationCopier.this.getDaemonSession().getRemoteAddressString()}));
                    } else {
                        if (bl) {
                            bStationSurrogate = BStationCopier.this.getStationSurrogate(string, true);
                            bStationSurrogate.startStation((ICancelHint)BStationCopier.this, (DaemonSessionTaskListener)BStationCopier.this);
                        }
                        BStationCopier.this.remoteStations.loadValue(BStationCopier.this.remoteStationsRoot);
                        BStationCopier.this.remoteList.getSelection().deselectAll();
                    }
                }
            }
            catch (Throwable throwable) {
                CommandUtil.error((Command)this, (Throwable)throwable);
            }
        }
    }

    private class WizardCommand
    extends AsyncCommand {
        public WizardCommand(StationListModel stationListModel, String string) {
            super((BWidget)BStationCopier.this, TYPE.getModule(), string);
        }

        public void doInvokeAsync() {
            try {
                BDirectory bDirectory;
                BINavNode bINavNode;
                BDirectory bDirectory2;
                if (BStationCopier.this.localList.getSelectedIndex() >= 0) {
                    bDirectory2 = BStationCopier.this.localStations.getDirectoryAt(BStationCopier.this.localList.getSelectedIndex());
                    bINavNode = bDirectory2.getNavChild("config.bog");
                    if (bINavNode == null) {
                        BDialog.error((BWidget)BStationCopier.this, (String)BStationCopier.this.getLexicon().getText("StationCopier.noConfigBog.title"), (Object)BStationCopier.this.getLexicon().getText("StationCopier.noConfigBog.message"));
                        return;
                    }
                    bDirectory = BStationCopier.this.remoteStationsRoot;
                } else {
                    bDirectory2 = BStationCopier.this.remoteStations.getDirectoryAt(BStationCopier.this.remoteList.getSelectedIndex());
                    bINavNode = bDirectory2.getNavChild("config.bog");
                    if (bINavNode == null) {
                        BDialog.error((BWidget)BStationCopier.this, (String)BStationCopier.this.getLexicon().getText("StationCopier.noConfigBog.title"), (Object)BStationCopier.this.getLexicon().getText("StationCopier.noConfigBog.message"));
                        return;
                    }
                    bDirectory = BStationCopier.this.localStationsRoot;
                }
                if (!StationWizardModel.open(bDirectory2, bDirectory, (BRemoteModuleList)BStationCopier.this.getDaemonPlatform().getModuleList(), BStationCopier.this) && (bINavNode = ((BDaemonFileSpace)BStationCopier.this.remoteStationsRoot.getFileSpace()).getDaemonSession()) != null && bINavNode.isConnected()) {
                    if (BStationCopier.this.localList.getSelectedIndex() >= 0) {
                        BStationCopier.this.remoteStations.loadValue(BStationCopier.this.remoteStationsRoot);
                    } else {
                        BStationCopier.this.localStations.loadValue(BStationCopier.this.localStationsRoot);
                    }
                }
            }
            catch (Exception exception) {
                CommandUtil.error((Command)this, (Throwable)exception);
            }
        }
    }
}

