/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.softwaremanager;

import com.tridium.install.InstallScenario;
import com.tridium.install.PartSpec;
import com.tridium.install.installable.InstallableRegistry;
import com.tridium.install.installable.LocalInstallableRegistry;
import com.tridium.platDaemon.ui.softwaremanager.InstallerTableModel;
import com.tridium.platDaemon.ui.softwaremanager.InstallerTableRow;
import com.tridium.platform.ui.util.AsyncCommand;
import com.tridium.platform.ui.util.BIndentPane;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.ui.theme.Theme;
import java.util.TreeSet;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.util.Array;
import javax.baja.util.Lexicon;
import javax.baja.util.LexiconText;
import javax.baja.workbench.BWbShell;

class UninstallCommand
extends AsyncCommand {
    private InstallerTableModel tableModel;
    private static Lexicon lex = Lexicon.make((String)"platDaemon");

    public UninstallCommand(BWidget bWidget, InstallerTableModel installerTableModel) {
        super(bWidget, lex, "SoftwareManager.command.uninstallSelected");
        this.tableModel = installerTableModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doInvokeAsync() {
        BWbShell bWbShell = BWbShell.getWbShell((BWidget)this.getOwner());
        try {
            if (bWbShell != null) {
                bWbShell.enterBusy();
            }
            int[] nArray = this.tableModel.getTable().getSelection().getRows();
            String[] stringArray = new String[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                stringArray[i] = this.tableModel.getNameAt(nArray[i]);
            }
            InstallScenario installScenario = this.tableModel.getScenario().solve(null, stringArray, null, null, (InstallableRegistry)LocalInstallableRegistry.getInstance());
            if (installScenario.getUnmetDependencies().length == 0) {
                this.tableModel.setScenario(installScenario);
            } else {
                BDialog.error((BWidget)this.getOwner(), (String)lex.getText("UninstallCommand.broken.title"), (Object)this.makeBrokenDepsDialog(installScenario));
            }
        }
        catch (Throwable throwable) {
            CommandUtil.error((Command)this, (Throwable)throwable);
        }
        finally {
            if (bWbShell != null) {
                bWbShell.exitBusy();
            }
        }
    }

    private BWidget makeBrokenDepsDialog(InstallScenario installScenario) {
        PartSpec partSpec;
        BIndentPane bIndentPane = new BIndentPane();
        TreeSet<PartSpec> treeSet = new TreeSet<PartSpec>();
        for (int i = 0; i < installScenario.getUnmetDependencies().length; ++i) {
            treeSet.add(installScenario.getUnmetDependencies()[i].getPartSpec());
        }
        LexiconText lexiconText = LexiconText.make((String)"platDaemon", (String)"UninstallCommand.broken.itemHeading");
        BScrollPane bScrollPane = treeSet.iterator();
        while (bScrollPane.hasNext()) {
            partSpec = (PartSpec)bScrollPane.next();
            bIndentPane.add(lexiconText, new Object[]{partSpec.getPartName()});
            bIndentPane.indent();
            Array array = this.tableModel.getReverseDependenciesAt(this.tableModel.indexOf(partSpec));
            for (int i = 0; i < array.size(); ++i) {
                InstallerTableRow installerTableRow = (InstallerTableRow)array.get(i);
                switch (installerTableRow.getInstallStatus().getOrdinal()) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        bIndentPane.add(installerTableRow.getPartName());
                    }
                }
            }
            bIndentPane.unindent();
        }
        bScrollPane = new BScrollPane((BWidget)new BBorderPane((BWidget)bIndentPane, 5.0, 5.0, 5.0, 5.0));
        bScrollPane.setViewportBackground(Theme.scrollPane().getControlBackground());
        bScrollPane.setBorderPolicy(BScrollBarPolicy.asNeeded);
        partSpec = new BConstrainedPane((BWidget)bScrollPane);
        partSpec.setFixedSize(320.0, 160.0);
        return new BEdgePane(null, null, null, null, (BWidget)partSpec);
    }
}

