/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.softwaremanager;

import com.tridium.install.BPartInstallStatus;
import com.tridium.platDaemon.ui.softwaremanager.InstallerTableModel;
import java.util.HashSet;
import java.util.Iterator;
import javax.baja.ui.table.TableSelection;

public class InstallerTableSelection
extends TableSelection {
    private InstallerTableModel model;

    public InstallerTableSelection(InstallerTableModel installerTableModel) {
        this.model = installerTableModel;
    }

    public void deselect(int n) {
        super.deselect(n);
        int[] nArray = this.getSlaveSelections(n);
        for (int i = 0; i < nArray.length; ++i) {
            super.deselect(nArray[i]);
        }
    }

    public void select(int n) {
        try {
            int n2;
            this.checkSelect(n);
            int[] nArray = this.getSlaveSelections(n);
            for (n2 = 0; n2 < nArray.length; ++n2) {
                this.checkSelect(nArray[n2]);
            }
            super.select(n);
            for (n2 = 0; n2 < nArray.length; ++n2) {
                super.select(nArray[n2]);
            }
        }
        catch (CannotSelectException cannotSelectException) {
            // empty catch block
        }
    }

    public void select(int n, int n2) {
        try {
            this.checkSelect(n, n2);
            int n3 = n > n2 ? n2 : n;
            int n4 = n2 > n ? n : n2;
            HashSet<Integer> hashSet = new HashSet<Integer>();
            for (int i = n3; i <= n4; ++i) {
                int[] nArray = this.getSlaveSelections(i);
                for (int j = 0; j < nArray.length; ++j) {
                    this.checkSelect(nArray[j]);
                    hashSet.add(new Integer(nArray[j]));
                }
            }
            super.select(n, n2);
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                int n5 = (Integer)iterator.next();
                super.select(n5);
            }
        }
        catch (CannotSelectException cannotSelectException) {
            // empty catch block
        }
    }

    private void checkSelect(int n) throws CannotSelectException {
        if (!this.canSelect(n)) {
            throw new CannotSelectException();
        }
    }

    private void checkSelect(int n, int n2) throws CannotSelectException {
        if (!this.canSelect(n, n2)) {
            throw new CannotSelectException();
        }
    }

    private boolean canSelect(int n, int n2) {
        int n3 = n < n2 ? n : n2;
        int n4 = n < n2 ? n2 : n;
        BPartInstallStatus bPartInstallStatus = this.model.getInstallStatusAt(n3);
        for (int i = n3 + 1; i < n4; ++i) {
            if (this.model.getInstallStatusAt(n3) == bPartInstallStatus) continue;
            return false;
        }
        return true;
    }

    private boolean canSelect(int n) {
        int n2 = this.getRow();
        if (n2 >= 0) {
            return this.model.getInstallStatusAt(n2) == this.model.getInstallStatusAt(n);
        }
        return true;
    }

    private int[] getSlaveSelections(int n) {
        String string = this.model.getRow(n).getInstallableName();
        if (string == null) {
            return new int[0];
        }
        int[] nArray = new int[this.model.getRowCount()];
        int n2 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (i == n || !this.stringsEqual(string, this.model.getRow(i).getInstallableName())) continue;
            nArray[n2++] = i;
        }
        int[] nArray2 = new int[n2];
        System.arraycopy(nArray, 0, nArray2, 0, n2);
        return nArray2;
    }

    private boolean stringsEqual(String string, String string2) {
        if (string == string2) {
            return true;
        }
        if (string == null || string2 == null) {
            return false;
        }
        return string.equals(string2);
    }

    private static class CannotSelectException
    extends Exception {
        private CannotSelectException() {
        }
    }
}

