/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.softwaremanager;

import com.tridium.install.BDaemonPlatform;
import com.tridium.install.InstallScenario;
import com.tridium.install.PartSpec;
import com.tridium.install.SolutionParameters;
import com.tridium.install.UnmeetableDependency;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.installable.InstallableRegistry;
import com.tridium.install.installable.LocalInstallableRegistry;
import com.tridium.install.part.BPart;
import com.tridium.platDaemon.ui.commissioningwizard.CommissioningWizardModel;
import com.tridium.platDaemon.ui.softwaremanager.InstallerTableModel;
import com.tridium.platform.ui.util.AsyncCommand;
import com.tridium.platform.ui.util.BIndentPane;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.ui.theme.Theme;
import java.util.Map;
import java.util.TreeMap;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.wizard.BWizard;
import javax.baja.ui.wizard.WizardModel;
import javax.baja.util.Lexicon;
import javax.baja.util.LexiconText;
import javax.baja.workbench.BWbShell;

public class InstallCommand
extends AsyncCommand {
    private InstallerTableModel tableModel;
    private static Lexicon lex = Lexicon.make((String)"platDaemon");

    public InstallCommand(BWidget bWidget, InstallerTableModel installerTableModel, String string) {
        super(bWidget, lex, string);
        this.tableModel = installerTableModel;
    }

    public InstallCommand(BWidget bWidget, InstallerTableModel installerTableModel) {
        this(bWidget, installerTableModel, "SoftwareManager.command.installSelected");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InstallScenario install(BWidget bWidget, InstallerTableModel installerTableModel, int[] nArray, boolean bl) throws Exception {
        BWbShell bWbShell = BWbShell.getWbShell((BWidget)bWidget);
        try {
            BWidget bWidget2;
            int n;
            if (bWbShell != null) {
                bWbShell.enterBusy();
            }
            TreeMap<PartSpec, Object> treeMap = new TreeMap<PartSpec, Object>();
            BInstallable[] bInstallableArray = installerTableModel.getScenario().getToInstall();
            for (n = 0; n < bInstallableArray.length; ++n) {
                treeMap.put(bInstallableArray[n].getPart().getPartSpec(), bInstallableArray[n]);
            }
            for (n = 0; n < nArray.length; ++n) {
                bWidget2 = installerTableModel.getInstallableAt(nArray[n]);
                treeMap.put(bWidget2.getPart().getPartSpec(), bWidget2);
            }
            bInstallableArray = new BInstallable[treeMap.size()];
            treeMap.values().toArray(bInstallableArray);
            InstallScenario installScenario = InstallScenario.solve((BDaemonPlatform)installerTableModel.getScenario().getTargetPlatform(), (String[])installerTableModel.getScenario().getModulesToUninstall(), null, (BInstallable[])bInstallableArray, (SolutionParameters)installerTableModel.getScenario().getSolutionParameters(), (InstallableRegistry)LocalInstallableRegistry.getInstance());
            if (installScenario.getExcludedInstallables().length > 0) {
                if (bl) {
                    BDialog.error((BWidget)bWidget, (String)lex.getText("InstallCommand.excluded.title"), (Object)lex.getText("InstallCommand.excluded.message"));
                }
            } else if (installScenario.getUnmeetableDependencies().length > 0) {
                bWidget2 = installScenario.getUnmeetableDependencies();
                boolean bl2 = false;
                for (int i = 0; i < ((BWidget)bWidget2).length; ++i) {
                    if (!bWidget2[i].isUnsolvable) continue;
                    bl2 = true;
                    break;
                }
                if (bl2) {
                    if (bl) {
                        if (4 == BDialog.confirm((BWidget)bWidget, (String)lex.getText("InstallCommand.mustCommission.title"), (Object)lex.getText("InstallCommand.mustCommission.prompt"), (int)12)) {
                            BWizard.open((BWidget)bWidget, (WizardModel)new CommissioningWizardModel(bWidget, installerTableModel.getScenario().getTargetPlatform().getDaemonSession(), true));
                        }
                    } else {
                        installerTableModel.setScenario(installScenario);
                    }
                } else if (bl) {
                    BDialog.error((BWidget)bWidget, (String)lex.getText("InstallCommand.unmet.title"), (Object)InstallCommand.makeUnmetDialog(installScenario));
                }
            } else if (bl) {
                bWidget2 = InstallCommand.makeAlsoInstallDialog(treeMap, installScenario);
                if (bWidget2 == null || 1 == BDialog.confirm((BWidget)bWidget, (String)lex.getText("InstallCommand.alsoInstall.title"), (Object)bWidget2, (int)3)) {
                    installerTableModel.setScenario(installScenario);
                }
            } else {
                installerTableModel.setScenario(installScenario);
            }
            bWidget2 = installScenario;
            return bWidget2;
        }
        finally {
            if (bWbShell != null) {
                bWbShell.exitBusy();
            }
        }
    }

    public void doInvokeAsync() {
        try {
            InstallCommand.install(this.getOwner(), this.tableModel, this.tableModel.getTable().getSelection().getRows(), true);
        }
        catch (Throwable throwable) {
            CommandUtil.error((Command)this, (Throwable)throwable);
        }
    }

    public static BWidget makeAlsoInstallDialog(Map map, InstallScenario installScenario) {
        BPart bPart;
        BIndentPane bIndentPane = null;
        BInstallable[] bInstallableArray = installScenario.getToInstall();
        for (int i = 0; i < bInstallableArray.length; ++i) {
            bPart = bInstallableArray[i].getPart();
            if (map.containsKey(bPart.getPartSpec())) continue;
            if (bIndentPane == null) {
                bIndentPane = new BIndentPane();
                bIndentPane.add(LexiconText.make((String)"platDaemon", (String)"InstallCommand.alsoInstall.toSatisfy"));
                bIndentPane.indent();
            }
            bIndentPane.add(bInstallableArray[i].getInstallableFileName());
        }
        if (bIndentPane == null) {
            return null;
        }
        bIndentPane.unindent();
        BScrollPane bScrollPane = new BScrollPane((BWidget)new BBorderPane(bIndentPane, 5.0, 5.0, 5.0, 5.0));
        bScrollPane.setViewportBackground(Theme.scrollPane().getControlBackground());
        bScrollPane.setBorderPolicy(BScrollBarPolicy.asNeeded);
        bPart = new BConstrainedPane((BWidget)bScrollPane);
        bPart.setFixedSize(275.0, 300.0);
        return new BEdgePane(null, null, null, null, (BWidget)bPart);
    }

    public static BWidget makeUnmetDialog(InstallScenario installScenario) {
        BIndentPane bIndentPane = new BIndentPane();
        bIndentPane.add(LexiconText.make((String)"platDaemon", (String)"InstallCommand.unmet.heading"));
        UnmeetableDependency[] unmeetableDependencyArray = installScenario.getUnmeetableDependencies();
        bIndentPane.indent();
        for (int i = 0; i < unmeetableDependencyArray.length; ++i) {
            if (unmeetableDependencyArray[i].isUnsolvable) continue;
            bIndentPane.add(unmeetableDependencyArray[i].toString(null));
        }
        bIndentPane.unindent();
        BScrollPane bScrollPane = new BScrollPane((BWidget)new BBorderPane((BWidget)bIndentPane, 5.0, 5.0, 5.0, 5.0));
        bScrollPane.setViewportBackground(Theme.scrollPane().getControlBackground());
        bScrollPane.setBorderPolicy(BScrollBarPolicy.asNeeded);
        BConstrainedPane bConstrainedPane = new BConstrainedPane((BWidget)bScrollPane);
        bConstrainedPane.setFixedSize(275.0, 160.0);
        return new BEdgePane(null, null, null, null, (BWidget)bConstrainedPane);
    }
}

