/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.softwaremanager;

import com.tridium.install.BDaemonPlatform;
import com.tridium.install.BDependency;
import com.tridium.install.InstallScenario;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.installable.InstallableRegistry;
import com.tridium.install.installable.LocalInstallableRegistry;
import com.tridium.install.part.BModulePart;
import com.tridium.install.part.BPart;
import com.tridium.platDaemon.ui.softwaremanager.InstallerTableModel;
import com.tridium.platform.ui.util.AsyncCommand;
import com.tridium.platform.ui.util.BIndentPane;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.ui.theme.Theme;
import java.util.Set;
import java.util.TreeSet;
import javax.baja.platform.install.BVersionRelation;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.util.Lexicon;
import javax.baja.util.LexiconText;
import javax.baja.workbench.BWbShell;

class CancelUninstallCommand
extends AsyncCommand {
    private InstallerTableModel tableModel;
    private static Lexicon lex = Lexicon.make((String)"platDaemon");

    public CancelUninstallCommand(BWidget bWidget, InstallerTableModel installerTableModel) {
        super(bWidget, lex, "SoftwareManager.command.cancelUninstallSelected");
        this.tableModel = installerTableModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doInvokeAsync() {
        BWbShell bWbShell = BWbShell.getWbShell((BWidget)this.getOwner());
        try {
            int n;
            if (bWbShell != null) {
                bWbShell.enterBusy();
            }
            int[] nArray = this.tableModel.getTable().getSelection().getRows();
            TreeSet treeSet = new TreeSet();
            TreeSet<String> treeSet2 = new TreeSet<String>();
            InstallScenario installScenario = this.tableModel.getScenario();
            String[] stringArray = installScenario.getModulesToUninstall();
            for (n = 0; n < stringArray.length; ++n) {
                treeSet2.add(stringArray[n]);
            }
            for (n = 0; n < nArray.length; ++n) {
                this.cascade(this.tableModel.getCurrentPartAt(nArray[n]), installScenario.getTargetPlatform(), treeSet2, treeSet);
            }
            if (treeSet.size() == 0 || 1 == BDialog.confirm((BWidget)this.getOwner(), (String)lex.getText("CancelUninstallCommand.alsoCancel.title"), (Object)this.makeAlsoCancelDetailsPane(treeSet), (int)3)) {
                String[] stringArray2 = new String[treeSet2.size()];
                treeSet2.toArray(stringArray2);
                this.tableModel.setScenario(InstallScenario.solve((BDaemonPlatform)installScenario.getTargetPlatform(), null, (String[])stringArray2, null, (BInstallable[])installScenario.getToInstall(), (InstallableRegistry)LocalInstallableRegistry.getInstance()));
            }
        }
        catch (Throwable throwable) {
            CommandUtil.error((Command)this, (Throwable)throwable);
        }
        finally {
            if (bWbShell != null) {
                bWbShell.exitBusy();
            }
        }
    }

    private void cascade(BPart bPart, BDaemonPlatform bDaemonPlatform, Set set, Set set2) throws Exception {
        set.remove(bPart.getPartName());
        BInstallable bInstallable = LocalInstallableRegistry.getInstance().findInstallable(BDependency.forPart((BPart)bPart, (BVersionRelation)BVersionRelation.exact), null);
        if (bInstallable == null) {
            bInstallable = LocalInstallableRegistry.getInstance().findInstallable(BDependency.forModule((String)bPart.getPartName()), null);
        }
        if (bInstallable != null) {
            BDependency[] bDependencyArray = bInstallable.getAllDependencies();
            for (int i = 0; i < bDependencyArray.length; ++i) {
                if (!bDependencyArray[i].getPartTypeSpec().equals((Object)BModulePart.TYPE.getTypeSpec()) || !set.contains(bDependencyArray[i].getPartName())) continue;
                String string = bDependencyArray[i].getPartName();
                set2.add(string);
                this.cascade(bDaemonPlatform.getPart(string, BModulePart.TYPE.getTypeSpec()), bDaemonPlatform, set, set2);
            }
        }
    }

    private BWidget makeAlsoCancelDetailsPane(Set set) {
        BIndentPane bIndentPane = new BIndentPane();
        bIndentPane.add(LexiconText.make((String)"platDaemon", (String)"CancelUninstallCommand.alsoCancel.heading"));
        bIndentPane.indent();
        BScrollPane bScrollPane = set.iterator();
        while (bScrollPane.hasNext()) {
            bIndentPane.add((String)bScrollPane.next());
        }
        bIndentPane.unindent();
        bScrollPane = new BScrollPane((BWidget)new BBorderPane((BWidget)bIndentPane, 5.0, 5.0, 5.0, 5.0));
        bScrollPane.setViewportBackground(Theme.scrollPane().getControlBackground());
        bScrollPane.setBorderPolicy(BScrollBarPolicy.asNeeded);
        BConstrainedPane bConstrainedPane = new BConstrainedPane((BWidget)bScrollPane);
        bConstrainedPane.setFixedSize(285.0, 160.0);
        return new BEdgePane(null, null, null, null, (BWidget)bConstrainedPane);
    }
}

